"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToggleTabFocusModeAction = void 0;
const aria_1 = require("../../../../base/browser/ui/aria/aria");
const tabFocus_1 = require("../../../browser/config/tabFocus");
const editorExtensions_1 = require("../../../browser/editorExtensions");
const nls = require("../../../../nls");
class ToggleTabFocusModeAction extends editorExtensions_1.EditorAction {
    constructor() {
        super({
            id: ToggleTabFocusModeAction.ID,
            label: nls.localize({ key: 'toggle.tabMovesFocus', comment: ['Turn on/off use of tab key for moving focus around VS Code'] }, "Toggle Tab Key Moves Focus"),
            alias: 'Toggle Tab Key Moves Focus',
            precondition: undefined,
            kbOpts: {
                kbExpr: null,
                primary: 2048 /* CtrlCmd */ | 43 /* KeyM */,
                mac: { primary: 256 /* WinCtrl */ | 1024 /* Shift */ | 43 /* KeyM */ },
                weight: 100 /* EditorContrib */
            }
        });
    }
    run(accessor, editor) {
        const oldValue = tabFocus_1.TabFocus.getTabFocusMode();
        const newValue = !oldValue;
        tabFocus_1.TabFocus.setTabFocusMode(newValue);
        if (newValue) {
            (0, aria_1.alert)(nls.localize('toggle.tabMovesFocus.on', "Pressing Tab will now move focus to the next focusable element"));
        }
        else {
            (0, aria_1.alert)(nls.localize('toggle.tabMovesFocus.off', "Pressing Tab will now insert the tab character"));
        }
    }
}
exports.ToggleTabFocusModeAction = ToggleTabFocusModeAction;
ToggleTabFocusModeAction.ID = 'editor.action.toggleTabFocusMode';
(0, editorExtensions_1.registerEditorAction)(ToggleTabFocusModeAction);
//# sourceMappingURL=toggleTabFocusMode.js.map