/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.base.Strings;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public class RuntimeEnvironment {
    private String name;
    private String path;
    private String javadoc;
    private String sources;
    private boolean isDefault;

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getJavadoc() {
        return this.javadoc;
    }

    public void setJavadoc(String javadoc) {
        this.javadoc = javadoc;
    }

    public String getSources() {
        return this.sources;
    }

    public void setSources(String sources) {
        this.sources = sources;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuntimeEnvironment other = (RuntimeEnvironment)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.name) && !Strings.isNullOrEmpty((String)this.path);
    }

    public File getInstallationFile() {
        if (this.isValid()) {
            return new File(this.path);
        }
        return null;
    }

    public URL getJavadocURL() {
        URL url;
        if (Strings.isNullOrEmpty((String)this.javadoc)) {
            return null;
        }
        try {
            url = new URL(this.javadoc);
        }
        catch (MalformedURLException e) {
            File file = new File(this.javadoc);
            if (file.exists()) {
                try {
                    return JDTUtils.toURI(this.javadoc).toURL();
                }
                catch (MalformedURLException e1) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
            JavaLanguageServerPlugin.logInfo("Invalid javadoc: " + this.javadoc);
            return null;
        }
        return url;
    }

    public IPath getSourcePath() {
        if (!Strings.isNullOrEmpty((String)this.sources)) {
            return new Path(this.sources);
        }
        return null;
    }

    public String toString() {
        return "JavaEnvironment [name=" + this.name + ", path=" + this.path + ", javadoc=" + this.javadoc + ", sources=" + this.sources + "]";
    }
}

