/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

import { ICodeEditor } from '../../../browser/editorBrowser';
import { EditorAction, ServicesAccessor, registerEditorAction } from '../../../browser/editorExtensions';
import { IStandaloneThemeService } from '../../common/standaloneTheme';
import { ToggleHighContrastNLS } from '../../../common/standaloneStrings';
import { isHighContrast } from '../../../../platform/theme/common/theme';

class ToggleHighContrast extends EditorAction {

	private _originalThemeName: string | null;

	constructor() {
		super({
			id: 'editor.action.toggleHighContrast',
			label: ToggleHighContrastNLS.toggleHighContrast,
			alias: 'Toggle High Contrast Theme',
			precondition: undefined
		});
		this._originalThemeName = null;
	}

	public run(accessor: ServicesAccessor, editor: ICodeEditor): void {
		const standaloneThemeService = accessor.get(IStandaloneThemeService);
		if (isHighContrast(standaloneThemeService.getColorTheme().type)) {
			// We must toggle back to the integrator's theme
			standaloneThemeService.setTheme(this._originalThemeName || 'vs');
			this._originalThemeName = null;
		} else {
			this._originalThemeName = standaloneThemeService.getColorTheme().themeName;
			standaloneThemeService.setTheme('hc-black');
		}
	}
}

registerEditorAction(ToggleHighContrast);
