"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tagged = void 0;
const metadata_1 = require("../planning/metadata");
const decorator_utils_1 = require("./decorator_utils");
function tagged(metadataKey, metadataValue) {
    return function (target, targetKey, index) {
        const metadata = new metadata_1.Metadata(metadataKey, metadataValue);
        if (typeof index === "number") {
            decorator_utils_1.tagParameter(target, targetKey, index, metadata);
        }
        else {
            decorator_utils_1.tagProperty(target, targetKey, metadata);
        }
    };
}
exports.tagged = tagged;
//# sourceMappingURL=tagged.js.map