/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.corext.codemanipulation.AddDelegateMethodsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corext.util.JdtFlags;
import org.eclipse.jdt.ls.core.internal.handlers.JdtDomModels;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.text.edits.TextEdit;

public class GenerateDelegateMethodsHandler {
    public static boolean supportsGenerateDelegateMethods(IType type) throws JavaModelException {
        if (type == null || type.getCompilationUnit() == null || type.isAnnotation() || type.isInterface()) {
            return false;
        }
        IField[] fields = type.getFields();
        int count = 0;
        IField[] iFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (!(JdtFlags.isEnum((IMember)field) || GenerateDelegateMethodsHandler.hasPrimitiveType(field) || GenerateDelegateMethodsHandler.isArray(field))) {
                ++count;
            }
            ++n2;
        }
        return count > 0;
    }

    private static boolean hasPrimitiveType(IField field) throws JavaModelException {
        String signature = field.getTypeSignature();
        char first = Signature.getElementType((String)signature).charAt(0);
        return first != 'L' && first != 'Q';
    }

    private static boolean isArray(IField field) throws JavaModelException {
        return Signature.getArrayCount((String)field.getTypeSignature()) > 0;
    }

    public static CheckDelegateMethodsResponse checkDelegateMethodsStatus(CodeActionParams params) {
        return GenerateDelegateMethodsHandler.checkDelegateMethodsStatus(params, (IProgressMonitor)new NullProgressMonitor());
    }

    public static CheckDelegateMethodsResponse checkDelegateMethodsStatus(CodeActionParams params, IProgressMonitor monitor) {
        IType type = SourceAssistProcessor.getSelectionType(params, monitor);
        if (type == null || type.getCompilationUnit() == null) {
            return new CheckDelegateMethodsResponse();
        }
        try {
            CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)type.getCompilationUnit(), CoreASTProvider.WAIT_YES, monitor);
            if (astRoot == null) {
                return new CheckDelegateMethodsResponse();
            }
            ITypeBinding typeBinding = ASTNodes.getTypeBinding((CompilationUnit)astRoot, (IType)type);
            if (typeBinding == null) {
                return new CheckDelegateMethodsResponse();
            }
            AddDelegateMethodsOperation.DelegateEntry[] delegateEntries = StubUtility2Core.getDelegatableMethods((ITypeBinding)typeBinding);
            LinkedHashMap<IVariableBinding, List> fieldToMethods = new LinkedHashMap<IVariableBinding, List>();
            AddDelegateMethodsOperation.DelegateEntry[] delegateEntryArray = delegateEntries;
            int n = delegateEntries.length;
            int n2 = 0;
            while (n2 < n) {
                AddDelegateMethodsOperation.DelegateEntry delegateEntry = delegateEntryArray[n2];
                List methods = fieldToMethods.getOrDefault(delegateEntry.field, new ArrayList());
                methods.add(delegateEntry.delegateMethod);
                fieldToMethods.put(delegateEntry.field, methods);
                ++n2;
            }
            return new CheckDelegateMethodsResponse((LspDelegateField[])fieldToMethods.entrySet().stream().map(entry -> new LspDelegateField((IVariableBinding)entry.getKey(), ((List)entry.getValue()).toArray(new IMethodBinding[0]))).toArray(LspDelegateField[]::new));
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Failed to check delegate methods status", e);
            return new CheckDelegateMethodsResponse();
        }
    }

    public static WorkspaceEdit generateDelegateMethods(GenerateDelegateMethodsParams params, IProgressMonitor monitor) {
        IType type = SourceAssistProcessor.getSelectionType(params.context, monitor);
        Preferences preferences = JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
        CodeGenerationSettings settings = new CodeGenerationSettings();
        settings.createComments = preferences.isCodeGenerationTemplateGenerateComments();
        TextEdit edit = GenerateDelegateMethodsHandler.generateDelegateMethods(type, params.delegateEntries, settings, monitor);
        return edit == null ? null : SourceAssistProcessor.convertToWorkspaceEdit(type.getCompilationUnit(), edit);
    }

    public static TextEdit generateDelegateMethods(IType type, LspDelegateEntry[] delegateEntries, CodeGenerationSettings settings) {
        return GenerateDelegateMethodsHandler.generateDelegateMethods(type, delegateEntries, settings, (IProgressMonitor)new NullProgressMonitor());
    }

    public static TextEdit generateDelegateMethods(IType type, LspDelegateEntry[] delegateEntries, CodeGenerationSettings settings, IProgressMonitor monitor) {
        ITypeBinding typeBinding;
        CompilationUnit astRoot;
        block7: {
            block6: {
                if (type == null || type.getCompilationUnit() == null || delegateEntries == null || delegateEntries.length == 0) {
                    return null;
                }
                astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)type.getCompilationUnit(), CoreASTProvider.WAIT_YES, monitor);
                if (astRoot != null) break block6;
                return null;
            }
            typeBinding = ASTNodes.getTypeBinding((CompilationUnit)astRoot, (IType)type);
            if (typeBinding != null) break block7;
            return null;
        }
        try {
            AddDelegateMethodsOperation.DelegateEntry[] methodEntries = StubUtility2Core.getDelegatableMethods((ITypeBinding)typeBinding);
            HashMap<String, AddDelegateMethodsOperation.DelegateEntry> delegateEntryMap = new HashMap<String, AddDelegateMethodsOperation.DelegateEntry>();
            AddDelegateMethodsOperation.DelegateEntry[] delegateEntryArray = methodEntries;
            int n = methodEntries.length;
            int n2 = 0;
            while (n2 < n) {
                AddDelegateMethodsOperation.DelegateEntry methodEntry = delegateEntryArray[n2];
                delegateEntryMap.put(String.valueOf(methodEntry.field.getKey()) + "#" + methodEntry.delegateMethod.getKey(), methodEntry);
                ++n2;
            }
            AddDelegateMethodsOperation.DelegateEntry[] selectedDelegateEntries = (AddDelegateMethodsOperation.DelegateEntry[])Arrays.stream(delegateEntries).map(delegateEntry -> (AddDelegateMethodsOperation.DelegateEntry)delegateEntryMap.get(String.valueOf(delegateEntry.field.bindingKey) + "#" + delegateEntry.delegateMethod.bindingKey)).filter(delegateEntry -> delegateEntry != null).toArray(AddDelegateMethodsOperation.DelegateEntry[]::new);
            AddDelegateMethodsOperation operation = new AddDelegateMethodsOperation(astRoot, selectedDelegateEntries, null, settings, false, false);
            operation.run(null);
            return operation.getResultingEdit();
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Failed to generate delegate methods", e);
            return null;
        }
    }

    public static class CheckDelegateMethodsResponse {
        public LspDelegateField[] delegateFields = new LspDelegateField[0];

        public CheckDelegateMethodsResponse() {
        }

        public CheckDelegateMethodsResponse(LspDelegateField[] delegateField) {
            this.delegateFields = delegateField;
        }
    }

    public static class GenerateDelegateMethodsParams {
        public CodeActionParams context;
        public LspDelegateEntry[] delegateEntries = new LspDelegateEntry[0];
    }

    public static class LspDelegateEntry {
        public JdtDomModels.LspVariableBinding field;
        public JdtDomModels.LspMethodBinding delegateMethod;

        public LspDelegateEntry(JdtDomModels.LspVariableBinding field, JdtDomModels.LspMethodBinding delegateMethod) {
            this.field = field;
            this.delegateMethod = delegateMethod;
        }
    }

    public static class LspDelegateField {
        public JdtDomModels.LspVariableBinding field;
        public JdtDomModels.LspMethodBinding[] delegateMethods = new JdtDomModels.LspMethodBinding[0];

        public LspDelegateField(IVariableBinding field, IMethodBinding[] methods) {
            this.field = new JdtDomModels.LspVariableBinding(field);
            this.delegateMethods = (JdtDomModels.LspMethodBinding[])Arrays.stream(methods).map(method -> new JdtDomModels.LspMethodBinding((IMethodBinding)method)).toArray(JdtDomModels.LspMethodBinding[]::new);
        }
    }
}

