/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.ls.core.internal.JDTEnvironmentUtils;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;
import org.eclipse.jdt.ls.core.internal.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class HoverInfoProvider {
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 0x10000000000000L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private static final long LOCAL_VARIABLE_FLAGS = LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private static final long COMMON_SIGNATURE_FLAGS = LABEL_FLAGS & (JavaElementLabels.ALL_FULLY_QUALIFIED ^ 0xFFFFFFFFFFFFFFFFL) | 0x40000L | 0x80L;
    private static final String LANGUAGE_ID = "java";
    private final ITypeRoot unit;
    private final PreferenceManager preferenceManager;

    public HoverInfoProvider(ITypeRoot aUnit, PreferenceManager preferenceManager) {
        this.unit = aUnit;
        this.preferenceManager = preferenceManager;
    }

    public List<Either<String, MarkedString>> computeHover(int line, int column, IProgressMonitor monitor) {
        LinkedList<Either<String, MarkedString>> res = new LinkedList<Either<String, MarkedString>>();
        try {
            if (monitor.isCanceled()) {
                return this.cancelled(res);
            }
            IJavaElement[] elements = JDTUtils.findElementsAtSelection(this.unit, line, column, this.preferenceManager, monitor);
            if (elements == null || elements.length == 0 || monitor.isCanceled()) {
                return this.cancelled(res);
            }
            IJavaElement curr = null;
            if (elements.length != 1) {
                IPackageFragment packageFragment = (IPackageFragment)this.unit.getParent();
                IJavaElement found = Stream.of(elements).filter(e -> e.equals(packageFragment)).findFirst().orElse(null);
                curr = found == null ? elements[0] : found;
            } else {
                curr = elements[0];
            }
            if (monitor.isCanceled()) {
                return this.cancelled(res);
            }
            if (JDTEnvironmentUtils.isSyntaxServer() || this.isResolved(curr, monitor)) {
                Optional<IBuildSupport> bs;
                IClassFile classFile;
                IBuffer buffer = curr.getOpenable().getBuffer();
                if (buffer == null && curr instanceof BinaryMember && (classFile = ((BinaryMember)curr).getClassFile()) != null && (bs = JavaLanguageServerPlugin.getProjectsManager().getBuildSupport(curr.getJavaProject().getProject())).isPresent()) {
                    bs.get().discoverSource(classFile, monitor);
                }
                if (monitor.isCanceled()) {
                    return this.cancelled(res);
                }
                MarkedString signature = HoverInfoProvider.computeSignature(curr);
                if (signature != null) {
                    res.add((Either<String, MarkedString>)Either.forRight((Object)signature));
                }
                if (monitor.isCanceled()) {
                    return this.cancelled(res);
                }
                MarkedString javadoc = HoverInfoProvider.computeJavadoc(curr);
                if (javadoc != null && javadoc.getValue() != null) {
                    res.add((Either<String, MarkedString>)Either.forLeft((Object)javadoc.getValue()));
                }
            }
        }
        catch (Exception e2) {
            JavaLanguageServerPlugin.logException("Error computing hover", e2);
        }
        if (monitor.isCanceled()) {
            return this.cancelled(res);
        }
        return res;
    }

    private List<Either<String, MarkedString>> cancelled(List<Either<String, MarkedString>> res) {
        res.clear();
        res.add((Either<String, MarkedString>)Either.forLeft((Object)""));
        return res;
    }

    private boolean isResolved(IJavaElement element, IProgressMonitor monitor) throws CoreException {
        if (!(this.unit instanceof ICompilationUnit)) {
            return true;
        }
        if (element == null) {
            return false;
        }
        if (element.getElementType() != 7) {
            return true;
        }
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)element, (int)3);
        final boolean[] res = new boolean[]{false};
        SearchEngine engine = new SearchEngine();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.unit}, (int)7);
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (match.getAccuracy() == 1) {
                        return;
                    }
                    Object o = match.getElement();
                    if (o instanceof IJavaElement) {
                        IJavaElement element = (IJavaElement)o;
                        if (element.getElementType() == 7) {
                            res[0] = true;
                            return;
                        }
                        ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
                        if (compilationUnit == null) {
                            return;
                        }
                        res[0] = true;
                        throw new HoverException();
                    }
                }
            }, monitor);
        }
        catch (OperationCanceledException | HoverException object) {
            // empty catch block
        }
        return res[0];
    }

    public static MarkedString computeSignature(IJavaElement element) {
        if (element == null) {
            return null;
        }
        String elementLabel = null;
        elementLabel = element instanceof ILocalVariable ? JavaElementLabels.getElementLabel(element, LOCAL_VARIABLE_FLAGS) : JavaElementLabels.getElementLabel(element, COMMON_SIGNATURE_FLAGS);
        if (element instanceof IField) {
            String constantValue;
            IField field = (IField)element;
            Region region = null;
            try {
                ISourceRange nameRange = JDTUtils.getNameRange((IJavaElement)field);
                if (SourceRange.isAvailable((ISourceRange)nameRange)) {
                    region = new Region(nameRange.getOffset(), nameRange.getLength());
                }
            }
            catch (JavaModelException nameRange) {
                // empty catch block
            }
            if ((constantValue = JDTUtils.getConstantValue(field, field.getTypeRoot(), region)) != null) {
                elementLabel = String.valueOf(elementLabel) + " = " + constantValue;
            }
        }
        return new MarkedString(LANGUAGE_ID, elementLabel);
    }

    private static String getDefaultValue(IMethod method) {
        if (method != null) {
            Region region = null;
            try {
                ISourceRange nameRange = JDTUtils.getNameRange((IJavaElement)method);
                if (SourceRange.isAvailable((ISourceRange)nameRange)) {
                    region = new Region(nameRange.getOffset(), nameRange.getLength());
                }
            }
            catch (JavaModelException nameRange) {
                // empty catch block
            }
            try {
                return JDTUtils.getAnnotationMemberDefaultValue(method, method.getTypeRoot(), region);
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        return null;
    }

    public static MarkedString computeJavadoc(IJavaElement element) throws CoreException {
        Reader r;
        IMember member = null;
        String result = null;
        if (element instanceof ITypeParameter) {
            member = ((ITypeParameter)element).getDeclaringMember();
        } else if (element instanceof IMember) {
            member = (IMember)element;
        } else if (element instanceof IPackageFragment && (r = JavadocContentAccess2.getMarkdownContentReader(element)) != null) {
            result = HoverInfoProvider.getString(r);
        }
        if (member != null) {
            String defaultValue;
            r = JavadocContentAccess2.getMarkdownContentReader((IJavaElement)member);
            if (r != null) {
                result = HoverInfoProvider.getString(r);
            }
            if (member instanceof IMethod && (defaultValue = HoverInfoProvider.getDefaultValue((IMethod)member)) != null) {
                result = JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isSupportsCompletionDocumentationMarkdown() ? String.valueOf(result == null ? "" : result) + "\n" + "Default: " + defaultValue : String.valueOf(result == null ? "" : result) + "Default: " + defaultValue;
            }
        }
        return result != null ? new MarkedString(LANGUAGE_ID, result) : null;
    }

    private static String getString(Reader reader) {
        try {
            return CharStreams.toString((Readable)reader);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private class HoverException
    extends CoreException {
        private static final long serialVersionUID = 1L;

        public HoverException() {
            super((IStatus)new Status(0, "org.eclipse.jdt.ls.core", ""));
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

