"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomEmitter = void 0;
const event_1 = require("../common/event");
class DomEmitter {
    get event() {
        return this.emitter.event;
    }
    constructor(element, type, useCapture) {
        const fn = (e) => this.emitter.fire(e);
        this.emitter = new event_1.Emitter({
            onFirstListenerAdd: () => element.addEventListener(type, fn, useCapture),
            onLastListenerRemove: () => element.removeEventListener(type, fn, useCapture)
        });
    }
    dispose() {
        this.emitter.dispose();
    }
}
exports.DomEmitter = DomEmitter;
//# sourceMappingURL=event.js.map