"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GotoLineAction = exports.StandaloneGotoLineQuickAccessProvider = void 0;
const gotoLineQuickAccess_1 = require("../../../contrib/quickAccess/browser/gotoLineQuickAccess");
const platform_1 = require("../../../../platform/registry/common/platform");
const quickAccess_1 = require("../../../../platform/quickinput/common/quickAccess");
const codeEditorService_1 = require("../../../browser/services/codeEditorService");
const types_1 = require("../../../../base/common/types");
const standaloneStrings_1 = require("../../../common/standaloneStrings");
const event_1 = require("../../../../base/common/event");
const editorExtensions_1 = require("../../../browser/editorExtensions");
const editorContextKeys_1 = require("../../../common/editorContextKeys");
const quickInput_1 = require("../../../../platform/quickinput/common/quickInput");
let StandaloneGotoLineQuickAccessProvider = class StandaloneGotoLineQuickAccessProvider extends gotoLineQuickAccess_1.AbstractGotoLineQuickAccessProvider {
    constructor(editorService) {
        super();
        this.editorService = editorService;
        this.onDidActiveTextEditorControlChange = event_1.Event.None;
    }
    get activeTextEditorControl() {
        return (0, types_1.withNullAsUndefined)(this.editorService.getFocusedCodeEditor());
    }
};
StandaloneGotoLineQuickAccessProvider = __decorate([
    __param(0, codeEditorService_1.ICodeEditorService)
], StandaloneGotoLineQuickAccessProvider);
exports.StandaloneGotoLineQuickAccessProvider = StandaloneGotoLineQuickAccessProvider;
class GotoLineAction extends editorExtensions_1.EditorAction {
    constructor() {
        super({
            id: GotoLineAction.ID,
            label: standaloneStrings_1.GoToLineNLS.gotoLineActionLabel,
            alias: 'Go to Line/Column...',
            precondition: undefined,
            kbOpts: {
                kbExpr: editorContextKeys_1.EditorContextKeys.focus,
                primary: 2048 /* KeyMod.CtrlCmd */ | 37 /* KeyCode.KeyG */,
                mac: { primary: 256 /* KeyMod.WinCtrl */ | 37 /* KeyCode.KeyG */ },
                weight: 100 /* KeybindingWeight.EditorContrib */
            }
        });
    }
    run(accessor) {
        accessor.get(quickInput_1.IQuickInputService).quickAccess.show(StandaloneGotoLineQuickAccessProvider.PREFIX);
    }
}
exports.GotoLineAction = GotoLineAction;
GotoLineAction.ID = 'editor.action.gotoLine';
(0, editorExtensions_1.registerEditorAction)(GotoLineAction);
platform_1.Registry.as(quickAccess_1.Extensions.Quickaccess).registerQuickAccessProvider({
    ctor: StandaloneGotoLineQuickAccessProvider,
    prefix: StandaloneGotoLineQuickAccessProvider.PREFIX,
    helpEntries: [{ description: standaloneStrings_1.GoToLineNLS.gotoLineActionLabel, commandId: GotoLineAction.ID }]
});
//# sourceMappingURL=standaloneGotoLineQuickAccess.js.map