// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************

import { injectable } from '@theia/core/shared/inversify';
import { AbstractViewContribution } from '@theia/core/lib/browser/shell/view-contribution';
import { PLUGINS_LABEL, PluginWidget } from './plugin-ext-widget';

@injectable()
export class PluginFrontendViewContribution extends AbstractViewContribution<PluginWidget> {

    public static PLUGINS_WIDGET_FACTORY_ID = 'plugins';

    constructor() {
        super({
            widgetId: PluginFrontendViewContribution.PLUGINS_WIDGET_FACTORY_ID,
            widgetName: PLUGINS_LABEL,
            defaultWidgetOptions: {
                area: 'left',
                rank: 400
            },
            toggleCommandId: 'pluginsView:toggle'
        });
    }

}
