/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class NavigateToDefinitionHandler {
    private final PreferenceManager preferenceManager;

    public NavigateToDefinitionHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<? extends Location> definition(TextDocumentPositionParams position, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ITypeRoot unit = JDTUtils.resolveTypeRoot(position.getTextDocument().getUri());
        Location location = null;
        if (unit != null && !monitor.isCanceled()) {
            location = this.computeDefinitionNavigation(unit, position.getPosition().getLine(), position.getPosition().getCharacter(), monitor);
        }
        return location == null || monitor.isCanceled() ? Collections.emptyList() : Arrays.asList(location);
    }

    private Location computeDefinitionNavigation(ITypeRoot unit, int line, int column, IProgressMonitor monitor) {
        IJavaElement element;
        block4: {
            try {
                element = JDTUtils.findElementAtSelection(unit, line, column, this.preferenceManager, monitor);
                if (!monitor.isCanceled()) break block4;
                return null;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem computing definition for" + unit.getElementName(), e);
                return null;
            }
        }
        if (element == null) {
            return this.computeBreakContinue(unit, line, column);
        }
        return NavigateToDefinitionHandler.computeDefinitionNavigation(element, unit.getJavaProject());
    }

    private Location computeBreakContinue(ITypeRoot typeRoot, int line, int column) throws CoreException {
        int offset = JsonRpcHelpers.toOffset(typeRoot.getBuffer(), line, column);
        if (offset >= 0) {
            CompilationUnit unit = SharedASTProviderCore.getAST((ITypeRoot)typeRoot, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_YES, null);
            if (unit == null) {
                return null;
            }
            ASTNode selectedNode = NodeFinder.perform((ASTNode)unit, (int)offset, (int)0);
            ASTNode node = null;
            SimpleName label = null;
            if (selectedNode instanceof BreakStatement) {
                node = selectedNode;
                label = ((BreakStatement)node).getLabel();
            } else if (selectedNode instanceof ContinueStatement) {
                node = selectedNode;
                label = ((ContinueStatement)node).getLabel();
            } else if (selectedNode instanceof SimpleName && selectedNode.getParent() instanceof BreakStatement) {
                node = selectedNode.getParent();
                label = ((BreakStatement)node).getLabel();
            } else if (selectedNode instanceof SimpleName && selectedNode.getParent() instanceof ContinueStatement) {
                node = selectedNode.getParent();
                label = ((ContinueStatement)node).getLabel();
            }
            if (node != null) {
                ASTNode parent = node.getParent();
                ASTNode target = null;
                while (parent != null) {
                    LabeledStatement ls;
                    if (parent instanceof MethodDeclaration || parent instanceof Initializer) break;
                    if (label == null) {
                        if (parent instanceof ForStatement || parent instanceof EnhancedForStatement || parent instanceof WhileStatement || parent instanceof DoStatement) {
                            target = parent;
                            break;
                        }
                        if (node instanceof BreakStatement && (parent instanceof SwitchStatement || parent instanceof SwitchExpression)) {
                            target = parent;
                            break;
                        }
                        if (node instanceof LabeledStatement) {
                            target = parent;
                            break;
                        }
                    } else if (LabeledStatement.class.isInstance(parent) && (ls = (LabeledStatement)parent).getLabel().getIdentifier().equals(label.getIdentifier())) {
                        target = ls;
                        break;
                    }
                    parent = parent.getParent();
                }
                if (target != null) {
                    int start = target.getStartPosition();
                    int end = new TokenScanner(unit.getTypeRoot()).getNextEndOffset(node.getStartPosition(), true) - start;
                    if (start >= 0 && end >= 0) {
                        return JDTUtils.toLocation((ICompilationUnit)typeRoot, start, end);
                    }
                }
            }
        }
        return null;
    }

    public static Location computeDefinitionNavigation(IJavaElement element, IJavaProject javaProject) throws JavaModelException {
        if (element == null) {
            return null;
        }
        ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
        IClassFile cf = (IClassFile)element.getAncestor(6);
        if (compilationUnit != null || cf != null && cf.getSourceRange() != null) {
            return NavigateToDefinitionHandler.fixLocation(element, JDTUtils.toLocation(element), javaProject);
        }
        if (element instanceof IMember && ((IMember)element).getClassFile() != null) {
            return NavigateToDefinitionHandler.fixLocation(element, JDTUtils.toLocation(((IMember)element).getClassFile()), javaProject);
        }
        return null;
    }

    private static Location fixLocation(IJavaElement element, Location location, IJavaProject javaProject) {
        if (location == null) {
            return null;
        }
        if (!javaProject.equals(element.getJavaProject()) && element.getJavaProject().getProject().getName().equals("jdt.ls-java-project") && location.getUri().contains("jdt.ls-java-project")) {
            String patched = StringUtils.replaceOnce((String)location.getUri(), (String)"jdt.ls-java-project", (String)javaProject.getProject().getName());
            try {
                IClassFile cf = (IClassFile)JavaCore.create((String)JDTUtils.toURI(patched).getQuery());
                if (cf != null && cf.exists()) {
                    location.setUri(patched);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return location;
    }
}

