/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.runner.testng;

import com.microsoft.java.test.runner.testng.TestNGListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.TestNG;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestNGRunner {
    public void run(Map<String, List<String>> map) {
        XmlSuite suite = new XmlSuite();
        this.createTests(map, suite);
        TestNG testNG = new TestNG();
        testNG.setUseDefaultListeners(false);
        TestNGListener listener = new TestNGListener();
        try {
            testNG.addListener((ITestNGListener)listener);
        }
        catch (NoSuchMethodError e) {
            testNG.addListener((ITestListener)listener);
        }
        testNG.setXmlSuites(Collections.singletonList(suite));
        testNG.run();
    }

    private void createTests(Map<String, List<String>> map, XmlSuite suite) {
        XmlTest test = new XmlTest(suite);
        test.setName("TestNGTest-" + UUID.randomUUID().toString());
        ArrayList<XmlClass> classes = new ArrayList<XmlClass>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            classes.add(this.createClass(entry.getKey(), entry.getValue()));
        }
        test.setXmlClasses(classes);
    }

    private XmlClass createClass(String clazz, List<String> methods) {
        XmlClass xmlClass = new XmlClass(clazz);
        if (methods.size() != 0) {
            ArrayList<XmlInclude> includes = new ArrayList<XmlInclude>();
            for (String method : methods) {
                includes.add(new XmlInclude(method));
            }
            xmlClass.setIncludedMethods(includes);
        }
        return xmlClass;
    }
}

