/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public final class MapFlattener {
    private MapFlattener() {
    }

    public static String getString(Map<String, Object> configuration, String key) {
        return MapFlattener.getString(configuration, key, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String getString(Map<String, Object> configuration, String key, String def) {
        String string;
        Object object = MapFlattener.getValue(configuration, key);
        if (object instanceof String) {
            void val;
            String string2 = (String)object;
            String cfr_ignored_0 = (String)object;
            string = val;
        } else {
            string = def;
        }
        return string;
    }

    public static List<String> getList(Map<String, Object> configuration, String key) {
        return MapFlattener.getList(configuration, key, null);
    }

    public static List<String> getList(Map<String, Object> configuration, String key, List<String> def) {
        Object val = MapFlattener.getValue(configuration, key);
        Object object = val;
        if (object instanceof String) {
            String str;
            String string = (String)object;
            String cfr_ignored_0 = (String)object;
            if (!str.trim().startsWith("[")) {
                if (str.contains(",")) {
                    str = String.valueOf('[') + (String)val + ']';
                } else {
                    String[] elements = str.split(" ");
                    return Arrays.stream(elements).filter(e -> e != null && !e.isEmpty()).collect(Collectors.toList());
                }
            }
            try {
                Gson gson = new Gson();
                Type type = new TypeToken<List<String>>(){}.getType();
                List list = (List)gson.fromJson(str, type);
                return list;
            }
            catch (JsonSyntaxException e2) {
                JavaLanguageServerPlugin.logException(e2.getMessage(), e2);
                return def;
            }
        }
        if (val instanceof List) {
            try {
                List ret = (List)val;
                return ret;
            }
            catch (Exception e3) {
                JavaLanguageServerPlugin.logException(e3.getMessage(), e3);
            }
        }
        return def;
    }

    public static boolean getBoolean(Map<String, Object> configuration, String key) {
        return MapFlattener.getBoolean(configuration, key, false);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean getBoolean(Map<String, Object> configuration, String key, boolean def) {
        Object val = MapFlattener.getValue(configuration, key);
        Object object = val;
        if (object instanceof Boolean) {
            void b;
            Boolean bl = (Boolean)object;
            Boolean cfr_ignored_0 = (Boolean)object;
            return b.booleanValue();
        }
        Object object2 = val;
        if (object2 instanceof String) {
            void s;
            String string = (String)object2;
            String cfr_ignored_1 = (String)object2;
            return Boolean.parseBoolean((String)s);
        }
        return def;
    }

    public static int getInt(Map<String, Object> configuration, String key) {
        return MapFlattener.getInt(configuration, key, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int getInt(Map<String, Object> configuration, String key, int def) {
        Object val = MapFlattener.getValue(configuration, key);
        Object object = val;
        if (object instanceof Number) {
            void n;
            Number number = (Number)object;
            Number cfr_ignored_0 = (Number)object;
            return n.intValue();
        }
        Object object2 = val;
        if (object2 instanceof String) {
            String string = (String)object2;
            String cfr_ignored_1 = (String)object2;
            try {
                void s;
                return Integer.parseInt((String)s);
            }
            catch (NumberFormatException nfe) {
                JavaLanguageServerPlugin.logError(String.valueOf(key) + " value (" + val + ") is not an int, falling back on " + def);
            }
        }
        return def;
    }

    public static Object getValue(Map<String, Object> configuration, String key) {
        Object value = configuration.get(key);
        if (value != null) {
            return value;
        }
        String[] keyParts = key.split("\\.");
        String currKey = null;
        Map currMap = configuration;
        int i = 0;
        while (i < keyParts.length) {
            currKey = keyParts[i];
            Object val = currMap.get(currKey);
            if (i == keyParts.length - 1) {
                return val;
            }
            if (!(val instanceof Map)) {
                return null;
            }
            currMap = (Map)val;
            ++i;
        }
        return null;
    }
}

