/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.preferences;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.ls.core.internal.ActionableNotification;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.RuntimeEnvironment;
import org.eclipse.jdt.ls.core.internal.commands.ProjectCommand;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionGuessMethodArgumentsMode;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionMatchCaseMode;
import org.eclipse.jdt.ls.core.internal.handlers.InlayHintsParameterMode;
import org.eclipse.jdt.ls.core.internal.handlers.MapFlattener;
import org.eclipse.jdt.ls.core.internal.handlers.ProjectEncodingMode;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.MessageType;

public class Preferences {
    private static final String IGNORE = "ignore";
    public static final String LINE = "line";
    public static final String JAVA_HOME = "java.home";
    public static final String JAVA_REFERENCES_INCLUDE_ACCESSORS = "java.references.includeAccessors";
    public static final String JAVA_REFERENCES_INCLUDE_DECOMPILED_SOURCES = "java.references.includeDecompiledSources";
    public static final String JAVA_SYMBOLS_INCLUDE_SOURCE_METHOD_DECLARATIONS = "java.symbols.includeSourceMethodDeclarations";
    public static final String JAVA_CONFIGURATION_INSERTSPACES = "java.format.insertSpaces";
    public static final String JAVA_CONFIGURATION_TABSIZE = "java.format.tabSize";
    public static final String JAVA_CONFIGURATION_RUNTIMES = "java.configuration.runtimes";
    public static final List<String> JAVA_CONFIGURATION_RUNTIMES_DEFAULT;
    public static final String JAVA_FORMATTER_URL = "java.format.settings.url";
    public static final String JAVA_FORMATTER_PROFILE_NAME = "java.format.settings.profile";
    public static final String JAVA_FORMAT_COMMENTS = "java.format.comments.enabled";
    public static final String JAVA_SETTINGS_URL = "java.settings.url";
    public static final String JAVA_RESOURCE_FILTERS = "java.project.resourceFilters";
    public static final List<String> JAVA_RESOURCE_FILTERS_DEFAULT;
    public static final String QUICK_FIX_SHOW_AT = "java.quickfix.showAt";
    public static final String IMPORT_GRADLE_ENABLED = "java.import.gradle.enabled";
    public static final String IMPORT_GRADLE_OFFLINE_ENABLED = "java.import.gradle.offline.enabled";
    public static final String GRADLE_WRAPPER_ENABLED = "java.import.gradle.wrapper.enabled";
    public static final String GRADLE_VERSION = "java.import.gradle.version";
    public static final String GRADLE_ARGUMENTS = "java.import.gradle.arguments";
    public static final String GRADLE_JVM_ARGUMENTS = "java.import.gradle.jvmArguments";
    public static final String GRADLE_HOME = "java.import.gradle.home";
    public static final String GRADLE_JAVA_HOME = "java.import.gradle.java.home";
    public static final String GRADLE_USER_HOME = "java.import.gradle.user.home";
    public static final String GRADLE_ANNOTATION_PROCESSING_ENABLED = "java.import.gradle.annotationProcessing.enabled";
    public static final String IMPORT_MAVEN_ENABLED = "java.import.maven.enabled";
    public static final String IMPORT_MAVEN_OFFLINE = "java.import.maven.offline.enabled";
    public static final String MAVEN_DISABLE_TEST_CLASSPATH_FLAG = "java.import.maven.disableTestClasspathFlag";
    public static final String MAVEN_DOWNLOAD_SOURCES = "java.maven.downloadSources";
    public static final String ECLIPSE_DOWNLOAD_SOURCES = "java.eclipse.downloadSources";
    public static final String MAVEN_UPDATE_SNAPSHOTS = "java.maven.updateSnapshots";
    public static final String REFERENCES_CODE_LENS_ENABLED_KEY = "java.referencesCodeLens.enabled";
    public static final String IMPLEMENTATIONS_CODE_LENS_ENABLED_KEY = "java.implementationsCodeLens.enabled";
    public static final String JAVA_FORMAT_ENABLED_KEY = "java.format.enabled";
    public static final String JAVA_FORMAT_ON_TYPE_ENABLED_KEY = "java.format.onType.enabled";
    public static final String JAVA_SAVE_ACTIONS_ORGANIZE_IMPORTS_KEY = "java.saveActions.organizeImports";
    public static final String SIGNATURE_HELP_ENABLED_KEY = "java.signatureHelp.enabled";
    public static final String SIGNATURE_HELP_DESCRIPTION_ENABLED_KEY = "java.signatureHelp.description.enabled";
    public static final String RENAME_ENABLED_KEY = "java.rename.enabled";
    public static final String EXECUTE_COMMAND_ENABLED_KEY = "java.executeCommand.enabled";
    public static final String AUTOBUILD_ENABLED_KEY = "java.autobuild.enabled";
    public static final String JAVA_MAX_CONCURRENT_BUILDS = "java.maxConcurrentBuilds";
    public static final String JAVA_IMPORT_EXCLUSIONS_KEY = "java.import.exclusions";
    public static final List<String> JAVA_IMPORT_EXCLUSIONS_DEFAULT;
    public static final String JAVA_PROJECT_REFERENCED_LIBRARIES_KEY = "java.project.referencedLibraries";
    public static final ReferencedLibraries JAVA_PROJECT_REFERENCED_LIBRARIES_DEFAULT;
    public static final String JAVA_PROJECT_OUTPUT_PATH_KEY = "java.project.outputPath";
    public static final String JAVA_PROJECT_SOURCE_PATHS_KEY = "java.project.sourcePaths";
    public static final String CONFIGURATION_UPDATE_BUILD_CONFIGURATION_KEY = "java.configuration.updateBuildConfiguration";
    public static final String ERRORS_INCOMPLETE_CLASSPATH_SEVERITY_KEY = "java.errors.incompleteClasspath.severity";
    public static final String MAVEN_USER_SETTINGS_KEY = "java.configuration.maven.userSettings";
    public static final String MAVEN_GLOBAL_SETTINGS_KEY = "java.configuration.maven.globalSettings";
    public static final String MAVEN_NOT_COVERED_PLUGIN_EXECUTION_SEVERITY = "java.configuration.maven.notCoveredPluginExecutionSeverity";
    public static final String MAVEN_DEFAULT_MOJO_EXECUTION_ACTION = "java.configuration.maven.defaultMojoExecutionAction";
    public static final String COMPLETION_ENABLED_KEY = "java.completion.enabled";
    public static final String POSTFIX_COMPLETION_KEY = "java.completion.postfix.enabled";
    public static final String COMPLETION_MATCH_CASE_MODE_KEY = "java.completion.matchCase";
    public static final String COMPLETION_LAZY_RESOLVE_TEXT_EDIT_ENABLED_KEY = "java.completion.lazyResolveTextEdit.enabled";
    public static final String FOLDINGRANGE_ENABLED_KEY = "java.foldingRange.enabled";
    public static final String SELECTIONRANGE_ENABLED_KEY = "java.selectionRange.enabled";
    public static final String JAVA_GRADLE_WRAPPER_SHA256_KEY = "java.imports.gradle.wrapper.checksums";
    public static final List<String> JAVA_GRADLE_WRAPPER_SHA256_DEFAULT;
    public static final String JAVA_COMPLETION_FAVORITE_MEMBERS_KEY = "java.completion.favoriteStaticMembers";
    public static final List<String> JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT;
    public static final String JAVA_COMPLETION_MAX_RESULTS_KEY = "java.completion.maxResults";
    public static final int JAVA_COMPLETION_MAX_RESULTS_DEFAULT = 50;
    public static final String JAVA_COMPLETION_OVERWRITE_KEY = "java.completion.overwrite";
    public static final String JAVA_COMPLETION_GUESS_METHOD_ARGUMENTS_KEY = "java.completion.guessMethodArguments";
    public static final String MEMBER_SORT_ORDER = "java.memberSortOrder";
    public static final String IMPORTS_ONDEMANDTHRESHOLD = "java.sources.organizeImports.starThreshold";
    public static final String IMPORTS_STATIC_ONDEMANDTHRESHOLD = "java.sources.organizeImports.staticStarThreshold";
    public static final int IMPORTS_ONDEMANDTHRESHOLD_DEFAULT = 99;
    public static final int IMPORTS_STATIC_ONDEMANDTHRESHOLD_DEFAULT = 99;
    public static final String PREFERRED_CONTENT_PROVIDER_KEY = "java.contentProvider.preferred";
    public static final String JAVA_IMPORT_ORDER_KEY = "java.completion.importOrder";
    public static final List<String> JAVA_IMPORT_ORDER_DEFAULT;
    public static final String JAVA_COMPLETION_FILTERED_TYPES_KEY = "java.completion.filteredTypes";
    public static final List<String> JAVA_COMPLETION_FILTERED_TYPES_DEFAULT;
    public static final String JAVA_CODEGENERATION_HASHCODEEQUALS_USEJAVA7OBJECTS = "java.codeGeneration.hashCodeEquals.useJava7Objects";
    public static final String JAVA_CODEGENERATION_HASHCODEEQUALS_USEINSTANCEOF = "java.codeGeneration.hashCodeEquals.useInstanceof";
    public static final String JAVA_CODEGENERATION_USEBLOCKS = "java.codeGeneration.useBlocks";
    public static final String JAVA_CODEGENERATION_GENERATECOMMENTS = "java.codeGeneration.generateComments";
    public static final String JAVA_CODEGENERATION_INSERTIONLOCATION = "java.codeGeneration.insertionLocation";
    public static final String JAVA_TEMPLATES_FILEHEADER = "java.templates.fileHeader";
    public static final String JAVA_TEMPLATES_TYPECOMMENT = "java.templates.typeComment";
    public static final String JAVA_PROJECT_ENCODING = "java.project.encoding";
    public static final String JAVA_TELEMETRY_ENABLED_KEY = "java.telemetry.enabled";
    public static final String JAVA_EDIT_VALIDATE_ALL_OPEN_BUFFERS_ON_CHANGES = "java.edit.validateAllOpenBuffersOnChanges";
    public static final String JAVA_CODEGENERATION_TOSTRING_TEMPLATE = "java.codeGeneration.toString.template";
    public static final String JAVA_CODEGENERATION_TOSTRING_CODESTYLE = "java.codeGeneration.toString.codeStyle";
    public static final String JAVA_CODEGENERATION_TOSTRING_SKIPNULLVALUES = "java.codeGeneration.toString.skipNullValues";
    public static final String JAVA_CODEGENERATION_TOSTRING_LISTARRAYCONTENTS = "java.codeGeneration.toString.listArrayContents";
    public static final String JAVA_CODEGENERATION_TOSTRING_LIMITELEMENTS = "java.codeGeneration.toString.limitElements";
    public static final String JAVA_INLAYHINTS_PARAMETERNAMES_ENABLED = "java.inlayHints.parameterNames.enabled";
    public static final String JAVA_INLAYHINTS_PARAMETERNAMES_EXCLUSIONS = "java.inlayHints.parameterNames.exclusions";
    public static final String JAVA_CODEACTION_SORTMEMBER_AVOIDVOLATILECHANGES = "java.codeAction.sortMembers.avoidVolatileChanges";
    public static final String JAVA_JDT_LS_PROTOBUF_SUPPORT_ENABLED = "java.jdt.ls.protobufSupport.enabled";
    public static final String JAVA_JDT_LS_ANDROID_SUPPORT_ENABLED = "java.jdt.ls.androidSupport.enabled";
    public static final String JAVA_COMPILE_NULLANALYSIS_NONNULL = "java.compile.nullAnalysis.nonnull";
    public static final String JAVA_COMPILE_NULLANALYSIS_NULLABLE = "java.compile.nullAnalysis.nullable";
    public static final String JAVA_COMPILE_NULLANALYSIS_MODE = "java.compile.nullAnalysis.mode";
    public static final String JAVA_CLEANUPS_ACTIONS_ON_SAVE = "java.cleanup.actionsOnSave";
    public static final String JAVA_REFACTORING_EXTRACT_INTERFACE_REPLACE = "java.refactoring.extract.interface.replace";
    public static final String CHAIN_COMPLETION_KEY = "java.completion.chain.enabled";
    public static final String TEXT_DOCUMENT_FORMATTING = "textDocument/formatting";
    public static final String TEXT_DOCUMENT_RANGE_FORMATTING = "textDocument/rangeFormatting";
    public static final String TEXT_DOCUMENT_ON_TYPE_FORMATTING = "textDocument/onTypeFormatting";
    public static final String TEXT_DOCUMENT_CODE_LENS = "textDocument/codeLens";
    public static final String TEXT_DOCUMENT_SIGNATURE_HELP = "textDocument/signatureHelp";
    public static final String TEXT_DOCUMENT_RENAME = "textDocument/rename";
    public static final String WORKSPACE_EXECUTE_COMMAND = "workspace/executeCommand";
    public static final String WORKSPACE_SYMBOL = "workspace/symbol";
    public static final String WORKSPACE_WATCHED_FILES = "workspace/didChangeWatchedFiles";
    public static final String DOCUMENT_SYMBOL = "textDocument/documentSymbol";
    public static final String COMPLETION = "textDocument/completion";
    public static final String CODE_ACTION = "textDocument/codeAction";
    public static final String DEFINITION = "textDocument/definition";
    public static final String DECLARATION = "textDocument/declaration";
    public static final String TYPEDEFINITION = "textDocument/typeDefinition";
    public static final String HOVER = "textDocument/hover";
    public static final String REFERENCES = "textDocument/references";
    public static final String DOCUMENT_HIGHLIGHT = "textDocument/documentHighlight";
    public static final String FOLDINGRANGE = "textDocument/foldingRange";
    public static final String WORKSPACE_CHANGE_FOLDERS = "workspace/didChangeWorkspaceFolders";
    public static final String IMPLEMENTATION = "textDocument/implementation";
    public static final String SELECTION_RANGE = "textDocument/selectionRange";
    public static final String INLAY_HINT = "textDocument/inlayHint";
    public static final String FORMATTING_ID;
    public static final String FORMATTING_ON_TYPE_ID;
    public static final String FORMATTING_RANGE_ID;
    public static final String CODE_LENS_ID;
    public static final String SIGNATURE_HELP_ID;
    public static final String RENAME_ID;
    public static final String EXECUTE_COMMAND_ID;
    public static final String WORKSPACE_SYMBOL_ID;
    public static final String DOCUMENT_SYMBOL_ID;
    public static final String COMPLETION_ID;
    public static final String CODE_ACTION_ID;
    public static final String DEFINITION_ID;
    public static final String DECLARATION_ID;
    public static final String TYPEDEFINITION_ID;
    public static final String HOVER_ID;
    public static final String REFERENCES_ID;
    public static final String DOCUMENT_HIGHLIGHT_ID;
    public static final String FOLDINGRANGE_ID;
    public static final String WORKSPACE_CHANGE_FOLDERS_ID;
    public static final String WORKSPACE_WATCHED_FILES_ID;
    public static final String IMPLEMENTATION_ID;
    public static final String SELECTION_RANGE_ID;
    public static final String INLAY_HINT_ID;
    private static final String GRADLE_OFFLINE_MODE = "gradle.offline.mode";
    private static final int DEFAULT_TAB_SIZE = 4;
    private static Map<String, List<String>> nonnullClasspathStorage;
    private static Map<String, List<String>> nullableClasspathStorage;
    private Map<String, Object> configuration = null;
    private Severity incompleteClasspathSeverity;
    private FeatureStatus updateBuildConfigurationStatus;
    private boolean referencesCodeLensEnabled = true;
    private boolean importGradleEnabled = true;
    private boolean importGradleOfflineEnabled = false;
    private boolean gradleWrapperEnabled = true;
    private String gradleVersion = null;
    private List<String> gradleArguments;
    private List<String> gradleJvmArguments;
    private String gradleHome = null;
    private String gradleJavaHome = null;
    private String gradleUserHome = null;
    private boolean gradleAnnotationProcessingEnabled = true;
    private boolean importMavenEnabled = true;
    private boolean mavenOffline = false;
    private boolean mavenDisableTestClasspathFlag = false;
    private boolean mavenDownloadSources = false;
    private boolean eclipseDownloadSources = false;
    private boolean mavenUpdateSnapshots = false;
    private boolean implementationsCodeLensEnabled = false;
    private boolean javaFormatEnabled = true;
    private String javaQuickFixShowAt = "line";
    private boolean javaFormatOnTypeEnabled = false;
    private boolean javaSaveActionsOrganizeImportsEnabled = false;
    private boolean signatureHelpEnabled = false;
    private boolean signatureHelpDescriptionEnabled = false;
    private boolean renameEnabled = true;
    private boolean executeCommandEnabled = true;
    private boolean autobuildEnabled = true;
    private boolean completionEnabled = true;
    private boolean postfixCompletionEnabled = true;
    private CompletionMatchCaseMode completionMatchCaseMode;
    private boolean completionLazyResolveTextEditEnabled = false;
    private boolean completionOverwrite = true;
    private boolean foldingRangeEnabled = true;
    private boolean selectionRangeEnabled = true;
    private CompletionGuessMethodArgumentsMode guessMethodArguments;
    private boolean javaFormatComments = true;
    private boolean hashCodeEqualsTemplateUseJava7Objects = false;
    private boolean hashCodeEqualsTemplateUseInstanceof = false;
    private boolean codeGenerationTemplateUseBlocks = false;
    private boolean codeGenerationTemplateGenerateComments = false;
    private String generateToStringTemplate;
    private String generateToStringCodeStyle;
    private boolean generateToStringSkipNullValues = false;
    private boolean generateToStringListArrayContents = true;
    private int generateToStringLimitElements = 0;
    private String codeGenerationInsertionLocation = null;
    private List<String> preferredContentProviderIds = null;
    private boolean includeAccessors = true;
    private boolean includeDecompiledSources = true;
    private boolean includeSourceMethodDeclarations = false;
    private String mavenUserSettings;
    private String mavenGlobalSettings;
    private String mavenNotCoveredPluginExecutionSeverity = "ignore";
    private String mavenDefaultMojoExecutionAction = "ignore";
    private List<String> javaCompletionFavoriteMembers;
    private List<?> gradleWrapperList;
    private List<String> javaImportExclusions = new LinkedList<String>();
    private ReferencedLibraries referencedLibraries;
    private String invisibleProjectOutputPath;
    private List<String> invisibleProjectSourcePaths;
    private String javaHome = null;
    private List<String> importOrder;
    private List<String> filteredTypes;
    private String formatterUrl = null;
    private String settingsUrl = null;
    private String formatterProfileName = null;
    private Collection<IPath> rootPaths;
    private Collection<IPath> triggerFiles;
    private Collection<IPath> projectConfigurations;
    private int parallelBuildsCount = 1;
    private int maxCompletionResults = 50;
    private int importOnDemandThreshold = 99;
    private int staticImportOnDemandThreshold = 99;
    private Set<RuntimeEnvironment> runtimes = new HashSet<RuntimeEnvironment>();
    private List<String> resourceFilters;
    private List<String> fileHeaderTemplate = new LinkedList<String>();
    private List<String> typeCommentTemplate = new LinkedList<String>();
    private boolean insertSpaces = true;
    private int tabSize = 4;
    private InlayHintsParameterMode inlayHintsParameterMode;
    private List<String> inlayHintsExclusionList;
    private ProjectEncodingMode projectEncoding;
    private boolean avoidVolatileChanges = true;
    private boolean protobufSupportEnabled;
    private boolean androidSupportEnabled;
    private List<String> nonnullTypes;
    private List<String> nullableTypes;
    private FeatureStatus nullAnalysisMode;
    private List<String> cleanUpActionsOnSave;
    private boolean extractInterfaceReplaceEnabled = false;
    private boolean telemetryEnabled = false;
    private boolean validateAllOpenBuffersOnChanges = true;
    private boolean chainCompletionEnabled;

    static {
        FORMATTING_ID = UUID.randomUUID().toString();
        FORMATTING_ON_TYPE_ID = UUID.randomUUID().toString();
        FORMATTING_RANGE_ID = UUID.randomUUID().toString();
        CODE_LENS_ID = UUID.randomUUID().toString();
        SIGNATURE_HELP_ID = UUID.randomUUID().toString();
        RENAME_ID = UUID.randomUUID().toString();
        EXECUTE_COMMAND_ID = UUID.randomUUID().toString();
        WORKSPACE_SYMBOL_ID = UUID.randomUUID().toString();
        DOCUMENT_SYMBOL_ID = UUID.randomUUID().toString();
        COMPLETION_ID = UUID.randomUUID().toString();
        CODE_ACTION_ID = UUID.randomUUID().toString();
        DEFINITION_ID = UUID.randomUUID().toString();
        DECLARATION_ID = UUID.randomUUID().toString();
        TYPEDEFINITION_ID = UUID.randomUUID().toString();
        HOVER_ID = UUID.randomUUID().toString();
        REFERENCES_ID = UUID.randomUUID().toString();
        DOCUMENT_HIGHLIGHT_ID = UUID.randomUUID().toString();
        FOLDINGRANGE_ID = UUID.randomUUID().toString();
        WORKSPACE_CHANGE_FOLDERS_ID = UUID.randomUUID().toString();
        WORKSPACE_WATCHED_FILES_ID = UUID.randomUUID().toString();
        IMPLEMENTATION_ID = UUID.randomUUID().toString();
        SELECTION_RANGE_ID = UUID.randomUUID().toString();
        INLAY_HINT_ID = UUID.randomUUID().toString();
        nonnullClasspathStorage = new HashMap<String, List<String>>();
        nullableClasspathStorage = new HashMap<String, List<String>>();
        JAVA_IMPORT_EXCLUSIONS_DEFAULT = new LinkedList<String>();
        JAVA_CONFIGURATION_RUNTIMES_DEFAULT = new ArrayList<String>();
        JAVA_GRADLE_WRAPPER_SHA256_DEFAULT = new ArrayList<String>();
        JAVA_IMPORT_EXCLUSIONS_DEFAULT.add("**/node_modules/**");
        JAVA_IMPORT_EXCLUSIONS_DEFAULT.add("**/.metadata/**");
        JAVA_IMPORT_EXCLUSIONS_DEFAULT.add("**/archetype-resources/**");
        JAVA_IMPORT_EXCLUSIONS_DEFAULT.add("**/META-INF/maven/**");
        JAVA_PROJECT_REFERENCED_LIBRARIES_DEFAULT = new ReferencedLibraries();
        JAVA_PROJECT_REFERENCED_LIBRARIES_DEFAULT.getInclude().add("lib/**");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT = new ArrayList<String>();
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.Assert.*");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.Assume.*");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.jupiter.api.Assertions.*");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.jupiter.api.Assumptions.*");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.jupiter.api.DynamicContainer.*");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.jupiter.api.DynamicTest.*");
        JAVA_IMPORT_ORDER_DEFAULT = new LinkedList<String>();
        JAVA_IMPORT_ORDER_DEFAULT.add("java");
        JAVA_IMPORT_ORDER_DEFAULT.add("javax");
        JAVA_IMPORT_ORDER_DEFAULT.add("org");
        JAVA_IMPORT_ORDER_DEFAULT.add("com");
        JAVA_COMPLETION_FILTERED_TYPES_DEFAULT = new ArrayList<String>();
        JAVA_COMPLETION_FILTERED_TYPES_DEFAULT.add("com.sun.*");
        JAVA_COMPLETION_FILTERED_TYPES_DEFAULT.add("io.micrometer.shaded.*");
        JAVA_COMPLETION_FILTERED_TYPES_DEFAULT.add("java.awt.*");
        JAVA_COMPLETION_FILTERED_TYPES_DEFAULT.add("jdk.*");
        JAVA_COMPLETION_FILTERED_TYPES_DEFAULT.add("org.graalvm.*");
        JAVA_COMPLETION_FILTERED_TYPES_DEFAULT.add("sun.*");
        JAVA_RESOURCE_FILTERS_DEFAULT = Arrays.asList("node_modules", "\\.git");
        Preferences.initializeNullAnalysisClasspathStorage();
    }

    public Preferences() {
        this.incompleteClasspathSeverity = Severity.warning;
        this.updateBuildConfigurationStatus = FeatureStatus.interactive;
        this.gradleArguments = new ArrayList<String>();
        this.gradleJvmArguments = new ArrayList<String>();
        this.completionMatchCaseMode = CompletionMatchCaseMode.OFF;
        this.guessMethodArguments = CompletionGuessMethodArgumentsMode.INSERT_PARAMETER_NAMES;
        this.javaImportExclusions = JAVA_IMPORT_EXCLUSIONS_DEFAULT;
        this.javaCompletionFavoriteMembers = JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT;
        this.importOrder = JAVA_IMPORT_ORDER_DEFAULT;
        this.filteredTypes = JAVA_COMPLETION_FILTERED_TYPES_DEFAULT;
        this.referencedLibraries = JAVA_PROJECT_REFERENCED_LIBRARIES_DEFAULT;
        this.resourceFilters = JAVA_RESOURCE_FILTERS_DEFAULT;
        this.inlayHintsParameterMode = InlayHintsParameterMode.LITERALS;
        this.projectEncoding = ProjectEncodingMode.IGNORE;
        this.nonnullTypes = new ArrayList<String>();
        this.nullableTypes = new ArrayList<String>();
        this.nullAnalysisMode = FeatureStatus.disabled;
        this.cleanUpActionsOnSave = new ArrayList<String>();
    }

    private static void initializeNullAnalysisClasspathStorage() {
        nonnullClasspathStorage.put("javax.annotation.Nonnull", Preferences.getClasspathSubStringFromArtifact("com.google.code.findbugs:jsr305"));
        nullableClasspathStorage.put("javax.annotation.Nullable", Preferences.getClasspathSubStringFromArtifact("com.google.code.findbugs:jsr305"));
        nonnullClasspathStorage.put("org.eclipse.jdt.annotation.NonNull", Preferences.getClasspathSubStringFromArtifact("org.eclipse.jdt:org.eclipse.jdt.annotation"));
        nullableClasspathStorage.put("org.eclipse.jdt.annotation.Nullable", Preferences.getClasspathSubStringFromArtifact("org.eclipse.jdt:org.eclipse.jdt.annotation"));
        nonnullClasspathStorage.put("org.springframework.lang.NonNull", Preferences.getClasspathSubStringFromArtifact("org.springframework:spring-core"));
        nullableClasspathStorage.put("org.springframework.lang.Nullable", Preferences.getClasspathSubStringFromArtifact("org.springframework:spring-core"));
        nonnullClasspathStorage.put("io.micrometer.core.lang.NonNull", Preferences.getClasspathSubStringFromArtifact("io.micrometer:micrometer-core"));
        nullableClasspathStorage.put("io.micrometer.core.lang.Nullable", Preferences.getClasspathSubStringFromArtifact("io.micrometer:micrometer-core"));
        nonnullClasspathStorage.put("org.jetbrains.annotations.NotNull", Preferences.getClasspathSubStringFromArtifact("org.jetbrains:annotations"));
        nullableClasspathStorage.put("org.jetbrains.annotations.Nullable", Preferences.getClasspathSubStringFromArtifact("org.jetbrains:annotations"));
    }

    private static List<String> getClasspathSubStringFromArtifact(String artifact) {
        String[] splitIds = artifact.split(":");
        if (splitIds.length != 2) {
            return new ArrayList<String>();
        }
        String groupId = splitIds[0];
        String artifactId = splitIds[1];
        String gradleStyleClasspath = Paths.get(groupId, artifactId).toString();
        String[] groupIdSplitByDot = groupId.split("\\.");
        if (groupIdSplitByDot.length < 1) {
            return new ArrayList<String>();
        }
        String mavenStyleClasspath = Paths.get("", groupIdSplitByDot).resolve(artifactId).toString();
        return new ArrayList<String>(Arrays.asList(gradleStyleClasspath, mavenStyleClasspath));
    }

    /*
     * WARNING - void declaration
     */
    public static Preferences createFrom(Map<String, Object> configuration) {
        Object guessMethodArguments;
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration can not be null");
        }
        Preferences prefs = new Preferences();
        prefs.configuration = configuration;
        String incompleteClasspathSeverity = MapFlattener.getString(configuration, ERRORS_INCOMPLETE_CLASSPATH_SEVERITY_KEY, null);
        prefs.setIncompleteClasspathSeverity(Severity.fromString(incompleteClasspathSeverity, Severity.warning));
        String updateBuildConfiguration = MapFlattener.getString(configuration, CONFIGURATION_UPDATE_BUILD_CONFIGURATION_KEY, null);
        prefs.setUpdateBuildConfigurationStatus(FeatureStatus.fromString(updateBuildConfiguration, FeatureStatus.interactive));
        boolean importGradleEnabled = MapFlattener.getBoolean(configuration, IMPORT_GRADLE_ENABLED, true);
        prefs.setImportGradleEnabled(importGradleEnabled);
        boolean insertSpaces = MapFlattener.getBoolean(configuration, JAVA_CONFIGURATION_INSERTSPACES, true);
        prefs.setInsertSpaces(insertSpaces);
        int tabSize = MapFlattener.getInt(configuration, JAVA_CONFIGURATION_TABSIZE, 4);
        prefs.setTabSize(tabSize);
        boolean importGradleOfflineEnabled = MapFlattener.getBoolean(configuration, IMPORT_GRADLE_OFFLINE_ENABLED, false);
        prefs.setImportGradleOfflineEnabled(importGradleOfflineEnabled);
        boolean gradleWrapperEnabled = MapFlattener.getBoolean(configuration, GRADLE_WRAPPER_ENABLED, true);
        prefs.setGradleWrapperEnabled(gradleWrapperEnabled);
        String gradleVersion = MapFlattener.getString(configuration, GRADLE_VERSION);
        prefs.setGradleVersion(gradleVersion);
        List<String> gradleArguments = MapFlattener.getList(configuration, GRADLE_ARGUMENTS);
        prefs.setGradleArguments(gradleArguments);
        List<String> gradleJvmArguments = MapFlattener.getList(configuration, GRADLE_JVM_ARGUMENTS);
        prefs.setGradleJvmArguments(gradleJvmArguments);
        String gradleHome = MapFlattener.getString(configuration, GRADLE_HOME);
        prefs.setGradleHome(gradleHome);
        String gradleJavaHome = MapFlattener.getString(configuration, GRADLE_JAVA_HOME);
        prefs.setGradleJavaHome(gradleJavaHome);
        String gradleUserHome = MapFlattener.getString(configuration, GRADLE_USER_HOME);
        prefs.setGradleUserHome(gradleUserHome);
        boolean gradleAnnotationProcessingEnabled = MapFlattener.getBoolean(configuration, GRADLE_ANNOTATION_PROCESSING_ENABLED, true);
        prefs.setGradleAnnotationProcessingEnabled(gradleAnnotationProcessingEnabled);
        boolean importMavenEnabled = MapFlattener.getBoolean(configuration, IMPORT_MAVEN_ENABLED, true);
        prefs.setImportMavenEnabled(importMavenEnabled);
        boolean mavenOffline = MapFlattener.getBoolean(configuration, IMPORT_MAVEN_OFFLINE, false);
        prefs.setMavenOffline(mavenOffline);
        boolean mavenDisableTestClasspathFlag = MapFlattener.getBoolean(configuration, MAVEN_DISABLE_TEST_CLASSPATH_FLAG, false);
        prefs.setMavenDisableTestClasspathFlag(mavenDisableTestClasspathFlag);
        boolean mavenDownloadSources = MapFlattener.getBoolean(configuration, MAVEN_DOWNLOAD_SOURCES, false);
        prefs.setMavenDownloadSources(mavenDownloadSources);
        boolean eclipseDownloadSources = MapFlattener.getBoolean(configuration, ECLIPSE_DOWNLOAD_SOURCES, false);
        prefs.setEclipseDownloadSources(eclipseDownloadSources);
        boolean updateSnapshots = MapFlattener.getBoolean(configuration, MAVEN_UPDATE_SNAPSHOTS, false);
        prefs.setMavenUpdateSnapshots(updateSnapshots);
        boolean referenceCodelensEnabled = MapFlattener.getBoolean(configuration, REFERENCES_CODE_LENS_ENABLED_KEY, true);
        prefs.setReferencesCodelensEnabled(referenceCodelensEnabled);
        boolean implementationCodeLensEnabled = MapFlattener.getBoolean(configuration, IMPLEMENTATIONS_CODE_LENS_ENABLED_KEY, false);
        prefs.setImplementationCodelensEnabled(implementationCodeLensEnabled);
        boolean javaFormatEnabled = MapFlattener.getBoolean(configuration, JAVA_FORMAT_ENABLED_KEY, true);
        prefs.setJavaFormatEnabled(javaFormatEnabled);
        String javaQuickFixShowAt = MapFlattener.getString(configuration, QUICK_FIX_SHOW_AT, LINE);
        prefs.setJavaQuickFixShowAt(javaQuickFixShowAt);
        boolean javaFormatOnTypeEnabled = MapFlattener.getBoolean(configuration, JAVA_FORMAT_ON_TYPE_ENABLED_KEY, false);
        prefs.setJavaFormatOnTypeEnabled(javaFormatOnTypeEnabled);
        boolean javaSaveActionAutoOrganizeImportsEnabled = MapFlattener.getBoolean(configuration, JAVA_SAVE_ACTIONS_ORGANIZE_IMPORTS_KEY, false);
        prefs.setJavaSaveActionAutoOrganizeImportsEnabled(javaSaveActionAutoOrganizeImportsEnabled);
        boolean signatureHelpEnabled = MapFlattener.getBoolean(configuration, SIGNATURE_HELP_ENABLED_KEY, true);
        prefs.setSignatureHelpEnabled(signatureHelpEnabled);
        boolean signatureDescriptionEnabled = MapFlattener.getBoolean(configuration, SIGNATURE_HELP_DESCRIPTION_ENABLED_KEY, false);
        prefs.setSignatureHelpDescriptionEnabled(signatureDescriptionEnabled);
        boolean renameEnabled = MapFlattener.getBoolean(configuration, RENAME_ENABLED_KEY, true);
        prefs.setRenameEnabled(renameEnabled);
        boolean executeCommandEnable = MapFlattener.getBoolean(configuration, EXECUTE_COMMAND_ENABLED_KEY, true);
        prefs.setExecuteCommandEnabled(executeCommandEnable);
        boolean autobuildEnable = MapFlattener.getBoolean(configuration, AUTOBUILD_ENABLED_KEY, true);
        prefs.setAutobuildEnabled(autobuildEnable);
        boolean completionEnable = MapFlattener.getBoolean(configuration, COMPLETION_ENABLED_KEY, true);
        prefs.setCompletionEnabled(completionEnable);
        boolean postfixEnabled = MapFlattener.getBoolean(configuration, POSTFIX_COMPLETION_KEY, true);
        prefs.setPostfixCompletionEnabled(postfixEnabled);
        String completionMatchCaseMode = MapFlattener.getString(configuration, COMPLETION_MATCH_CASE_MODE_KEY, null);
        prefs.setCompletionMatchCaseMode(CompletionMatchCaseMode.fromString(completionMatchCaseMode, CompletionMatchCaseMode.OFF));
        boolean completionLazyResolveTextEditEnabled = MapFlattener.getBoolean(configuration, COMPLETION_LAZY_RESOLVE_TEXT_EDIT_ENABLED_KEY, false);
        prefs.setCompletionLazyResolveTextEditEnabled(completionLazyResolveTextEditEnabled);
        boolean completionOverwrite = MapFlattener.getBoolean(configuration, JAVA_COMPLETION_OVERWRITE_KEY, true);
        prefs.setCompletionOverwrite(completionOverwrite);
        boolean foldingRangeEnable = MapFlattener.getBoolean(configuration, FOLDINGRANGE_ENABLED_KEY, true);
        prefs.setFoldingRangeEnabled(foldingRangeEnable);
        boolean selectionRangeEnabled = MapFlattener.getBoolean(configuration, SELECTIONRANGE_ENABLED_KEY, true);
        prefs.setSelectionRangeEnabled(selectionRangeEnabled);
        Object object = guessMethodArguments = MapFlattener.getValue(configuration, JAVA_COMPLETION_GUESS_METHOD_ARGUMENTS_KEY);
        if (object instanceof Boolean) {
            void b;
            Boolean bl = (Boolean)object;
            Boolean cfr_ignored_0 = (Boolean)object;
            prefs.setGuessMethodArgumentsMode(b.booleanValue() ? CompletionGuessMethodArgumentsMode.INSERT_BEST_GUESSED_ARGUMENTS : CompletionGuessMethodArgumentsMode.INSERT_PARAMETER_NAMES);
        } else {
            String guessMethodArgumentsMode = MapFlattener.getString(configuration, JAVA_COMPLETION_GUESS_METHOD_ARGUMENTS_KEY, null);
            prefs.setGuessMethodArgumentsMode(CompletionGuessMethodArgumentsMode.fromString(guessMethodArgumentsMode, CompletionGuessMethodArgumentsMode.INSERT_PARAMETER_NAMES));
        }
        boolean hashCodeEqualsTemplateUseJava7Objects = MapFlattener.getBoolean(configuration, JAVA_CODEGENERATION_HASHCODEEQUALS_USEJAVA7OBJECTS, false);
        prefs.setHashCodeEqualsTemplateUseJava7Objects(hashCodeEqualsTemplateUseJava7Objects);
        boolean hashCodeEqualsTemplateUseInstanceof = MapFlattener.getBoolean(configuration, JAVA_CODEGENERATION_HASHCODEEQUALS_USEINSTANCEOF, false);
        prefs.setHashCodeEqualsTemplateUseInstanceof(hashCodeEqualsTemplateUseInstanceof);
        boolean codeGenerationTemplateUseBlocks = MapFlattener.getBoolean(configuration, JAVA_CODEGENERATION_USEBLOCKS, false);
        prefs.setCodeGenerationTemplateUseBlocks(codeGenerationTemplateUseBlocks);
        boolean codeGenerationTemplateGenerateComments = MapFlattener.getBoolean(configuration, JAVA_CODEGENERATION_GENERATECOMMENTS, false);
        prefs.setCodeGenerationTemplateGenerateComments(codeGenerationTemplateGenerateComments);
        String generateToStringTemplate = MapFlattener.getString(configuration, JAVA_CODEGENERATION_TOSTRING_TEMPLATE);
        prefs.setGenerateToStringTemplate(generateToStringTemplate);
        String generateToStringCodeStyle = MapFlattener.getString(configuration, JAVA_CODEGENERATION_TOSTRING_CODESTYLE, "STRING_CONCATENATION");
        prefs.setGenerateToStringCodeStyle(generateToStringCodeStyle);
        boolean generateToStringSkipNullValues = MapFlattener.getBoolean(configuration, JAVA_CODEGENERATION_TOSTRING_SKIPNULLVALUES, false);
        prefs.setGenerateToStringSkipNullValues(generateToStringSkipNullValues);
        boolean generateToStringListArrayContents = MapFlattener.getBoolean(configuration, JAVA_CODEGENERATION_TOSTRING_LISTARRAYCONTENTS, true);
        prefs.setGenerateToStringListArrayContents(generateToStringListArrayContents);
        int generateToStringLimitElements = MapFlattener.getInt(configuration, JAVA_CODEGENERATION_TOSTRING_LIMITELEMENTS, 0);
        prefs.setGenerateToStringLimitElements(generateToStringLimitElements);
        String insertionLocation = MapFlattener.getString(configuration, JAVA_CODEGENERATION_INSERTIONLOCATION);
        prefs.setCodeGenerationInsertionLocation(insertionLocation);
        List<String> javaImportExclusions = MapFlattener.getList(configuration, JAVA_IMPORT_EXCLUSIONS_KEY, JAVA_IMPORT_EXCLUSIONS_DEFAULT);
        if (javaImportExclusions instanceof LinkedList) {
            prefs.setJavaImportExclusions(javaImportExclusions);
        } else {
            LinkedList<String> copy = new LinkedList<String>(javaImportExclusions);
            prefs.setJavaImportExclusions(copy);
        }
        Object referencedLibraries = MapFlattener.getValue(configuration, JAVA_PROJECT_REFERENCED_LIBRARIES_KEY);
        if (referencedLibraries == null) {
            prefs.setReferencedLibraries(JAVA_PROJECT_REFERENCED_LIBRARIES_DEFAULT);
        } else if (referencedLibraries instanceof Map) {
            try {
                Map config = (Map)referencedLibraries;
                HashSet<String> include = new HashSet<String>(config.getOrDefault("include", new ArrayList()));
                HashSet<String> exclude = new HashSet<String>(config.getOrDefault("exclude", new ArrayList()));
                Map sources = config.getOrDefault("sources", new HashMap());
                prefs.setReferencedLibraries(new ReferencedLibraries(include, exclude, sources));
            }
            catch (Exception e) {
                prefs.setReferencedLibraries(JAVA_PROJECT_REFERENCED_LIBRARIES_DEFAULT);
            }
        } else {
            try {
                HashSet<String> include = new HashSet<String>((List)referencedLibraries);
                prefs.setReferencedLibraries(new ReferencedLibraries(include));
            }
            catch (Exception e) {
                prefs.setReferencedLibraries(JAVA_PROJECT_REFERENCED_LIBRARIES_DEFAULT);
            }
        }
        String invisibleProjectOutputPath = MapFlattener.getString(configuration, JAVA_PROJECT_OUTPUT_PATH_KEY, "");
        prefs.setInvisibleProjectOutputPath(invisibleProjectOutputPath);
        List<String> invisibleProjectSourcePaths = MapFlattener.getList(configuration, JAVA_PROJECT_SOURCE_PATHS_KEY, null);
        prefs.setInvisibleProjectSourcePaths(invisibleProjectSourcePaths);
        List<String> javaCompletionFavoriteMembers = MapFlattener.getList(configuration, JAVA_COMPLETION_FAVORITE_MEMBERS_KEY, JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT);
        prefs.setJavaCompletionFavoriteMembers(javaCompletionFavoriteMembers);
        List<String> gradleWrapperList = MapFlattener.getList(configuration, JAVA_GRADLE_WRAPPER_SHA256_KEY, JAVA_GRADLE_WRAPPER_SHA256_DEFAULT);
        prefs.setGradleWrapperList(gradleWrapperList);
        String mavenUserSettings = MapFlattener.getString(configuration, MAVEN_USER_SETTINGS_KEY, null);
        prefs.setMavenUserSettings(mavenUserSettings);
        String mavenGlobalSettings = MapFlattener.getString(configuration, MAVEN_GLOBAL_SETTINGS_KEY, null);
        prefs.setMavenGlobalSettings(mavenGlobalSettings);
        String mavenNotCoveredPluginExecution = MapFlattener.getString(configuration, MAVEN_NOT_COVERED_PLUGIN_EXECUTION_SEVERITY, IGNORE);
        prefs.setMavenNotCoveredPluginExecutionSeverity(mavenNotCoveredPluginExecution);
        String mavenDefaultMojoExecution = MapFlattener.getString(configuration, MAVEN_DEFAULT_MOJO_EXECUTION_ACTION, IGNORE);
        prefs.setMavenDefaultMojoExecutionAction(mavenDefaultMojoExecution);
        String sortOrder = MapFlattener.getString(configuration, MEMBER_SORT_ORDER, null);
        prefs.setMembersSortOrder(sortOrder);
        List<String> preferredContentProviders = MapFlattener.getList(configuration, PREFERRED_CONTENT_PROVIDER_KEY);
        prefs.setPreferredContentProviderIds(preferredContentProviders);
        String javaHome = MapFlattener.getString(configuration, JAVA_HOME);
        prefs.setJavaHome(javaHome);
        String formatterUrl = MapFlattener.getString(configuration, JAVA_FORMATTER_URL);
        prefs.setFormatterUrl(formatterUrl);
        String settingsUrl = MapFlattener.getString(configuration, JAVA_SETTINGS_URL);
        prefs.setSettingsUrl(settingsUrl);
        List<String> resourceFilters = MapFlattener.getList(configuration, JAVA_RESOURCE_FILTERS, JAVA_RESOURCE_FILTERS_DEFAULT);
        prefs.setResourceFilters(resourceFilters);
        String formatterProfileName = MapFlattener.getString(configuration, JAVA_FORMATTER_PROFILE_NAME);
        prefs.setFormatterProfileName(formatterProfileName);
        boolean javaFormatComments = MapFlattener.getBoolean(configuration, JAVA_FORMAT_COMMENTS, true);
        prefs.setJavaFormatComments(javaFormatComments);
        List<String> javaImportOrder = MapFlattener.getList(configuration, JAVA_IMPORT_ORDER_KEY, JAVA_IMPORT_ORDER_DEFAULT);
        prefs.setImportOrder(javaImportOrder);
        List<String> javaFilteredTypes = MapFlattener.getList(configuration, JAVA_COMPLETION_FILTERED_TYPES_KEY, JAVA_COMPLETION_FILTERED_TYPES_DEFAULT);
        prefs.setFilteredTypes(javaFilteredTypes);
        int maxConcurrentBuilds = MapFlattener.getInt(configuration, JAVA_MAX_CONCURRENT_BUILDS, 1);
        maxConcurrentBuilds = maxConcurrentBuilds >= 1 ? maxConcurrentBuilds : 1;
        prefs.setMaxBuildCount(maxConcurrentBuilds);
        int maxCompletions = MapFlattener.getInt(configuration, JAVA_COMPLETION_MAX_RESULTS_KEY, 50);
        prefs.setMaxCompletionResults(maxCompletions);
        int onDemandThreshold = MapFlattener.getInt(configuration, IMPORTS_ONDEMANDTHRESHOLD, 99);
        prefs.setImportOnDemandThreshold(onDemandThreshold);
        int staticOnDemandThreshold = MapFlattener.getInt(configuration, IMPORTS_STATIC_ONDEMANDTHRESHOLD, 99);
        prefs.setStaticImportOnDemandThreshold(staticOnDemandThreshold);
        List<String> runtimeList = MapFlattener.getList(configuration, JAVA_CONFIGURATION_RUNTIMES, JAVA_CONFIGURATION_RUNTIMES_DEFAULT);
        HashSet<RuntimeEnvironment> runtimes = new HashSet<RuntimeEnvironment>();
        boolean[] hasDefault = new boolean[1];
        for (String object2 : runtimeList) {
            void map;
            String string = object2;
            if (!(string instanceof Map)) continue;
            Map cfr_ignored_1 = (Map)((Object)string);
            Map cfr_ignored_2 = (Map)((Object)string);
            RuntimeEnvironment runtime = new RuntimeEnvironment();
            map.forEach((k, v) -> {
                block20: {
                    void key;
                    Object object = k;
                    if (!(object instanceof String)) break block20;
                    String string = (String)object;
                    String cfr_ignored_0 = (String)object;
                    switch (key) {
                        case "name": {
                            void value;
                            Object object2 = v;
                            if (!(object2 instanceof String)) break;
                            String string2 = (String)object2;
                            String cfr_ignored_1 = (String)object2;
                            runtime.setName((String)value);
                            break;
                        }
                        case "path": {
                            void value;
                            Object object3 = v;
                            if (!(object3 instanceof String)) break;
                            String string3 = (String)object3;
                            String cfr_ignored_2 = (String)object3;
                            runtime.setPath(ResourceUtils.expandPath((String)value));
                            break;
                        }
                        case "javadoc": {
                            void value;
                            Object object4 = v;
                            if (!(object4 instanceof String)) break;
                            String string4 = (String)object4;
                            String cfr_ignored_3 = (String)object4;
                            runtime.setJavadoc(ResourceUtils.expandPath((String)value));
                            break;
                        }
                        case "sources": {
                            void value;
                            Object object5 = v;
                            if (!(object5 instanceof String)) break;
                            String string5 = (String)object5;
                            String cfr_ignored_4 = (String)object5;
                            runtime.setSources(ResourceUtils.expandPath((String)value));
                            break;
                        }
                        case "default": {
                            if (hasDefault[0]) break;
                            Object object6 = v;
                            if (object6 instanceof Boolean) {
                                void bool;
                                Boolean bl = (Boolean)object6;
                                Boolean cfr_ignored_5 = (Boolean)object6;
                                runtime.setDefault(bool.booleanValue());
                            }
                            blArray[0] = true;
                            break;
                        }
                    }
                }
            });
            if (!runtimes.contains(runtime)) {
                if (runtime.isValid()) {
                    runtimes.add(runtime);
                    continue;
                }
                JavaLanguageServerPlugin.logInfo("Runtime " + runtime + " is not valid.");
                continue;
            }
            JavaLanguageServerPlugin.logInfo("Multiple runtimes with name " + runtime.getName());
        }
        prefs.setRuntimes(runtimes);
        List<String> fileHeader = MapFlattener.getList(configuration, JAVA_TEMPLATES_FILEHEADER);
        prefs.setFileHeaderTemplate(fileHeader);
        List<String> typeComment = MapFlattener.getList(configuration, JAVA_TEMPLATES_TYPECOMMENT);
        prefs.setTypeCommentTemplate(typeComment);
        boolean includeAccessors = MapFlattener.getBoolean(configuration, JAVA_REFERENCES_INCLUDE_ACCESSORS, true);
        prefs.setIncludeAccessors(includeAccessors);
        boolean includeDecompiledSources = MapFlattener.getBoolean(configuration, JAVA_REFERENCES_INCLUDE_DECOMPILED_SOURCES, true);
        prefs.setIncludeDecompiledSources(includeDecompiledSources);
        boolean includeSourceMethodDeclarations = MapFlattener.getBoolean(configuration, JAVA_SYMBOLS_INCLUDE_SOURCE_METHOD_DECLARATIONS, false);
        prefs.setIncludeSourceMethodDeclarations(includeSourceMethodDeclarations);
        String inlayHintsParameterMode = MapFlattener.getString(configuration, JAVA_INLAYHINTS_PARAMETERNAMES_ENABLED, null);
        prefs.setInlayHintsParameterMode(InlayHintsParameterMode.fromString(inlayHintsParameterMode, InlayHintsParameterMode.LITERALS));
        List<String> inlayHintsExclusionList = MapFlattener.getList(configuration, JAVA_INLAYHINTS_PARAMETERNAMES_EXCLUSIONS, Collections.emptyList());
        prefs.setInlayHintsExclusionList(inlayHintsExclusionList);
        String projectEncoding = MapFlattener.getString(configuration, JAVA_PROJECT_ENCODING, null);
        prefs.setProjectEncoding(ProjectEncodingMode.fromString(projectEncoding, ProjectEncodingMode.IGNORE));
        boolean avoidVolatileChanges = MapFlattener.getBoolean(configuration, JAVA_CODEACTION_SORTMEMBER_AVOIDVOLATILECHANGES, true);
        prefs.setAvoidVolatileChanges(avoidVolatileChanges);
        boolean protobufSupported = MapFlattener.getBoolean(configuration, JAVA_JDT_LS_PROTOBUF_SUPPORT_ENABLED, false);
        prefs.setProtobufSupportEnabled(protobufSupported);
        boolean androidSupported = MapFlattener.getBoolean(configuration, JAVA_JDT_LS_ANDROID_SUPPORT_ENABLED, false);
        prefs.setAndroidSupportEnabled(androidSupported);
        List<String> nonnullTypes = MapFlattener.getList(configuration, JAVA_COMPILE_NULLANALYSIS_NONNULL, Collections.emptyList());
        prefs.setNonnullTypes(nonnullTypes);
        List<String> nullableTypes = MapFlattener.getList(configuration, JAVA_COMPILE_NULLANALYSIS_NULLABLE, Collections.emptyList());
        prefs.setNullableTypes(nullableTypes);
        String nullAnalysisMode = MapFlattener.getString(configuration, JAVA_COMPILE_NULLANALYSIS_MODE, null);
        prefs.setNullAnalysisMode(FeatureStatus.fromString(nullAnalysisMode, FeatureStatus.disabled));
        List<String> cleanupActionsOnSave = MapFlattener.getList(configuration, JAVA_CLEANUPS_ACTIONS_ON_SAVE, Collections.emptyList());
        prefs.setCleanUpActionsOnSave(cleanupActionsOnSave);
        boolean extractInterfaceReplaceEnabled = MapFlattener.getBoolean(configuration, JAVA_REFACTORING_EXTRACT_INTERFACE_REPLACE, false);
        prefs.setExtractInterfaceReplaceEnabled(extractInterfaceReplaceEnabled);
        boolean telemetryEnabled = MapFlattener.getBoolean(configuration, JAVA_TELEMETRY_ENABLED_KEY, false);
        prefs.setTelemetryEnabled(telemetryEnabled);
        boolean validateAllOpenBuffers = MapFlattener.getBoolean(configuration, JAVA_EDIT_VALIDATE_ALL_OPEN_BUFFERS_ON_CHANGES, true);
        prefs.setValidateAllOpenBuffersOnChanges(validateAllOpenBuffers);
        boolean chainCompletionEnabled = MapFlattener.getBoolean(configuration, CHAIN_COMPLETION_KEY, false);
        prefs.setChainCompletionEnabled(chainCompletionEnabled);
        return prefs;
    }

    private void setCleanUpActionsOnSave(List<String> enabledCleanUps) {
        this.cleanUpActionsOnSave = enabledCleanUps;
    }

    public Preferences setJavaHome(String javaHome) {
        this.javaHome = javaHome;
        return this;
    }

    public Preferences setGradleVersion(String gradleVersion) {
        this.gradleVersion = gradleVersion == null || gradleVersion.isEmpty() ? null : gradleVersion;
        return this;
    }

    public Preferences setGradleArguments(List<String> arguments) {
        this.gradleArguments = arguments == null ? new ArrayList() : arguments;
        return this;
    }

    public Preferences setGradleJvmArguments(List<String> jvmArguments) {
        this.gradleJvmArguments = jvmArguments == null ? new ArrayList() : jvmArguments;
        return this;
    }

    public Preferences setGradleHome(String gradleHome) {
        this.gradleHome = ResourceUtils.expandPath(gradleHome);
        return this;
    }

    public Preferences setGradleJavaHome(String gradleJavaHome) {
        this.gradleJavaHome = ResourceUtils.expandPath(gradleJavaHome);
        return this;
    }

    public Preferences setGradleUserHome(String gradleUserHome) {
        this.gradleUserHome = ResourceUtils.expandPath(gradleUserHome);
        return this;
    }

    public Preferences setFormatterUrl(String formatterUrl) {
        this.formatterUrl = ResourceUtils.expandPath(formatterUrl);
        return this;
    }

    public Preferences setSettingsUrl(String settingsUrl) {
        this.settingsUrl = ResourceUtils.expandPath(settingsUrl);
        return this;
    }

    public Preferences setResourceFilters(List<String> resourceFilters) {
        this.resourceFilters = resourceFilters == null ? new ArrayList() : resourceFilters;
        return this;
    }

    public Preferences setJavaFormatComments(boolean javaFormatComments) {
        this.javaFormatComments = javaFormatComments;
        return this;
    }

    public boolean isJavaFormatComments() {
        return this.javaFormatComments;
    }

    public Preferences setFormatterProfileName(String formatterProfileName) {
        this.formatterProfileName = formatterProfileName;
        return this;
    }

    public Preferences setJavaImportExclusions(List<String> javaImportExclusions) {
        this.javaImportExclusions = javaImportExclusions;
        return this;
    }

    public Preferences setJavaCompletionFavoriteMembers(List<String> javaCompletionFavoriteMembers) {
        this.javaCompletionFavoriteMembers = javaCompletionFavoriteMembers == null || javaCompletionFavoriteMembers.isEmpty() ? JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT : javaCompletionFavoriteMembers;
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode(JavaManipulation.getPreferenceNodeId());
        String value = String.join((CharSequence)";", JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getJavaCompletionFavoriteMembers());
        prefs.put("content_assist_favorite_static_members", value);
        return this;
    }

    private Preferences setMembersSortOrder(String sortOrder) {
        if (sortOrder != null) {
            IEclipsePreferences fPreferenceStore = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
            fPreferenceStore.put("outlinesortoption", sortOrder);
        }
        return this;
    }

    private Preferences setPreferredContentProviderIds(List<String> preferredContentProviderIds) {
        this.preferredContentProviderIds = preferredContentProviderIds;
        return this;
    }

    private Preferences setReferencesCodelensEnabled(boolean enabled) {
        this.referencesCodeLensEnabled = enabled;
        return this;
    }

    public Preferences setImportGradleEnabled(boolean enabled) {
        this.importGradleEnabled = enabled;
        return this;
    }

    public Preferences setImportGradleOfflineEnabled(boolean enabled) {
        this.importGradleOfflineEnabled = enabled;
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.buildship.core");
        boolean offlineMode = prefs.getBoolean(GRADLE_OFFLINE_MODE, false);
        if (offlineMode != enabled) {
            prefs.putBoolean(GRADLE_OFFLINE_MODE, enabled);
        }
        return this;
    }

    public Preferences setGradleWrapperEnabled(boolean enabled) {
        this.gradleWrapperEnabled = enabled;
        return this;
    }

    public Preferences setImportMavenEnabled(boolean enabled) {
        this.importMavenEnabled = enabled;
        return this;
    }

    public Preferences setMavenOffline(boolean enabled) {
        this.mavenOffline = enabled;
        return this;
    }

    public Preferences setMavenDisableTestClasspathFlag(boolean enabled) {
        this.mavenDisableTestClasspathFlag = enabled;
        return this;
    }

    public Preferences setMavenDownloadSources(boolean enabled) {
        this.mavenDownloadSources = enabled;
        return this;
    }

    public Preferences setMavenUpdateSnapshots(boolean enabled) {
        this.mavenUpdateSnapshots = enabled;
        return this;
    }

    private Preferences setSignatureHelpEnabled(boolean enabled) {
        this.signatureHelpEnabled = enabled;
        return this;
    }

    public void setSignatureHelpDescriptionEnabled(boolean signatureHelpDescriptionEnabled) {
        this.signatureHelpDescriptionEnabled = signatureHelpDescriptionEnabled;
    }

    private Preferences setImplementationCodelensEnabled(boolean enabled) {
        this.implementationsCodeLensEnabled = enabled;
        return this;
    }

    private Preferences setRenameEnabled(boolean enabled) {
        this.renameEnabled = enabled;
        return this;
    }

    private Preferences setExecuteCommandEnabled(boolean enabled) {
        this.executeCommandEnabled = enabled;
        return this;
    }

    public Preferences setAutobuildEnabled(boolean enabled) {
        this.autobuildEnabled = enabled;
        return this;
    }

    public Preferences setCompletionEnabled(boolean enabled) {
        this.completionEnabled = enabled;
        return this;
    }

    public boolean isPostfixCompletionEnabled() {
        return this.postfixCompletionEnabled;
    }

    public void setPostfixCompletionEnabled(boolean postfixCompletionEnabled) {
        this.postfixCompletionEnabled = postfixCompletionEnabled;
    }

    public CompletionMatchCaseMode getCompletionMatchCaseMode() {
        return this.completionMatchCaseMode;
    }

    public void setCompletionMatchCaseMode(CompletionMatchCaseMode completionMatchCaseMode) {
        this.completionMatchCaseMode = completionMatchCaseMode;
    }

    public boolean isCompletionLazyResolveTextEditEnabled() {
        return this.completionLazyResolveTextEditEnabled;
    }

    public void setCompletionLazyResolveTextEditEnabled(boolean completionLazyResolveTextEditEnabled) {
        this.completionLazyResolveTextEditEnabled = completionLazyResolveTextEditEnabled;
    }

    public Preferences setCompletionOverwrite(boolean completionOverwrite) {
        this.completionOverwrite = completionOverwrite;
        return this;
    }

    public Preferences setFoldingRangeEnabled(boolean enabled) {
        this.foldingRangeEnabled = enabled;
        return this;
    }

    public Preferences setSelectionRangeEnabled(boolean enabled) {
        this.selectionRangeEnabled = enabled;
        return this;
    }

    public Preferences setGuessMethodArgumentsMode(CompletionGuessMethodArgumentsMode guessMethodArguments) {
        this.guessMethodArguments = guessMethodArguments;
        return this;
    }

    public Preferences setJavaFormatEnabled(boolean enabled) {
        this.javaFormatEnabled = enabled;
        return this;
    }

    public Preferences setJavaQuickFixShowAt(String value) {
        this.javaQuickFixShowAt = value;
        return this;
    }

    public Preferences setJavaSaveActionAutoOrganizeImportsEnabled(boolean javaSaveActionAutoOrganizeImportsEnabled) {
        this.javaSaveActionsOrganizeImportsEnabled = javaSaveActionAutoOrganizeImportsEnabled;
        return this;
    }

    public Preferences setHashCodeEqualsTemplateUseJava7Objects(boolean hashCodeEqualsTemplateUseJ7Objects) {
        this.hashCodeEqualsTemplateUseJava7Objects = hashCodeEqualsTemplateUseJ7Objects;
        return this;
    }

    public Preferences setHashCodeEqualsTemplateUseInstanceof(boolean hashCodeEqualsTemplateUseInstanceof) {
        this.hashCodeEqualsTemplateUseInstanceof = hashCodeEqualsTemplateUseInstanceof;
        return this;
    }

    public Preferences setCodeGenerationTemplateUseBlocks(boolean codeGenerationTemplateUseBlocks) {
        this.codeGenerationTemplateUseBlocks = codeGenerationTemplateUseBlocks;
        return this;
    }

    public Preferences setCodeGenerationTemplateGenerateComments(boolean codeGenerationTemplateGenerateComments) {
        this.codeGenerationTemplateGenerateComments = codeGenerationTemplateGenerateComments;
        return this;
    }

    public Preferences setGenerateToStringTemplate(String generateToStringTemplate) {
        this.generateToStringTemplate = generateToStringTemplate;
        return this;
    }

    public Preferences setGenerateToStringCodeStyle(String generateToStringCodeStyle) {
        this.generateToStringCodeStyle = generateToStringCodeStyle;
        return this;
    }

    public Preferences setGenerateToStringSkipNullValues(boolean generateToStringSkipNullValues) {
        this.generateToStringSkipNullValues = generateToStringSkipNullValues;
        return this;
    }

    public Preferences setGenerateToStringListArrayContents(boolean generateToStringListArrayContents) {
        this.generateToStringListArrayContents = generateToStringListArrayContents;
        return this;
    }

    public Preferences setGenerateToStringLimitElements(int generateToStringLimitElements) {
        this.generateToStringLimitElements = generateToStringLimitElements;
        return this;
    }

    public Preferences setUpdateBuildConfigurationStatus(FeatureStatus status) {
        this.updateBuildConfigurationStatus = status;
        return this;
    }

    private Preferences setIncompleteClasspathSeverity(Severity severity) {
        this.incompleteClasspathSeverity = severity;
        return this;
    }

    public Preferences setImportOrder(List<String> importOrder) {
        this.importOrder = importOrder == null || importOrder.size() == 0 ? JAVA_IMPORT_ORDER_DEFAULT : importOrder;
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
        pref.put("org.eclipse.jdt.ui.importorder", String.join((CharSequence)";", importOrder));
        return this;
    }

    public Preferences setFilteredTypes(List<String> filteredTypes) {
        this.filteredTypes = filteredTypes == null ? Collections.emptyList() : filteredTypes;
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
        pref.put("org.eclipse.jdt.ui.typefilter.enabled", String.join((CharSequence)";", filteredTypes));
        JavaLanguageServerPlugin.getInstance().getTypeFilter().dispose();
        return this;
    }

    public void setTelemetryEnabled(boolean telemetry) {
        this.telemetryEnabled = telemetry;
    }

    public Preferences setMaxBuildCount(int maxConcurrentBuilds) {
        this.parallelBuildsCount = maxConcurrentBuilds;
        return this;
    }

    public Severity getIncompleteClasspathSeverity() {
        return this.incompleteClasspathSeverity;
    }

    public FeatureStatus getUpdateBuildConfigurationStatus() {
        return this.updateBuildConfigurationStatus;
    }

    public List<String> getJavaImportExclusions() {
        return this.javaImportExclusions;
    }

    public String[] getJavaCompletionFavoriteMembers() {
        return this.javaCompletionFavoriteMembers.toArray(new String[0]);
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public String getGradleVersion() {
        return this.gradleVersion;
    }

    public List<String> getGradleArguments() {
        return this.gradleArguments == null ? new ArrayList() : this.gradleArguments;
    }

    public List<String> getGradleJvmArguments() {
        return this.gradleJvmArguments == null ? new ArrayList() : this.gradleJvmArguments;
    }

    public String getGradleHome() {
        return this.gradleHome;
    }

    public String getGradleJavaHome() {
        return this.gradleJavaHome;
    }

    public String getGradleUserHome() {
        return this.gradleUserHome;
    }

    public boolean isGradleAnnotationProcessingEnabled() {
        return this.gradleAnnotationProcessingEnabled;
    }

    public void setGradleAnnotationProcessingEnabled(boolean gradleAnnotationProcessingEnabled) {
        this.gradleAnnotationProcessingEnabled = gradleAnnotationProcessingEnabled;
    }

    public String getFormatterUrl() {
        return this.formatterUrl;
    }

    public URI getFormatterAsURI() {
        return this.asURI(this.formatterUrl);
    }

    public String getSettingsUrl() {
        return this.settingsUrl;
    }

    public URI getSettingsAsURI() {
        return this.asURI(this.settingsUrl);
    }

    private URI asURI(String url) {
        if (url == null || url.isBlank()) {
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(ResourceUtils.toClientUri(url));
            if (!uri.isAbsolute()) {
                uri = this.getURI(url);
            }
        }
        catch (URISyntaxException e1) {
            uri = this.getURI(url);
        }
        if (uri == null) {
            JavaLanguageServerPlugin.logInfo("Cannot resolve '" + url + "'.");
        }
        return uri;
    }

    private URI getURI(String path) {
        File file = this.findFile(path);
        if (file != null && file.isFile()) {
            return file.toURI();
        }
        return null;
    }

    private File findFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            return file;
        }
        Collection<IPath> rootPaths = this.getRootPaths();
        if (rootPaths != null) {
            for (IPath rootPath : rootPaths) {
                File f = new File(rootPath.toOSString(), path);
                if (!f.isFile()) continue;
                return f;
            }
        }
        return null;
    }

    public List<String> getResourceFilters() {
        return this.resourceFilters;
    }

    public String getFormatterProfileName() {
        return this.formatterProfileName;
    }

    public List<String> getPreferredContentProviderIds() {
        return this.preferredContentProviderIds;
    }

    public boolean isReferencesCodeLensEnabled() {
        return this.referencesCodeLensEnabled;
    }

    public boolean isImportGradleEnabled() {
        return this.importGradleEnabled;
    }

    public boolean isImportGradleOfflineEnabled() {
        return this.importGradleOfflineEnabled;
    }

    public boolean isGradleWrapperEnabled() {
        return this.gradleWrapperEnabled;
    }

    public boolean isImportMavenEnabled() {
        return this.importMavenEnabled;
    }

    public boolean isMavenOffline() {
        return this.mavenOffline;
    }

    public boolean isMavenDisableTestClasspathFlag() {
        return this.mavenDisableTestClasspathFlag;
    }

    public boolean isMavenDownloadSources() {
        return this.mavenDownloadSources;
    }

    public boolean isMavenUpdateSnapshots() {
        return this.mavenUpdateSnapshots;
    }

    public boolean isImplementationsCodeLensEnabled() {
        return this.implementationsCodeLensEnabled;
    }

    public boolean isCodeLensEnabled() {
        return this.referencesCodeLensEnabled || this.implementationsCodeLensEnabled;
    }

    public boolean isJavaFormatEnabled() {
        return this.javaFormatEnabled;
    }

    public String getJavaQuickFixShowAt() {
        return this.javaQuickFixShowAt;
    }

    public boolean isJavaQuickFixShowAtLine() {
        return LINE.equals(this.javaQuickFixShowAt);
    }

    public boolean isJavaSaveActionsOrganizeImportsEnabled() {
        return this.javaSaveActionsOrganizeImportsEnabled;
    }

    public boolean isSignatureHelpEnabled() {
        return this.signatureHelpEnabled;
    }

    public boolean isSignatureHelpDescriptionEnabled() {
        return this.signatureHelpDescriptionEnabled;
    }

    public boolean isRenameEnabled() {
        return this.renameEnabled;
    }

    public boolean isExecuteCommandEnabled() {
        return this.executeCommandEnabled;
    }

    public boolean isAutobuildEnabled() {
        return this.autobuildEnabled;
    }

    public boolean isCompletionEnabled() {
        return this.completionEnabled;
    }

    public boolean isCompletionOverwrite() {
        return this.completionOverwrite;
    }

    public boolean isFoldingRangeEnabled() {
        return this.foldingRangeEnabled;
    }

    public boolean isSelectionRangeEnabled() {
        return this.selectionRangeEnabled;
    }

    public CompletionGuessMethodArgumentsMode getGuessMethodArgumentsMode() {
        return this.guessMethodArguments;
    }

    public boolean isHashCodeEqualsTemplateUseJava7Objects() {
        return this.hashCodeEqualsTemplateUseJava7Objects;
    }

    public boolean isHashCodeEqualsTemplateUseInstanceof() {
        return this.hashCodeEqualsTemplateUseInstanceof;
    }

    public boolean isCodeGenerationTemplateUseBlocks() {
        return this.codeGenerationTemplateUseBlocks;
    }

    public boolean isCodeGenerationTemplateGenerateComments() {
        return this.codeGenerationTemplateGenerateComments;
    }

    public String getGenerateToStringTemplate() {
        return this.generateToStringTemplate;
    }

    public String getGenerateToStringCodeStyle() {
        return this.generateToStringCodeStyle;
    }

    public boolean isGenerateToStringSkipNullValues() {
        return this.generateToStringSkipNullValues;
    }

    public boolean isGenerateToStringListArrayContents() {
        return this.generateToStringListArrayContents;
    }

    public int getGenerateToStringLimitElements() {
        return this.generateToStringLimitElements;
    }

    public String getCodeGenerationInsertionLocation() {
        return this.codeGenerationInsertionLocation;
    }

    public void setCodeGenerationInsertionLocation(String insertionLocation) {
        this.codeGenerationInsertionLocation = insertionLocation;
    }

    public Preferences setMavenUserSettings(String mavenUserSettings) {
        this.mavenUserSettings = ResourceUtils.expandPath(mavenUserSettings);
        return this;
    }

    public String getMavenUserSettings() {
        return this.mavenUserSettings;
    }

    public Preferences setMavenGlobalSettings(String mavenGlobalSettings) {
        this.mavenGlobalSettings = ResourceUtils.expandPath(mavenGlobalSettings);
        return this;
    }

    public String getMavenGlobalSettings() {
        return this.mavenGlobalSettings;
    }

    public String getMavenNotCoveredPluginExecutionSeverity() {
        return this.mavenNotCoveredPluginExecutionSeverity;
    }

    public Preferences setMavenNotCoveredPluginExecutionSeverity(String mavenNotCoveredPluginExecutionSeverity) {
        this.mavenNotCoveredPluginExecutionSeverity = mavenNotCoveredPluginExecutionSeverity;
        return this;
    }

    public String getMavenDefaultMojoExecutionAction() {
        return this.mavenDefaultMojoExecutionAction;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public Preferences setMavenDefaultMojoExecutionAction(String mavenDefaultMojoExecutionAction) {
        if (mavenDefaultMojoExecutionAction == null) {
            mavenDefaultMojoExecutionAction = IGNORE;
        }
        switch (mavenDefaultMojoExecutionAction) {
            default: {
                mavenDefaultMojoExecutionAction = IGNORE;
                break;
            }
            case "execute": 
            case "ignore": 
            case "warn": 
            case "error": 
        }
        this.mavenDefaultMojoExecutionAction = mavenDefaultMojoExecutionAction;
        return this;
    }

    public String[] getImportOrder() {
        return this.importOrder == null ? new String[]{} : this.importOrder.toArray(new String[this.importOrder.size()]);
    }

    public String[] getFilteredTypes() {
        return this.filteredTypes == null ? new String[]{} : this.filteredTypes.toArray(new String[this.filteredTypes.size()]);
    }

    public int getMaxConcurrentBuilds() {
        return this.parallelBuildsCount;
    }

    public Map<String, Object> asMap() {
        if (this.configuration == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.configuration);
    }

    public Preferences setRootPaths(Collection<IPath> rootPaths) {
        this.rootPaths = rootPaths;
        return this;
    }

    public Collection<IPath> getRootPaths() {
        return this.rootPaths;
    }

    public Preferences setTriggerFiles(Collection<IPath> triggerFiles) {
        this.triggerFiles = triggerFiles;
        return this;
    }

    public Collection<IPath> getTriggerFiles() {
        return this.triggerFiles;
    }

    public Collection<IPath> getProjectConfigurations() {
        return this.projectConfigurations;
    }

    public void setProjectConfigurations(Collection<IPath> projectConfigurations) {
        this.projectConfigurations = projectConfigurations;
    }

    public boolean isJavaFormatOnTypeEnabled() {
        return this.javaFormatOnTypeEnabled;
    }

    public Preferences setJavaFormatOnTypeEnabled(boolean javaFormatOnTypeEnabled) {
        this.javaFormatOnTypeEnabled = javaFormatOnTypeEnabled;
        return this;
    }

    public int getMaxCompletionResults() {
        return this.maxCompletionResults;
    }

    public Preferences setMaxCompletionResults(int maxCompletions) {
        this.maxCompletionResults = maxCompletions < 1 ? Integer.MAX_VALUE : maxCompletions;
        return this;
    }

    public ReferencedLibraries getReferencedLibraries() {
        return this.referencedLibraries;
    }

    public Preferences setReferencedLibraries(ReferencedLibraries referencedLibraries) {
        this.referencedLibraries = referencedLibraries;
        return this;
    }

    public Set<RuntimeEnvironment> getRuntimes() {
        return this.runtimes;
    }

    public Preferences setRuntimes(Set<RuntimeEnvironment> runtimes) {
        this.runtimes = runtimes;
        return this;
    }

    public int getImportOnDemandThreshold() {
        return this.importOnDemandThreshold;
    }

    public Preferences setImportOnDemandThreshold(int importOnDemandThreshold) {
        this.importOnDemandThreshold = importOnDemandThreshold <= 0 ? 99 : importOnDemandThreshold;
        IEclipsePreferences defEclipsePrefs = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
        defEclipsePrefs.put("org.eclipse.jdt.ui.ondemandthreshold", String.valueOf(this.importOnDemandThreshold));
        return this;
    }

    public int getStaticImportOnDemandThreshold() {
        return this.staticImportOnDemandThreshold;
    }

    public Preferences setStaticImportOnDemandThreshold(int staticImportOnDemandThreshold) {
        this.staticImportOnDemandThreshold = staticImportOnDemandThreshold <= 0 ? 99 : staticImportOnDemandThreshold;
        IEclipsePreferences defEclipsePrefs = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
        defEclipsePrefs.put("org.eclipse.jdt.ui.staticondemandthreshold", String.valueOf(this.staticImportOnDemandThreshold));
        return this;
    }

    public Preferences setGradleWrapperList(List<?> gradleWrapperList) {
        this.gradleWrapperList = gradleWrapperList;
        return this;
    }

    public List<?> getGradleWrapperList() {
        return this.gradleWrapperList == null ? Collections.emptyList() : this.gradleWrapperList;
    }

    public List<String> getFileHeaderTemplate() {
        return this.fileHeaderTemplate;
    }

    public Preferences setFileHeaderTemplate(List<String> fileHeaderTemplate) {
        this.fileHeaderTemplate = fileHeaderTemplate;
        return this;
    }

    public List<String> getTypeCommentTemplate() {
        return this.typeCommentTemplate;
    }

    public Preferences setTypeCommentTemplate(List<String> typeCommentTemplate) {
        this.typeCommentTemplate = typeCommentTemplate;
        return this;
    }

    public Preferences setIncludeAccessors(boolean includeAccessors) {
        this.includeAccessors = includeAccessors;
        return this;
    }

    public boolean isIncludeAccessors() {
        return this.includeAccessors;
    }

    public boolean isEclipseDownloadSources() {
        return this.eclipseDownloadSources;
    }

    public Preferences setEclipseDownloadSources(boolean enabled) {
        this.eclipseDownloadSources = enabled;
        return this;
    }

    public String getInvisibleProjectOutputPath() {
        return this.invisibleProjectOutputPath;
    }

    public void setInvisibleProjectOutputPath(String invisibleProjectOutputPath) {
        this.invisibleProjectOutputPath = ResourceUtils.expandPath(invisibleProjectOutputPath);
    }

    public List<String> getInvisibleProjectSourcePaths() {
        return this.invisibleProjectSourcePaths;
    }

    public void setInvisibleProjectSourcePaths(List<String> invisibleProjectSourcePaths) {
        if (invisibleProjectSourcePaths != null) {
            this.invisibleProjectSourcePaths = new ArrayList<String>();
            for (String path : invisibleProjectSourcePaths) {
                this.invisibleProjectSourcePaths.add(ResourceUtils.expandPath(path));
            }
        } else {
            this.invisibleProjectSourcePaths = invisibleProjectSourcePaths;
        }
    }

    public Preferences setIncludeDecompiledSources(boolean includeDecompiledSources) {
        this.includeDecompiledSources = includeDecompiledSources;
        return this;
    }

    public boolean isIncludeDecompiledSources() {
        return this.includeDecompiledSources;
    }

    public boolean isIncludeSourceMethodDeclarations() {
        return this.includeSourceMethodDeclarations;
    }

    public void setIncludeSourceMethodDeclarations(boolean includeSourceMethodDeclarations) {
        this.includeSourceMethodDeclarations = includeSourceMethodDeclarations;
    }

    public Preferences setInsertSpaces(boolean insertSpaces) {
        this.insertSpaces = insertSpaces;
        return this;
    }

    public Preferences setTabSize(int tabSize) {
        this.tabSize = tabSize;
        return this;
    }

    public boolean isInsertSpaces() {
        return this.insertSpaces;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void updateTabSizeInsertSpaces(Hashtable<String, String> options) {
        if (options == null) {
            return;
        }
        if (this.tabSize > 0) {
            options.put("org.eclipse.jdt.core.formatter.tabulation.size", String.valueOf(this.tabSize));
        }
        options.put("org.eclipse.jdt.core.formatter.tabulation.char", this.insertSpaces ? "space" : "tab");
    }

    public InlayHintsParameterMode getInlayHintsParameterMode() {
        return this.inlayHintsParameterMode;
    }

    public void setInlayHintsParameterMode(InlayHintsParameterMode inlayHintsParameterMode) {
        this.inlayHintsParameterMode = inlayHintsParameterMode;
    }

    public Preferences setProjectEncoding(ProjectEncodingMode projectEncoding) {
        this.projectEncoding = projectEncoding;
        return this;
    }

    public List<String> getInlayHintsExclusionList() {
        return this.inlayHintsExclusionList;
    }

    public void setInlayHintsExclusionList(List<String> inlayHintsExclusionList) {
        this.inlayHintsExclusionList = inlayHintsExclusionList;
    }

    public ProjectEncodingMode getProjectEncoding() {
        return this.projectEncoding;
    }

    public void setAvoidVolatileChanges(boolean avoidVolatileChanges) {
        this.avoidVolatileChanges = avoidVolatileChanges;
    }

    public boolean getAvoidVolatileChanges() {
        return this.avoidVolatileChanges;
    }

    public boolean isProtobufSupportEnabled() {
        return this.protobufSupportEnabled;
    }

    public void setProtobufSupportEnabled(boolean protobufSupportEnabled) {
        this.protobufSupportEnabled = protobufSupportEnabled;
    }

    public boolean isAndroidSupportEnabled() {
        return this.androidSupportEnabled;
    }

    public void setAndroidSupportEnabled(boolean androidSupportEnabled) {
        this.androidSupportEnabled = androidSupportEnabled;
    }

    public List<String> getNonnullTypes() {
        return this.nonnullTypes;
    }

    public void setNonnullTypes(List<String> nonnullTypes) {
        this.nonnullTypes = nonnullTypes;
    }

    public List<String> getNullableTypes() {
        return this.nullableTypes;
    }

    public void setNullableTypes(List<String> nullableTypes) {
        this.nullableTypes = nullableTypes;
    }

    public void setNullAnalysisMode(FeatureStatus nullAnalysisMode) {
        this.nullAnalysisMode = nullAnalysisMode;
    }

    public FeatureStatus getNullAnalysisMode() {
        return this.nullAnalysisMode;
    }

    public void setExtractInterfaceReplaceEnabled(boolean extractInterfaceReplaceEnabled) {
        this.extractInterfaceReplaceEnabled = extractInterfaceReplaceEnabled;
    }

    public boolean getExtractInterfaceReplaceEnabled() {
        return this.extractInterfaceReplaceEnabled;
    }

    public void setChainCompletionEnabled(boolean chainCompletionEnabled) {
        this.chainCompletionEnabled = chainCompletionEnabled;
    }

    public boolean isChainCompletionEnabled() {
        return this.chainCompletionEnabled;
    }

    public List<String> getCleanUpActionsOnSave() {
        return this.cleanUpActionsOnSave;
    }

    public boolean updateAnnotationNullAnalysisOptions() {
        switch (this.getNullAnalysisMode()) {
            case automatic: {
                return this.updateAnnotationNullAnalysisOptions(true);
            }
            case interactive: {
                if (this.hasAnnotationNullAnalysisTypes()) {
                    String cmd = "java.compile.nullAnalysis.setMode";
                    ActionableNotification updateNullAnalysisStatusNotification = new ActionableNotification().withSeverity(MessageType.Info).withMessage("Null annotation types have been detected in the project. Do you wish to enable null analysis for this project?").withCommands(Arrays.asList(new Command("Enable", cmd, Arrays.asList(new Object[]{FeatureStatus.automatic})), new Command("Disable", cmd, Arrays.asList(new Object[]{FeatureStatus.disabled}))));
                    JavaLanguageServerPlugin.getProjectsManager().getConnection().sendActionableNotification(updateNullAnalysisStatusNotification);
                }
                return false;
            }
        }
        return this.updateAnnotationNullAnalysisOptions(false);
    }

    private boolean updateAnnotationNullAnalysisOptions(boolean enabled) {
        boolean isChanged = false;
        IJavaProject[] iJavaProjectArray = ProjectUtils.getJavaProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            isChanged |= this.updateAnnotationNullAnalysisOptions(javaProject, enabled);
            ++n2;
        }
        return isChanged;
    }

    public boolean updateAnnotationNullAnalysisOptions(IJavaProject javaProject, boolean enabled) {
        boolean shouldUpdate;
        Map<String, String> projectNullAnalysisOptions;
        if (javaProject.getElementName().equals("jdt.ls-java-project")) {
            return false;
        }
        Map projectInheritOptions = javaProject.getOptions(true);
        if (projectInheritOptions == null) {
            return false;
        }
        if (enabled) {
            String nonnullType = this.getAnnotationType(javaProject, this.nonnullTypes, nonnullClasspathStorage);
            String nullableType = this.getAnnotationType(javaProject, this.nullableTypes, nullableClasspathStorage);
            projectNullAnalysisOptions = this.generateProjectNullAnalysisOptions(nonnullType, nullableType);
        } else {
            projectNullAnalysisOptions = this.generateProjectNullAnalysisOptions(null, null);
        }
        boolean bl = shouldUpdate = !projectNullAnalysisOptions.entrySet().stream().allMatch(e -> ((String)e.getValue()).equals(projectInheritOptions.get(e.getKey())));
        if (shouldUpdate) {
            Map projectOptions = javaProject.getOptions(false);
            if (projectOptions != null) {
                projectOptions.putAll(projectNullAnalysisOptions);
                javaProject.setOptions(projectOptions);
            } else {
                return false;
            }
        }
        return shouldUpdate;
    }

    private boolean hasAnnotationNullAnalysisTypes() {
        if (this.nonnullTypes.isEmpty() && this.nullableTypes.isEmpty()) {
            return false;
        }
        IJavaProject[] iJavaProjectArray = ProjectUtils.getJavaProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            if (!javaProject.getElementName().equals("jdt.ls-java-project")) {
                String nonnullType = this.getAnnotationType(javaProject, this.nonnullTypes, nonnullClasspathStorage);
                String nullableType = this.getAnnotationType(javaProject, this.nullableTypes, nullableClasspathStorage);
                if (nonnullType != null || nullableType != null) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private String getAnnotationType(IJavaProject javaProject, List<String> annotationTypes, Map<String, List<String>> classpathStorage) {
        if (!annotationTypes.isEmpty()) {
            try {
                ProjectCommand.ClasspathResult result = ProjectCommand.getClasspathsFromJavaProject(javaProject, new ProjectCommand.ClasspathOptions());
                for (String annotationType : annotationTypes) {
                    String aType;
                    if (classpathStorage.keySet().contains(annotationType)) {
                        String[] stringArray = result.classpaths;
                        int n = result.classpaths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String classpath = stringArray[n2];
                            IClasspathEntry classpathEntry = javaProject.getClasspathEntryFor((IPath)new Path(classpath));
                            if (classpathEntry == null || !classpathEntry.isTest()) {
                                for (String classpathSubString : classpathStorage.get(annotationType)) {
                                    if (!classpath.contains(classpathSubString)) continue;
                                    return annotationType;
                                }
                            }
                            ++n2;
                        }
                        aType = this.findTypeInProject(javaProject, annotationType, classpathStorage);
                        if (aType == null) continue;
                        return aType;
                    }
                    try {
                        aType = this.findTypeInProject(javaProject, annotationType, classpathStorage);
                        if (aType == null) continue;
                        return aType;
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
            }
            catch (URISyntaxException | CoreException e) {
                JavaLanguageServerPlugin.logException(e);
            }
        }
        return null;
    }

    private String findTypeInProject(IJavaProject javaProject, String annotationType, Map<String, List<String>> classpathStorage) throws JavaModelException {
        IJavaElement fragmentRoot;
        IClasspathEntry classpathEntry;
        IType type = javaProject.findType(annotationType);
        if (!(type == null || (classpathEntry = javaProject.getClasspathEntryFor((fragmentRoot = type.getAncestor(3)).getPath())) != null && classpathEntry.isTest())) {
            String classpath = fragmentRoot.getPath().toOSString();
            if (classpathStorage.containsKey(annotationType)) {
                classpathStorage.get(annotationType).add(classpath);
            } else {
                classpathStorage.put(annotationType, new ArrayList<String>(Arrays.asList(classpath)));
            }
            return annotationType;
        }
        return null;
    }

    private Map<String, String> generateProjectNullAnalysisOptions(String nonnullType, String nullableType) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (nonnullType == null && nullableType == null) {
            options.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "disabled");
            Hashtable defaultOptions = JavaCore.getDefaultOptions();
            options.put("org.eclipse.jdt.core.compiler.annotation.nonnull", (String)defaultOptions.get("org.eclipse.jdt.core.compiler.annotation.nonnull"));
            options.put("org.eclipse.jdt.core.compiler.annotation.nullable", (String)defaultOptions.get("org.eclipse.jdt.core.compiler.annotation.nullable"));
            options.put("org.eclipse.jdt.core.compiler.problem.nullReference", (String)defaultOptions.get("org.eclipse.jdt.core.compiler.problem.nullReference"));
            options.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", (String)defaultOptions.get("org.eclipse.jdt.core.compiler.problem.potentialNullReference"));
            options.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", (String)defaultOptions.get("org.eclipse.jdt.core.compiler.problem.nullSpecViolation"));
            options.put("org.eclipse.jdt.core.compiler.problem.nullAnnotationInferenceConflict", (String)defaultOptions.get("org.eclipse.jdt.core.compiler.problem.nullAnnotationInferenceConflict"));
        } else {
            options.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
            options.put("org.eclipse.jdt.core.compiler.annotation.nonnull", nonnullType != null ? nonnullType : "");
            options.put("org.eclipse.jdt.core.compiler.annotation.nullable", nullableType != null ? nullableType : "");
            options.put("org.eclipse.jdt.core.compiler.problem.nullReference", "warning");
            options.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "warning");
            options.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "warning");
            options.put("org.eclipse.jdt.core.compiler.problem.nullAnnotationInferenceConflict", "warning");
        }
        return options;
    }

    public boolean isTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    public boolean isValidateAllOpenBuffersOnChanges() {
        return this.validateAllOpenBuffersOnChanges;
    }

    public void setValidateAllOpenBuffersOnChanges(boolean validateAllOpenBuffersOnChanges) {
        this.validateAllOpenBuffersOnChanges = validateAllOpenBuffersOnChanges;
    }

    public static enum FeatureStatus {
        disabled,
        interactive,
        automatic;


        static FeatureStatus fromString(String value, FeatureStatus defaultStatus) {
            if (value != null) {
                String val = value.toLowerCase();
                try {
                    return FeatureStatus.valueOf(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return defaultStatus;
        }
    }

    public static class ReferencedLibraries {
        private Set<String> include = new HashSet<String>(){

            @Override
            public boolean add(String e) {
                return super.add(ResourceUtils.expandPath(e));
            }
        };
        private Set<String> exclude;
        private Map<String, String> sources;

        public ReferencedLibraries() {
            this(new HashSet<String>(), new HashSet<String>(), new HashMap<String, String>());
        }

        public ReferencedLibraries(Set<String> include) {
            this(include, new HashSet<String>(), new HashMap<String, String>());
        }

        public ReferencedLibraries(Set<String> include, Set<String> exclude, Map<String, String> sources) {
            this.include.addAll(include);
            this.exclude = new HashSet<String>(){

                @Override
                public boolean add(String e) {
                    return super.add(ResourceUtils.expandPath(e));
                }
            };
            this.exclude.addAll(exclude);
            this.sources = new HashMap<String, String>(){

                @Override
                public String put(String key, String value) {
                    return super.put(ResourceUtils.expandPath(key), ResourceUtils.expandPath(value));
                }
            };
            this.sources.putAll(sources);
        }

        public Set<String> getInclude() {
            return this.include;
        }

        public Set<String> getExclude() {
            return this.exclude;
        }

        public Map<String, String> getSources() {
            return this.sources;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReferencedLibraries other = (ReferencedLibraries)obj;
            return Objects.equals(this.include, other.include) && Objects.equals(this.exclude, other.exclude) && Objects.equals(this.sources, other.sources);
        }
    }

    public static enum Severity {
        ignore,
        log,
        info,
        warning,
        error;


        static Severity fromString(String value, Severity defaultSeverity) {
            if (value != null) {
                String val = value.toLowerCase();
                try {
                    return Severity.valueOf(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return defaultSeverity;
        }

        public MessageType toMessageType() {
            MessageType[] messageTypeArray = MessageType.values();
            int n = messageTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MessageType type = messageTypeArray[n2];
                if (this.name().equalsIgnoreCase(type.name())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }
    }
}

