"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BIMath = void 0;
var BIMath = /** @class */ (function () {
    function BIMath() {
    }
    BIMath.round = function (val) {
        return typeof val === 'bigint' ? val : BigInt(Math.round(val));
    };
    BIMath.clamp = function (val, min, max) {
        val = BIMath.round(val);
        if (val < min) {
            return min;
        }
        else if (val > max) {
            return max;
        }
        return val;
    };
    BIMath.min = function (val1, val2) {
        val1 = BIMath.round(val1);
        val2 = BIMath.round(val2);
        return val1 <= val2 ? val1 : val2;
    };
    BIMath.max = function (val1, val2) {
        val1 = BIMath.round(val1);
        val2 = BIMath.round(val2);
        return val1 >= val2 ? val1 : val2;
    };
    BIMath.abs = function (val) {
        val = BIMath.round(val);
        return val >= 0 ? val : -val;
    };
    BIMath.multiply = function (a, b) {
        a = Number(a);
        b = Number(b);
        var c = a * b;
        return BIMath.round(c);
    };
    return BIMath;
}());
exports.BIMath = BIMath;
;
//# sourceMappingURL=bigint-utils.js.map