"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphAxis = void 0;
var time_graph_axis_scale_1 = require("../components/time-graph-axis-scale");
var time_graph_layer_1 = require("./time-graph-layer");
var _ = require("lodash");
var bigint_utils_1 = require("../bigint-utils");
var TimeGraphAxis = /** @class */ (function (_super) {
    __extends(TimeGraphAxis, _super);
    function TimeGraphAxis(id, style) {
        var _this = _super.call(this, id) || this;
        _this.style = style;
        return _this;
    }
    TimeGraphAxis.prototype.getOptions = function () {
        var color;
        var lineColor;
        var verticalAlign = 'top'; // Default position is top, same as CSS verticalAlign is 'baseline'
        if (this.style) {
            color = this.style.color;
            lineColor = this.style.lineColor;
            verticalAlign = this.style.verticalAlign;
        }
        return {
            height: this.stateController.canvasDisplayHeight,
            width: this.stateController.canvasDisplayWidth,
            position: {
                x: 0,
                y: 0
            },
            color: color,
            lineColor: lineColor,
            verticalAlign: verticalAlign
        };
    };
    TimeGraphAxis.prototype.afterAddToContainer = function () {
        var _this = this;
        this.controlKeyDown = false;
        this._keyDownHandler = function (event) {
            _this.controlKeyDown = event.ctrlKey;
        };
        document.addEventListener('keydown', this._keyDownHandler);
        this._keyUpHandler = function (event) {
            _this.controlKeyDown = event.ctrlKey;
        };
        document.addEventListener('keyup', this._keyUpHandler);
        this._mouseWheelHandler = _.throttle(function (ev) {
            if (_this.controlKeyDown) {
                // ZOOM AROUND MOUSE POINTER
                var zoomPosition = bigint_utils_1.BIMath.round(ev.offsetX / _this.stateController.zoomFactor);
                var zoomIn = ev.deltaY < 0;
                var newViewRangeLength = bigint_utils_1.BIMath.clamp(Number(_this.unitController.viewRangeLength) * (zoomIn ? 0.8 : 1.25), BigInt(1), _this.unitController.absoluteRange);
                var center = _this.unitController.viewRange.start + zoomPosition;
                var start = bigint_utils_1.BIMath.clamp(Number(center) - Number(zoomPosition) * Number(newViewRangeLength) / Number(_this.unitController.viewRangeLength), BigInt(0), _this.unitController.absoluteRange - newViewRangeLength);
                var end = start + newViewRangeLength;
                _this.unitController.viewRange = {
                    start: start,
                    end: end
                };
            }
            else {
                // PANNING
                var shiftStep = ev.deltaY;
                var oldViewRange = _this.unitController.viewRange;
                var start = oldViewRange.start + bigint_utils_1.BIMath.round(shiftStep / _this.stateController.zoomFactor);
                if (start < 0) {
                    start = BigInt(0);
                }
                var end = start + _this.unitController.viewRangeLength;
                if (end > _this.unitController.absoluteRange) {
                    start = _this.unitController.absoluteRange - _this.unitController.viewRangeLength;
                    end = _this.unitController.absoluteRange;
                }
                _this.unitController.viewRange = { start: start, end: end };
            }
            ev.preventDefault();
            return false;
        });
        this.onCanvasEvent('mousewheel', this._mouseWheelHandler);
        this.onCanvasEvent('wheel', this._mouseWheelHandler);
        this.scaleComponent = new time_graph_axis_scale_1.TimeGraphAxisScale(this.id + '_scale', this.getOptions(), this.unitController, this.stateController);
        this.addChild(this.scaleComponent);
        this._updateHandler = function () { return _this.update(); };
        this.unitController.onSelectionRangeChange(this._updateHandler);
        this.unitController.onViewRangeChanged(this._updateHandler);
    };
    TimeGraphAxis.prototype.update = function (opts) {
        if (opts && this.style) {
            this.style.lineColor = opts.lineColor;
        }
        this.scaleComponent.update(this.getOptions());
    };
    TimeGraphAxis.prototype.destroy = function () {
        if (this.unitController) {
            this.unitController.removeViewRangeChangedHandler(this._updateHandler);
            this.unitController.removeSelectionRangeChangedHandler(this._updateHandler);
        }
        if (this._mouseWheelHandler) {
            this.removeOnCanvasEvent('mousewheel', this._mouseWheelHandler);
            this.removeOnCanvasEvent('wheel', this._mouseWheelHandler);
        }
        if (this._keyDownHandler) {
            document.removeEventListener('keydown', this._keyDownHandler);
        }
        if (this._keyUpHandler) {
            document.removeEventListener('keyup', this._keyUpHandler);
        }
        _super.prototype.destroy.call(this);
    };
    return TimeGraphAxis;
}(time_graph_layer_1.TimeGraphLayer));
exports.TimeGraphAxis = TimeGraphAxis;
//# sourceMappingURL=time-graph-axis.js.map