"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphMarkersChartCursors = void 0;
var time_graph_chart_cursors_1 = require("./time-graph-chart-cursors");
var TimeGraphMarkersChartCursors = /** @class */ (function (_super) {
    __extends(TimeGraphMarkersChartCursors, _super);
    function TimeGraphMarkersChartCursors() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.selectClosestStateAndMakeSelectionRange = function (direction) {
            var next = direction === 'next';
            var selectedRow = _this.rowController.selectedRow;
            if (_this.unitController.selectionRange && selectedRow) {
                var _a = _this.unitController.selectionRange, start = _a.start, end = _a.end;
                var point1_1 = next ? end : start;
                var closestState_1;
                var closestDiff_1 = Number.POSITIVE_INFINITY;
                var isValid_1 = false;
                selectedRow === null || selectedRow === void 0 ? void 0 : selectedRow.states.forEach(function (marker, key) {
                    var _a, _b;
                    var _c = marker.range, start = _c.start, end = _c.end;
                    if (start === ((_a = _this.unitController.selectionRange) === null || _a === void 0 ? void 0 : _a.start) && end === ((_b = _this.unitController.selectionRange) === null || _b === void 0 ? void 0 : _b.end)) {
                        return;
                    }
                    var point2 = next ? start : end;
                    var innerIsValid = next ? (point1_1 <= point2) : (point1_1 >= point2);
                    var diff = Math.abs(Number(point1_1 - point2));
                    if (diff < closestDiff_1 && innerIsValid) {
                        closestDiff_1 = diff;
                        closestState_1 = marker;
                        isValid_1 = innerIsValid;
                    }
                });
                if (isValid_1 && closestState_1) {
                    _this.unitController.selectionRange = closestState_1.range;
                    _this.maybeCenterCursor();
                    _this.update();
                }
            }
        };
        return _this;
    }
    TimeGraphMarkersChartCursors.prototype.afterAddToContainer = function () {
        var _this = this;
        _super.prototype.afterAddToContainer.call(this);
        this.removeOnCanvasEvent('keydown', this._keyboardShortcutKeyDownHandler);
        this._keyboardShortcutKeyDownHandler = function (event) {
            switch (event.key) {
                case ",":
                    _this.selectClosestStateAndMakeSelectionRange('prev');
                    break;
                case ".":
                    _this.selectClosestStateAndMakeSelectionRange('next');
                    break;
                default:
                    return;
            }
        };
        this.onCanvasEvent('keydown', this._keyboardShortcutKeyDownHandler);
    };
    return TimeGraphMarkersChartCursors;
}(time_graph_chart_cursors_1.TimeGraphChartCursors));
exports.TimeGraphMarkersChartCursors = TimeGraphMarkersChartCursors;
//# sourceMappingURL=time-graph-markers-chart-cursors.js.map