"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphRenderController = exports.RenderEvents = void 0;
var lodash_1 = require("lodash");
var PIXI = require("pixi.js-legacy");
var START_RENDER_STRING = 'startPixiRender';
var STOP_RENDER_STRING = 'stopPixiRender';
var throttledStart = (0, lodash_1.throttle)(function () {
    window.dispatchEvent(new Event(START_RENDER_STRING));
}, 450, { leading: true });
var debouncedStop = (0, lodash_1.debounce)(function () {
    window.dispatchEvent(new Event(STOP_RENDER_STRING));
}, 1000);
;
exports.RenderEvents = {
    /**
     * Fires an event that will start the PIXI.Ticker.
     * This will start rendering.
     * Event handler located in time-graph-render-controller.ts
     */
    startRender: function () {
        throttledStart();
    },
    /**
     * Fires an event that will stop the PIXI.Ticker.
     * This will stop rendering.
     * Event handler located in time-graph-render-controller.ts
     */
    stopRender: function () {
        debouncedStop();
    }
};
var TimeGraphRenderController = /** @class */ (function () {
    function TimeGraphRenderController() {
        var _this = this;
        this.initializeRenderEvents = function () {
            var _a = _this, startRender = _a.startRender, stopRender = _a.stopRender;
            window.addEventListener(START_RENDER_STRING, startRender);
            window.addEventListener(STOP_RENDER_STRING, stopRender);
            window.addEventListener('beforeunload', function () {
                window.removeEventListener(START_RENDER_STRING, startRender);
                window.removeEventListener(STOP_RENDER_STRING, stopRender);
            });
        };
        this.startRender = function () {
            PIXI.Ticker.shared.start();
            debouncedStop();
        };
        this.stopRender = function () {
            PIXI.Ticker.shared.stop();
        };
        this.initializeRenderEvents();
    }
    return TimeGraphRenderController;
}());
exports.TimeGraphRenderController = TimeGraphRenderController;
//# sourceMappingURL=time-graph-render-controller.js.map