"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceOverviewSelectionDialogComponent = void 0;
const react_1 = __importDefault(require("react"));
const abstract_dialog_component_1 = require("./abstract-dialog-component");
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
const available_views_component_1 = require("./utils/available-views-component");
class TraceOverviewSelectionDialogComponent extends abstract_dialog_component_1.AbstractDialogComponent {
    constructor(props) {
        super(props);
        this.handleOutputClicked = (selectedOutput) => this.doHandleOutputClicked(selectedOutput);
        this.state = {
            outputDescriptors: []
        };
        this.getAvailableOutputDescriptors();
    }
    renderDialogBody() {
        if (!this.state.outputDescriptors) {
            return (react_1.default.createElement("div", null, "Loading available outputs..."));
        }
        return (react_1.default.createElement("div", { id: "trace-overview-selection-dialog-content-container" },
            react_1.default.createElement(available_views_component_1.AvailableViewsComponent, { traceID: this.props.traceID, onOutputClicked: e => { this.doHandleOutputClicked(e); }, outputDescriptors: this.state.outputDescriptors, listRowWidth: '95%', listRowPadding: '10px' })));
    }
    renderFooter() {
        return (react_1.default.createElement("button", { className: "theia-button secondary", onClick: this.props.onCloseDialog }, "Close"));
    }
    async getAvailableOutputDescriptors() {
        if (this.props.traceID) {
            const result = await this.props.tspClient.experimentOutputs(this.props.traceID);
            const descriptors = result.getModel();
            const overviewOutputDescriptors = descriptors === null || descriptors === void 0 ? void 0 : descriptors.filter(output => output.type === 'TREE_TIME_XY');
            if (overviewOutputDescriptors) {
                this.setState({
                    outputDescriptors: overviewOutputDescriptors
                });
            }
        }
    }
    doHandleOutputClicked(selectedOutput) {
        (0, signal_manager_1.signalManager)().fireOverviewOutputSelectedSignal({
            traceId: this.props.traceID,
            outputDescriptor: selectedOutput
        });
        this.props.onCloseDialog();
    }
}
exports.TraceOverviewSelectionDialogComponent = TraceOverviewSelectionDialogComponent;
//# sourceMappingURL=trace-overview-selection-dialog-component.js.map