/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JVMConfigurator;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.StatusFactory;
import org.eclipse.jdt.ls.core.internal.commands.DiagnosticsCommand;
import org.eclipse.jdt.ls.core.internal.handlers.DiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.managers.BuildSupportManager;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.InternalBuildSupports;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.TextDocumentIdentifier;

public final class ProjectUtils {
    public static final String SETTINGS = ".settings";
    public static final String WORKSPACE_LINK = "_";
    private static final String JAR_SUFFIX = ".jar";
    private static final String SOURCE_JAR_SUFFIX = "-sources.jar";

    private ProjectUtils() {
    }

    public static boolean hasNature(IProject project, String natureId) {
        try {
            return project != null && project.hasNature(natureId);
        }
        catch (CoreException e) {
            return false;
        }
    }

    public static boolean isJavaProject(IProject project) {
        return ProjectUtils.hasNature(project, "org.eclipse.jdt.core.javanature");
    }

    public static boolean isMavenProject(IProject project) {
        return ProjectUtils.hasNature(project, "org.eclipse.m2e.core.maven2Nature");
    }

    public static boolean isGradleProject(IProject project) {
        return ProjectUtils.hasNature(project, "org.eclipse.buildship.core.gradleprojectnature");
    }

    public static boolean isGeneralJavaProject(IProject project) {
        return ProjectUtils.isJavaProject(project) && ProjectUtils.isInternalBuildSupport(BuildSupportManager.find(project).orElse(null));
    }

    public static boolean isInternalBuildSupport(IBuildSupport buildSupport) {
        return buildSupport != null && Arrays.stream(InternalBuildSupports.values()).anyMatch(bsn -> Objects.equals(buildSupport.buildToolName(), bsn.toString()));
    }

    public static String getJavaSourceLevel(IProject project) {
        Map<String, String> options = ProjectUtils.getJavaOptions(project);
        return options == null ? null : options.get("org.eclipse.jdt.core.compiler.source");
    }

    public static Map<String, String> getJavaOptions(IProject project) {
        if (!ProjectUtils.isJavaProject(project)) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return javaProject.getOptions(true);
    }

    public static List<IProject> getGradleProjects() {
        return Stream.of(ProjectUtils.getAllProjects()).filter(ProjectUtils::isGradleProject).collect(Collectors.toList());
    }

    public static IJavaProject[] getJavaProjects() {
        return (IJavaProject[])Stream.of(ProjectUtils.getAllProjects()).filter(ProjectUtils::isJavaProject).map(p -> JavaCore.create((IProject)p)).filter(p -> p != null).toArray(IJavaProject[]::new);
    }

    public static IProject[] getAllProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public static IProject[] getAllProjects(boolean includeInvisibleProjects) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (includeInvisibleProjects) {
            return projects;
        }
        return Stream.of(projects).filter(p -> ProjectUtils.isVisibleProject(p)).collect(Collectors.toList()).toArray(new IProject[0]);
    }

    public static IProject getProject(String projectName) {
        if (StringUtils.isBlank((CharSequence)projectName)) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static IJavaProject getJavaProject(String projectName) {
        IProject project = ProjectUtils.getProject(projectName);
        return ProjectUtils.getJavaProject(project);
    }

    public static IJavaProject getJavaProject(IProject project) {
        if (project != null && ProjectUtils.isJavaProject(project)) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static boolean addSourcePath(IPath sourcePath, IJavaProject project) throws CoreException {
        return ProjectUtils.addSourcePath(sourcePath, null, project);
    }

    public static boolean addSourcePath(IPath sourcePath, IPath[] exclusionPaths, IJavaProject project) throws CoreException {
        IClasspathEntry[] existingEntries = project.getRawClasspath();
        ArrayList<IPath> parentSrcPaths = new ArrayList<IPath>();
        ArrayList<IPath> exclusionPatterns = new ArrayList<IPath>();
        IClasspathEntry[] iClasspathEntryArray = existingEntries;
        int n = existingEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                if (entry.getPath().equals((Object)sourcePath)) {
                    return false;
                }
                if (entry.getPath().isPrefixOf(sourcePath)) {
                    parentSrcPaths.add(entry.getPath());
                } else if (sourcePath.isPrefixOf(entry.getPath())) {
                    exclusionPatterns.add(entry.getPath().makeRelativeTo(sourcePath).addTrailingSeparator());
                }
            }
            ++n2;
        }
        if (!parentSrcPaths.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", Messages.format("Cannot add the folder ''{0}'' to the source path because its parent folder is already in the source path of the project ''{1}''.", new String[]{sourcePath.toOSString(), project.getProject().getName()})));
        }
        if (exclusionPaths != null) {
            iClasspathEntryArray = exclusionPaths;
            n = exclusionPaths.length;
            n2 = 0;
            while (n2 < n) {
                IClasspathEntry exclusion = iClasspathEntryArray[n2];
                if (sourcePath.isPrefixOf((IPath)exclusion) && !sourcePath.equals((Object)exclusion)) {
                    exclusionPatterns.add(exclusion.makeRelativeTo(sourcePath).addTrailingSeparator());
                }
                ++n2;
            }
        }
        IClasspathEntry[] newEntries = new IClasspathEntry[existingEntries.length + 1];
        System.arraycopy(existingEntries, 0, newEntries, 0, existingEntries.length);
        newEntries[newEntries.length - 1] = JavaCore.newSourceEntry((IPath)sourcePath, (IPath[])exclusionPatterns.toArray(new IPath[0]));
        project.setRawClasspath(newEntries, project.getOutputLocation(), null);
        return true;
    }

    public static boolean removeSourcePath(IPath sourcePath, IJavaProject project) throws JavaModelException {
        IClasspathEntry[] existingEntries = project.getRawClasspath();
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
        boolean found = false;
        IClasspathEntry[] iClasspathEntryArray = existingEntries;
        int n = existingEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                if (entry.getPath().equals((Object)sourcePath)) {
                    found = true;
                } else {
                    newEntries.add(ProjectUtils.removeFilters(entry, sourcePath));
                }
            } else {
                newEntries.add(entry);
            }
            ++n2;
        }
        if (found) {
            project.setRawClasspath(newEntries.toArray(new IClasspathEntry[0]), project.getOutputLocation(), null);
            return true;
        }
        return false;
    }

    public static IPath[] listSourcePaths(IJavaProject project) throws JavaModelException {
        ArrayList<IPath> result = new ArrayList<IPath>();
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                result.add(entry.getPath());
            }
            ++n2;
        }
        return result.toArray(new IPath[0]);
    }

    public static IPath[] listReferencedLibraries(IJavaProject project) throws JavaModelException {
        LinkedList<IPath> libraries = new LinkedList<IPath>();
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry resolvedEntry;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 1 && (resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry)) != null) {
                libraries.add(resolvedEntry.getPath());
            }
            ++n2;
        }
        return (IPath[])libraries.toArray(IPath[]::new);
    }

    public static boolean isOnSourcePath(IPath sourcePath, IJavaProject project) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && entry.getPath().equals((Object)sourcePath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IPath findBelongedWorkspaceRoot(IPath filePath) {
        PreferenceManager manager = JavaLanguageServerPlugin.getPreferencesManager();
        Collection<IPath> rootPaths = manager.getPreferences().getRootPaths();
        if (rootPaths != null) {
            for (IPath rootPath : rootPaths) {
                if (!rootPath.isPrefixOf(filePath)) continue;
                return rootPath;
            }
        }
        return null;
    }

    public static String getWorkspaceInvisibleProjectName(IPath workspacePath) {
        String fileName = workspacePath.toFile().getName();
        String projectName = fileName + WORKSPACE_LINK + Integer.toHexString(workspacePath.toPortableString().hashCode());
        return projectName;
    }

    public static boolean isVisibleProject(IProject project) {
        PreferenceManager manager = JavaLanguageServerPlugin.getPreferencesManager();
        Collection<IPath> rootPaths = manager.getPreferences().getRootPaths();
        if (rootPaths == null) {
            return false;
        }
        return ResourceUtils.isContainedIn(project.getLocation(), rootPaths);
    }

    public static boolean isUnmanagedFolder(IProject project) {
        if (Objects.equals(project.getName(), "jdt.ls-java-project")) {
            return false;
        }
        if (ProjectUtils.isVisibleProject(project)) {
            return false;
        }
        return ProjectUtils.hasNature(project, "org.eclipse.jdt.ls.unmanagedFolderNature");
    }

    public static List<IProject> getVisibleProjects(IPath workspaceRoot) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.exists() && ProjectUtils.isVisibleProject(project) && workspaceRoot.isPrefixOf(project.getLocation())) {
                projects.add(project);
            }
            ++n2;
        }
        return projects;
    }

    public static IPath getProjectRealFolder(IProject project) {
        if (project.isAccessible() && ProjectUtils.isUnmanagedFolder(project)) {
            return project.getFolder(WORKSPACE_LINK).getLocation();
        }
        return project.getLocation();
    }

    public static IProject createInvisibleProjectIfNotExist(IPath workspaceRoot) throws OperationCanceledException, CoreException {
        String invisibleProjectName = ProjectUtils.getWorkspaceInvisibleProjectName(workspaceRoot);
        IProject invisibleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(invisibleProjectName);
        if (!invisibleProject.exists()) {
            ProjectsManager.createJavaProject(invisibleProject, null, null, "bin", null);
            IFolder workspaceLinkFolder = invisibleProject.getFolder(WORKSPACE_LINK);
            if (!workspaceLinkFolder.isLinked()) {
                try {
                    JDTUtils.createFolders(workspaceLinkFolder.getParent(), null);
                    workspaceLinkFolder.createLink(workspaceRoot.toFile().toURI(), 256, null);
                    File settings = new File(workspaceRoot.toFile(), SETTINGS);
                    if (settings.exists()) {
                        Hashtable defaultOptions = JavaCore.getDefaultOptions();
                        String defaultPreview = (String)defaultOptions.get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures");
                        String defaultReport = (String)defaultOptions.get("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures");
                        IJavaProject javaProject = JavaCore.create((IProject)invisibleProject);
                        javaProject.setOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", defaultPreview);
                        javaProject.setOption("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", defaultReport);
                        IFolder settingsLinkFolder = invisibleProject.getFolder(SETTINGS);
                        settingsLinkFolder.createLink(settings.toURI(), 256, null);
                        JVMConfigurator.configureJVMSettings(javaProject);
                    }
                }
                catch (CoreException e) {
                    invisibleProject.delete(true, null);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", Messages.format("Failed to create linked resource from ''{0}'' to the invisible project ''{1}''.", new String[]{workspaceRoot.toString(), invisibleProjectName}), (Throwable)e));
                }
            }
        }
        return invisibleProject;
    }

    public static boolean isSettingsFolderLinked(IProject project) {
        IFolder workspaceLinkFolder;
        if (project != null && (workspaceLinkFolder = project.getFolder(WORKSPACE_LINK)).isLinked()) {
            IFolder settings = project.getFolder(SETTINGS);
            return settings.exists() && settings.isLinked();
        }
        return false;
    }

    private static IClasspathEntry removeFilters(IClasspathEntry entry, IPath path) {
        IPath[] inclusionPatterns = entry.getInclusionPatterns();
        ArrayList<IPath> inclusionList = new ArrayList<IPath>();
        if (inclusionPatterns != null) {
            IPath[] iPathArray = inclusionPatterns;
            int n = inclusionPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                IPath pattern = iPathArray[n2];
                if (!path.equals((Object)entry.getPath().append(pattern))) {
                    inclusionList.add(pattern);
                }
                ++n2;
            }
        }
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        ArrayList<IPath> exclusionList = new ArrayList<IPath>();
        if (exclusionPatterns != null) {
            IPath[] iPathArray = exclusionPatterns;
            int n = exclusionPatterns.length;
            int n3 = 0;
            while (n3 < n) {
                IPath pattern = iPathArray[n3];
                if (!path.equals((Object)entry.getPath().append(pattern))) {
                    exclusionList.add(pattern);
                }
                ++n3;
            }
        }
        if (!(inclusionPatterns != null && inclusionPatterns.length != inclusionList.size() || exclusionPatterns != null && exclusionPatterns.length != exclusionList.size())) {
            return entry;
        }
        return JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])inclusionList.toArray(new IPath[0]), (IPath[])exclusionList.toArray(new IPath[0]), (IPath)entry.getOutputLocation(), (IClasspathAttribute[])entry.getExtraAttributes());
    }

    public static void updateBinaries(IJavaProject javaProject, Map<java.nio.file.Path, IPath> libraries, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        Object[] rawClasspath = javaProject.getRawClasspath();
        List newEntries = Arrays.stream(rawClasspath).filter(cpe -> cpe.getEntryKind() != 1).collect(Collectors.toCollection(ArrayList::new));
        List libEntries = Arrays.stream(rawClasspath).filter(cpe -> cpe.getEntryKind() == 1 && cpe.getSourceAttachmentPath() != null && cpe.getSourceAttachmentPath().toFile().exists()).collect(Collectors.toCollection(ArrayList::new));
        for (Map.Entry<java.nio.file.Path, IPath> library : libraries.entrySet()) {
            if (monitor.isCanceled()) {
                return;
            }
            Path binary = new Path(library.getKey().toString());
            IPath source = library.getValue();
            if (source == null && !libEntries.isEmpty()) {
                Optional<IClasspathEntry> result = libEntries.stream().filter(arg_0 -> ProjectUtils.lambda$12((IPath)binary, arg_0)).findAny();
                source = result.isPresent() ? result.get().getSourceAttachmentPath() : null;
            }
            IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)binary, (IPath)source, null);
            JavaLanguageServerPlugin.logInfo(">> Adding " + String.valueOf(binary) + " to the classpath");
            newEntries.add(newEntry);
        }
        Object[] newClasspath = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
        if (!Arrays.equals(rawClasspath, newClasspath)) {
            javaProject.setRawClasspath((IClasspathEntry[])newClasspath, monitor);
        } else {
            javaProject.getJavaModel().refreshExternalArchives(new IJavaElement[]{javaProject}, monitor);
        }
    }

    public static Set<java.nio.file.Path> collectBinaries(IPath projectDir, Set<String> include, Set<String> exclude, IProgressMonitor monitor) throws CoreException {
        LinkedHashSet<java.nio.file.Path> binaries = new LinkedHashSet<java.nio.file.Path>();
        Map<IPath, Set<String>> includeByPrefix = ProjectUtils.groupGlobsByPrefix(projectDir, include);
        Set excludeResolved = exclude.stream().map(glob -> ProjectUtils.resolveGlobPath(projectDir, glob)).collect(Collectors.toSet());
        for (IPath baseDir : includeByPrefix.keySet()) {
            java.nio.file.Path base = baseDir.toFile().toPath();
            if (monitor.isCanceled()) {
                return binaries;
            }
            if (Files.isRegularFile(base, new LinkOption[0])) {
                if (!ProjectUtils.isBinary(base)) continue;
                binaries.add(base);
                continue;
            }
            if (!Files.isDirectory(base, new LinkOption[0])) continue;
            Set<String> subInclude = includeByPrefix.get(baseDir);
            Set<String> subExclude = excludeResolved.stream().map(glob -> glob.makeRelativeTo(baseDir).toOSString()).collect(Collectors.toSet());
            DirectoryScanner scanner = new DirectoryScanner();
            try {
                scanner.setIncludes(subInclude.toArray(new String[subInclude.size()]));
                scanner.setExcludes(subExclude.toArray(new String[subExclude.size()]));
                scanner.addDefaultExcludes();
                scanner.setBasedir(base.toFile());
                scanner.scan();
            }
            catch (IllegalStateException e) {
                throw new CoreException(StatusFactory.newErrorStatus("Unable to collect binaries", e));
            }
            String[] stringArray = scanner.getIncludedFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String result = stringArray[n2];
                java.nio.file.Path file = base.resolve(result);
                if (ProjectUtils.isBinary(file)) {
                    binaries.add(file);
                }
                ++n2;
            }
        }
        return binaries;
    }

    public static IPath detectSources(java.nio.file.Path file) {
        String filename = file.getFileName().toString();
        String sourceName = filename.substring(0, filename.lastIndexOf(JAR_SUFFIX)) + SOURCE_JAR_SUFFIX;
        java.nio.file.Path sourcePath = file.getParent().resolve(sourceName);
        return Files.isRegularFile(sourcePath, new LinkOption[0]) ? new Path(sourcePath.toString()) : null;
    }

    private static boolean isBinary(java.nio.file.Path file) {
        String fileName = file.getFileName().toString();
        return fileName.endsWith(JAR_SUFFIX) && !fileName.endsWith(SOURCE_JAR_SUFFIX);
    }

    public static IPath resolveGlobPath(IPath base, String glob) {
        Path pattern = new Path(glob);
        if (!pattern.isAbsolute()) {
            pattern = base.append((IPath)pattern);
        }
        if (pattern.getDevice() != null) {
            pattern = pattern.setDevice(pattern.getDevice().toLowerCase());
        }
        return pattern;
    }

    private static Map<IPath, Set<String>> groupGlobsByPrefix(IPath base, Set<String> globs) {
        HashMap<IPath, Set<String>> groupedPatterns = new HashMap<IPath, Set<String>>();
        for (String glob : globs) {
            IPath pattern = ProjectUtils.resolveGlobPath(base, glob);
            int prefixLength = 0;
            while (prefixLength < pattern.segmentCount()) {
                String segment = pattern.segment(prefixLength);
                if (segment.contains("*") || segment.contains("?")) break;
                ++prefixLength;
            }
            IPath prefix = pattern.uptoSegment(prefixLength);
            IPath remain = pattern.removeFirstSegments(prefixLength).setDevice(null);
            if (!groupedPatterns.containsKey(prefix)) {
                groupedPatterns.put(prefix, new LinkedHashSet());
            }
            ((Set)groupedPatterns.get(prefix)).add(remain.toOSString());
        }
        return groupedPatterns;
    }

    public static void removeJavaNatureAndBuilder(IProject project, IProgressMonitor monitor) throws CoreException {
        if (project != null && project.isAccessible() && ProjectUtils.isJavaProject(project)) {
            IProjectDescription description = project.getDescription();
            String[] natureIds = description.getNatureIds();
            String[] newIds = new String[natureIds.length - 1];
            int count = 0;
            String[] stringArray = natureIds;
            int n = natureIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (!"org.eclipse.jdt.core.javanature".equals(id)) {
                    newIds[count++] = id;
                }
                ++n2;
            }
            description.setNatureIds(newIds);
            ICommand[] commands = description.getBuildSpec();
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) {
                    ICommand[] newCommands = new ICommand[commands.length - 1];
                    System.arraycopy(commands, 0, newCommands, 0, i);
                    System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                    description.setBuildSpec(newCommands);
                    break;
                }
                ++i;
            }
            project.setDescription(description, 1, monitor);
        }
    }

    public static int getMaxProjectProblemSeverity() {
        int maxSeverity = 0;
        IProject[] iProjectArray = ProjectUtils.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!"jdt.ls-java-project".equals(project.getName())) {
                try {
                    maxSeverity = Math.max(maxSeverity, project.findMaxProblemSeverity(null, true, 0));
                    List<IMarker> markers = ResourceUtils.findMarkers((IResource)project, 2, 1);
                    List buildFileMarkers = markers.stream().filter(marker -> ProjectUtils.isBuildFileMarker(marker, project)).collect(Collectors.toList());
                    for (IMarker marker2 : buildFileMarkers) {
                        if ((maxSeverity = Math.max(maxSeverity, marker2.getAttribute("severity", 0))) != 2) {
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (maxSeverity == 2) break;
            }
            ++n2;
        }
        return maxSeverity;
    }

    private static boolean isBuildFileMarker(IMarker marker, IProject project) {
        IResource resource = marker.getResource();
        if (!resource.exists()) {
            return false;
        }
        String lastSegment = resource.getFullPath().lastSegment();
        if (ProjectUtils.isMavenProject(project)) {
            return lastSegment.equals("pom.xml");
        }
        if (ProjectUtils.isGradleProject(project)) {
            return lastSegment.equals("build.gradle") || lastSegment.equals("build.gradle.kts") || lastSegment.equals("settings.gradle") || lastSegment.equals("settings.gradle.kts");
        }
        return false;
    }

    public static Collection<IProject> getProjectsFromDocumentIdentifiers(List<TextDocumentIdentifier> identifiers) {
        HashSet<IProject> projects = new HashSet<IProject>();
        for (TextDocumentIdentifier identifier : identifiers) {
            IProject project = ProjectUtils.getProjectFromUri(identifier.getUri());
            if (project != null) {
                projects.add(project);
                continue;
            }
            IFile file = JDTUtils.findFile(identifier.getUri());
            if (file == null || (project = file.getProject()) == null) continue;
            projects.add(project);
        }
        return projects;
    }

    public static IProject getProjectFromUri(String uri) {
        IProject[] projects;
        IPath uriPath = ResourceUtils.canonicalFilePathFromURI(uri);
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getLocation().equals((Object)uriPath)) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    public static void refreshDiagnostics(IProgressMonitor monitor) throws JavaModelException {
        if (JavaLanguageServerPlugin.getInstance().getProtocol() != null && JavaLanguageServerPlugin.getInstance().getProtocol().getClientConnection() != null) {
            ICompilationUnit[] iCompilationUnitArray = JavaCore.getWorkingCopies(null);
            int n = iCompilationUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit unit = iCompilationUnitArray[n2];
                IPath path = unit.getPath();
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                if (file.exists()) {
                    String contents = null;
                    try {
                        if (unit.hasUnsavedChanges()) {
                            contents = unit.getSource();
                        }
                    }
                    catch (Exception e) {
                        JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    }
                    unit.discardWorkingCopy();
                    if (unit.equals(CoreASTProvider.getInstance().getActiveJavaElement())) {
                        CoreASTProvider.getInstance().disposeAST();
                    }
                    unit = JavaCore.createCompilationUnitFrom((IFile)file);
                    unit.becomeWorkingCopy(monitor);
                    if (contents != null) {
                        unit.getBuffer().setContents(contents);
                    }
                }
                DiagnosticsHandler diagnosticHandler = new DiagnosticsHandler(JavaLanguageServerPlugin.getInstance().getProtocol().getClientConnection(), unit);
                diagnosticHandler.clearDiagnostics();
                DiagnosticsCommand.refreshDiagnostics(JDTUtils.toURI(unit), "thisFile", JDTUtils.isDefaultProject(unit) || !JDTUtils.isOnClassPath(unit));
                ++n2;
            }
        }
    }

    private static /* synthetic */ boolean lambda$12(IPath iPath, IClasspathEntry cpe) {
        return cpe.getPath().equals((Object)iPath);
    }
}

