/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateFileChange;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class NewCUProposal
extends ChangeCorrectionProposalCore {
    public static final int K_CLASS = 1;
    public static final int K_INTERFACE = 2;
    public static final int K_ENUM = 3;
    public static final int K_ANNOTATION = 4;
    private Name fNode;
    private ICompilationUnit fCompilationUnit;
    private int fTypeKind;
    private IJavaElement fTypeContainer;
    private String fTypeNameWithParameters;

    public NewCUProposal(ICompilationUnit cu, Name node, int typeKind, IJavaElement typeContainer, int relevance) {
        super("", null, relevance);
        this.fCompilationUnit = cu;
        this.fNode = node;
        this.fTypeKind = typeKind;
        this.fTypeContainer = typeContainer;
        if (this.fNode != null) {
            this.fTypeNameWithParameters = NewCUProposal.getTypeName(typeKind, node);
        }
        this.setDisplayName();
    }

    /*
     * WARNING - void declaration
     */
    private void setDisplayName() {
        String containerName;
        if (this.fNode != null) {
            containerName = ASTNodes.getQualifier((Name)this.fNode);
        } else {
            IJavaElement iJavaElement = this.fTypeContainer;
            if (iJavaElement instanceof IPackageFragment) {
                void pack;
                IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                IPackageFragment cfr_ignored_0 = (IPackageFragment)iJavaElement;
                containerName = pack.getElementName();
            } else {
                containerName = "";
            }
        }
        String typeName = this.fTypeNameWithParameters;
        String containerLabel = BasicElementLabels.getJavaElementName((String)containerName);
        String typeLabel = BasicElementLabels.getJavaElementName((String)typeName);
        boolean isInnerType = this.fTypeContainer instanceof IType;
        switch (this.fTypeKind) {
            case 1: {
                if (this.fNode != null) {
                    if (isInnerType) {
                        if (containerName.length() == 0) {
                            this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerclass_description, (Object)typeLabel));
                            break;
                        }
                        this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerclass_intype_description, (Object[])new String[]{typeLabel, containerLabel}));
                        break;
                    }
                    if (containerName.length() == 0) {
                        this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createclass_description, (Object)typeLabel));
                        break;
                    }
                    this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createclass_inpackage_description, (Object[])new String[]{typeLabel, containerLabel}));
                    break;
                }
                this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createnewclass_inpackage_description, (Object)containerLabel));
                break;
            }
            case 2: {
                if (this.fNode != null) {
                    if (isInnerType) {
                        if (containerName.length() == 0) {
                            this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerinterface_description, (Object)typeLabel));
                            break;
                        }
                        this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerinterface_intype_description, (Object[])new String[]{typeLabel, containerLabel}));
                        break;
                    }
                    if (containerName.length() == 0) {
                        this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createinterface_description, (Object)typeLabel));
                        break;
                    }
                    this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createinterface_inpackage_description, (Object[])new String[]{typeLabel, containerLabel}));
                    break;
                }
                this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createnewinterface_inpackage_description, (Object)containerLabel));
                break;
            }
            case 3: {
                if (this.fNode != null) {
                    if (isInnerType) {
                        if (containerName.length() == 0) {
                            this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerenum_description, (Object)typeLabel));
                            break;
                        }
                        this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerenum_intype_description, (Object[])new String[]{typeLabel, containerLabel}));
                        break;
                    }
                    if (containerName.length() == 0) {
                        this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createenum_description, (Object)typeLabel));
                        break;
                    }
                    this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createenum_inpackage_description, (Object[])new String[]{typeLabel, containerLabel}));
                    break;
                }
                this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createnewenum_inpackage_description, (Object)containerLabel));
                break;
            }
            case 4: {
                if (this.fNode != null) {
                    if (isInnerType) {
                        if (containerName.length() == 0) {
                            this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerannotation_description, (Object)typeLabel));
                            break;
                        }
                        this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerannotation_intype_description, (Object[])new String[]{typeLabel, containerLabel}));
                        break;
                    }
                    if (containerName.length() == 0) {
                        this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createannotation_description, (Object)typeLabel));
                        break;
                    }
                    this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createannotation_inpackage_description, (Object[])new String[]{typeLabel, containerLabel}));
                    break;
                }
                this.setDisplayName(Messages.format((String)CorrectionMessages.NewCUCompletionUsingWizardProposal_createnewannotation_inpackage_description, (Object)containerLabel));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type kind");
            }
        }
    }

    private static boolean isParameterizedType(int typeKind, Name node) {
        if (typeKind == 1 || typeKind == 2) {
            return node.getParent().getLocationInParent() == ParameterizedType.TYPE_PROPERTY;
        }
        return false;
    }

    private static String getTypeName(int typeKind, Name node) {
        String name = ASTNodes.getSimpleNameIdentifier((Name)node);
        if (NewCUProposal.isParameterizedType(typeKind, node)) {
            ASTNode parent = node.getParent();
            String typeArgBaseName = NewCUProposal.getGenericTypeArgBaseName(name);
            int nTypeArgs = ((ParameterizedType)parent.getParent()).typeArguments().size();
            StringBuilder buf = new StringBuilder(name);
            buf.append('<');
            if (nTypeArgs == 1) {
                buf.append(typeArgBaseName);
            } else {
                int i = 0;
                while (i < nTypeArgs) {
                    if (i != 0) {
                        buf.append(", ");
                    }
                    buf.append(typeArgBaseName).append(i + 1);
                    ++i;
                }
            }
            buf.append('>');
            return buf.toString();
        }
        return name;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private TypeDeclaration findEnclosingTypeDeclaration(ASTNode node, String typeName) {
        Iterator iter;
        ASTNode aSTNode = node;
        if (aSTNode instanceof CompilationUnit) {
            void unit;
            CompilationUnit compilationUnit = (CompilationUnit)aSTNode;
            CompilationUnit cfr_ignored_0 = (CompilationUnit)aSTNode;
            iter = unit.types().iterator();
        } else {
            void typeDecl;
            ASTNode aSTNode2 = node;
            if (!(aSTNode2 instanceof TypeDeclaration)) {
                return null;
            }
            TypeDeclaration typeDeclaration = (TypeDeclaration)aSTNode2;
            TypeDeclaration cfr_ignored_1 = (TypeDeclaration)aSTNode2;
            if (Objects.equals(typeName, typeDecl.getName().toString())) {
                return typeDecl;
            }
            iter = typeDecl.bodyDeclarations().iterator();
        }
        while (iter.hasNext()) {
            TypeDeclaration decl = this.findEnclosingTypeDeclaration((ASTNode)iter.next(), typeName);
            if (decl == null) continue;
            return decl;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected Change createChange() throws CoreException {
        IJavaElement iJavaElement = this.fTypeContainer;
        if (iJavaElement instanceof IType) {
            void enclosingType;
            IType iType = (IType)iJavaElement;
            IType cfr_ignored_0 = (IType)iJavaElement;
            ICompilationUnit parentCU = enclosingType.getCompilationUnit();
            CompilationUnitChange cuChange = new CompilationUnitChange(this.fName, parentCU);
            TextEdit edit = this.constructEnclosingTypeEdit(parentCU);
            cuChange.setEdit(edit);
            return cuChange;
        }
        IJavaElement iJavaElement2 = this.fTypeContainer;
        if (iJavaElement2 instanceof IPackageFragment) {
            void pack;
            IPackageFragment parentCU = (IPackageFragment)iJavaElement2;
            IPackageFragment cfr_ignored_1 = (IPackageFragment)iJavaElement2;
            if (pack.getKind() == 1) {
                String name = ASTNodes.getSimpleNameIdentifier((Name)this.fNode);
                ICompilationUnit parentCU2 = pack.getCompilationUnit(NewCUProposal.getCompilationUnitName(name));
                IType targetType = parentCU2.getType(name);
                CompositeChange change = new CompositeChange(this.fName);
                change.add((Change)new CreateFileChange(targetType.getResource().getRawLocation(), "", ""));
                change.add((Change)this.constructNewCUChange(parentCU2));
                return change;
            }
        }
        return null;
    }

    private TextEdit constructEnclosingTypeEdit(ICompilationUnit icu) throws CoreException {
        TypeDeclaration newDeclaration;
        ASTParser astParser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        astParser.setSource(icu);
        CompilationUnit cu = (CompilationUnit)astParser.createAST(null);
        TypeDeclaration enclosingDecl = this.findEnclosingTypeDeclaration((ASTNode)cu, this.fTypeContainer.getElementName());
        AST ast = cu.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        switch (this.fTypeKind) {
            case 1: {
                newDeclaration = ast.newTypeDeclaration();
                newDeclaration.setInterface(false);
                break;
            }
            case 2: {
                newDeclaration = ast.newTypeDeclaration();
                newDeclaration.setInterface(true);
                break;
            }
            case 3: {
                newDeclaration = ast.newEnumDeclaration();
                break;
            }
            case 4: {
                newDeclaration = ast.newAnnotationTypeDeclaration();
                break;
            }
            default: {
                return null;
            }
        }
        newDeclaration.setJavadoc(null);
        newDeclaration.setName(ast.newSimpleName(ASTNodes.getSimpleNameIdentifier((Name)this.fNode)));
        newDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        if (NewCUProposal.isParameterizedType(this.fTypeKind, this.fNode)) {
            this.addTypeParameters(newDeclaration);
        }
        ListRewrite lrw = rewrite.getListRewrite((ASTNode)enclosingDecl, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
        lrw.insertLast((ASTNode)newDeclaration, null);
        return rewrite.rewriteAST();
    }

    private void addTypeParameters(TypeDeclaration newDeclaration) {
        if (NewCUProposal.isParameterizedType(this.fTypeKind, this.fNode)) {
            String typeArgBaseName = NewCUProposal.getGenericTypeArgBaseName(ASTNodes.getSimpleNameIdentifier((Name)this.fNode));
            int nTypeArgs = ((ParameterizedType)this.fNode.getParent().getParent()).typeArguments().size();
            String[] typeArgNames = new String[nTypeArgs];
            if (nTypeArgs == 1) {
                typeArgNames[0] = typeArgBaseName;
            } else {
                int i = 0;
                while (i < nTypeArgs) {
                    StringBuilder buf = new StringBuilder(typeArgBaseName);
                    buf.append(i + 1);
                    typeArgNames[i] = buf.toString();
                    ++i;
                }
            }
            AST ast = newDeclaration.getAST();
            String[] stringArray = typeArgNames;
            int n = typeArgNames.length;
            int n2 = 0;
            while (n2 < n) {
                String typeArgName = stringArray[n2];
                TypeParameter typeArg = ast.newTypeParameter();
                typeArg.setName(ast.newSimpleName(typeArgName));
                newDeclaration.typeParameters().add(typeArg);
                ++n2;
            }
        }
    }

    private static String getGenericTypeArgBaseName(String typeName) {
        return typeName.startsWith(String.valueOf('T')) ? String.valueOf('S') : String.valueOf('T');
    }

    private CompilationUnitChange constructNewCUChange(ICompilationUnit cu) throws CoreException {
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)this.fCompilationUnit.getJavaProject());
        String typeStub = this.constructTypeStub(cu, this.fTypeNameWithParameters, 1, lineDelimiter);
        String cuContent = this.constructCUContent(cu, typeStub, lineDelimiter);
        CompilationUnitChange cuChange = new CompilationUnitChange("", cu);
        cuChange.setEdit((TextEdit)new InsertEdit(0, cuContent));
        return cuChange;
    }

    private String constructCUContent(ICompilationUnit cu, String typeContent, String lineDelimiter) throws CoreException {
        Object fileComment = CodeGeneration.getFileComment((ICompilationUnit)cu, (String)lineDelimiter);
        if (fileComment != null && !((String)fileComment).isEmpty()) {
            fileComment = (String)fileComment + lineDelimiter;
        }
        String typeComment = CodeGeneration.getTypeComment((ICompilationUnit)cu, (String)cu.getElementName(), (String)lineDelimiter);
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String content = CodeGeneration.getCompilationUnitContent((ICompilationUnit)cu, (String)fileComment, (String)typeComment, (String)typeContent, (String)lineDelimiter);
        if (content != null) {
            ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
            parser.setProject(cu.getJavaProject());
            parser.setSource(content.toCharArray());
            CompilationUnit unit = (CompilationUnit)parser.createAST(null);
            if ((pack.isDefaultPackage() || unit.getPackage() != null) && !unit.types().isEmpty()) {
                return content;
            }
        }
        StringBuilder buf = new StringBuilder();
        if (!pack.isDefaultPackage()) {
            buf.append("package ").append(pack.getElementName()).append(';');
        }
        buf.append(lineDelimiter).append(lineDelimiter);
        buf.append(typeContent);
        return buf.toString();
    }

    private String constructTypeStub(ICompilationUnit parentCU, String name, int modifiers, String lineDelimiter) throws CoreException {
        IType cuType;
        String[] permittedNames;
        boolean isPermitted;
        StringBuilder buf = new StringBuilder();
        buf.append(Flags.toString((int)modifiers));
        if (modifiers != 0) {
            buf.append(' ');
        }
        if (isPermitted = Arrays.asList(permittedNames = (cuType = this.fCompilationUnit.findPrimaryType()).getPermittedSubtypeNames()).stream().anyMatch(p -> name.equals(p))) {
            buf.append("final ");
        }
        String type = "";
        String templateID = "";
        String superType = "";
        switch (this.fTypeKind) {
            case 1: {
                type = "class ";
                templateID = "org.eclipse.jdt.ui.text.codetemplates.classbody";
                superType = cuType.isInterface() ? "implements " : "extends ";
                break;
            }
            case 2: {
                type = "interface ";
                templateID = "org.eclipse.jdt.ui.text.codetemplates.interfacebody";
                superType = "extends ";
                break;
            }
            case 3: {
                type = "enum ";
                templateID = "org.eclipse.jdt.ui.text.codetemplates.enumbody";
                break;
            }
            case 4: {
                type = "@interface ";
                templateID = "org.eclipse.jdt.ui.text.codetemplates.annotationbody";
            }
        }
        buf.append(type);
        buf.append(name);
        if (isPermitted) {
            buf.append(' ');
            buf.append(superType);
            buf.append(cuType.getElementName());
        }
        buf.append(" {").append(lineDelimiter);
        String typeBody = CodeGeneration.getTypeBody((String)templateID, (ICompilationUnit)parentCU, (String)name, (String)lineDelimiter);
        if (typeBody != null) {
            buf.append(typeBody);
        } else {
            buf.append(lineDelimiter);
        }
        buf.append('}').append(lineDelimiter);
        return buf.toString();
    }

    private static String getSimpleName(Name name) {
        if (name.isQualifiedName()) {
            return ((QualifiedName)name).getName().getIdentifier();
        }
        return ((SimpleName)name).getIdentifier();
    }

    private static String getCompilationUnitName(String typeName) {
        return typeName + ".java";
    }
}

