/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.ls.core.internal.ExtensionsExtractor;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;

public class BuildSupportManager {
    private static final BuildSupportManager instance = new BuildSupportManager();
    private List<IBuildSupport> lazyLoadedBuildSupportList;

    private BuildSupportManager() {
    }

    public static List<IBuildSupport> obtainBuildSupports() {
        if (BuildSupportManager.instance.lazyLoadedBuildSupportList == null) {
            BuildSupportManager.instance.lazyLoadedBuildSupportList = ExtensionsExtractor.extractOrderedExtensions("org.eclipse.jdt.ls.core", "buildSupport");
        }
        return BuildSupportManager.instance.lazyLoadedBuildSupportList;
    }

    public static Optional<IBuildSupport> find(IProject project) {
        return instance.find(bs -> bs.applies(project));
    }

    public static Optional<IBuildSupport> find(String buildToolName) {
        return instance.find(bs -> bs.buildToolName().equalsIgnoreCase(buildToolName));
    }

    private Optional<IBuildSupport> find(Predicate<? super IBuildSupport> predicate) {
        return BuildSupportManager.obtainBuildSupports().stream().filter(predicate).findFirst();
    }
}

