/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.codemanipulation.GenerateGetterSetterOperation;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.jdt.ls.core.internal.handlers.CodeGenerationUtils;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.text.edits.TextEdit;

public class GenerateAccessorsHandler {
    public static GenerateGetterSetterOperation.AccessorField[] getUnimplementedAccessors(AccessorCodeActionParams params) {
        IType type = SourceAssistProcessor.getSelectionType(params);
        return GenerateAccessorsHandler.getUnimplementedAccessors(type, params.kind);
    }

    public static GenerateGetterSetterOperation.AccessorField[] getUnimplementedAccessors(IType type, GenerateGetterSetterOperation.AccessorKind kind) {
        try {
            return GenerateGetterSetterOperation.getUnimplementedAccessors(type, kind);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Failed to resolve the unimplemented accessors.", e);
            return new GenerateGetterSetterOperation.AccessorField[0];
        }
    }

    public static WorkspaceEdit generateAccessors(GenerateAccessorsParams params, IProgressMonitor monitor) {
        IType type = SourceAssistProcessor.getSelectionType(params.context);
        if (type == null || type.getCompilationUnit() == null) {
            return null;
        }
        Preferences preferences = JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
        TextEdit edit = GenerateAccessorsHandler.generateAccessors(type, params.accessors, preferences.isCodeGenerationTemplateGenerateComments(), params.context.getRange(), monitor);
        return edit == null ? null : SourceAssistProcessor.convertToWorkspaceEdit(type.getCompilationUnit(), edit);
    }

    public static TextEdit generateAccessors(IType type, GenerateGetterSetterOperation.AccessorField[] accessors, boolean generateComments, Range cursor, IProgressMonitor monitor) {
        if (type == null || type.getCompilationUnit() == null) {
            return null;
        }
        try {
            ASTNode declarationNode = null;
            CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)type.getCompilationUnit(), CoreASTProvider.WAIT_YES, monitor);
            if (astRoot != null && cursor != null) {
                ASTNode node = NodeFinder.perform((ASTNode)astRoot, (int)DiagnosticsHelper.getStartOffset(type.getCompilationUnit(), cursor), (int)DiagnosticsHelper.getLength(type.getCompilationUnit(), cursor));
                declarationNode = SourceAssistProcessor.getTypeDeclarationNode(node);
            }
            IJavaElement insertPosition = declarationNode != null ? CodeGenerationUtils.findInsertElement(type, null) : CodeGenerationUtils.findInsertElement(type, cursor);
            GenerateGetterSetterOperation operation = new GenerateGetterSetterOperation(type, null, generateComments, insertPosition);
            return operation.createTextEdit(null, accessors);
        }
        catch (CoreException | OperationCanceledException e) {
            JavaLanguageServerPlugin.logException("Failed to generate the accessors.", e);
            return null;
        }
    }

    public static TextEdit generateAccessors(IType type, GenerateGetterSetterOperation.AccessorField[] accessors, boolean generateComments, Range cursor) {
        return GenerateAccessorsHandler.generateAccessors(type, accessors, generateComments, cursor, (IProgressMonitor)new NullProgressMonitor());
    }

    public static class AccessorCodeActionParams
    extends CodeActionParams {
        GenerateGetterSetterOperation.AccessorKind kind;

        public AccessorCodeActionParams(TextDocumentIdentifier textDocument, Range range, CodeActionContext context, GenerateGetterSetterOperation.AccessorKind kind) {
            super(textDocument, range, context);
            this.kind = kind;
        }
    }

    public static class GenerateAccessorsParams {
        CodeActionParams context;
        GenerateGetterSetterOperation.AccessorField[] accessors;
    }
}

