/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Collections;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.BaseDocumentLifeCycleHandler;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;

public class WorkspaceEventsHandler {
    private final ProjectsManager pm;
    private final JavaClientConnection connection;
    private final BaseDocumentLifeCycleHandler handler;
    private final LinkedBlockingQueue<FileEvent> queue = new LinkedBlockingQueue();

    public WorkspaceEventsHandler(ProjectsManager projects, JavaClientConnection connection, BaseDocumentLifeCycleHandler handler) {
        this.pm = projects;
        this.connection = connection;
        this.handler = handler;
        Thread eventThread = new Thread(() -> {
            try {
                while (true) {
                    if (!this.pm.isBuildFinished()) {
                        Thread.sleep(200L);
                        continue;
                    }
                    FileEvent event = this.queue.take();
                    this.handleFileEvent(event);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }, "WorkspaceEventsHandler");
        eventThread.start();
    }

    private ProjectsManager.CHANGE_TYPE toChangeType(FileChangeType vtype) {
        switch (vtype) {
            case Created: {
                return ProjectsManager.CHANGE_TYPE.CREATED;
            }
            case Changed: {
                return ProjectsManager.CHANGE_TYPE.CHANGED;
            }
            case Deleted: {
                return ProjectsManager.CHANGE_TYPE.DELETED;
            }
        }
        throw new UnsupportedOperationException();
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams param) {
        param.getChanges().stream().distinct().forEach(event -> {
            try {
                this.queue.put((FileEvent)event);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public void handleFileEvents(FileEvent ... fileEvents) {
        FileEvent[] fileEventArray = fileEvents;
        int n = fileEvents.length;
        int n2 = 0;
        while (n2 < n) {
            FileEvent fileEvent = fileEventArray[n2];
            this.handleFileEvent(fileEvent);
            ++n2;
        }
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    private void handleFileEvent(FileEvent fileEvent) {
        ICompilationUnit unit;
        ProjectsManager.CHANGE_TYPE changeType = this.toChangeType(fileEvent.getType());
        if (changeType == ProjectsManager.CHANGE_TYPE.DELETED) {
            this.cleanUpDiagnostics(fileEvent.getUri());
            this.handler.didClose(new DidCloseTextDocumentParams(new TextDocumentIdentifier(fileEvent.getUri())));
            this.discardWorkingCopies(fileEvent.getUri());
        }
        if ((unit = JDTUtils.resolveCompilationUnit(fileEvent.getUri())) != null && changeType == ProjectsManager.CHANGE_TYPE.CREATED && !unit.exists()) {
            final ICompilationUnit[] units = new ICompilationUnit[]{unit};
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        units[0] = WorkspaceEventsHandler.this.createCompilationUnit(units[0]);
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            unit = units[0];
        }
        if (unit != null) {
            if (unit.isWorkingCopy()) {
                try {
                    IResource resource = unit.getUnderlyingResource();
                    if (resource != null && resource.exists()) {
                        resource.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
                return;
            }
            if ((changeType == ProjectsManager.CHANGE_TYPE.DELETED || changeType == ProjectsManager.CHANGE_TYPE.CHANGED) && unit.equals(CoreASTProvider.getInstance().getActiveJavaElement())) {
                CoreASTProvider.getInstance().disposeAST();
            }
        }
        this.pm.fileChanged(fileEvent.getUri(), changeType);
    }

    private ICompilationUnit createCompilationUnit(ICompilationUnit unit) {
        try {
            IJavaElement parent;
            unit.getResource().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            if (unit.getResource().exists() && (parent = unit.getParent()) instanceof PackageFragment) {
                PackageFragment pkg = (PackageFragment)parent;
                if (JavaModelManager.determineIfOnClasspath((IResource)unit.getResource(), (IJavaProject)unit.getJavaProject()) != null) {
                    OpenableElementInfo elementInfo = (OpenableElementInfo)pkg.getElementInfo();
                    elementInfo.addChild((IJavaElement)unit);
                }
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        return unit;
    }

    private void cleanUpDiagnostics(String uri) {
        this.connection.publishDiagnostics(new PublishDiagnosticsParams(ResourceUtils.toClientUri(uri), Collections.emptyList()));
    }

    private void discardWorkingCopies(String parentUri) {
        IPath parentPath = ResourceUtils.filePathFromURI(parentUri);
        if (parentPath != null && !parentPath.lastSegment().endsWith(".java")) {
            ICompilationUnit[] workingCopies;
            ICompilationUnit[] iCompilationUnitArray = workingCopies = JavaCore.getWorkingCopies(null);
            int n = workingCopies.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit workingCopy = iCompilationUnitArray[n2];
                IResource resource = workingCopy.getResource();
                if (resource != null) {
                    IPath cuPath;
                    IPath iPath = cuPath = resource.getRawLocation() != null ? resource.getRawLocation() : resource.getLocation();
                    if (cuPath != null && parentPath.isPrefixOf(cuPath)) {
                        try {
                            workingCopy.discardWorkingCopy();
                        }
                        catch (JavaModelException javaModelException) {
                            // empty catch block
                        }
                    }
                }
                ++n2;
            }
        }
    }
}

