/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.resources.CharsetDeltaJob;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.ValidateProjectEncoding;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CharsetManager
implements IManager {
    private static final String PROJECT_KEY = "<project>";
    private CharsetDeltaJob charsetListener;
    CharsetManagerJob job;
    private IResourceChangeListener resourceChangeListener;
    private IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener;
    protected final Bundle systemBundle = Platform.getBundle((String)"org.eclipse.osgi");
    Workspace workspace;

    public CharsetManager(Workspace workspace) {
        this.workspace = workspace;
    }

    void flushPreferences(Preferences projectPrefs, boolean shouldDisableCharsetDeltaJob) throws BackingStoreException {
        if (projectPrefs != null) {
            try {
                if (shouldDisableCharsetDeltaJob) {
                    this.charsetListener.setDisabled(true);
                }
                projectPrefs.flush();
            }
            finally {
                if (shouldDisableCharsetDeltaJob) {
                    this.charsetListener.setDisabled(false);
                }
            }
        }
    }

    public String getCharsetFor(IPath resourcePath, boolean recurse) {
        Assert.isLegal((resourcePath.segmentCount() >= 1 ? 1 : 0) != 0);
        IProject project = this.workspace.getRoot().getProject(resourcePath.segment(0));
        Preferences prefs = this.getPreferences(project, false, false);
        Preferences derivedPrefs = this.getPreferences(project, false, true);
        if (prefs == null && derivedPrefs == null) {
            return recurse ? ResourcesPlugin.getEncoding() : null;
        }
        return this.internalGetCharsetFor(prefs, derivedPrefs, resourcePath, recurse);
    }

    static String getKeyFor(IPath resourcePath) {
        return resourcePath.segmentCount() > 1 ? resourcePath.removeFirstSegments(1).toString() : PROJECT_KEY;
    }

    Preferences getPreferences(IProject project, boolean create, boolean isDerived) {
        return this.getPreferences(project, create, isDerived, this.isDerivedEncodingStoredSeparately(project));
    }

    Preferences getPreferences(IProject project, boolean create, boolean isDerived, boolean isDerivedEncodingStoredSeparately) {
        Preferences node;
        block8: {
            String qualifier;
            block7: {
                block6: {
                    boolean localIsDerived = isDerivedEncodingStoredSeparately ? isDerived : false;
                    String string = qualifier = localIsDerived ? "org.eclipse.core.resources.derived" : "org.eclipse.core.resources";
                    if (create) {
                        return new ProjectScope(project).getNode(qualifier).node("encoding");
                    }
                    node = Platform.getPreferencesService().getRootNode().node("project");
                    try {
                        if (node.nodeExists(project.getName())) break block6;
                        return null;
                    }
                    catch (BackingStoreException e) {
                        String message = Messages.resources_readingEncoding;
                        Policy.log(new ResourceStatus(383, project.getFullPath(), message, e));
                        return null;
                    }
                }
                node = node.node(project.getName());
                if (node.nodeExists(qualifier)) break block7;
                return null;
            }
            node = node.node(qualifier);
            if (node.nodeExists("encoding")) break block8;
            return null;
        }
        return node.node("encoding");
    }

    /*
     * Unable to fully structure code
     */
    private String internalGetCharsetFor(Preferences prefs, Preferences derivedPrefs, IPath resourcePath, boolean recurse) {
        charset = null;
        if (prefs != null) {
            charset = prefs.get(CharsetManager.getKeyFor(resourcePath), null);
        }
        if (charset == null && derivedPrefs != null) {
            charset = derivedPrefs.get(CharsetManager.getKeyFor(resourcePath), null);
        }
        if (recurse) ** GOTO lbl13
        return charset;
lbl-1000:
        // 1 sources

        {
            resourcePath = resourcePath.removeLastSegments(1);
            if (prefs != null) {
                charset = prefs.get(CharsetManager.getKeyFor(resourcePath), null);
            }
            if (charset != null || derivedPrefs == null) continue;
            charset = derivedPrefs.get(CharsetManager.getKeyFor(resourcePath), null);
lbl13:
            // 3 sources

            ** while (charset == null && resourcePath.segmentCount() > 1)
        }
lbl14:
        // 1 sources

        return charset == null ? ResourcesPlugin.getEncoding() : charset;
    }

    private boolean isDerivedEncodingStoredSeparately(IProject project) {
        Preferences node;
        block5: {
            block4: {
                node = Platform.getPreferencesService().getRootNode().node("project");
                try {
                    if (node.nodeExists(project.getName())) break block4;
                    return false;
                }
                catch (BackingStoreException e) {
                    String message = Messages.resources_readingEncoding;
                    Policy.log(new ResourceStatus(383, project.getFullPath(), message, e));
                    return false;
                }
            }
            node = node.node(project.getName());
            if (node.nodeExists("org.eclipse.core.resources")) break block5;
            return false;
        }
        node = node.node("org.eclipse.core.resources");
        return node.getBoolean("separateDerivedEncodings", false);
    }

    protected void mergeEncodingPreferences(IProject project) {
        Preferences projectRegularPrefs = null;
        Preferences projectDerivedPrefs = this.getPreferences(project, false, true, true);
        if (projectDerivedPrefs == null) {
            return;
        }
        try {
            String[] affectedResources;
            boolean prefsChanged = false;
            String[] stringArray = affectedResources = projectDerivedPrefs.keys();
            int n = affectedResources.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                String value = projectDerivedPrefs.get(path, null);
                projectDerivedPrefs.remove(path);
                if (projectRegularPrefs == null) {
                    projectRegularPrefs = this.getPreferences(project, true, false, false);
                }
                projectRegularPrefs.put(path, value);
                prefsChanged = true;
                ++n2;
            }
            if (prefsChanged) {
                HashMap<IProject, Boolean> projectsToSave = new HashMap<IProject, Boolean>();
                projectsToSave.put(project, Boolean.TRUE);
                this.job.addChanges(projectsToSave);
            }
        }
        catch (BackingStoreException e) {
            String message = Messages.resources_readingEncoding;
            Policy.log(new ResourceStatus(383, project.getFullPath(), message, e));
        }
    }

    public void projectPreferencesChanged(IProject project) {
        this.charsetListener.charsetPreferencesChanged(project);
    }

    public void setCharsetFor(IPath resourcePath, String newCharset) throws CoreException {
        if (IPath.ROOT.equals((Object)resourcePath)) {
            this.setCharsetForRoot(newCharset);
        } else {
            IResource iResource = this.workspace.getRoot().findMember(resourcePath);
            if (iResource instanceof Resource) {
                Resource resource = (Resource)iResource;
                this.setCharsetForResource(resourcePath, newCharset, resource);
            }
        }
    }

    private void setCharsetForRoot(String newCharset) throws ResourceException {
        IEclipsePreferences resourcesPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        if (newCharset != null) {
            resourcesPreferences.put("encoding", newCharset);
        } else {
            resourcesPreferences.remove("encoding");
        }
        try {
            resourcesPreferences.flush();
        }
        catch (BackingStoreException e) {
            this.setCharsetForHasFailed(IPath.ROOT, e);
        }
    }

    private void setCharsetForResource(IPath resourcePath, String newCharset, IResource resource) throws ResourceException {
        try {
            this.setResourceEncodingSettings(resourcePath, newCharset, resource);
            if (resource instanceof Project) {
                Project project = (Project)resource;
                ValidateProjectEncoding.scheduleProjectValidation(this.workspace, project);
            }
        }
        catch (BackingStoreException e) {
            this.setCharsetForHasFailed(resourcePath, e);
        }
    }

    private void setResourceEncodingSettings(IPath resourcePath, String newCharset, IResource resource) throws BackingStoreException {
        Preferences encodingSettings = this.getPreferences(resource.getProject(), true, resource.isDerived(512));
        if (newCharset == null || newCharset.isBlank()) {
            encodingSettings.remove(CharsetManager.getKeyFor(resourcePath));
        } else {
            encodingSettings.put(CharsetManager.getKeyFor(resourcePath), newCharset);
        }
        this.flushPreferences(encodingSettings, true);
    }

    private void setCharsetForHasFailed(IPath resourcePath, BackingStoreException e) throws ResourceException {
        String message = Messages.resources_savingEncoding;
        throw new ResourceException(382, resourcePath, message, e);
    }

    @Override
    public void shutdown(IProgressMonitor monitor) {
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").removePreferenceChangeListener(this.preferenceChangeListener);
        this.workspace.removeResourceChangeListener(this.resourceChangeListener);
        if (this.charsetListener != null) {
            this.charsetListener.shutdown();
        }
    }

    protected void splitEncodingPreferences(IProject project) {
        Preferences projectRegularPrefs = this.getPreferences(project, false, false, false);
        Preferences projectDerivedPrefs = null;
        if (projectRegularPrefs == null) {
            return;
        }
        try {
            String[] affectedResources;
            boolean prefsChanged = false;
            String[] stringArray = affectedResources = projectRegularPrefs.keys();
            int n = affectedResources.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                IResource resource = project.findMember(path);
                if (resource != null && resource.isDerived(512)) {
                    String value = projectRegularPrefs.get(path, null);
                    projectRegularPrefs.remove(path);
                    if (projectDerivedPrefs == null) {
                        projectDerivedPrefs = this.getPreferences(project, true, true, true);
                    }
                    projectDerivedPrefs.put(path, value);
                    prefsChanged = true;
                }
                ++n2;
            }
            if (prefsChanged) {
                HashMap<IProject, Boolean> projectsToSave = new HashMap<IProject, Boolean>();
                projectsToSave.put(project, Boolean.TRUE);
                this.job.addChanges(projectsToSave);
            }
        }
        catch (BackingStoreException e) {
            String message = Messages.resources_readingEncoding;
            Policy.log(new ResourceStatus(383, project.getFullPath(), message, e));
        }
    }

    @Override
    public void startup(IProgressMonitor monitor) {
        this.job = new CharsetManagerJob();
        this.resourceChangeListener = new ResourceChangeListener();
        this.workspace.addResourceChangeListener(this.resourceChangeListener, 1);
        this.charsetListener = new CharsetDeltaJob(this.workspace);
        this.charsetListener.startup();
        ValidateProjectEncoding.scheduleWorkspaceValidation(this.workspace);
        this.initPreferenceChangeListener();
    }

    private void initPreferenceChangeListener() {
        this.preferenceChangeListener = event -> {
            if ("missingEncodingMarkerSeverity".equals(event.getKey())) {
                ValidateProjectEncoding.scheduleWorkspaceValidation(this.workspace);
            }
        };
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").addPreferenceChangeListener(this.preferenceChangeListener);
    }

    private class CharsetManagerJob
    extends Job {
        private static final int CHARSET_UPDATE_DELAY = 500;
        private final List<Map.Entry<IProject, Boolean>> asyncChanges;

        public CharsetManagerJob() {
            super(Messages.resources_charsetUpdating);
            this.asyncChanges = new ArrayList<Map.Entry<IProject, Boolean>>();
            this.setSystem(true);
            this.setPriority(10);
        }

        public boolean belongsTo(Object family) {
            return CharsetManager.class == family;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChanges(Map<IProject, Boolean> newChanges) {
            if (newChanges.isEmpty()) {
                return;
            }
            List<Map.Entry<IProject, Boolean>> list = this.asyncChanges;
            synchronized (list) {
                this.asyncChanges.addAll(newChanges.entrySet());
                this.asyncChanges.notify();
            }
            this.schedule(500L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map.Entry<IProject, Boolean> getNextChange() {
            List<Map.Entry<IProject, Boolean>> list = this.asyncChanges;
            synchronized (list) {
                return this.asyncChanges.isEmpty() ? null : this.asyncChanges.remove(this.asyncChanges.size() - 1);
            }
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 13[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            List<Map.Entry<IProject, Boolean>> list = this.asyncChanges;
            synchronized (list) {
                return !this.asyncChanges.isEmpty();
            }
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private boolean moveSettingsIfDerivedChanged(IResourceDelta parent, IProject currentProject, Preferences projectPrefs, String[] affectedResources) {
            int n;
            boolean resourceChanges = false;
            if ((parent.getFlags() & 0x400000) != 0) {
                IPath parentPath = parent.getResource().getProjectRelativePath();
                String[] stringArray = affectedResources;
                int n2 = affectedResources.length;
                n = 0;
                while (n < n2) {
                    IResource member;
                    String affectedResource = stringArray[n];
                    IPath affectedPath = IPath.fromOSString((String)affectedResource);
                    if (parentPath.isPrefixOf(affectedPath) && (member = currentProject.findMember(affectedPath)) != null) {
                        Preferences targetPrefs = CharsetManager.this.getPreferences(currentProject, true, member.isDerived(512));
                        if (!projectPrefs.absolutePath().equals(targetPrefs.absolutePath())) {
                            String currentValue = projectPrefs.get(affectedResource, null);
                            projectPrefs.remove(affectedResource);
                            targetPrefs.put(affectedResource, currentValue);
                            resourceChanges = true;
                        }
                    }
                    ++n;
                }
            }
            IResourceDelta[] iResourceDeltaArray = parent.getAffectedChildren();
            n = iResourceDeltaArray.length;
            int n3 = 0;
            while (n3 < n) {
                IResourceDelta child = iResourceDeltaArray[n3];
                resourceChanges = this.moveSettingsIfDerivedChanged(child, currentProject, projectPrefs, affectedResources) || resourceChanges;
                ++n3;
            }
            return resourceChanges;
        }

        private void processEntryChanges(IResourceDelta projectDelta, Map<IProject, Boolean> projectsToSave) {
            IProject currentProject = (IProject)projectDelta.getResource();
            Preferences projectRegularPrefs = CharsetManager.this.getPreferences(currentProject, false, false, true);
            Preferences projectDerivedPrefs = CharsetManager.this.getPreferences(currentProject, false, true, true);
            HashMap<Boolean, String[]> affectedResourcesMap = new HashMap<Boolean, String[]>();
            try {
                if (projectRegularPrefs == null) {
                    affectedResourcesMap.put(Boolean.FALSE, new String[0]);
                } else {
                    affectedResourcesMap.put(Boolean.FALSE, projectRegularPrefs.keys());
                }
                if (projectDerivedPrefs == null) {
                    affectedResourcesMap.put(Boolean.TRUE, new String[0]);
                } else {
                    affectedResourcesMap.put(Boolean.TRUE, projectDerivedPrefs.keys());
                }
            }
            catch (BackingStoreException e) {
                String message = Messages.resources_readingEncoding;
                Policy.log(new ResourceStatus(383, currentProject.getFullPath(), message, e));
                return;
            }
            for (Map.Entry entry : affectedResourcesMap.entrySet()) {
                Boolean isDerived = (Boolean)entry.getKey();
                String[] affectedResources = (String[])entry.getValue();
                Preferences projectPrefs = isDerived != false ? projectDerivedPrefs : projectRegularPrefs;
                String[] stringArray = affectedResources;
                int n = affectedResources.length;
                int n2 = 0;
                while (n2 < n) {
                    String affectedResource = stringArray[n2];
                    IResourceDelta memberDelta = projectDelta.findMember(IPath.fromOSString((String)affectedResource));
                    if (memberDelta != null && memberDelta.getKind() == 2) {
                        boolean shouldDisableCharsetDeltaJobForCurrentProject = false;
                        String currentValue = projectPrefs.get(affectedResource, null);
                        projectPrefs.remove(affectedResource);
                        if ((memberDelta.getFlags() & 0x2000) != 0) {
                            IPath movedToPath = memberDelta.getMovedToPath();
                            IResource resource = CharsetManager.this.workspace.getRoot().findMember(movedToPath);
                            if (resource != null) {
                                Preferences encodingSettings = CharsetManager.this.getPreferences(resource.getProject(), true, resource.isDerived(512));
                                if (currentValue == null || currentValue.trim().length() == 0) {
                                    encodingSettings.remove(CharsetManager.getKeyFor(movedToPath));
                                } else {
                                    encodingSettings.put(CharsetManager.getKeyFor(movedToPath), currentValue);
                                }
                                IProject targetProject = CharsetManager.this.workspace.getRoot().getProject(movedToPath.segment(0));
                                if (targetProject.equals(currentProject)) {
                                    shouldDisableCharsetDeltaJobForCurrentProject = true;
                                } else {
                                    projectsToSave.put(targetProject, Boolean.FALSE);
                                }
                            }
                        }
                        projectsToSave.put(currentProject, shouldDisableCharsetDeltaJobForCurrentProject);
                    }
                    ++n2;
                }
                if (!this.moveSettingsIfDerivedChanged(projectDelta, currentProject, projectPrefs, affectedResources)) continue;
                projectsToSave.put(currentProject, Boolean.TRUE);
            }
        }

        @Override
        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            IResourceDelta[] projectDeltas = delta.getAffectedChildren();
            HashMap<IProject, Boolean> projectsToSave = new HashMap<IProject, Boolean>();
            IResourceDelta[] iResourceDeltaArray = projectDeltas;
            int n = projectDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta projectDelta = iResourceDeltaArray[n2];
                if (projectDelta.getKind() == 4 && (projectDelta.getFlags() & 0x4000) == 0) {
                    this.processEntryChanges(projectDelta, projectsToSave);
                }
                ++n2;
            }
            CharsetManager.this.job.addChanges(projectsToSave);
        }
    }
}

