/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.apt.internal;

import org.apache.maven.plugin.MojoExecution;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.apt.MavenJdtAptPlugin;
import org.eclipse.m2e.apt.internal.AptConfiguratorDelegate;
import org.eclipse.m2e.apt.preferences.AnnotationProcessingMode;
import org.eclipse.m2e.apt.preferences.IPreferencesManager;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;

public abstract class AbstractAptProjectConfigurator
extends AbstractProjectConfigurator
implements IJavaProjectConfigurator {
    protected abstract AptConfiguratorDelegate getDelegate(AnnotationProcessingMode var1);

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        if (request == null || monitor == null) {
            return;
        }
        IMavenProjectFacade mavenProjectFacade = request.mavenProjectFacade();
        AnnotationProcessingMode mode = this.getAnnotationProcessorMode(mavenProjectFacade);
        mavenProjectFacade.createExecutionContext().execute((c, m) -> {
            AptConfiguratorDelegate configuratorDelegate = this.getDelegate(mode);
            configuratorDelegate.setSession(c.getSession());
            configuratorDelegate.setFacade(mavenProjectFacade);
            if (!configuratorDelegate.isIgnored(monitor)) {
                configuratorDelegate.configureProject(monitor);
            }
            return null;
        }, monitor);
        this.configureAptReconcile(mavenProjectFacade.getProject());
    }

    private void configureAptReconcile(IProject project) throws CoreException {
        IJavaProject jp;
        if (project.hasNature("org.eclipse.jdt.core.javanature") && (jp = JavaCore.create((IProject)project)) != null && AptConfig.isEnabled((IJavaProject)jp)) {
            boolean shouldEnable = MavenJdtAptPlugin.getPreferencesManager().shouldEnableAnnotationProcessDuringReconcile(project);
            if (shouldEnable && !AptConfig.shouldProcessDuringReconcile((IJavaProject)jp)) {
                AptConfig.setProcessDuringReconcile((IJavaProject)jp, (boolean)true);
            }
            if (!shouldEnable && AptConfig.shouldProcessDuringReconcile((IJavaProject)jp)) {
                AptConfig.setProcessDuringReconcile((IJavaProject)jp, (boolean)false);
            }
        }
    }

    public void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) {
    }

    public void configureRawClasspath(ProjectConfigurationRequest request, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        IProject eclipseProject = request.mavenProjectFacade().getProject();
        if (!eclipseProject.hasNature("org.eclipse.jdt.core.javanature")) {
            return;
        }
        request.mavenProjectFacade().createExecutionContext().execute((c, m) -> {
            AptConfiguratorDelegate delegate = this.getDelegate(request.mavenProjectFacade());
            delegate.setFacade(request.mavenProjectFacade());
            delegate.setSession(c.getSession());
            if (!delegate.isIgnored(monitor)) {
                delegate.configureClasspath(classpath, monitor);
            }
            return null;
        }, monitor);
    }

    public AbstractBuildParticipant getBuildParticipant(IMavenProjectFacade projectFacade, MojoExecution execution, IPluginExecutionMetadata executionMetadata) {
        AptConfiguratorDelegate configuratorDelegate = this.getDelegate(projectFacade);
        return configuratorDelegate.getMojoExecutionBuildParticipant(execution);
    }

    private AptConfiguratorDelegate getDelegate(IMavenProjectFacade facade) {
        AnnotationProcessingMode mode = this.getAnnotationProcessorMode(facade);
        return this.getDelegate(mode);
    }

    private AnnotationProcessingMode getAnnotationProcessorMode(IMavenProjectFacade facade) {
        IPreferencesManager preferencesManager = MavenJdtAptPlugin.getPreferencesManager();
        return preferencesManager.getAnnotationProcessorMode(facade.getProject());
    }
}

