/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.util;

import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.searcher.JUnit4TestSearcher;
import com.microsoft.java.test.plugin.searcher.JUnit5TestSearcher;
import com.microsoft.java.test.plugin.searcher.JUnit6TestSearcher;
import com.microsoft.java.test.plugin.searcher.TestFrameworkSearcher;
import com.microsoft.java.test.plugin.searcher.TestNGTestSearcher;
import java.util.Objects;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class TestFrameworkUtils {
    public static final TestFrameworkSearcher JUNIT4_TEST_SEARCHER = new JUnit4TestSearcher();
    public static final TestFrameworkSearcher JUNIT5_TEST_SEARCHER = new JUnit5TestSearcher();
    public static final TestFrameworkSearcher JUNIT6_TEST_SEARCHER = new JUnit6TestSearcher();
    public static final TestFrameworkSearcher TESTNG_TEST_SEARCHER = new TestNGTestSearcher();

    public static boolean isEquivalentAnnotationType(ITypeBinding annotationType, String annotationName) {
        return annotationType != null && Objects.equals(annotationType.getQualifiedName(), annotationName);
    }

    public static TestFrameworkSearcher getSearcherByTestKind(TestKind kind) {
        switch (kind) {
            case JUnit: {
                return JUNIT4_TEST_SEARCHER;
            }
            case JUnit5: {
                return JUNIT5_TEST_SEARCHER;
            }
            case JUnit6: {
                return JUNIT6_TEST_SEARCHER;
            }
            case TestNG: {
                return TESTNG_TEST_SEARCHER;
            }
        }
        return null;
    }
}

