/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtilsCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public final class RefactoringAvailabilityTesterCore {
    public static boolean isDeleteAvailable(IJavaElement element) {
        if (!element.exists()) {
            return false;
        }
        if (element instanceof IJavaModel || element instanceof IJavaProject) {
            return false;
        }
        if (element.getParent() != null && element.getParent().isReadOnly()) {
            return false;
        }
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            if (root.isExternal() || Checks.isClasspathDelete(root)) {
                return false;
            }
            if (root.getResource().equals((Object)root.getJavaProject().getProject())) {
                return false;
            }
        }
        if (element instanceof IPackageFragment && ((IPackageFragment)element).isDefaultPackage()) {
            return false;
        }
        if (element.getResource() == null && !RefactoringAvailabilityTesterCore.isWorkingCopyElement(element)) {
            return false;
        }
        return !(element instanceof IMember) || !((IMember)element).isBinary();
    }

    public static boolean isMoveStaticMembersAvailable(IMember[] members) throws JavaModelException {
        if (members == null) {
            return false;
        }
        if (members.length == 0) {
            return false;
        }
        if (!RefactoringAvailabilityTesterCore.isMoveStaticAvailable(members)) {
            return false;
        }
        return RefactoringAvailabilityTesterCore.isCommonDeclaringType(members);
    }

    public static boolean isMoveStaticAvailable(IMember[] members) throws JavaModelException {
        IMember[] iMemberArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            if (!RefactoringAvailabilityTesterCore.isMoveStaticAvailable(member)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isMoveStaticAvailable(IMember member) throws JavaModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8 && type != 7) {
            return false;
        }
        if (JdtFlags.isEnum(member) && type != 7) {
            return false;
        }
        IType declaring = member.getDeclaringType();
        if (declaring == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (type == 9 && declaring.isInterface() && !Flags.isStatic((int)member.getFlags())) {
            return false;
        }
        if (type == 9 && !JdtFlags.isStatic(member)) {
            return false;
        }
        if (type == 9 && ((IMethod)member).isConstructor()) {
            return false;
        }
        if (type == 7 && !JdtFlags.isStatic(member)) {
            return false;
        }
        return declaring.isInterface() || JdtFlags.isStatic(member);
    }

    public static boolean isCommonDeclaringType(IMember[] members) {
        if (members.length == 0) {
            return false;
        }
        IType type = members[0].getDeclaringType();
        if (type == null) {
            return false;
        }
        IMember[] iMemberArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            if (!type.equals(member.getDeclaringType())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isDelegateCreationAvailable(IField field) throws JavaModelException {
        return field.exists() && Flags.isStatic((int)field.getFlags()) && Flags.isFinal((int)field.getFlags());
    }

    public static boolean isInlineTempAvailable(ILocalVariable variable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)variable);
    }

    public static boolean isInlineConstantAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field) && JdtFlags.isStatic((IMember)field) && JdtFlags.isFinal((IMember)field) && !JdtFlags.isEnum((IMember)field);
    }

    public static boolean isInlineMethodAvailable(IMethod method) throws JavaModelException {
        if (method == null) {
            return false;
        }
        if (!method.exists()) {
            return false;
        }
        if (!method.isStructureKnown()) {
            return false;
        }
        if (!method.isBinary()) {
            return true;
        }
        if (method.isConstructor()) {
            return false;
        }
        return SourceRange.isAvailable((ISourceRange)method.getNameRange());
    }

    public static ASTNode getInlineableMethodNode(ITypeRoot typeRoot, CompilationUnit root, int offset, int length) {
        ASTNode node = null;
        try {
            node = RefactoringAvailabilityTesterCore.getInlineableMethodNode(NodeFinder.perform((ASTNode)root, (int)offset, (int)length, (ITypeRoot)typeRoot), (IJavaElement)typeRoot);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (node != null) {
            return node;
        }
        return RefactoringAvailabilityTesterCore.getInlineableMethodNode(NodeFinder.perform((ASTNode)root, (int)offset, (int)length), (IJavaElement)typeRoot);
    }

    private static ASTNode getInlineableMethodNode(ASTNode node, IJavaElement unit) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 42: {
                StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
                if (locationInParent == MethodDeclaration.NAME_PROPERTY) {
                    return node.getParent();
                }
                if (locationInParent == MethodInvocation.NAME_PROPERTY || locationInParent == SuperMethodInvocation.NAME_PROPERTY) {
                    return unit instanceof ICompilationUnit ? node.getParent() : null;
                }
                return null;
            }
            case 21: {
                node = ((ExpressionStatement)node).getExpression();
            }
        }
        switch (node.getNodeType()) {
            case 31: {
                return node;
            }
            case 17: 
            case 32: 
            case 48: {
                return unit instanceof ICompilationUnit ? node : null;
            }
        }
        return null;
    }

    public static boolean isChangeSignatureAvailable(IMethod method) throws JavaModelException {
        return method != null && Checks.isAvailable((IJavaElement)method) && !Flags.isAnnotation((int)method.getDeclaringType().getFlags());
    }

    public static IType getDeclaringType(IJavaElement element) {
        if (element == null) {
            return null;
        }
        if (!(element instanceof IType)) {
            element = element.getAncestor(7);
        }
        return (IType)element;
    }

    public static IJavaElement[] getJavaElements(Object[] elements) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IJavaElement) {
                result.add((IJavaElement)element);
            }
            ++n2;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    public static IMember[] getPullUpMembers(IType type) throws JavaModelException {
        ArrayList<IField> list = new ArrayList<IField>(3);
        if (type.exists()) {
            IField member;
            IField[] iFieldArray = type.getFields();
            int n = iFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                member = iFieldArray[n2];
                if (RefactoringAvailabilityTesterCore.isPullUpAvailable((IMember)member)) {
                    list.add(member);
                }
                ++n2;
            }
            iFieldArray = type.getMethods();
            n = iFieldArray.length;
            n2 = 0;
            while (n2 < n) {
                member = iFieldArray[n2];
                if (RefactoringAvailabilityTesterCore.isPullUpAvailable((IMember)member)) {
                    list.add(member);
                }
                ++n2;
            }
            iFieldArray = type.getTypes();
            n = iFieldArray.length;
            n2 = 0;
            while (n2 < n) {
                member = iFieldArray[n2];
                if (RefactoringAvailabilityTesterCore.isPullUpAvailable((IMember)member)) {
                    list.add(member);
                }
                ++n2;
            }
        }
        return list.toArray(new IMember[list.size()]);
    }

    public static IMember[] getPushDownMembers(IType type) throws JavaModelException {
        ArrayList<IField> list = new ArrayList<IField>(3);
        if (type.exists()) {
            IField member;
            IField[] iFieldArray = type.getFields();
            int n = iFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                member = iFieldArray[n2];
                if (RefactoringAvailabilityTesterCore.isPushDownAvailable((IMember)member)) {
                    list.add(member);
                }
                ++n2;
            }
            iFieldArray = type.getMethods();
            n = iFieldArray.length;
            n2 = 0;
            while (n2 < n) {
                member = iFieldArray[n2];
                if (RefactoringAvailabilityTesterCore.isPushDownAvailable((IMember)member)) {
                    list.add(member);
                }
                ++n2;
            }
        }
        return list.toArray(new IMember[list.size()]);
    }

    public static IResource[] getResources(Object[] elements) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IResource) {
                result.add((IResource)element);
            }
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static IType getTopLevelType(IMember[] members) {
        if (members != null && members.length == 1 && Checks.isTopLevelType(members[0])) {
            return (IType)members[0];
        }
        return null;
    }

    public static boolean isCanonicalConstructor(IMethod method) {
        boolean isCanonicalConstructor = false;
        try {
            IMethodBinding mBinding;
            MethodDeclaration mDecl;
            CompilationUnit cUnit;
            if (method != null && method.isConstructor() && (cUnit = SharedASTProviderCore.getAST((ITypeRoot)method.getCompilationUnit(), SharedASTProviderCore.WAIT_YES, null)) != null && (mDecl = ASTNodeSearchUtil.getMethodDeclarationNode(method, cUnit)) != null && (mBinding = mDecl.resolveBinding()) != null && mBinding.isCanonicalConstructor()) {
                isCanonicalConstructor = true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return isCanonicalConstructor;
    }

    public static boolean isConvertAnonymousAvailable(IType type) throws JavaModelException {
        if (Checks.isAvailable((IJavaElement)type)) {
            IJavaElement element = type.getParent();
            if (element instanceof IField && JdtFlags.isEnum((IMember)element)) {
                return false;
            }
            return type.isAnonymous();
        }
        return false;
    }

    public static boolean isConvertToRecordAvailable(IType type) throws JavaModelException {
        if (Checks.isAvailable((IJavaElement)type)) {
            if (type.isImplicitlyDeclared() || type.isBinary() || type.isLambda() || type.isAnnotation()) {
                return false;
            }
            if (type.isClass()) {
                IField[] fields = type.getFields();
                if (fields.length == 0) {
                    return false;
                }
                IField[] iFieldArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    if (!Flags.isPrivate((int)field.getFlags()) || Flags.isStatic((int)field.getFlags())) {
                        return false;
                    }
                    ++n2;
                }
                IMethod[] methods = type.getMethods();
                boolean hasConstructor = false;
                IMethod[] iMethodArray = methods;
                int n3 = methods.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMethod method = iMethodArray[n4];
                    if (method.isConstructor()) {
                        if (hasConstructor) {
                            return false;
                        }
                        hasConstructor = true;
                        if (method.getNumberOfParameters() < fields.length) {
                            return false;
                        }
                    }
                    if (Modifier.isStatic(method.getFlags())) {
                        return false;
                    }
                    ++n4;
                }
            }
            return type.isClass();
        }
        return false;
    }

    public static boolean isDeleteAvailable(IResource resource) {
        if (!resource.exists() || resource.isPhantom()) {
            return false;
        }
        return resource.getType() != 8 && resource.getType() != 4;
    }

    public static boolean isExtractInterfaceAvailable(IType type) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)type) && !type.isBinary() && !type.isReadOnly() && !type.isAnnotation() && !type.isAnonymous() && !type.isLambda();
    }

    public static boolean isExtractMethodAvailable(ASTNode[] nodes) {
        if (nodes != null && nodes.length != 0) {
            if (nodes.length == 1) {
                return nodes[0] instanceof Statement || Checks.isExtractableExpression(nodes[0]);
            }
            ASTNode[] aSTNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ASTNode node = aSTNodeArray[n2];
                if (!(node instanceof Statement)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static boolean isExtractSupertypeAvailable(IMember member) throws JavaModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8 && type != 7) {
            return false;
        }
        if (JdtFlags.isEnum(member) && type != 7) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)method)) {
                return false;
            }
            member = method.getDeclaringType();
        } else if (member instanceof IField) {
            member = member.getDeclaringType();
        }
        if (member instanceof IType) {
            if (JdtFlags.isEnum(member) || JdtFlags.isAnnotation(member)) {
                return false;
            }
            if (member.getDeclaringType() != null && !JdtFlags.isStatic(member)) {
                return false;
            }
            if (((IType)member).isAnonymous()) {
                return false;
            }
            if (((IType)member).isLambda()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isExtractSupertypeAvailable(IMember[] members) throws JavaModelException {
        if (members != null && members.length != 0) {
            IType type = RefactoringAvailabilityTesterCore.getTopLevelType(members);
            if (type != null && !type.isClass()) {
                return false;
            }
            IMember[] iMemberArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IMember member = iMemberArray[n2];
                if (!RefactoringAvailabilityTesterCore.isExtractSupertypeAvailable(member)) {
                    return false;
                }
                ++n2;
            }
            return members.length == 1 || RefactoringAvailabilityTesterCore.isCommonDeclaringType(members);
        }
        return false;
    }

    public static boolean isGeneralizeTypeAvailable(IJavaElement element) throws JavaModelException {
        if (element != null && element.exists()) {
            String type = null;
            if (element instanceof IMethod) {
                type = ((IMethod)element).getReturnType();
            } else if (element instanceof IField) {
                IField field = (IField)element;
                if (JdtFlags.isEnum((IMember)field)) {
                    return false;
                }
                type = field.getTypeSignature();
            } else {
                if (element instanceof ILocalVariable) {
                    return true;
                }
                if (element instanceof IType) {
                    IType clazz = (IType)element;
                    return !JdtFlags.isEnum((IMember)clazz);
                }
            }
            return type != null && PrimitiveType.toCode((String)Signature.toString((String)type)) == null;
        }
        return false;
    }

    public static boolean isInferTypeArgumentsAvailable(IJavaElement element) throws JavaModelException {
        if (!Checks.isAvailable(element)) {
            return false;
        }
        if (element instanceof IJavaProject) {
            IJavaProject project = (IJavaProject)element;
            IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 3) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (element instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)element).getKind() == 1;
        }
        if (element instanceof IPackageFragment) {
            return ((IPackageFragment)element).getKind() == 1;
        }
        return element instanceof ICompilationUnit || element.getAncestor(5) != null;
    }

    public static boolean isInferTypeArgumentsAvailable(IJavaElement[] elements) throws JavaModelException {
        if (elements.length == 0) {
            return false;
        }
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (!RefactoringAvailabilityTesterCore.isInferTypeArgumentsAvailable(element)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isIntroduceFactoryAvailable(IMethod method) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)method) && method.isConstructor();
    }

    public static boolean isIntroduceIndirectionAvailable(IMethod method) throws JavaModelException {
        if (method == null) {
            return false;
        }
        if (!method.exists()) {
            return false;
        }
        if (!method.isStructureKnown()) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        if (method.getDeclaringType().isAnnotation()) {
            return false;
        }
        return !JavaModelUtil.isPolymorphicSignature(method);
    }

    public static boolean isIntroduceParameterAvailable(ASTNode[] selectedNodes, ASTNode coveringNode) {
        return Checks.isExtractableExpression(selectedNodes, coveringNode);
    }

    public static boolean isMoveInnerAvailable(IType type) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)type) && !Checks.isAnonymous(type) && !JavaElementUtil.isMainType(type) && !Checks.isInsideLocalType(type);
    }

    public static boolean isMoveMethodAvailable(IMethod method) throws JavaModelException {
        return method.exists() && !method.isConstructor() && !method.isBinary() && !method.isReadOnly() && !JdtFlags.isStatic((IMember)method) && (JdtFlags.isDefaultMethod(method) || !method.getDeclaringType().isInterface());
    }

    public static boolean isPromoteTempAvailable(ILocalVariable variable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)variable);
    }

    public static boolean isPullUpAvailable(IMember member) throws JavaModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8 && type != 7) {
            return false;
        }
        if (JdtFlags.isEnum(member) && type != 7) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (member instanceof IType && !JdtFlags.isStatic(member) && !JdtFlags.isEnum(member) && !JdtFlags.isAnnotation(member)) {
            return false;
        }
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)method)) {
                return false;
            }
            IType declaring = method.getDeclaringType();
            if (declaring != null && declaring.isAnnotation()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isPullUpAvailable(IMember[] members) throws JavaModelException {
        if (members != null && members.length != 0) {
            IType type = RefactoringAvailabilityTesterCore.getTopLevelType(members);
            if (type != null && RefactoringAvailabilityTesterCore.getPullUpMembers(type).length != 0) {
                return true;
            }
            IMember[] iMemberArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IMember member = iMemberArray[n2];
                if (!RefactoringAvailabilityTesterCore.isPullUpAvailable(member)) {
                    return false;
                }
                ++n2;
            }
            return RefactoringAvailabilityTesterCore.isCommonDeclaringType(members);
        }
        return false;
    }

    public static boolean isPushDownAvailable(IMember member) throws JavaModelException {
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8) {
            return false;
        }
        if (JdtFlags.isEnum(member)) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (JdtFlags.isStatic(member)) {
            return false;
        }
        if (type == 9) {
            IMethod method = (IMethod)member;
            if (method.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)method)) {
                return false;
            }
            IType declaring = method.getDeclaringType();
            if (declaring != null && declaring.isAnnotation()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isPushDownAvailable(IMember[] members) throws JavaModelException {
        if (members != null && members.length != 0) {
            IType type = RefactoringAvailabilityTesterCore.getTopLevelType(members);
            if (type != null && RefactoringAvailabilityTesterCore.getPushDownMembers(type).length != 0) {
                return true;
            }
            if (type != null && JdtFlags.isEnum((IMember)type)) {
                return false;
            }
            IMember[] iMemberArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IMember member = iMemberArray[n2];
                if (!RefactoringAvailabilityTesterCore.isPushDownAvailable(member)) {
                    return false;
                }
                ++n2;
            }
            return RefactoringAvailabilityTesterCore.isCommonDeclaringType(members);
        }
        return false;
    }

    public static boolean isRenameAvailable(ICompilationUnit unit) {
        if (unit == null) {
            return false;
        }
        if (!unit.exists()) {
            return false;
        }
        if (!JavaModelUtil.isPrimary(unit)) {
            return false;
        }
        return !unit.isReadOnly();
    }

    public static boolean isRenameAvailable(IJavaProject project) throws JavaModelException {
        if (project == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)project)) {
            return false;
        }
        return project.isConsistent();
    }

    public static boolean isRenameAvailable(IModuleDescription module) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)module);
    }

    public static boolean isRenameAvailable(ILocalVariable variable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)variable);
    }

    public static boolean isRenameAvailable(IMethod method) throws CoreException {
        if (method == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)method)) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        return !RefactoringAvailabilityTesterCore.isRenameProhibited(method);
    }

    public static boolean isRenameAvailable(IPackageFragment fragment) throws JavaModelException {
        if (fragment == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)fragment)) {
            return false;
        }
        return !fragment.isDefaultPackage();
    }

    public static boolean isRenameAvailable(IPackageFragmentRoot root) throws JavaModelException {
        if (root == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)root)) {
            return false;
        }
        if (root.isArchive()) {
            return false;
        }
        if (root.isExternal()) {
            return false;
        }
        if (!root.isConsistent()) {
            return false;
        }
        return !(root.getResource() instanceof IProject);
    }

    public static boolean isRenameAvailable(IResource resource) {
        if (resource == null) {
            return false;
        }
        if (!resource.exists()) {
            return false;
        }
        return resource.isAccessible();
    }

    public static boolean isRenameAvailable(IType type) throws JavaModelException {
        if (type == null) {
            return false;
        }
        if (type.isAnonymous()) {
            return false;
        }
        if (type.isLambda()) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)type)) {
            return false;
        }
        return !RefactoringAvailabilityTesterCore.isRenameProhibited(type);
    }

    public static boolean isRenameAvailable(ITypeParameter parameter) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)parameter);
    }

    public static boolean isRenameEnumConstAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field) && field.getDeclaringType().isEnum();
    }

    public static boolean isRenameFieldAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field) && !JdtFlags.isEnum((IMember)field);
    }

    public static boolean isRenameModuleAvailable(IModuleDescription module) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)module);
    }

    public static boolean isRenameNonVirtualMethodAvailable(IMethod method) throws JavaModelException, CoreException {
        return RefactoringAvailabilityTesterCore.isRenameAvailable(method) && !MethodChecks.isVirtual(method);
    }

    public static boolean isRenameProhibited(IMethod method) throws CoreException {
        return "toString".equals(method.getElementName()) && method.getNumberOfParameters() == 0 && ("Ljava.lang.String;".equals(method.getReturnType()) || "QString;".equals(method.getReturnType()) || "Qjava.lang.String;".equals(method.getReturnType()));
    }

    public static boolean isRenameProhibited(IType type) {
        return "java.lang".equals(type.getPackageFragment().getElementName());
    }

    public static boolean isRenameVirtualMethodAvailable(IMethod method) throws CoreException {
        return RefactoringAvailabilityTesterCore.isRenameAvailable(method) && MethodChecks.isVirtual(method);
    }

    public static boolean isRenameElementAvailable(IJavaElement element) throws CoreException {
        if (element != null) {
            switch (element.getElementType()) {
                case 2: {
                    return RefactoringAvailabilityTesterCore.isRenameAvailable((IJavaProject)element);
                }
                case 3: {
                    return RefactoringAvailabilityTesterCore.isRenameAvailable((IPackageFragmentRoot)element);
                }
                case 4: {
                    return RefactoringAvailabilityTesterCore.isRenameAvailable((IPackageFragment)element);
                }
                case 5: {
                    return RefactoringAvailabilityTesterCore.isRenameAvailable((ICompilationUnit)element);
                }
                case 7: {
                    return RefactoringAvailabilityTesterCore.isRenameAvailable((IType)element);
                }
                case 9: {
                    IMethod method = (IMethod)element;
                    if (method.isConstructor()) {
                        return RefactoringAvailabilityTesterCore.isRenameAvailable(method.getDeclaringType());
                    }
                    return RefactoringAvailabilityTesterCore.isRenameAvailable(method);
                }
                case 8: {
                    IField field = (IField)element;
                    if (Flags.isEnum((int)field.getFlags())) {
                        return RefactoringAvailabilityTesterCore.isRenameEnumConstAvailable(field);
                    }
                    return RefactoringAvailabilityTesterCore.isRenameFieldAvailable(field);
                }
                case 15: {
                    return RefactoringAvailabilityTesterCore.isRenameAvailable((ITypeParameter)element);
                }
                case 14: {
                    return RefactoringAvailabilityTesterCore.isRenameAvailable((ILocalVariable)element);
                }
                case 17: {
                    return RefactoringAvailabilityTesterCore.isRenameAvailable((IModuleDescription)element);
                }
            }
        }
        return false;
    }

    public static boolean isReplaceInvocationsAvailable(IMethod method) throws JavaModelException {
        if (method == null) {
            return false;
        }
        if (!method.exists()) {
            return false;
        }
        return !method.isConstructor();
    }

    public static boolean isSelfEncapsulateAvailable(IField field) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)field) && !JdtFlags.isEnum((IMember)field) && !field.getDeclaringType().isInterface();
    }

    public static boolean isUseSuperTypeAvailable(IType type) throws JavaModelException {
        return type != null && type.exists() && !type.isAnnotation() && !type.isAnonymous() && !type.isLambda();
    }

    public static boolean isWorkingCopyElement(IJavaElement element) {
        if (element instanceof ICompilationUnit) {
            return ((ICompilationUnit)element).isWorkingCopy();
        }
        if (ReorgUtilsCore.isInsideCompilationUnit(element)) {
            return ReorgUtilsCore.getCompilationUnit(element).isWorkingCopy();
        }
        return false;
    }

    public static boolean isExtractClassAvailable(IType type) throws JavaModelException {
        if (type == null) {
            return false;
        }
        if (!type.exists()) {
            return false;
        }
        return ReorgUtilsCore.isInsideCompilationUnit((IJavaElement)type) && type.isClass() && !type.isAnonymous() && !type.isLambda();
    }

    public static boolean isMakeStaticAvailable(IMethod method) throws JavaModelException {
        return method != null && Checks.isAvailable((IJavaElement)method) && !Flags.isAnnotation((int)method.getDeclaringType().getFlags());
    }

    private RefactoringAvailabilityTesterCore() {
    }
}

