/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.m2e.core.internal.embedder.MavenProperties;
import org.eclipse.m2e.core.project.IProjectConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverConfigurationIO {
    private static final Logger log = LoggerFactory.getLogger(ResolverConfigurationIO.class);
    private static final String P_VERSION = "version";
    private static final String P_RESOLVE_WORKSPACE_PROJECTS = "resolveWorkspaceProjects";
    private static final boolean P_RESOLVE_WORKSPACE_PROJECTS_DEFAULT = false;
    private static final String P_AUTO_UPDATE_CONFIGURATION = "eclipse.m2.autoUpdateProjects";
    private static final String P_SELECTED_PROFILES = "activeProfiles";
    private static final String P_LIFECYCLE_MAPPING_ID = "lifecycleMappingId";
    private static final String P_PROPERTIES = "properties";
    private static final String P_BASEDIR = "basedir";
    private static final String PROPERTIES_KV_SEPARATOR = ">";
    private static final String PROPERTIES_SEPARATOR = "|";
    private static final String ENCODING = "UTF-8";
    private static final String VERSION = "1";

    public static boolean saveResolverConfiguration(IProject project, IProjectConfiguration configuration) {
        IEclipsePreferences projectNode = ResolverConfigurationIO.getMavenProjectPreferences(project);
        if (projectNode != null) {
            projectNode.put(P_VERSION, VERSION);
            projectNode.putBoolean(P_RESOLVE_WORKSPACE_PROJECTS, configuration.isResolveWorkspaceProjects());
            projectNode.put(P_SELECTED_PROFILES, configuration.getSelectedProfiles());
            if (configuration.getLifecycleMappingId() != null) {
                projectNode.put(P_LIFECYCLE_MAPPING_ID, configuration.getLifecycleMappingId());
            } else {
                projectNode.remove(P_LIFECYCLE_MAPPING_ID);
            }
            if (configuration.getConfigurationProperties() != null && !configuration.getConfigurationProperties().isEmpty()) {
                projectNode.put(P_PROPERTIES, ResolverConfigurationIO.propertiesAsString(configuration.getConfigurationProperties()));
            } else {
                projectNode.remove(P_PROPERTIES);
            }
            return ResolverConfigurationIO.savePreferences(projectNode);
        }
        return false;
    }

    public static IProjectConfiguration readResolverConfiguration(IProject project) {
        IEclipsePreferences projectNode = ResolverConfigurationIO.getMavenProjectPreferences(project);
        if (projectNode == null) {
            return new ResolverConfiguration(project);
        }
        String version = projectNode.get(P_VERSION, null);
        if (version == null) {
            return new ResolverConfiguration(project);
        }
        ResolverConfiguration configuration = new ResolverConfiguration();
        configuration.setResolveWorkspaceProjects(projectNode.getBoolean(P_RESOLVE_WORKSPACE_PROJECTS, false));
        configuration.setSelectedProfiles(projectNode.get(P_SELECTED_PROFILES, ""));
        configuration.setLifecycleMappingId(projectNode.get(P_LIFECYCLE_MAPPING_ID, null));
        configuration.setProperties(ResolverConfigurationIO.stringAsProperties(projectNode.get(P_PROPERTIES, null)));
        configuration.setMultiModuleProjectDirectory(ResolverConfigurationIO.getBasedir(projectNode, project));
        return configuration;
    }

    public static boolean isAutomaticallyUpdateConfiguration(IProject project) {
        IEclipsePreferences preferences = ResolverConfigurationIO.getMavenProjectPreferences(project);
        boolean defaultValue = true;
        return preferences != null ? preferences.getBoolean(P_AUTO_UPDATE_CONFIGURATION, defaultValue) : defaultValue;
    }

    public static void setAutomaticallyUpdateConfiguration(IProject project, boolean isAutomaticallyUpdateConfiguration) {
        IEclipsePreferences preferences = ResolverConfigurationIO.getMavenProjectPreferences(project);
        if (preferences != null) {
            preferences.putBoolean(P_AUTO_UPDATE_CONFIGURATION, isAutomaticallyUpdateConfiguration);
            ResolverConfigurationIO.savePreferences(preferences);
        }
    }

    public static boolean isResolveWorkspaceProjects(IProject project) {
        IEclipsePreferences preferences = ResolverConfigurationIO.getMavenProjectPreferences(project);
        if (preferences == null) {
            return false;
        }
        return preferences.getBoolean(P_RESOLVE_WORKSPACE_PROJECTS, false);
    }

    private static IEclipsePreferences getMavenProjectPreferences(IProject project) {
        return new ProjectScope(project).getNode("org.eclipse.m2e.core");
    }

    private static boolean savePreferences(IEclipsePreferences node) {
        try {
            node.flush();
            return true;
        }
        catch (BackingStoreException ex) {
            log.error("Failed to save resolver configuration", (Throwable)ex);
            return false;
        }
    }

    private static File getBasedir(IEclipsePreferences projectNode, IProject project) {
        File directory;
        String basedirSetting = projectNode.get(P_BASEDIR, null);
        if (basedirSetting != null && (directory = new File(basedirSetting)).isDirectory()) {
            return directory;
        }
        return MavenProperties.computeMultiModuleProjectDirectory((IResource)project);
    }

    private static String propertiesAsString(Map<?, ?> properties) {
        return properties.entrySet().stream().map(e -> ResolverConfigurationIO.encodeEntry(e)).collect(Collectors.joining(PROPERTIES_SEPARATOR));
    }

    private static Properties stringAsProperties(String properties) {
        Properties p = new Properties();
        if (properties != null) {
            String[] entries = properties.split("\\|");
            Stream.of(entries).forEach(e -> ResolverConfigurationIO.convert(e, p));
        }
        return p;
    }

    private static void convert(String e, Properties p) {
        String[] kv = e.split(PROPERTIES_KV_SEPARATOR);
        String key = kv[0];
        String value = null;
        if (kv.length == 2) {
            value = kv[1];
        }
        p.put(ResolverConfigurationIO.urlDecode(key), ResolverConfigurationIO.urlDecode(value));
    }

    private static String encodeEntry(Map.Entry<?, ?> e) {
        String key = e.getKey().toString();
        String value = e.getValue() == null ? "" : e.getValue().toString();
        return String.valueOf(ResolverConfigurationIO.urlEncode(key)) + PROPERTIES_KV_SEPARATOR + ResolverConfigurationIO.urlEncode(value);
    }

    private static String urlEncode(String string) {
        if (string == null) {
            return "";
        }
        try {
            return URLEncoder.encode(string, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    private static String urlDecode(String string) {
        if (string == null) {
            return "";
        }
        try {
            return URLDecoder.decode(string, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }
}

