/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;

public class JavaClassFilter {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static final int BLOCK_NONE = 0;
    private static final int BLOCK_JDK = 1;
    private static final int BLOCK_LIB = 2;
    private static final int BLOCK_BIN = 3;

    public static String[] resolveClassFilters(List<Object> unresolvedFilters) {
        IJavaProject[] javaProjects;
        if (unresolvedFilters == null || unresolvedFilters.isEmpty()) {
            return new String[0];
        }
        int variableScope = 0;
        LinkedHashSet<String> hardcodePatterns = new LinkedHashSet<String>();
        for (Object filter : unresolvedFilters) {
            String value;
            if (Objects.equals("$JDK", filter)) {
                variableScope |= 1;
                continue;
            }
            if (Objects.equals("$Libraries", filter)) {
                variableScope |= 2;
                continue;
            }
            if (!(filter instanceof String) || !StringUtils.isNotBlank((CharSequence)(value = (String)filter))) continue;
            hardcodePatterns.add(value.trim());
        }
        if (variableScope == 0) {
            return hardcodePatterns.toArray(new String[0]);
        }
        LinkedHashSet<String> blackList = new LinkedHashSet<String>();
        LinkedHashSet<String> whiteList = new LinkedHashSet<String>();
        IJavaProject[] iJavaProjectArray = javaProjects = ProjectUtils.getJavaProjects();
        int n = javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            try {
                IPackageFragmentRoot[] roots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getAllPackageFragmentRoots();
                int n3 = roots.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                    if (JavaClassFilter.isOnBlackList(root, variableScope)) {
                        JavaClassFilter.collectPackages(root, blackList);
                    } else {
                        JavaClassFilter.collectPackages(root, whiteList);
                    }
                    ++n4;
                }
            }
            catch (JavaModelException e) {
                logger.log(Level.SEVERE, String.format("Failed to get the classpath entry for the PackageFragmentRoot: %s", e.toString()), e);
            }
            ++n2;
        }
        return JavaClassFilter.convertToExclusionPatterns(blackList, whiteList, hardcodePatterns);
    }

    private static boolean isOnBlackList(IPackageFragmentRoot root, int variableScope) throws JavaModelException {
        if (root.isArchive()) {
            if (variableScope == 3) {
                return true;
            }
            boolean isJDK = JavaClassFilter.isJDKPackageFragmentRoot(root);
            return variableScope == 1 && isJDK || variableScope == 2 && !isJDK;
        }
        return false;
    }

    private static boolean isJDKPackageFragmentRoot(IPackageFragmentRoot root) throws JavaModelException {
        if (root.getRawClasspathEntry() != null) {
            IPath path = root.getRawClasspathEntry().getPath();
            return path != null && path.segmentCount() > 0 && Objects.equals(JavaRuntime.JRE_CONTAINER, path.segment(0));
        }
        return false;
    }

    private static void collectPackages(IPackageFragmentRoot root, Set<String> result) throws JavaModelException {
        IJavaElement[] iJavaElementArray = root.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            String elementName = javaElement.getElementName();
            if (javaElement instanceof IPackageFragment && ((IPackageFragment)javaElement).hasChildren() && StringUtils.isNotBlank((CharSequence)elementName)) {
                result.add(elementName);
            }
            ++n2;
        }
    }

    private static String[] convertToExclusionPatterns(Collection<String> blackList, Collection<String> whiteList, Collection<String> hardcodePatterns) {
        List<String> hardcodeBlockedPackages = hardcodePatterns.stream().filter(pattern -> pattern.endsWith(".*")).map(pattern -> pattern.substring(0, pattern.length() - 2)).collect(Collectors.toList());
        Trie hardcodeBlackTree = new Trie(hardcodeBlockedPackages);
        List<String> newWhiteList = whiteList.stream().filter(pattern -> !hardcodeBlackTree.isPrefix((String)pattern)).collect(Collectors.toList());
        Trie whiteTree = new Trie(newWhiteList);
        Trie blackTree = new Trie(blackList);
        JavaClassFilter.superimpose(whiteTree, blackTree);
        ArrayList<String> wildcardPatterns = new ArrayList<String>();
        JavaClassFilter.traverse(blackTree.root, 0, wildcardPatterns, new ArrayList<String>());
        for (String name : hardcodePatterns) {
            if (blackTree.wildcardMatch(name)) continue;
            wildcardPatterns.add(name);
        }
        return wildcardPatterns.toArray(new String[0]);
    }

    private static void superimpose(Trie upTree, Trie downTree) {
        LinkedList<TrieNode> upQueue = new LinkedList<TrieNode>();
        LinkedList<TrieNode> downQueue = new LinkedList<TrieNode>();
        upQueue.offer(upTree.root);
        downQueue.offer(downTree.root);
        while (!upQueue.isEmpty()) {
            TrieNode upNode = (TrieNode)upQueue.poll();
            TrieNode downNode = (TrieNode)downQueue.poll();
            downNode.isGray = true;
            for (Map.Entry<String, TrieNode> entry : upNode.children.entrySet()) {
                if (!downNode.children.containsKey(entry.getKey())) continue;
                upQueue.offer(entry.getValue());
                downQueue.offer(downNode.children.get(entry.getKey()));
            }
        }
    }

    private static void traverse(TrieNode root, int depth, List<String> result, List<String> parent) {
        if (!root.isGray) {
            CharSequence[] names = new String[depth + 1];
            int i = 0;
            while (i < depth - 1) {
                names[i] = parent.get(i);
                ++i;
            }
            names[depth - 1] = root.name;
            names[depth] = "*";
            result.add(String.join((CharSequence)".", names));
            return;
        }
        if (depth > 0) {
            if (parent.size() < depth) {
                parent.add(root.name);
            } else {
                parent.set(depth - 1, root.name);
            }
        }
        for (TrieNode child : root.children.values()) {
            JavaClassFilter.traverse(child, depth + 1, result, parent);
        }
    }

    private static class Trie {
        private TrieNode root = new TrieNode();

        public Trie(Collection<String> names) {
            for (String name : names) {
                this.insert(name);
            }
        }

        public void insert(String name) {
            if (StringUtils.isBlank((CharSequence)name)) {
                return;
            }
            String[] names = name.split("\\.");
            TrieNode currentNode = this.root;
            int i = 0;
            while (i < names.length) {
                TrieNode node;
                if (currentNode.children.containsKey(names[i])) {
                    node = currentNode.children.get(names[i]);
                } else {
                    node = new TrieNode(names[i]);
                    currentNode.children.put(names[i], node);
                }
                currentNode = node;
                ++i;
            }
            currentNode.isLeaf = true;
        }

        public boolean isPrefix(String name) {
            String[] names = name.split("\\.");
            TrieNode currentNode = this.root;
            int i = 0;
            while (i < names.length) {
                TrieNode node = currentNode.children.get(names[i]);
                if (node == null) break;
                currentNode = node;
                ++i;
            }
            return currentNode != this.root && currentNode.isLeaf;
        }

        public boolean wildcardMatch(String name) {
            String[] names = name.split("\\.");
            Map<String, TrieNode> children = this.root.children;
            int i = 0;
            while (i < names.length) {
                TrieNode node = children.get(names[i]);
                if (node == null) break;
                if (!node.isGray) {
                    return true;
                }
                children = node.children;
                ++i;
            }
            return false;
        }
    }

    private static class TrieNode {
        private String name;
        private Map<String, TrieNode> children = new LinkedHashMap<String, TrieNode>();
        private boolean isLeaf = false;
        private boolean isGray = false;

        public TrieNode() {
        }

        public TrieNode(String name) {
            this.name = name;
        }
    }
}

