/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.AlreadyExistsDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.CreateProfileDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;

public abstract class ProfileConfigurationBlock {
    private Composite fComposite;
    private Combo fProfileCombo;
    private Button fEditButton;
    private Button fDeleteButton;
    private Button fNewButton;
    private Button fLoadButton;
    private Button fExportAllButton;
    private PixelConverter fPixConv;
    private final ProfileManager fProfileManager;
    private final IScopeContext fCurrContext;
    private final IScopeContext fInstanceScope;
    private final ProfileStore fProfileStore;
    private final IProfileVersioner fProfileVersioner;
    private final String fLastSaveLoadPathKey;
    private IEclipsePreferences.IPreferenceChangeListener fPreferenceListener;
    private final PreferencesAccess fPreferenceAccess;
    private boolean fPreferenceListenerEnabled;

    public ProfileConfigurationBlock(IProject project, PreferencesAccess access, String lastSaveLoadPathKey) {
        this.fPreferenceAccess = access;
        this.fLastSaveLoadPathKey = lastSaveLoadPathKey;
        this.fProfileVersioner = this.createProfileVersioner();
        this.fProfileStore = this.createProfileStore(this.fProfileVersioner);
        this.fInstanceScope = access.getInstanceScope();
        this.fCurrContext = project != null ? access.getProjectScope(project) : this.fInstanceScope;
        List<ProfileManager.Profile> profiles = null;
        try {
            profiles = this.fProfileStore.readProfiles(this.fInstanceScope);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        if (profiles == null) {
            try {
                profiles = this.fProfileStore.readProfiles(DefaultScope.INSTANCE);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        if (profiles == null) {
            profiles = new ArrayList<ProfileManager.Profile>();
        }
        this.fProfileManager = this.createProfileManager(profiles, this.fCurrContext, access, this.fProfileVersioner);
        new StoreUpdater();
        this.fPreferenceListenerEnabled = true;
        this.fPreferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (ProfileConfigurationBlock.this.fPreferenceListenerEnabled) {
                    ProfileConfigurationBlock.this.preferenceChanged(event);
                }
            }
        };
        access.getInstanceScope().getNode("org.eclipse.jdt.ui").addPreferenceChangeListener(this.fPreferenceListener);
    }

    protected void preferenceChanged(IEclipsePreferences.PreferenceChangeEvent event) {
    }

    protected abstract IProfileVersioner createProfileVersioner();

    protected abstract ProfileStore createProfileStore(IProfileVersioner var1);

    protected abstract ProfileManager createProfileManager(List<ProfileManager.Profile> var1, IScopeContext var2, PreferencesAccess var3, IProfileVersioner var4);

    protected abstract ModifyDialog createModifyDialog(Shell var1, ProfileManager.Profile var2, ProfileManager var3, ProfileStore var4, boolean var5);

    protected abstract void configurePreview(Composite var1, int var2, ProfileManager var3);

    private static Button createButton(Composite composite, String text, int style) {
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        button.setText(text);
        GridData gd = new GridData(style);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        return button;
    }

    public Composite createContents(Composite parent) {
        this.fPixConv = new PixelConverter((Control)parent);
        this.fComposite = this.createComposite(parent, 5);
        Label profileLabel = new Label(this.fComposite, 0);
        profileLabel.setText(PreferencesMessages.CleanUpPreferencePage_Description);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 5;
        profileLabel.setLayoutData((Object)data);
        this.fProfileCombo = ProfileConfigurationBlock.createProfileCombo(this.fComposite, 3, this.fPixConv.convertWidthInCharsToPixels(20));
        this.fEditButton = ProfileConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_edit_button_desc, 32);
        this.fDeleteButton = ProfileConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_remove_button_desc, 32);
        this.fNewButton = ProfileConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_new_button_desc, 32);
        this.fLoadButton = ProfileConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_load_button_desc, 128);
        this.fExportAllButton = ProfileConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_export_all_button_desc, 32);
        ProfileConfigurationBlock.createLabel(this.fComposite, "", 2);
        this.configurePreview(this.fComposite, 5, this.fProfileManager);
        new ButtonController();
        new ProfileComboController();
        return this.fComposite;
    }

    private static Combo createProfileCombo(Composite composite, int span, int widthHint) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = widthHint;
        Combo combo = new Combo(composite, 12);
        combo.setFont(composite.getFont());
        SWTUtil.setDefaultVisibleItemCount(combo);
        combo.setLayoutData((Object)gd);
        return combo;
    }

    protected static Label createLabel(Composite composite, String text, int numColumns) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = numColumns;
        gd.widthHint = 0;
        Label label = new Label(composite, 64);
        label.setFont(composite.getFont());
        label.setText(text);
        label.setLayoutData((Object)gd);
        return label;
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    public final boolean hasProjectSpecificOptions(IProject project) {
        if (project != null) {
            return this.fProfileManager.hasProjectSpecificSettings((IScopeContext)new ProjectScope(project));
        }
        return false;
    }

    public boolean performOk() {
        return true;
    }

    public void performApply() {
        try {
            this.fCurrContext.getNode("org.eclipse.jdt.ui").flush();
            this.fCurrContext.getNode("org.eclipse.jdt.core").flush();
            if (this.fCurrContext != this.fInstanceScope) {
                this.fInstanceScope.getNode("org.eclipse.jdt.ui").flush();
                this.fInstanceScope.getNode("org.eclipse.jdt.core").flush();
            }
        }
        catch (BackingStoreException e) {
            JavaPlugin.log(e);
        }
    }

    public void performDefaults() {
        int defaultIndex;
        ProfileManager.Profile profile = this.fProfileManager.getDefaultProfile();
        if (profile != null && (defaultIndex = this.fProfileManager.getSortedProfiles().indexOf(profile)) != -1) {
            this.fProfileManager.setSelected(profile);
        }
    }

    public void dispose() {
        if (this.fPreferenceListener != null) {
            this.fPreferenceAccess.getInstanceScope().getNode("org.eclipse.jdt.ui").removePreferenceChangeListener(this.fPreferenceListener);
            this.fPreferenceListener = null;
        }
    }

    public void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        if (useProjectSpecificSettings) {
            this.fProfileManager.commitChanges(this.fCurrContext);
        } else {
            this.fProfileManager.clearAllSettings(this.fCurrContext);
        }
    }

    class ButtonController
    implements Observer,
    SelectionListener {
        public ButtonController() {
            ProfileConfigurationBlock.this.fProfileManager.addObserver(this);
            ProfileConfigurationBlock.this.fNewButton.addSelectionListener((SelectionListener)this);
            ProfileConfigurationBlock.this.fEditButton.addSelectionListener((SelectionListener)this);
            ProfileConfigurationBlock.this.fDeleteButton.addSelectionListener((SelectionListener)this);
            ProfileConfigurationBlock.this.fLoadButton.addSelectionListener((SelectionListener)this);
            ProfileConfigurationBlock.this.fExportAllButton.addSelectionListener((SelectionListener)this);
            this.update(ProfileConfigurationBlock.this.fProfileManager, null);
        }

        @Override
        public void update(Observable o, Object arg) {
            ProfileManager.Profile selected = ((ProfileManager)o).getSelected();
            boolean notBuiltIn = !selected.isBuiltInProfile();
            ProfileConfigurationBlock.this.fDeleteButton.setEnabled(notBuiltIn);
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            if (button == ProfileConfigurationBlock.this.fEditButton) {
                this.modifyButtonPressed();
            } else if (button == ProfileConfigurationBlock.this.fDeleteButton) {
                this.deleteButtonPressed();
            } else if (button == ProfileConfigurationBlock.this.fNewButton) {
                this.newButtonPressed();
            } else if (button == ProfileConfigurationBlock.this.fLoadButton) {
                this.loadButtonPressed();
            } else if (button == ProfileConfigurationBlock.this.fExportAllButton) {
                this.exportAllButtonPressed();
            }
        }

        private void exportAllButtonPressed() {
            String path;
            FileDialog dialog = new FileDialog(ProfileConfigurationBlock.this.fComposite.getShell(), 8192);
            dialog.setText(FormatterMessages.CodingStyleConfigurationBlock_export_profiles_dialog_title);
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = JavaPlugin.getDefault().getDialogSettings().get(String.valueOf(ProfileConfigurationBlock.this.fLastSaveLoadPathKey) + ".loadpath");
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            JavaPlugin.getDefault().getDialogSettings().put(String.valueOf(ProfileConfigurationBlock.this.fLastSaveLoadPathKey) + ".savepath", dialog.getFilterPath());
            File file = new File(path);
            if (file.exists() && !MessageDialog.openQuestion((Shell)ProfileConfigurationBlock.this.fComposite.getShell(), (String)FormatterMessages.CodingStyleConfigurationBlock_export_profiles_overwrite_title, (String)Messages.format(FormatterMessages.CodingStyleConfigurationBlock_export_profiles_overwrite_message, BasicElementLabels.getPathLabel(file)))) {
                return;
            }
            String encoding = "UTF-8";
            IContentType type = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.xml");
            if (type != null) {
                encoding = type.getDefaultCharset();
            }
            ArrayList<ProfileManager.Profile> profiles = new ArrayList<ProfileManager.Profile>();
            profiles.addAll(ProfileConfigurationBlock.this.fProfileManager.getSortedProfiles());
            try {
                ProfileConfigurationBlock.this.fProfileStore.writeProfilesToFile(profiles, file, encoding);
            }
            catch (CoreException e) {
                String title = FormatterMessages.CodingStyleConfigurationBlock_export_profiles_error_title;
                String message = FormatterMessages.CodingStyleConfigurationBlock_export_profiles_error_message;
                ExceptionHandler.handle(e, ProfileConfigurationBlock.this.fComposite.getShell(), title, message);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void modifyButtonPressed() {
            ModifyDialog modifyDialog = ProfileConfigurationBlock.this.createModifyDialog(ProfileConfigurationBlock.this.fComposite.getShell(), ProfileConfigurationBlock.this.fProfileManager.getSelected(), ProfileConfigurationBlock.this.fProfileManager, ProfileConfigurationBlock.this.fProfileStore, false);
            modifyDialog.open();
        }

        private void deleteButtonPressed() {
            if (MessageDialog.openQuestion((Shell)ProfileConfigurationBlock.this.fComposite.getShell(), (String)FormatterMessages.CodingStyleConfigurationBlock_delete_confirmation_title, (String)Messages.format(FormatterMessages.CodingStyleConfigurationBlock_delete_confirmation_question, ProfileConfigurationBlock.this.fProfileManager.getSelected().getName()))) {
                ProfileConfigurationBlock.this.fProfileManager.deleteSelected();
            }
        }

        private void newButtonPressed() {
            CreateProfileDialog p = new CreateProfileDialog(ProfileConfigurationBlock.this.fComposite.getShell(), ProfileConfigurationBlock.this.fProfileManager, ProfileConfigurationBlock.this.fProfileVersioner);
            if (p.open() != 0) {
                return;
            }
            if (!p.openEditDialog()) {
                return;
            }
            ModifyDialog modifyDialog = ProfileConfigurationBlock.this.createModifyDialog(ProfileConfigurationBlock.this.fComposite.getShell(), p.getCreatedProfile(), ProfileConfigurationBlock.this.fProfileManager, ProfileConfigurationBlock.this.fProfileStore, true);
            modifyDialog.open();
        }

        private void loadButtonPressed() {
            String path;
            FileDialog dialog = new FileDialog(ProfileConfigurationBlock.this.fComposite.getShell(), 4096);
            dialog.setText(FormatterMessages.CodingStyleConfigurationBlock_load_profile_dialog_title);
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = JavaPlugin.getDefault().getDialogSettings().get(String.valueOf(ProfileConfigurationBlock.this.fLastSaveLoadPathKey) + ".loadpath");
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            JavaPlugin.getDefault().getDialogSettings().put(String.valueOf(ProfileConfigurationBlock.this.fLastSaveLoadPathKey) + ".loadpath", dialog.getFilterPath());
            File file = new File(path);
            List<ProfileManager.Profile> profiles = null;
            try {
                profiles = ProfileConfigurationBlock.this.fProfileStore.readProfilesFromFile(file);
            }
            catch (CoreException e) {
                String string = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_title;
                String message = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_message;
                ExceptionHandler.handle(e, ProfileConfigurationBlock.this.fComposite.getShell(), string, message);
            }
            if (profiles == null || profiles.isEmpty()) {
                return;
            }
            for (ProfileManager.CustomProfile customProfile : profiles) {
                AlreadyExistsDialog aeDialog;
                String message;
                String title;
                if (!ProfileConfigurationBlock.this.fProfileVersioner.getProfileKind().equals(customProfile.getKind())) {
                    title = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_title;
                    message = Messages.format(FormatterMessages.ProfileConfigurationBlock_load_profile_wrong_profile_message, new String[]{ProfileConfigurationBlock.this.fProfileVersioner.getProfileKind(), customProfile.getKind()});
                    MessageDialog.openError((Shell)ProfileConfigurationBlock.this.fComposite.getShell(), (String)title, (String)message);
                    return;
                }
                if (customProfile.getVersion() > ProfileConfigurationBlock.this.fProfileVersioner.getCurrentVersion()) {
                    title = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_too_new_title;
                    message = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_too_new_message;
                    MessageDialog.openWarning((Shell)ProfileConfigurationBlock.this.fComposite.getShell(), (String)title, (String)message);
                }
                if (ProfileConfigurationBlock.this.fProfileManager.containsName(customProfile.getName()) && (aeDialog = new AlreadyExistsDialog(ProfileConfigurationBlock.this.fComposite.getShell(), customProfile, ProfileConfigurationBlock.this.fProfileManager)).open() != 0) {
                    return;
                }
                ProfileConfigurationBlock.this.fProfileVersioner.update(customProfile);
                ProfileConfigurationBlock.this.fProfileManager.addProfile(customProfile);
            }
        }
    }

    class ProfileComboController
    implements Observer,
    SelectionListener {
        private final List<ProfileManager.Profile> fSortedProfiles;

        public ProfileComboController() {
            this.fSortedProfiles = ProfileConfigurationBlock.this.fProfileManager.getSortedProfiles();
            ProfileConfigurationBlock.this.fProfileCombo.addSelectionListener((SelectionListener)this);
            ProfileConfigurationBlock.this.fProfileManager.addObserver(this);
            this.updateProfiles();
            this.updateSelection();
        }

        public void widgetSelected(SelectionEvent e) {
            int index = ProfileConfigurationBlock.this.fProfileCombo.getSelectionIndex();
            ProfileConfigurationBlock.this.fProfileManager.setSelected(this.fSortedProfiles.get(index));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        @Override
        public void update(Observable o, Object arg) {
            if (arg == null) {
                return;
            }
            int value = (Integer)arg;
            switch (value) {
                case 2: 
                case 3: 
                case 4: {
                    this.updateProfiles();
                    this.updateSelection();
                    break;
                }
                case 1: {
                    this.updateSelection();
                }
            }
        }

        private void updateProfiles() {
            ProfileConfigurationBlock.this.fProfileCombo.setItems(ProfileConfigurationBlock.this.fProfileManager.getSortedDisplayNames());
        }

        private void updateSelection() {
            ProfileConfigurationBlock.this.fProfileCombo.setText(ProfileConfigurationBlock.this.fProfileManager.getSelected().getName());
        }
    }

    private class StoreUpdater
    implements Observer {
        public StoreUpdater() {
            ProfileConfigurationBlock.this.fProfileManager.addObserver(this);
        }

        @Override
        public void update(Observable o, Object arg) {
            try {
                ProfileConfigurationBlock.this.fPreferenceListenerEnabled = false;
                int value = (Integer)arg;
                switch (value) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        try {
                            ProfileConfigurationBlock.this.fProfileStore.writeProfiles(ProfileConfigurationBlock.this.fProfileManager.getSortedProfiles(), ProfileConfigurationBlock.this.fInstanceScope);
                            ProfileConfigurationBlock.this.fProfileManager.commitChanges(ProfileConfigurationBlock.this.fCurrContext);
                        }
                        catch (CoreException x) {
                            JavaPlugin.log(x);
                        }
                        break;
                    }
                    case 1: {
                        ProfileConfigurationBlock.this.fProfileManager.commitChanges(ProfileConfigurationBlock.this.fCurrContext);
                    }
                }
            }
            finally {
                ProfileConfigurationBlock.this.fPreferenceListenerEnabled = true;
            }
        }
    }
}

