/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.javadoc;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.viewers.StyledString;

public class JavadocInlineTagCompletionProposal
extends LazyJavaCompletionProposal {
    protected static final char[] JDOC_INLINE_TAG_TRIGGERS = new char[]{'#', '}', ' '};

    public JavadocInlineTagCompletionProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context) {
        super(proposal, context);
        Assert.isTrue((boolean)this.isInJavadoc());
    }

    @Override
    protected String computeReplacementString() {
        String replacement = super.computeReplacementString();
        return replacement;
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        boolean needsLinkedMode = true;
        if (needsLinkedMode) {
            this.setCursorPosition(this.getCursorPosition() - 1);
        }
        super.apply(document, trigger, offset);
        if (needsLinkedMode) {
            this.setUpLinkedMode(document, '}');
        }
    }

    @Override
    protected boolean isPrefix(String pattern, String string) {
        if (string.charAt(0) == '{') {
            string = string.substring(1);
        }
        if (pattern.charAt(0) == '{') {
            pattern = pattern.substring(1);
        }
        return super.isPrefix(pattern, string);
    }

    @Override
    public StyledString getStyledDisplayString(IDocument document, int offset, BoldStylerProvider boldStylerProvider) {
        StyledString styledDisplayString = new StyledString();
        styledDisplayString.append(this.getStyledDisplayString());
        String pattern = this.getPatternToEmphasizeMatch(document, offset);
        if (pattern != null && pattern.length() > 0) {
            boolean patternHasBrace;
            String displayString = styledDisplayString.getString().substring(1);
            boolean bl = patternHasBrace = pattern.charAt(0) == '{';
            if (patternHasBrace) {
                pattern = pattern.substring(1);
            }
            if (displayString.charAt(0) == '@' && pattern.charAt(0) == '@') {
                int patternMatchRule;
                displayString = displayString.substring(1);
                int[] matchingRegions = SearchPattern.getMatchingRegions((String)(pattern = pattern.substring(1)), (String)displayString, (int)(patternMatchRule = this.getPatternMatchRule(pattern, displayString)));
                if (matchingRegions != null) {
                    if (patternHasBrace) {
                        int[] nArray = new int[2];
                        nArray[1] = 1;
                        Strings.markMatchingRegions(styledDisplayString, 0, nArray, boldStylerProvider.getBoldStyler());
                    }
                    Strings.markMatchingRegions(styledDisplayString, 0, new int[]{1, 1}, boldStylerProvider.getBoldStyler());
                    int i = 0;
                    while (i < matchingRegions.length) {
                        int n = i;
                        matchingRegions[n] = matchingRegions[n] + 2;
                        i += 2;
                    }
                }
                Strings.markMatchingRegions(styledDisplayString, 0, matchingRegions, boldStylerProvider.getBoldStyler());
            }
        }
        return styledDisplayString;
    }
}

