/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.comparator;

import org.eclipse.pde.api.tools.internal.comparator.TypeParameterDescriptor;

class SignatureDescriptor {
    private static final TypeParameterDescriptor[] EMPTY_TYPE_PARAMETER_DESCRIPTORS = new TypeParameterDescriptor[0];
    private static final String[] EMPTY_TYPE_ARGUMENTS = new String[0];
    static final int INITIAL_SIZE = 1;
    TypeParameterDescriptor currentTypeParameterDescriptor;
    String superClass;
    TypeParameterDescriptor[] typeParameterDescriptors;
    int typeParameterDescriptorsCounter;
    String[] typeArguments;
    int typeArgumentsCounter;

    public void addInterfaceBound(String bound) {
        this.currentTypeParameterDescriptor.addInterfaceBound(bound);
    }

    public void addTypeArgument(String typeArgument) {
        if (this.typeArguments == null) {
            this.typeArguments = new String[1];
            this.typeArgumentsCounter = 0;
        } else {
            int length = this.typeArguments.length;
            if (length == this.typeArgumentsCounter) {
                this.typeArguments = new String[length * 2];
                System.arraycopy(this.typeArguments, 0, this.typeArguments, 0, length);
            }
        }
        this.typeArguments[this.typeArgumentsCounter++] = typeArgument;
    }

    public void addTypeParameterDescriptor(String name) {
        TypeParameterDescriptor typeParameterDescriptor;
        if (this.typeParameterDescriptors == null) {
            this.typeParameterDescriptors = new TypeParameterDescriptor[1];
            this.typeParameterDescriptorsCounter = 0;
        } else {
            int length = this.typeParameterDescriptors.length;
            if (this.typeParameterDescriptorsCounter == length) {
                this.typeParameterDescriptors = new TypeParameterDescriptor[length * 2];
                System.arraycopy(this.typeParameterDescriptors, 0, this.typeParameterDescriptors, 0, length);
            }
        }
        this.currentTypeParameterDescriptor = typeParameterDescriptor = new TypeParameterDescriptor(name);
        this.typeParameterDescriptors[this.typeParameterDescriptorsCounter++] = typeParameterDescriptor;
    }

    public TypeParameterDescriptor[] getTypeParameterDescriptors() {
        if (this.typeParameterDescriptors == null) {
            return EMPTY_TYPE_PARAMETER_DESCRIPTORS;
        }
        int length = this.typeParameterDescriptors.length;
        if (this.typeParameterDescriptorsCounter != length) {
            this.typeParameterDescriptors = new TypeParameterDescriptor[this.typeParameterDescriptorsCounter];
            System.arraycopy(this.typeParameterDescriptors, 0, this.typeParameterDescriptors, 0, this.typeParameterDescriptorsCounter);
        }
        return this.typeParameterDescriptors;
    }

    public String[] getTypeArguments() {
        if (this.typeArguments == null) {
            return EMPTY_TYPE_ARGUMENTS;
        }
        int length = this.typeArguments.length;
        if (this.typeArgumentsCounter != length) {
            this.typeArguments = new String[this.typeArgumentsCounter];
            System.arraycopy(this.typeArguments, 0, this.typeArguments, 0, this.typeArgumentsCounter);
        }
        return this.typeArguments;
    }

    public void setClassBound(String bound) {
        this.currentTypeParameterDescriptor.setClassBound(bound);
    }

    public void setSuperclass(String superclass) {
        this.superClass = superclass;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int max = this.typeParameterDescriptorsCounter;
        while (i < max) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(this.typeParameterDescriptors[i]);
            ++i;
        }
        buffer.append("superclass: " + this.superClass);
        i = 0;
        max = this.typeArgumentsCounter;
        while (i < max) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(this.typeArguments[i]);
            ++i;
        }
        return String.valueOf(buffer);
    }
}

