/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.editor.utils.AdapterFactoryDescriptor;

public final class AdapterUtils {
    private static final String ADAPTER_FACTORY_EXTENSION_POINT = "org.eclipse.emf.edit.itemProviderAdapterFactories";
    private static Map<String, AdapterFactoryDescriptor> factories = new HashMap<String, AdapterFactoryDescriptor>();

    static {
        AdapterUtils.parseExtensionMetadata();
    }

    private AdapterUtils() {
    }

    public static AdapterFactory findAdapterFactory(String nsURI) {
        AdapterFactory adapterFactory = null;
        if (factories.containsKey(nsURI)) {
            adapterFactory = factories.get(nsURI).getAdapterInstance();
        }
        return adapterFactory;
    }

    public static AdapterFactory findAdapterFactory(EObject eObj) {
        String uri = eObj.eClass().getEPackage().getNsURI();
        return AdapterUtils.findAdapterFactory(uri);
    }

    private static void parseExtensionMetadata() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(ADAPTER_FACTORY_EXTENSION_POINT).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                AdapterFactoryDescriptor desc = AdapterUtils.parseAdapterFactory(configElements[j]);
                factories.put(desc.getNsURI(), desc);
                ++j;
            }
            ++i;
        }
    }

    private static AdapterFactoryDescriptor parseAdapterFactory(IConfigurationElement configElements) {
        AdapterFactoryDescriptor desc = new AdapterFactoryDescriptor(configElements);
        return desc;
    }
}

