/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.polarsys.time4sys.builder.design.DesignBuilder;
import org.polarsys.time4sys.builder.simulation.SimulationBuilder;
import org.polarsys.time4sys.design.DesignFactory;
import org.polarsys.time4sys.design.DesignModel;
import org.polarsys.time4sys.marte.gqam.GqamFactory;
import org.polarsys.time4sys.marte.grm.GrmFactory;
import org.polarsys.time4sys.marte.hrm.HrmFactory;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.srm.SrmFactory;
import org.polarsys.time4sys.model.time4sys.Project;
import org.polarsys.time4sys.model.time4sys.Simulation;
import org.polarsys.time4sys.model.time4sys.Time4sysFactory;
import org.polarsys.time4sys.model.time4sys.impl.Time4sysPackageImpl;

public class ProjectBuilder {
    protected static DesignFactory df = DesignFactory.eINSTANCE;
    protected static GqamFactory gqamFactory = GqamFactory.eINSTANCE;
    protected static SrmFactory srmFactory = SrmFactory.eINSTANCE;
    protected static GrmFactory grmFactory = GrmFactory.eINSTANCE;
    protected static HrmFactory hrmFactory = HrmFactory.eINSTANCE;
    protected static NfpFactory nfpFactory = NfpFactory.eINSTANCE;
    private final Project project;
    private final DesignBuilder design;

    public ProjectBuilder() {
        this((Project)null);
    }

    public ProjectBuilder(DesignBuilder designBuilder) {
        if (designBuilder == null) {
            throw new IllegalArgumentException("designBuilder must not be null");
        }
        this.design = designBuilder;
        if (this.design.build().eContainer() instanceof Project) {
            this.project = (Project)this.design.build().eContainer();
        } else {
            this.project = Time4sysFactory.eINSTANCE.createProject();
            this.project.setDesign(this.design.build());
        }
        assert (this.design != null);
        assert (this.project.getDesign() == this.design.build());
    }

    public ProjectBuilder(Project prj) {
        this.project = prj == null ? Time4sysFactory.eINSTANCE.createProject() : prj;
        DesignModel designModel = this.project.getDesign();
        this.design = new DesignBuilder(this, designModel);
        this.project.setDesign(this.design.build());
        assert (this.design != null);
        assert (this.project.getDesign() == this.design.build());
    }

    public ProjectBuilder(String filepath) {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("time4sys", new XMIResourceFactoryImpl());
        Time4sysPackageImpl.init();
        ResourceSetImpl resSet = new ResourceSetImpl();
        URI uri = URI.createFileURI((String)filepath);
        Resource resource = resSet.getResource(uri, true);
        EObject root = (EObject)resource.getContents().get(0);
        if (root instanceof Project) {
            this.project = (Project)root;
            this.design = new DesignBuilder(this.project.getDesign());
        } else if (root instanceof DesignModel) {
            this.design = new DesignBuilder((DesignModel)root);
            this.project = Time4sysFactory.eINSTANCE.createProject();
            this.project.setDesign((DesignModel)root);
        } else {
            throw new IllegalArgumentException("Cannot load " + root.getClass().getSimpleName() + " as a Project");
        }
    }

    public DesignBuilder design() {
        assert (this.project.getDesign() == this.design.build());
        return this.design;
    }

    public Project build() {
        this.design.build();
        return this.project;
    }

    public void saveDesignAsEcore(String pathName) throws IOException {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("design", new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        URI uri = URI.createFileURI((String)pathName);
        Resource resource = resSet.createResource(uri);
        assert (resource != null);
        EList contents = resource.getContents();
        DesignModel designModel = this.design.build();
        contents.add((Object)designModel);
        resource.save(new HashMap());
        this.project.setDesign(designModel);
    }

    public void saveAsEcore(String pathName) throws IOException {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("time4sys", new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        URI uri = URI.createFileURI((String)pathName);
        Resource resource = resSet.createResource(uri);
        assert (resource != null);
        EList contents = resource.getContents();
        Project theProject = this.build();
        contents.add((Object)theProject);
        resource.save(new HashMap());
    }

    public ProjectBuilder isNamed(String name) {
        this.project.setName(name);
        return this;
    }

    public SimulationBuilder hasASimulation() {
        Simulation theSimu = Time4sysFactory.eINSTANCE.createSimulation();
        this.project.getSimulations().add((Object)theSimu);
        return new SimulationBuilder(this, theSimu);
    }
}

