/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.actions;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.SelectionUtils;
import org.eclipse.titanium.utils.ProjectAnalyzerJob;
import org.eclipse.titanium.utils.SonarDataExporter;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ExportDataForSonarAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage iwPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        List res = SelectionUtils.getProjectsFromSelection((ISelection)iwPage.getSelection());
        for (final IProject project : res) {
            new ProjectAnalyzerJob("Exporting sonar data for project " + project.getName()){

                @Override
                public IStatus doPostWork(IProgressMonitor monitor) {
                    try {
                        SonarDataExporter exporter = new SonarDataExporter(project);
                        exporter.exportDataForProject();
                    }
                    catch (IOException e) {
                        ErrorReporter.logExceptionStackTrace((String)("Error while exporting data for project " + project.getName()), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.quickSchedule(project);
        }
        return null;
    }
}

