/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.clustering;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.titanium.graph.clustering.PathCluster;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;

public class FolderNameCluster
extends PathCluster {
    public FolderNameCluster(DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> graph, IProject project) {
        super(graph, project);
    }

    @Override
    protected void checkProject(IProgressMonitor progress) throws CoreException {
        progress.subTask("Checking " + this.project.getName());
        IResource[] contents = this.project.members();
        HashSet<NodeDescriptor> cluster = new HashSet<NodeDescriptor>();
        for (IResource content : contents) {
            this.check(content, cluster, progress);
        }
        if (!cluster.isEmpty()) {
            this.clusters.add(cluster);
            this.mapNameCluster.put("/", cluster);
        }
    }

    protected void checkFile(IFile file, Set<NodeDescriptor> cluster) {
        String name = this.parser.containedModuleName(file);
        if (name == null) {
            return;
        }
        this.addNodeToCluster(name, cluster);
    }

    protected void checkFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Checking " + folder.getName());
        IResource[] contents = folder.members();
        HashSet<NodeDescriptor> cluster = new HashSet<NodeDescriptor>();
        for (IResource nextContent : contents) {
            this.check(nextContent, cluster, monitor);
        }
        this.addNewCluster(cluster, folder);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.worked(1);
    }

    protected void addNewCluster(Set<NodeDescriptor> cluster, IFolder folder) {
        if (!cluster.isEmpty()) {
            this.clusters.add(cluster);
            this.mapNameCluster.put(folder.getProjectRelativePath().toOSString(), cluster);
        }
    }

    protected void check(IResource content, Set<NodeDescriptor> cluster, IProgressMonitor monitor) throws CoreException {
        switch (content.getType()) {
            case 1: {
                this.checkFile((IFile)content, cluster);
                break;
            }
            case 2: {
                this.checkFolder((IFolder)content, monitor);
                break;
            }
        }
    }

    @Override
    protected String getType() {
        return "Clustering by folder name";
    }
}

