/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.components;

import java.awt.Color;
import java.awt.Font;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titanium.graph.components.NodeColours;

public class NodeDescriptor
implements Comparable<NodeDescriptor> {
    protected Color nodeColour = NodeColours.NO_VALUE_COLOUR;
    protected Color fontColour;
    protected Font fontType;
    protected String nodeName;
    protected String displayName;
    protected IProject project;
    protected boolean isMissingModule;
    protected Set<NodeDescriptor> cluster;
    protected final Location referencedLocation;

    public NodeDescriptor(String displayName, String name, Color colour, IProject proj, boolean missing, Location loc) {
        this.displayName = displayName;
        this.nodeName = name;
        this.nodeColour = colour;
        this.project = proj;
        this.isMissingModule = missing;
        this.cluster = null;
        this.fontColour = Color.white;
        this.fontType = new Font("Arial", 0, 12);
        this.referencedLocation = loc;
    }

    public NodeDescriptor(String displayName, String name, IProject proj, boolean missing, Location loc) {
        this(displayName, name, NodeColours.NO_VALUE_COLOUR, proj, missing, loc);
    }

    public NodeDescriptor(String displayName, String name) {
        this(displayName, name, NodeColours.NO_VALUE_COLOUR, null, false, null);
    }

    public NodeDescriptor(String name) {
        this(name, name, NodeColours.NO_VALUE_COLOUR, null, false, null);
    }

    public String getName() {
        return this.nodeName;
    }

    public Color getColor() {
        return this.nodeColour;
    }

    public String getDisplayName() {
        if (this.displayName != null && this.displayName.length() > 0) {
            return this.displayName;
        }
        return this.nodeName;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setNodeColour(Color c) {
        this.nodeColour = c;
    }

    public void setFontColour(Color c) {
        this.fontColour = c;
    }

    public Color getFontColour() {
        return this.fontColour;
    }

    public void setFontType(Font font) {
        this.fontType = font;
    }

    public Font getFontType() {
        return this.fontType;
    }

    public boolean isMissing() {
        return this.isMissingModule;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NodeDescriptor)) {
            return false;
        }
        NodeDescriptor instance = (NodeDescriptor)obj;
        return instance.getName().equals(this.nodeName);
    }

    public int hashCode() {
        return this.nodeName.hashCode();
    }

    public Set<NodeDescriptor> getCluster() {
        return this.cluster;
    }

    public void setCluster(Set<NodeDescriptor> cluster) {
        this.cluster = cluster;
    }

    public Location getLocation() {
        return this.referencedLocation;
    }

    @Override
    public int compareTo(NodeDescriptor other) {
        return this.displayName.compareTo(other.displayName);
    }
}

