/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.common;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PluggableGraphMouse;
import edu.uci.ics.jung.visualization.control.ViewTranslatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.gui.menus.NodePopupMenu;

public class CustomVisualizationViewer
extends VisualizationViewer<NodeDescriptor, EdgeDescriptor> {
    private static final long serialVersionUID = 1736343406579424405L;

    public CustomVisualizationViewer(Layout<NodeDescriptor, EdgeDescriptor> layout, final NodePopupMenu popupMenu) {
        super(layout);
        GraphMouseListener<NodeDescriptor> nodeMouseEvents = new GraphMouseListener<NodeDescriptor>(){

            public void graphReleased(NodeDescriptor arg0, MouseEvent arg1) {
            }

            public void graphPressed(NodeDescriptor node, MouseEvent e) {
                if (e.getButton() == 3 && popupMenu != null) {
                    popupMenu.show(node, e.getX(), e.getY());
                }
            }

            public void graphClicked(NodeDescriptor arg0, MouseEvent arg1) {
            }
        };
        final CustomVisualizationViewer thisViewer = this;
        PluggableGraphMouse mouse = new PluggableGraphMouse(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                float scale = e.getWheelRotation() > 0 ? 0.9f : 1.1f;
                CrossoverScalingControl control = new CrossoverScalingControl();
                control.scale((VisualizationServer)thisViewer, scale, CustomVisualizationViewer.this.getCenter());
            }
        };
        mouse.add((GraphMousePlugin)new ViewTranslatingGraphMousePlugin(4));
        PickingGraphMousePlugin<NodeDescriptor, EdgeDescriptor> pickingMouse = new PickingGraphMousePlugin<NodeDescriptor, EdgeDescriptor>(){

            public void mouseDragged(MouseEvent e) {
                if (this.down == null) {
                    return;
                }
                super.mouseDragged(e);
            }
        };
        mouse.add((GraphMousePlugin)pickingMouse);
        KeyListener keyboardEvents = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                char pressed = e.getKeyChar();
                if (pressed != '-' && pressed != '+') {
                    return;
                }
                float scale = 1.0f;
                scale = pressed == '-' ? 0.9f : 1.1f;
                CrossoverScalingControl control = new CrossoverScalingControl();
                control.scale((VisualizationServer)thisViewer, scale, CustomVisualizationViewer.this.getCenter());
            }
        };
        this.setGraphMouse((VisualizationViewer.GraphMouse)mouse);
        this.addGraphMouseListener((GraphMouseListener)nodeMouseEvents);
        this.addKeyListener(keyboardEvents);
    }

    public void jumpToPlace(Point2D place) {
        MutableTransformer modelTransformerMaster = this.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
        Point2D orig = this.getRenderContext().getMultiLayerTransformer().inverseTransform(this.getCenter());
        modelTransformerMaster.translate(orig.getX() - place.getX(), orig.getY() - place.getY());
    }
}

