/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.visualization;

import java.awt.Color;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titanium.graph.components.NodeColours;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.gui.menus.MeasureableNodePopupMenu;
import org.eclipse.titanium.graph.visualization.GraphHandler;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.utils.ModuleMetricsWrapper;
import org.eclipse.titanium.metrics.utils.RiskLevel;
import org.eclipse.titanium.metrics.utils.WrapperStore;

public class MeasureableGraphHandler
extends GraphHandler {
    protected IMetricEnum chosenColouringMetric;

    public MeasureableGraphHandler(Shell parent) {
        this.popupMenu = new MeasureableNodePopupMenu(this, parent);
    }

    public Color calculateColour(NodeDescriptor node, IMetricEnum metric) {
        Color actColor;
        this.chosenColouringMetric = metric;
        if (node.isMissing()) {
            node.setNodeColour(NodeColours.MISSING_COLOUR);
            return NodeColours.MISSING_COLOUR;
        }
        ModuleMetricsWrapper actProvider = WrapperStore.getWrapper(node.getProject());
        RiskLevel rColor = actProvider.getRisk(metric, node.getName());
        switch (rColor) {
            case NO: {
                actColor = NodeColours.DARK_GREEN;
                break;
            }
            case LOW: {
                actColor = NodeColours.DARK_YELLOW;
                break;
            }
            case HIGH: {
                actColor = NodeColours.DARK_RED;
                break;
            }
            default: {
                actColor = NodeColours.NO_VALUE_COLOUR;
            }
        }
        node.setNodeColour(actColor);
        return actColor;
    }

    public void enableInfoWindow(boolean value) {
        ((MeasureableNodePopupMenu)this.popupMenu).enableInfoWindow(value);
    }

    public final IMetricEnum getChosenMetric() {
        return this.chosenColouringMetric;
    }
}

