/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.handler;

import org.eclipse.core.resources.IResource;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class Marker {
    private final Location loc;
    private final String message;
    private final int severity;
    private final CodeSmellType problemType;

    public Marker(Location loc, String message, int severity, CodeSmellType problemType) {
        this.loc = loc;
        this.message = message;
        this.severity = severity;
        this.problemType = problemType;
    }

    public Marker(IResource res, String message, int severity, CodeSmellType problemType) {
        this.loc = new Location(res);
        this.message = message;
        this.severity = severity;
        this.problemType = problemType;
    }

    public IResource getResource() {
        return this.loc.getFile();
    }

    public int getLine() {
        return this.loc.getLine();
    }

    public int getCharBegin() {
        return this.loc.getOffset();
    }

    public int getCharEnd() {
        return this.loc.getEndOffset();
    }

    public String getMessage() {
        return this.message;
    }

    public CodeSmellType getProblemType() {
        return this.problemType;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void show() {
        this.loc.reportExternalProblem(this.message, this.severity, 0, "org.eclipse.titanium.markers.CodeSmellMarker");
    }
}

