/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class DuplicateName
extends BaseModuleCodeSmellSpotter {
    public static final String SIMILARDEFINITIONREPEATED = "Multiple definitions with similar names `{0}'', `{1}'' were found";
    protected final CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();

    public DuplicateName() {
        super(CodeSmellType.DUPLICATE_NAME);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (!(node instanceof TTCN3Module)) {
            return;
        }
        HashMap<String, Assignment> names = new HashMap<String, Assignment>();
        Assignments assignments = ((TTCN3Module)node).getAssignments();
        for (int i = 0; i < assignments.getNofAssignments(); ++i) {
            Assignment assignment = assignments.getAssignmentByIndex(i);
            String sUp = assignment.getIdentifier().getDisplayName().toUpperCase();
            if (names.containsKey(sUp)) {
                problems.report(assignment.getIdentifier().getLocation(), MessageFormat.format(SIMILARDEFINITIONREPEATED, ((Assignment)names.get(sUp)).getIdentifier().getDisplayName(), assignment.getIdentifier().getDisplayName()));
                continue;
            }
            names.put(sUp, assignment);
        }
        names.clear();
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(TTCN3Module.class);
        return ret;
    }
}

