/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ExternalConst;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class NonprivatePrivate
extends BaseModuleCodeSmellSpotter {
    private static final String SHOULD_BE_PRIVATE = "{0} is referenced only locally, it should be private";

    public NonprivatePrivate() {
        super(CodeSmellType.NONPRIVATE_PRIVATE);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (!(node instanceof Definition)) {
            return;
        }
        Definition d = (Definition)node;
        if (d.isUsed() && d.referingHere.size() == 1 && !VisibilityModifier.Private.equals((Object)d.getVisibilityModifier()) && !d.isLocal()) {
            String moduleName = d.getMyScope().getModuleScope().getName();
            if (((String)d.referingHere.get(0)).equals(moduleName)) {
                String msg = MessageFormat.format(SHOULD_BE_PRIVATE, d.getIdentifier().getDisplayName());
                problems.report(d.getIdentifier().getLocation(), msg);
            }
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(8);
        ret.add(Def_Altstep.class);
        ret.add(Def_Const.class);
        ret.add(Def_ExternalConst.class);
        ret.add(Def_Extfunction.class);
        ret.add(Def_Function.class);
        ret.add(Def_ModulePar.class);
        ret.add(Def_Template.class);
        ret.add(Def_Type.class);
        return ret;
    }
}

