/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class RunsOnScopeReduction
extends BaseModuleCodeSmellSpotter {
    public RunsOnScopeReduction() {
        super(CodeSmellType.RUNS_ON_SCOPE_REDUCTION);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        Identifier identifier;
        Identifier componentIdentifier;
        Component_Type componentType;
        Def_Function variable;
        CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();
        boolean isTestCase = false;
        if (node instanceof Def_Function) {
            variable = (Def_Function)node;
            componentType = variable.getRunsOnType(timestamp);
            if (componentType == null) {
                return;
            }
            componentIdentifier = componentType.getComponentBody().getIdentifier();
            identifier = variable.getIdentifier();
        } else if (node instanceof Def_Altstep) {
            variable = (Def_Altstep)node;
            componentType = variable.getRunsOnType(timestamp);
            if (componentType == null) {
                return;
            }
            componentIdentifier = componentType.getComponentBody().getIdentifier();
            identifier = variable.getIdentifier();
        } else {
            variable = (Def_Testcase)node;
            componentType = variable.getRunsOnType(timestamp);
            if (componentType == null) {
                return;
            }
            componentIdentifier = componentType.getComponentBody().getIdentifier();
            identifier = variable.getIdentifier();
            isTestCase = true;
        }
        ReferenceCheck chek = new ReferenceCheck();
        node.accept((ASTVisitor)chek);
        HashSet<Identifier> definitions = new HashSet<Identifier>();
        definitions.addAll(chek.getIdentifiers());
        if (definitions.isEmpty()) {
            if (isTestCase) {
                List attributes = componentType.getComponentBody().getDefinitions();
                if (!attributes.isEmpty()) {
                    problems.report(identifier.getLocation(), MessageFormat.format("The runs on component `{0}'' seems to be never used. Use empty component.", componentIdentifier.getDisplayName()));
                }
            } else {
                problems.report(identifier.getLocation(), MessageFormat.format("The runs on component `{0}'' seems to be never used, can be removed.", componentIdentifier.getDisplayName()));
            }
        } else if (!definitions.contains(componentIdentifier)) {
            if (definitions.size() == 1) {
                Identifier id = (Identifier)definitions.iterator().next();
                problems.report(identifier.getLocation(), MessageFormat.format("The runs on component `{0}'' seems to be never used. Use `{1}'' component.", componentIdentifier.getName(), id.getDisplayName()));
            } else {
                ComponentTypeBody variable2 = this.searchComponent(componentType.getComponentBody(), definitions, new HashSet<Identifier>());
                if (variable2 != null && variable2.getIdentifier() != componentIdentifier) {
                    problems.report(identifier.getLocation(), MessageFormat.format("The runs on component `{0}'' seems to be never used.Use `{1}'' component.", componentIdentifier.getDisplayName(), variable2.getIdentifier().getDisplayName()));
                }
            }
        }
    }

    private ComponentTypeBody searchComponent(ComponentTypeBody component, Set<Identifier> definitions, Set<Identifier> identifiersOfTree) {
        CopyOnWriteArrayList parentComponentBodies = component.getExtensions().getComponentBodies();
        if (parentComponentBodies.isEmpty()) {
            identifiersOfTree.add(component.getIdentifier());
            return null;
        }
        HashSet<Identifier> setNodes = new HashSet<Identifier>();
        setNodes.add(component.getIdentifier());
        for (ComponentTypeBody variable : parentComponentBodies) {
            HashSet<Identifier> identifiersOfNode;
            ComponentTypeBody cb = this.searchComponent(variable, definitions, identifiersOfNode = new HashSet<Identifier>());
            if (cb != null) {
                return cb;
            }
            setNodes.addAll(identifiersOfNode);
        }
        if (setNodes.containsAll(definitions)) {
            identifiersOfTree.addAll(setNodes);
            return component;
        }
        identifiersOfTree.addAll(setNodes);
        return null;
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(4);
        ret.add(Def_Altstep.class);
        ret.add(Def_Function.class);
        ret.add(Def_Testcase.class);
        return ret;
    }

    class ReferenceCheck
    extends ASTVisitor {
        private final Set<Identifier> setOfIdentifier = new HashSet<Identifier>();

        public ReferenceCheck() {
            this.setOfIdentifier.clear();
        }

        public Set<Identifier> getIdentifiers() {
            return this.setOfIdentifier;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Reference) {
                Assignment assignment;
                if (((Reference)node).getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
                    return 3;
                }
                Reference reference = (Reference)node;
                CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();
                if (reference != null && (assignment = reference.getRefdAssignment(timestamp, false)) != null) {
                    if (assignment instanceof Def_Function) {
                        Component_Type componentType = ((Def_Function)assignment).getRunsOnType(timestamp);
                        if (componentType == null) {
                            return 3;
                        }
                        Identifier sc = componentType.getComponentBody().getIdentifier();
                        this.setOfIdentifier.add(sc);
                    }
                    if (assignment.getMyScope() instanceof ComponentTypeBody) {
                        Identifier sc = ((ComponentTypeBody)assignment.getMyScope()).getIdentifier();
                        this.setOfIdentifier.add(sc);
                    }
                }
            }
            return 3;
        }
    }
}

