/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.visitors;

import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.statements.DoWhile_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.For_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Clause;
import org.eclipse.titan.designer.AST.TTCN3.statements.Operation_Altguard;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase;
import org.eclipse.titan.designer.AST.TTCN3.statements.While_Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstances;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.AndExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.NotExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.OrExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.XorExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titanium.metrics.visitors.Counter;
import org.eclipse.titanium.metrics.visitors.CounterVisitor;

public class CCVisitor
extends CounterVisitor {
    public CCVisitor(Counter n) {
        super(n);
        this.count.inc();
    }

    public int visit(IVisitableNode node) {
        if (node instanceof Operation_Altguard) {
            this.count.inc();
            node.accept((ASTVisitor)new OpAltGuardExpVisitor(this.count));
        } else if (node instanceof DoWhile_Statement) {
            this.count.inc();
            node.accept((ASTVisitor)new ExpressionComplexityVisitor(this.count));
        } else if (node instanceof For_Statement) {
            this.count.inc();
            node.accept((ASTVisitor)new ExpressionComplexityVisitor(this.count));
        } else if (node instanceof If_Clause) {
            this.count.inc();
            node.accept((ASTVisitor)new ExpressionComplexityVisitor(this.count));
        } else if (node instanceof SelectCase) {
            node.accept((ASTVisitor)new SelectCaseVisitor(this.count));
        } else if (node instanceof While_Statement) {
            this.count.inc();
            node.accept((ASTVisitor)new ExpressionComplexityVisitor(this.count));
        }
        return 3;
    }

    private static class SelectCaseVisitor
    extends CounterVisitor {
        public SelectCaseVisitor(Counter n) {
            super(n);
        }

        public int visit(IVisitableNode node) {
            if (node instanceof SelectCase) {
                return 3;
            }
            if (node instanceof TemplateInstances) {
                this.count.inc();
            }
            return 1;
        }
    }

    private static class OpAltGuardExpVisitor
    extends CounterVisitor {
        public OpAltGuardExpVisitor(Counter n) {
            super(n);
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Operation_Altguard) {
                return 3;
            }
            if (node instanceof Value) {
                this.count.inc();
                node.accept((ASTVisitor)new ExpressionComplexityVisitor(this.count));
            }
            return 1;
        }
    }

    private static class ExpressionComplexityVisitor
    extends CounterVisitor {
        public ExpressionComplexityVisitor(Counter n) {
            super(n);
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Expression_Value) {
                if (node instanceof AndExpression) {
                    this.count.inc();
                    return 3;
                }
                if (node instanceof OrExpression) {
                    this.count.inc();
                    return 3;
                }
                if (node instanceof XorExpression) {
                    this.count.inc();
                    return 3;
                }
                if (node instanceof NotExpression) {
                    return 3;
                }
                return 1;
            }
            return 1;
        }
    }
}

