/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.preferences.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.MetricGroup;
import org.eclipse.titanium.metrics.preferences.PreferenceManager;
import org.eclipse.titanium.preferences.PreferenceConstants;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MetricsViewPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Setting which metrics to display in the Metrics View";
    private final List<FieldEditor> editors = new ArrayList<FieldEditor>();

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
        this.setPreferenceStore(PreferenceManager.getStore());
    }

    protected Control createContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout l = new GridLayout();
        l.numColumns = 2;
        page.setLayout((Layout)l);
        for (MetricGroup type : MetricGroup.values()) {
            Label header = new Label(page, 0);
            header.setText(type.getGroupName() + " metrics");
            GridData headerData = new GridData();
            headerData.horizontalSpan = 2;
            header.setLayoutData((Object)headerData);
            Composite padding = new Composite(page, 0);
            padding.setLayoutData((Object)new GridData(25, 0));
            Composite inner = new Composite(page, 0);
            for (IMetricEnum metric : type.getMetrics()) {
                BooleanFieldEditor editor = new BooleanFieldEditor(PreferenceConstants.nameMetricEnabled(metric.id()), metric.getName(), inner);
                editor.getDescriptionControl(inner).setToolTipText(metric.getHint());
                editor.setPage((DialogPage)this);
                editor.setPreferenceStore(this.getPreferenceStore());
                editor.load();
                this.editors.add((FieldEditor)editor);
            }
        }
        return page;
    }

    protected void performDefaults() {
        for (FieldEditor e : this.editors) {
            e.loadDefault();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        for (FieldEditor e : this.editors) {
            e.store();
        }
        return super.performOk();
    }
}

