/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.swt;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titanium.Activator;

public final class SWTResourceManager {
    private static final Map<ImageDescriptor, Image> IMAGE_CACHE = new ConcurrentHashMap<ImageDescriptor, Image>();
    private static final Map<RGB, Color> COLOR_MAP = new HashMap<RGB, Color>();

    private SWTResourceManager() {
    }

    public static Color getColor(RGB rgb) {
        Color color = COLOR_MAP.get(rgb);
        if (color == null) {
            Display display = Display.getCurrent();
            color = new Color((Device)display, rgb);
            COLOR_MAP.put(rgb, color);
        }
        return color;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return Activator.imageDescriptorFromPlugin((String)"org.eclipse.titanium", (String)name);
    }

    public static Image getImage(String name) {
        ImageDescriptor descriptor = SWTResourceManager.getImageDescriptor(name);
        if (descriptor == null) {
            return null;
        }
        if (IMAGE_CACHE.containsKey(descriptor)) {
            return IMAGE_CACHE.get(descriptor);
        }
        Image image = descriptor.createImage();
        IMAGE_CACHE.put(descriptor, image);
        return image;
    }
}

