/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.text.table;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.actions.OpenSourceViewMenuAction;
import org.eclipse.titan.log.viewer.actions.OpenValueViewMenuAction;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.models.FilterPattern;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.preferences.PreferencesHandler;
import org.eclipse.titan.log.viewer.preferences.PreferencesHolder;
import org.eclipse.titan.log.viewer.readers.CachedLogReader;
import org.eclipse.titan.log.viewer.readers.FilteredLogReader;
import org.eclipse.titan.log.viewer.readers.LogFileReader;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.DetailsView;
import org.eclipse.titan.log.viewer.views.ILogViewerView;
import org.eclipse.titan.log.viewer.views.msc.model.EventObject;
import org.eclipse.titan.log.viewer.views.msc.model.EventSelection;
import org.eclipse.titan.log.viewer.views.msc.model.EventType;
import org.eclipse.titan.log.viewer.views.navigator.ProjectsViewerMenuListener;
import org.eclipse.titan.log.viewer.views.navigator.ProjectsViewerMenuManager;
import org.eclipse.titan.log.viewer.views.text.table.CloseAllAction;
import org.eclipse.titan.log.viewer.views.text.table.FilterAction;
import org.eclipse.titan.log.viewer.views.text.table.IconHandler;
import org.eclipse.titan.log.viewer.views.text.table.SetVerdictFilter;
import org.eclipse.titan.log.viewer.views.text.table.SwitchToMscAction;
import org.eclipse.titan.log.viewer.views.text.table.TextTableViewHelper;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class TextTableView
extends ViewPart
implements ISelectionProvider,
ILogViewerView {
    private Table table;
    private LogFileMetaData logFileMetaData = null;
    private CachedLogReader cachedLogReader = null;
    private FilteredLogReader filteredLogReader = null;
    private int selectedRow;
    private IMemento memento = null;
    private int viewerWidth = 0;
    private boolean problemDuringRestore;
    private OpenValueViewMenuAction openValueViewMenuAction;
    private OpenValueViewMenuAction silentOpenValueViewMenuAction;
    private OpenSourceViewMenuAction openSourceViewMenuAction;
    private OpenSourceViewMenuAction silentOpenSourceViewMenuAction;
    private final IAction filterAction;
    private ISelection eventSelection;
    private final List<ISelectionChangedListener> registeredListeners;
    private EventObject selectedEventObject;
    private Listener tableSetDataListener = null;
    private FilterPattern filterPattern = null;
    private static final int DEFAULT_COLUMN_WIDTH = 80;
    private static final int CACHE_SIZE = 10;
    private static PreferencesHolder preferences;
    private final List<Column> orderedColumns = Arrays.asList(Column.COL_TIMESTAMP, Column.COL_COMP_REF, Column.COL_EVENT_TYPE, Column.COL_SRC_INFO, Column.COL_MESSAGE);
    private ClearingRunnable clearingThread = null;

    public TextTableView() {
        this.registeredListeners = new ArrayList<ISelectionChangedListener>();
        this.filterAction = new FilterAction(this);
        this.filterAction.setEnabled(true);
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!(event.getSelection() instanceof EventSelection)) {
                    return;
                }
                EventObject tmpEventObject = ((EventSelection)event.getSelection()).getEventObject();
                if (tmpEventObject == null) {
                    return;
                }
                int selectedRecord = tmpEventObject.getRecordNumber();
                TextTableViewHelper.updateSelectionInConnectedMscView(selectedRecord, TextTableView.this.getLogFileMetaData());
            }
        });
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.filteredLogReader == null) {
            return;
        }
        IMemento tempMemento = memento.createChild("selection");
        try {
            IMemento viewAttributes = tempMemento.createChild("viewAttributes");
            viewAttributes.putString("projectName", this.logFileMetaData.getProjectName());
            viewAttributes.putInteger("selectedRow", this.table.getSelectionIndex());
            viewAttributes.putInteger("viewWidth", this.table.getClientArea().width);
            Path filePath = new Path(this.logFileMetaData.getProjectRelativePath());
            IFile logFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
            if (logFile != null && logFile.exists()) {
                viewAttributes.putString("propertyFile", LogFileCacheHandler.getPropertyFileForLogFile(logFile).getAbsolutePath());
                File aLogFile = logFile.getLocation().toFile();
                viewAttributes.putString("fileSize", String.valueOf(aLogFile.length()));
                viewAttributes.putString("fileModification", String.valueOf(aLogFile.lastModified()));
            }
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
    }

    private void restoreState() {
        if (this.memento == null) {
            return;
        }
        this.memento = this.memento.getChild("selection");
        if (this.memento == null) {
            return;
        }
        try {
            IMemento viewAttributes = this.memento.getChild("viewAttributes");
            String projectName = viewAttributes.getString("projectName");
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null || !project.exists() || !project.isOpen()) {
                return;
            }
            String propertyFilePath = viewAttributes.getString("propertyFile");
            if (propertyFilePath == null) {
                return;
            }
            File propertyFile = new File(propertyFilePath);
            if (!propertyFile.exists()) {
                return;
            }
            this.logFileMetaData = LogFileCacheHandler.logFileMetaDataReader(propertyFile);
            Path path = new Path(this.logFileMetaData.getProjectRelativePath());
            IFile logFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (logFile == null || !logFile.exists() || !logFile.getProject().getName().equals(project.getName())) {
                return;
            }
            File file = logFile.getLocation().toFile();
            String fileSizeString = viewAttributes.getString("fileSize");
            long fileSize = 0L;
            if (fileSizeString != null) {
                fileSize = Long.parseLong(fileSizeString);
            }
            String fileModificationString = viewAttributes.getString("fileModification");
            long fileModification = 0L;
            if (fileModificationString != null) {
                fileModification = Long.parseLong(fileModificationString);
            }
            if (file.lastModified() != fileModification || file.length() != fileSize) {
                return;
            }
            if (LogFileCacheHandler.hasLogFileChanged(logFile)) {
                return;
            }
            this.filteredLogReader = new FilteredLogReader(LogFileReader.getReaderForLogFile(logFile));
            this.cachedLogReader = new CachedLogReader(this.filteredLogReader);
            this.selectedRow = viewAttributes.getInteger("selectedRow");
            this.viewerWidth = viewAttributes.getInteger("viewWidth");
            this.problemDuringRestore = false;
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        catch (ClassNotFoundException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        this.memento = null;
    }

    public void createPartControl(Composite parent) {
        this.createToolbar();
        this.restoreState();
        if (this.problemDuringRestore) {
            Label text = new Label(parent, 16384);
            text.setText(Messages.getString("TextTableModel.8"));
            return;
        }
        Composite composite = new Composite(parent, 0x20040000);
        composite.setLayout((Layout)new FillLayout());
        this.table = new Table(composite, 0x10010B00);
        for (Column col : this.orderedColumns) {
            TableColumn tableColumn = new TableColumn(this.table, 2048);
            tableColumn.setText(col.getDisplayName());
            tableColumn.setResizable(true);
            tableColumn.setMoveable(true);
            tableColumn.setWidth(80);
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setMenu(this.hookContextMenu((Control)this.table));
        this.addListeners();
        this.createContextMenuActions();
        if (this.cachedLogReader != null && this.filteredLogReader != null) {
            this.setInput(this.logFileMetaData, this.cachedLogReader, this.filteredLogReader, this.selectedRow);
        }
    }

    private void addListeners() {
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextTableView.this.logFileMetaData == null) {
                    return;
                }
                IFile logFile = TextTableView.this.logFileMetaData.getLogfile();
                if (logFile == null) {
                    return;
                }
                if (LogFileCacheHandler.hasLogFileChanged(logFile)) {
                    LogFileCacheHandler.handleLogFileChange(logFile);
                    return;
                }
                TextTableView.this.setContentDescription(TextTableView.this.logFileMetaData.getProjectRelativePath() + " [" + (TextTableView.this.table.getSelectionIndex() + 1) + "/" + TextTableView.this.filteredLogReader.size() + "]");
                if (e.getSource() instanceof Table) {
                    TextTableView.this.updateSelection((Table)e.getSource());
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (TextTableView.this.logFileMetaData == null) {
                    return;
                }
                IFile logFile = TextTableView.this.logFileMetaData.getLogfile();
                if (logFile == null) {
                    return;
                }
                if (LogFileCacheHandler.hasLogFileChanged(logFile)) {
                    LogFileCacheHandler.handleLogFileChange(logFile);
                    return;
                }
                if (!(e.getSource() instanceof Table)) {
                    return;
                }
                Table table = (Table)e.getSource();
                int index = table.getSelectionIndex();
                if (index < 0 || index >= table.getItemCount()) {
                    return;
                }
                TableItem tableItem = table.getItem(index);
                Object data = tableItem.getData();
                if (data instanceof LogRecord) {
                    LogRecord logrecord = (LogRecord)data;
                    EventObject eventObject = TextTableView.this.createEventObject(logrecord);
                    TextTableView.this.eventSelection = new EventSelection(eventObject, "");
                    TextTableView.this.openValueViewMenuAction.run();
                    TextTableView.this.silentOpenSourceViewMenuAction.selectionChanged(TextTableView.this.eventSelection);
                    TextTableView.this.silentOpenSourceViewMenuAction.run();
                } else {
                    TextTableView.this.eventSelection = new EventSelection(null, null);
                }
                TextTableView.this.fireSelectionChangeEvent();
            }
        });
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int moves = e.keyCode;
                if (moves != 13) {
                    return;
                }
                if (e.getSource() instanceof Table) {
                    Table table = (Table)e.getSource();
                    TableItem tableItem = table.getItem(table.getSelectionIndex());
                    Object data = tableItem.getData();
                    if (data instanceof LogRecord) {
                        LogRecord logrecord = (LogRecord)data;
                        EventObject eventObject = TextTableView.this.createEventObject(logrecord);
                        TextTableView.this.eventSelection = new EventSelection(eventObject, "");
                    } else {
                        TextTableView.this.eventSelection = new EventSelection(null, null);
                    }
                }
                TextTableView.this.fireSelectionChangeEvent();
                TextTableView.this.openValueViewMenuAction.run();
                TextTableView.this.silentOpenSourceViewMenuAction.selectionChanged(TextTableView.this.eventSelection);
                TextTableView.this.silentOpenSourceViewMenuAction.run();
            }
        });
    }

    private EventObject createEventObject(LogRecord logrecord) {
        EventObject newEventObject = new EventObject(EventType.UNKNOWN);
        newEventObject.setRecordLength(logrecord.getRecordLength());
        newEventObject.setRecordNumber(logrecord.getRecordNumber());
        newEventObject.setRecordOffset(logrecord.getRecordOffset());
        newEventObject.setReference(logrecord.getComponentReference());
        newEventObject.setEventType(logrecord.getEventType());
        return newEventObject;
    }

    public void setFocus() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.forceFocus();
        }
    }

    public void setInput(IFile logFile, int selection) throws IOException, ClassNotFoundException {
        LogFileMetaData newLogFileMetaData = LogFileCacheHandler.logFileMetaDataReader(LogFileCacheHandler.getPropertyFileForLogFile(logFile));
        FilteredLogReader filteredReader = new FilteredLogReader(LogFileReader.getReaderForLogFile(logFile));
        CachedLogReader cachedReader = new CachedLogReader(filteredReader);
        this.setInput(newLogFileMetaData, cachedReader, filteredReader, selection);
    }

    public void setInput(IFile logFile) throws IOException, ClassNotFoundException {
        this.setInput(logFile, 0);
    }

    private void setInput(LogFileMetaData logFileMetaData, CachedLogReader cachedReader, FilteredLogReader reader, int selection) {
        TableColumn[] columns;
        int colWidth;
        this.setLogFileMetaData(logFileMetaData);
        if (this.tableSetDataListener != null) {
            this.table.removeListener(36, this.tableSetDataListener);
        }
        this.tableSetDataListener = new TableSetDataListener();
        this.table.addListener(36, this.tableSetDataListener);
        this.cachedLogReader = cachedReader;
        this.filteredLogReader = reader;
        this.table.setItemCount(reader.size());
        this.setPartName(new File(this.logFileMetaData.getFilePath()).getName());
        if (this.viewerWidth == 0) {
            this.viewerWidth = this.table.getClientArea().width;
        }
        if ((colWidth = this.viewerWidth / (columns = this.table.getColumns()).length) > 0) {
            this.table.setRedraw(false);
            for (TableColumn column : columns) {
                column.setWidth(colWidth);
            }
            this.table.setRedraw(true);
        }
        this.table.setTopIndex(selection);
        this.table.setSelection(selection);
        this.table.setTopIndex(selection);
        this.table.setSelection(selection);
        this.setContentDescription(this.logFileMetaData.getProjectRelativePath() + " [" + (selection + 1) + "/" + reader.size() + "]");
    }

    private void setLogFileMetaData(LogFileMetaData logFileMetaData) {
        this.logFileMetaData = logFileMetaData;
        preferences = PreferencesHandler.getInstance().getPreferences(logFileMetaData.getProjectName());
    }

    public void dispose() {
        DetailsView detailsView;
        IWorkbenchPage activePage;
        if (this.cachedLogReader != null) {
            this.cachedLogReader.close();
        }
        if (this.filteredLogReader != null) {
            this.filteredLogReader.close();
        }
        if ((activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null && (detailsView = (DetailsView)activePage.findView("org.eclipse.titan.log.viewer.views.DetailsView")) != null && this.selectedEventObject != null) {
            URI dvFullPath = detailsView.getFullPath();
            URI ttFullPath = this.logFileMetaData.getFilePath();
            if (dvFullPath != null && ttFullPath != null && dvFullPath.equals(ttFullPath)) {
                detailsView.setData(null, false);
            }
        }
        super.dispose();
    }

    private LogRecord getLogRecordAtRow(int row) throws IOException, ParseException {
        return this.cachedLogReader.getRecord(row);
    }

    private void createToolbar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager mgr = actionBars.getToolBarManager();
        CloseAllAction closeAllAction = new CloseAllAction();
        closeAllAction.setEnabled(true);
        SwitchToMscAction switchToMSCAction = new SwitchToMscAction(this);
        switchToMSCAction.setEnabled(true);
        mgr.add(this.filterAction);
        mgr.add((IAction)closeAllAction);
        mgr.add((IContributionItem)new Separator("SWITCH_VIEW_GROUP"));
        mgr.appendToGroup("SWITCH_VIEW_GROUP", (IAction)switchToMSCAction);
        actionBars.updateActionBars();
    }

    void refreshTable() {
        this.table.setItemCount(this.filteredLogReader.size());
        this.table.setTopIndex(0);
        this.table.setSelection(0);
        boolean topIndex = false;
        int visibleItems = this.table.getClientArea().height / this.table.getItemHeight();
        int startPos = 0 + visibleItems + 10;
        if (startPos >= this.filteredLogReader.size()) {
            startPos = this.filteredLogReader.size() - 1;
        }
        if (this.clearingThread != null) {
            this.clearingThread.stop();
        }
        this.clearingThread = new ClearingRunnable(0, visibleItems);
        Display.getDefault().asyncExec((Runnable)this.clearingThread);
        try {
            this.cachedLogReader.cacheRecords(0, startPos);
            for (int rowIndex = 0; rowIndex <= startPos; ++rowIndex) {
                TableItem item = this.table.getItem(rowIndex);
                LogRecord record = this.getLogRecordAtRow(rowIndex);
                this.setTableItem(item, record);
            }
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("TextTableModel.6") + e.getMessage()));
        }
        catch (ParseException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("TextTableModel.7") + e.getMessage()));
        }
    }

    private void setTableItem(TableItem item, LogRecord record) {
        SetVerdictFilter setVerdictFilter = new SetVerdictFilter(preferences);
        for (int i = 0; i < this.orderedColumns.size(); ++i) {
            Column column = this.orderedColumns.get(i);
            String message = column.getData(record);
            item.setText(i, message);
            item.setData((Object)record);
            Image cellImage = column.getIcon(record, setVerdictFilter);
            if (cellImage == null) continue;
            item.setImage(i, cellImage);
        }
        this.table.update();
        this.table.redraw();
    }

    private void createContextMenuActions() {
        this.openValueViewMenuAction = new OpenValueViewMenuAction(this, true);
        this.openValueViewMenuAction.setEnabled(true);
        this.openValueViewMenuAction.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/details.gif"));
        this.silentOpenValueViewMenuAction = new OpenValueViewMenuAction(this, false);
        this.silentOpenValueViewMenuAction.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/details.gif"));
        this.openSourceViewMenuAction = new OpenSourceViewMenuAction(this, false, true);
        this.openSourceViewMenuAction.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/details.gif"));
        this.silentOpenSourceViewMenuAction = new OpenSourceViewMenuAction(this, true, false);
        this.silentOpenSourceViewMenuAction.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/details.gif"));
    }

    private Menu hookContextMenu(Control control) {
        ProjectsViewerMenuManager menuMgr = new ProjectsViewerMenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new ProjectsViewerMenuListener(){

            @Override
            public void menuAboutToShow(IMenuManager menuManager) {
                TextTableView.this.fillContextMenu(menuManager);
            }
        });
        return menuMgr.createContextMenu(control);
    }

    protected void fillContextMenu(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IAction)this.openValueViewMenuAction);
        menuManager.add((IAction)this.openSourceViewMenuAction);
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add(this.filterAction);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.registeredListeners.contains(listener)) {
            this.registeredListeners.add(listener);
        }
    }

    public ISelection getSelection() {
        return this.eventSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.registeredListeners.contains(listener)) {
            this.registeredListeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
        this.eventSelection = selection;
    }

    private void fireSelectionChangeEvent() {
        for (ISelectionChangedListener listener : this.registeredListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.eventSelection));
        }
    }

    public LogRecord getSelectedRecord() {
        int index = this.table.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        TableItem selectedItem = this.table.getItem(index);
        Object data = selectedItem.getData();
        if (data instanceof LogRecord) {
            return (LogRecord)data;
        }
        return null;
    }

    public void setSelectedRecord(int recordNumber) {
        if (this.filteredLogReader == null) {
            return;
        }
        int position = this.filteredLogReader.getPositionFromRecordNumber(recordNumber);
        if (position >= 0 && position < this.table.getItemCount()) {
            this.table.setSelection(position);
            this.updateSelection(this.table);
        }
    }

    private void updateSelection(Table table1) {
        TableItem tableItem = table1.getItem(table1.getSelectionIndex());
        Object data = tableItem.getData();
        if (data instanceof LogRecord) {
            LogRecord logrecord = (LogRecord)data;
            this.selectedEventObject = this.createEventObject(logrecord);
            this.eventSelection = new EventSelection(this.selectedEventObject, "");
        } else {
            this.eventSelection = new EventSelection(null, null);
        }
        this.fireSelectionChangeEvent();
        this.silentOpenSourceViewMenuAction.delayedRun(this.eventSelection);
        this.silentOpenValueViewMenuAction.delayedRun(this.eventSelection);
    }

    public boolean isFiltered() {
        return this.filteredLogReader.isFiltered();
    }

    public boolean contains(int recordNumber) {
        return this.filteredLogReader.contains(recordNumber);
    }

    public static String getViewId() {
        return "org.eclipse.titan.log.viewer.views.text.table.TextTableView";
    }

    public static String getSecondaryId(IFile logFile) {
        return logFile.getFullPath().toOSString();
    }

    @Override
    public LogFileMetaData getLogFileMetaData() {
        return this.logFileMetaData;
    }

    @Override
    public String getName() {
        return "Text Table View";
    }

    Table getTable() {
        return this.table;
    }

    FilterPattern getFilterPattern() {
        return this.filterPattern;
    }

    void setFilterPattern(FilterPattern filterPattern) {
        this.filterPattern = filterPattern;
    }

    FilteredLogReader getFilteredLogReader() {
        return this.filteredLogReader;
    }

    private final class ClearingRunnable
    implements Runnable {
        private final int topIndex;
        private final int visibleItems;
        private volatile boolean stoped = false;

        public ClearingRunnable(int topIndex, int visibleItems) {
            this.topIndex = topIndex;
            this.visibleItems = visibleItems;
        }

        public void stop() {
            this.stoped = true;
        }

        @Override
        public void run() {
            if (this.stoped || TextTableView.this.table.isDisposed()) {
                return;
            }
            int endPos = this.topIndex - 10;
            if (endPos > 0) {
                TextTableView.this.table.clear(0, endPos);
            }
            if (this.stoped || TextTableView.this.table.isDisposed()) {
                return;
            }
            int startPos = this.topIndex + this.visibleItems + 10;
            endPos = TextTableView.this.table.getItemCount() - 1;
            if (startPos < endPos) {
                TextTableView.this.table.clear(startPos + 1, endPos);
            }
            TextTableView.this.clearingThread = null;
        }
    }

    private class TableSetDataListener
    implements Listener {
        private TableSetDataListener() {
        }

        public void handleEvent(Event event) {
            int visibleItems;
            int topIndex = TextTableView.this.table.getTopIndex();
            int startPos = topIndex + (visibleItems = ((TextTableView)TextTableView.this).table.getClientArea().height / TextTableView.this.table.getItemHeight()) + 10;
            if (startPos >= TextTableView.this.filteredLogReader.size()) {
                startPos = TextTableView.this.filteredLogReader.size() - 1;
            }
            TableItem item = (TableItem)event.item;
            if (TextTableView.this.clearingThread != null) {
                TextTableView.this.clearingThread.stop();
            }
            TextTableView.this.clearingThread = new ClearingRunnable(topIndex, visibleItems);
            Display.getDefault().asyncExec((Runnable)TextTableView.this.clearingThread);
            int rowIndex = event.index;
            try {
                TextTableView.this.cachedLogReader.cacheRecords(topIndex, startPos);
                LogRecord record = TextTableView.this.getLogRecordAtRow(rowIndex);
                TextTableView.this.setTableItem(item, record);
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("TextTableModel.6") + e.getMessage()));
            }
            catch (ParseException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("TextTableModel.7") + e.getMessage()));
            }
        }
    }

    private static enum Column {
        COL_TIMESTAMP{

            @Override
            public String getDisplayName() {
                return Messages.getString("TextTableModel.0");
            }

            @Override
            public String getData(LogRecord logRecord) {
                return logRecord.getTimestamp();
            }
        }
        ,
        COL_COMP_REF{

            @Override
            public String getDisplayName() {
                return Messages.getString("TextTableModel.1");
            }

            @Override
            public String getData(LogRecord logRecord) {
                return logRecord.getComponentReference();
            }
        }
        ,
        COL_EVENT_TYPE{

            @Override
            public String getDisplayName() {
                return Messages.getString("TextTableModel.3");
            }

            @Override
            public String getData(LogRecord logRecord) {
                return logRecord.getEventType();
            }
        }
        ,
        COL_SRC_INFO{

            @Override
            public String getDisplayName() {
                return Messages.getString("TextTableModel.4");
            }

            @Override
            public String getData(LogRecord logRecord) {
                return logRecord.getSourceInformation();
            }
        }
        ,
        COL_MESSAGE{
            IconHandler iconHandler = new IconHandler();

            @Override
            public String getDisplayName() {
                return Messages.getString("TextTableModel.5");
            }

            @Override
            public String getData(LogRecord logRecord) {
                return logRecord.getMessage();
            }

            @Override
            public Image getIcon(LogRecord logRecord, SetVerdictFilter setVerdictFilter) {
                return this.iconHandler.getIcon(logRecord, setVerdictFilter);
            }
        };


        public abstract String getDisplayName();

        public abstract String getData(LogRecord var1);

        public Image getIcon(LogRecord logRecord, SetVerdictFilter setVerdictFilter) {
            return null;
        }
    }
}

