/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.views.testexecution;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.titan.executor.executors.BaseExecutor;
import org.eclipse.titan.executor.executors.ITreeLeaf;
import org.eclipse.titan.executor.graphics.ImageCache;
import org.eclipse.titan.executor.views.executormonitor.LaunchElement;
import org.eclipse.titan.executor.views.executormonitor.MainControllerElement;
import org.eclipse.titan.executor.views.notification.NotificationView;
import org.eclipse.titan.executor.views.testexecution.ExecutedTestcase;
import org.eclipse.titan.executor.views.testexecution.TestExecutionContentProvider;
import org.eclipse.titan.executor.views.testexecution.TestExecutionLabelProvider;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public final class TestExecutionView
extends ViewPart
implements ISelectionListener {
    public static final String TESTEXECUTIONVIEW = "org.eclipse.titan.executor.views.testExecution.TestExecutionView";
    private static TestExecutionView instance = null;
    private Table table;
    private TableViewer viewer;
    private TestExecutionContentProvider contentProvider;
    private TestExecutionLabelProvider labelProvider;
    private ITreeLeaf actualInput;
    private Action saveAsAction;
    private Action followLastRecord;
    private boolean isFollowing = true;

    public void createPartControl(Composite parent) {
        this.table = new Table(parent, 66308);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setText("Reason");
        column.setWidth(300);
        Image infoImage = ImageCache.getImage("information2.gif");
        column.setImage(infoImage);
        column.setMoveable(true);
        column.setAlignment(16384);
        column = new TableColumn(this.table, 16384, 0);
        column.setText("Verdict");
        column.setWidth(100);
        column.setImage(infoImage);
        column.setMoveable(true);
        column.setAlignment(16384);
        column = new TableColumn(this.table, 16384, 0);
        column.setText("Testcase");
        column.setWidth(300);
        column.setImage(infoImage);
        column.setMoveable(true);
        column.setAlignment(16384);
        column = new TableColumn(this.table, 16384, 0);
        column.setText("Timestamp");
        column.setWidth(164);
        column.setMoveable(true);
        column.setAlignment(16384);
        column.setImage(ImageCache.getImage("clock.gif"));
        this.viewer = new TableViewer(this.table);
        this.viewer.setColumnProperties(new String[]{"timestamp", "info", "verdict"});
        this.contentProvider = new TestExecutionContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new TestExecutionLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.actualInput = this.getInitialInput();
        this.viewer.setInput((Object)this.actualInput);
        this.createTooltip(this.actualInput);
        this.createActions();
        this.createToolBar();
        this.createMenu();
        this.getSite().getPage().addSelectionListener("org.eclipse.titan.executor.views.executorMonitor.ExecutorMonitorView", (ISelectionListener)this);
        TestExecutionView.setInstance(this);
    }

    public void dispose() {
        TestExecutionView.setInstance(null);
        this.saveAsAction = null;
        this.followLastRecord = null;
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    private ITreeLeaf getInitialInput() {
        ISelection selection = this.getSite().getPage().getSelection("org.eclipse.titan.executor.views.executorMonitor.ExecutorMonitorView");
        if (null == selection || selection.isEmpty()) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        ITreeLeaf element = (ITreeLeaf)structuredSelection.getFirstElement();
        if (null != element) {
            while (!(element instanceof LaunchElement)) {
                element = element.parent();
            }
        }
        return element;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(part) || !(selection instanceof IStructuredSelection) || null == this.viewer.getContentProvider()) {
            return;
        }
        ITreeLeaf selectedElement = selection.isEmpty() ? null : (ITreeLeaf)((IStructuredSelection)selection).getFirstElement();
        if (null != selectedElement) {
            while (!(selectedElement instanceof LaunchElement)) {
                selectedElement = selectedElement.parent();
            }
        }
        if (null != this.actualInput && this.actualInput.equals(selectedElement)) {
            this.viewer.refresh(false);
        } else {
            this.viewer.setInput((Object)selectedElement);
            this.actualInput = selectedElement;
        }
        if (this.isFollowing && null != this.actualInput && this.actualInput instanceof LaunchElement) {
            List<ITreeLeaf> children = ((LaunchElement)this.actualInput).children();
            for (ITreeLeaf aChildren : children) {
                BaseExecutor executor = ((MainControllerElement)aChildren).executor();
                if (null == executor || executor.executedTests().isEmpty()) continue;
                this.viewer.reveal((Object)executor.executedTests().get(executor.executedTests().size() - 1));
            }
        }
        this.createTooltip(selectedElement);
        if (null == selectedElement) {
            this.saveAsAction.setEnabled(false);
        } else {
            this.saveAsAction.setEnabled(true);
        }
    }

    public static void refreshInput(final BaseExecutor executor) {
        if (null == TestExecutionView.getInstance()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (null != executor && !executor.executedTests().isEmpty()) {
                    TableViewer tableViewer = TestExecutionView.getInstance().viewer;
                    tableViewer.setInput(executor.executedTests());
                    tableViewer.reveal((Object)executor.executedTests().get(executor.executedTests().size() - 1));
                }
            }
        });
    }

    private void createTooltip(ITreeLeaf element) {
        if (null == element) {
            this.setTitleToolTip(null);
            return;
        }
        ArrayList<ExecutedTestcase> executedTestCases = new ArrayList<ExecutedTestcase>();
        List<ITreeLeaf> children = ((LaunchElement)this.actualInput).children();
        for (ITreeLeaf aChildren : children) {
            BaseExecutor executor;
            ITreeLeaf executorElement = aChildren;
            if (!(executorElement instanceof MainControllerElement) || null == (executor = ((MainControllerElement)executorElement).executor())) continue;
            executedTestCases.addAll(executor.executedTests());
        }
        if (executedTestCases.isEmpty()) {
            this.setTitleToolTip(element.name());
            return;
        }
        String statistics = this.createStatistics(element, executedTestCases);
        this.setTitleToolTip(statistics);
    }

    private String createStatistics(ITreeLeaf element, List<ExecutedTestcase> executedTestCases) {
        int inconc = 0;
        int fail = 0;
        int error = 0;
        int none = 0;
        int pass = 0;
        int sum = executedTestCases.size();
        for (ExecutedTestcase test : executedTestCases) {
            if ("pass".equals(test.getVerdict())) {
                ++pass;
                continue;
            }
            if ("inconc".equals(test.getVerdict())) {
                ++inconc;
                continue;
            }
            if ("fail".equals(test.getVerdict())) {
                ++fail;
                continue;
            }
            if ("error".equals(test.getVerdict())) {
                ++error;
                continue;
            }
            if (!"none".equals(test.getVerdict())) continue;
            ++none;
        }
        StringBuilder builder = new StringBuilder(element.name());
        builder.append("\nVerdict statistics: ").append(none).append(" none (").append(100 * none / sum).append("%), ").append(pass).append(" pass (").append(100 * pass / sum).append("%), ").append(inconc).append(" inconc (").append(100 * inconc / sum).append("%), ").append(fail).append(" fail (").append(100 * fail / sum).append("%), ").append(error).append(" error(").append(100 * error / sum).append("%)");
        return builder.toString();
    }

    private void createActions() {
        this.saveAsAction = new Action("Save As"){

            public void run() {
                TestExecutionView.this.saveAs();
            }
        };
        this.saveAsAction.setToolTipText("Save As");
        this.saveAsAction.setImageDescriptor(ImageCache.getImageDescriptor("saveas_edit.gif"));
        this.saveAsAction.setEnabled(false);
        this.followLastRecord = new Action("Follow the last record"){

            public void run() {
                TestExecutionView.this.isFollowing = TestExecutionView.this.followLastRecord.isChecked();
            }
        };
        this.followLastRecord.setToolTipText("Toggles the follow the last line behavior");
        this.followLastRecord.setEnabled(true);
        this.followLastRecord.setChecked(this.isFollowing);
    }

    private void createToolBar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.saveAsAction);
    }

    private void createMenu() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)this.followLastRecord);
    }

    public void setFocus() {
    }

    private void saveAs() {
        NotificationView.saveLaunchElementAs(this.getSite().getShell(), this.actualInput);
    }

    private static synchronized TestExecutionView getInstance() {
        return instance;
    }

    private static synchronized void setInstance(TestExecutionView instance) {
        TestExecutionView.instance = instance;
    }
}

