/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.titan.runtime.core.ILoggerPlugin;
import org.eclipse.titan.runtime.core.TTCN_Communication;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TTCN_Runtime;
import org.eclipse.titan.runtime.core.TitanComponent;
import org.eclipse.titan.runtime.core.TitanLoggerApi;
import org.eclipse.titan.runtime.core.TitanVerdictType;
import org.eclipse.titan.runtime.core.TtcnError;

public class LegacyLogger
implements ILoggerPlugin {
    private String filename_skeleton_;
    private TTCN_Logger.disk_full_action_t disk_full_action_ = new TTCN_Logger.disk_full_action_t(TTCN_Logger.disk_full_action_type_t.DISKFULL_ERROR, 0);
    private int disk_full_time_seconds = 0;
    private int disk_full_time_microseconds = 0;
    private boolean skeleton_given_ = false;
    private boolean append_file_ = false;
    private boolean is_disk_full_ = false;
    private static final ThreadLocal<String> current_filename_ = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return null;
        }
    };
    private int logfile_size_ = 0;
    private int logfile_number_ = 1;
    private int logfile_index_ = 1;
    private int logfile_bytes_ = 0;
    private boolean format_c_present_ = false;
    private boolean format_t_present_ = false;
    private static ThreadLocal<File> log_fp_ = new ThreadLocal<File>(){

        @Override
        protected File initialValue() {
            return null;
        }
    };
    private boolean is_configured;
    private File er_;
    private static final ThreadLocal<BufferedWriter> log_file_writer = new ThreadLocal<BufferedWriter>(){

        @Override
        protected BufferedWriter initialValue() {
            return null;
        }
    };
    private static final String name_ = "LegacyLogger";
    private static final String help_ = "LegacyLogger";
    private static final ThreadLocal<Boolean> already_warned = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static LegacyLogger myself = null;

    public LegacyLogger() {
        log_fp_.set(null);
        this.er_ = null;
        this.logfile_bytes_ = 0;
        this.logfile_size_ = 0;
        this.logfile_number_ = 1;
        this.logfile_index_ = 1;
        this.filename_skeleton_ = null;
        this.skeleton_given_ = false;
        this.append_file_ = false;
        this.is_disk_full_ = false;
        this.format_c_present_ = false;
        this.format_t_present_ = false;
        current_filename_.set(null);
        if (myself == null) {
            myself = this;
        } else {
            System.err.print("Only one LegacyLogger allowed!\n");
        }
        this.disk_full_action_.type = TTCN_Logger.disk_full_action_type_t.DISKFULL_ERROR;
        this.disk_full_action_.retry_interval = 0;
    }

    @Override
    public void reset() {
        this.disk_full_action_.type = TTCN_Logger.disk_full_action_type_t.DISKFULL_ERROR;
        this.disk_full_action_.retry_interval = 0;
        this.logfile_size_ = 0;
        this.logfile_number_ = 1;
        this.logfile_bytes_ = 0;
        this.logfile_index_ = 1;
        this.is_disk_full_ = false;
        this.skeleton_given_ = false;
        this.append_file_ = false;
        this.is_configured = false;
    }

    @Override
    public String plugin_name() {
        return "LegacyLogger";
    }

    @Override
    public String plugin_help() {
        return "LegacyLogger";
    }

    @Override
    public void set_parameter(String parameter_name, String parameter_value) {
    }

    @Override
    public void log(TitanLoggerApi.TitanLogEvent event, boolean log_buffered, boolean separate_file, boolean use_emergency_mask) {
        if (separate_file) {
            this.log_file_emerg(event);
        }
        int severityIndex = event.get_field_severity().get_int();
        TTCN_Logger.Severity severity = TTCN_Logger.Severity.values()[severityIndex];
        if (use_emergency_mask) {
            if (TTCN_Logger.should_log_to_emergency(severity) || TTCN_Logger.should_log_to_file(severity)) {
                this.log_file(event, log_buffered);
            }
            if (TTCN_Logger.should_log_to_console(severity)) {
                LegacyLogger.log_console(event, severity);
            }
        } else {
            if (TTCN_Logger.should_log_to_file(severity)) {
                this.log_file(event, log_buffered);
            }
            if (TTCN_Logger.should_log_to_console(severity)) {
                LegacyLogger.log_console(event, severity);
            }
        }
    }

    @Override
    public void set_file_name(String new_filename_skeleton, boolean from_config) {
        this.filename_skeleton_ = new_filename_skeleton;
        if (from_config) {
            this.skeleton_given_ = true;
        }
    }

    @Override
    public void set_append_file(boolean new_append_file) {
        this.append_file_ = new_append_file;
    }

    @Override
    public boolean set_file_size(int p_size) {
        this.logfile_size_ = p_size;
        return true;
    }

    @Override
    public boolean set_file_number(int p_number) {
        this.logfile_number_ = p_number;
        return true;
    }

    @Override
    public boolean set_disk_full_action(TTCN_Logger.disk_full_action_t p_disk_full_action) {
        this.disk_full_action_ = p_disk_full_action;
        return true;
    }

    @Override
    public void open_file(boolean is_first) {
        if (is_first) {
            this.chk_log_file();
            if (!this.skeleton_given_) {
                this.set_file_name(TTCN_Runtime.is_single() ? (this.logfile_number_ == 1 ? "%e.%s" : "%e-part%i.%s") : (this.logfile_number_ == 1 ? "%e.%h-%r.%s" : "%e.%h-%r-part%i.%s"), false);
            }
        }
        String localFilename = this.get_file_name(this.logfile_index_);
        current_filename_.set(localFilename);
        if (localFilename != null) {
            this.create_parent_directories(localFilename);
            File localFile = new File(localFilename);
            log_fp_.set(localFile);
            if (!localFile.exists()) {
                try {
                    localFile.createNewFile();
                }
                catch (IOException e) {
                    throw new TtcnError(e);
                }
            }
            if (log_file_writer.get() != null) {
                try {
                    log_file_writer.get().close();
                }
                catch (IOException e) {
                    System.err.println("Cannot close file writer!");
                }
            }
            try {
                log_file_writer.set(new BufferedWriter(new FileWriter(log_fp_.get(), this.append_file_), 32768));
            }
            catch (IOException e) {
                System.err.println("Cannot open file!");
            }
        }
        this.logfile_bytes_ = 0;
        this.is_configured = true;
    }

    @Override
    public void close_file() {
        BufferedWriter localFileWriter = log_file_writer.get();
        if (localFileWriter == null || log_fp_ == null || log_fp_.get() == null) {
            return;
        }
        try {
            localFileWriter.flush();
            localFileWriter.close();
        }
        catch (IOException e) {
            System.err.println("Cannot close file!");
        }
        log_fp_.set(null);
    }

    @Override
    public boolean is_configured() {
        return this.is_configured;
    }

    private void fatal_error(String err_msg, Object ... args) {
        System.err.println("Fatal error during logging: ");
        if (args == null || err_msg == null) {
            System.err.println(" (Unkown error!)");
        }
        if (args == null && err_msg != null) {
            System.err.println(err_msg);
        }
        if (args != null && err_msg != null) {
            MessageFormat err_str = new MessageFormat(err_msg);
            System.err.println(err_str.format(args));
        }
        System.err.println("Exiting.\n");
        System.exit(1);
    }

    private String get_file_name(int idx) {
        if (this.filename_skeleton_ == null) {
            return null;
        }
        whoami whoami_variable = TTCN_Runtime.is_single() ? whoami.SINGLE : (TTCN_Runtime.is_hc() ? whoami.HC : (TTCN_Runtime.is_mtc() ? whoami.MTC : whoami.PTC));
        boolean h_present = false;
        boolean p_present = false;
        boolean r_present = false;
        boolean i_present = false;
        this.format_c_present_ = false;
        this.format_t_present_ = false;
        StringBuilder ret_val = new StringBuilder();
        block24: for (int i = 0; i < this.filename_skeleton_.length(); ++i) {
            if (this.filename_skeleton_.charAt(i) != '%') {
                if (this.filename_skeleton_.charAt(i) == '/' || this.filename_skeleton_.charAt(i) == '\\') {
                    ret_val.append(File.separatorChar);
                    continue;
                }
                ret_val.append(this.filename_skeleton_.charAt(i));
                continue;
            }
            switch (this.filename_skeleton_.charAt(++i)) {
                case 'c': {
                    ret_val.append(TTCN_Runtime.get_testcase_name());
                    this.format_c_present_ = true;
                    continue block24;
                }
                case 'e': {
                    ret_val.append(TTCN_Logger.get_executable_name());
                    continue block24;
                }
                case 'h': {
                    ret_val.append(TTCN_Runtime.get_host_name());
                    h_present = true;
                    continue block24;
                }
                case 'l': {
                    ret_val.append(System.getProperty("user.name").toString());
                    continue block24;
                }
                case 'n': {
                    switch (whoami_variable) {
                        case SINGLE: 
                        case MTC: {
                            ret_val.append("MTC");
                            continue block24;
                        }
                        case HC: {
                            ret_val.append("HC");
                            continue block24;
                        }
                        case PTC: {
                            ret_val.append(TTCN_Runtime.get_component_name());
                            continue block24;
                        }
                    }
                    continue block24;
                }
                case 'p': {
                    ret_val.append(Thread.currentThread().getId());
                    p_present = true;
                    continue block24;
                }
                case 'r': {
                    switch (whoami_variable) {
                        case SINGLE: {
                            ret_val.append("single");
                            break;
                        }
                        case HC: {
                            ret_val.append("hc");
                            break;
                        }
                        case MTC: {
                            ret_val.append("mtc");
                            break;
                        }
                        default: {
                            ret_val.append(TitanComponent.self.get().get_component());
                        }
                    }
                    r_present = true;
                    continue block24;
                }
                case 's': {
                    ret_val.append("log");
                    continue block24;
                }
                case 't': {
                    ret_val.append(TTCN_Runtime.get_component_type());
                    this.format_t_present_ = true;
                    continue block24;
                }
                case 'i': {
                    if (this.logfile_number_ != 1) {
                        ret_val.append(idx);
                    }
                    i_present = true;
                    continue block24;
                }
                case '\u0000': {
                    --i;
                }
                case '%': {
                    ret_val.append('%');
                    continue block24;
                }
                default: {
                    ret_val.append('%');
                    ret_val.append(this.filename_skeleton_.charAt(i));
                }
            }
        }
        if (ret_val.length() == 0) {
            return null;
        }
        if (whoami_variable == whoami.HC && !already_warned.get().booleanValue()) {
            already_warned.set(true);
            if (!h_present || !p_present && !r_present) {
                TtcnError.TtcnWarning(MessageFormat.format("Skeleton {0} does not guarantee unique log file name for every test system process. It may cause unpredictable results if several test components try to write into the same log file.", this.filename_skeleton_));
            }
        }
        if (this.logfile_number_ != 1 && !i_present) {
            TtcnError.TtcnWarning(MessageFormat.format("LogFileNumber = {0}, but `%%i' is missing from the log file name skeleton. `%%i' was appended to the skeleton.", this.logfile_number_));
            this.filename_skeleton_ = this.filename_skeleton_ + "%i";
            ret_val.append(idx);
        }
        return ret_val.toString();
    }

    private void chk_log_file() {
        if (this.logfile_size_ == 0 && this.logfile_number_ != 1) {
            TtcnError.TtcnWarning(MessageFormat.format("Invalid combination of LogFileSize (= {0}) and LogFileNumber (= {1}). LogFileNumber was reset to 1.", this.logfile_size_, this.logfile_number_));
            this.logfile_number_ = 1;
        }
        if (this.logfile_size_ > 0 && this.logfile_number_ == 1) {
            TtcnError.TtcnWarning(MessageFormat.format("Invalid combination of LogFileSize (= {0}) and LogFileNumber (= {1}). LogFileSize was reset to 0.", this.logfile_size_, this.logfile_number_));
            this.logfile_size_ = 0;
        }
        if (this.logfile_number_ == 1 && this.disk_full_action_.type == TTCN_Logger.disk_full_action_type_t.DISKFULL_DELETE) {
            TtcnError.TtcnWarning("Invalid combination of LogFileNumber (= 1) and DiskFullAction (= Delete). DiskFullAction was reset to Error.");
            this.disk_full_action_.type = TTCN_Logger.disk_full_action_type_t.DISKFULL_ERROR;
        }
        if (this.logfile_number_ != 1 && this.append_file_) {
            TtcnError.TtcnWarning(MessageFormat.format("Invalid combination of LogFileNumber (= {0}) and AppendFile (= Yes). AppendFile was reset to No.", this.logfile_number_));
            this.append_file_ = false;
        }
    }

    private void create_parent_directories(String path_name) {
        String path_backup = null;
        for (int i = 0; i < path_name.length(); ++i) {
            File path_backup_file;
            if (path_name.charAt(i) != File.separatorChar || (path_backup_file = new File(path_backup = path_name.substring(0, i + 1))).exists() || path_backup_file.mkdir()) continue;
            this.fatal_error("Creation of directory {0} failed when trying to open log file {1}.", path_backup, path_name);
        }
    }

    private static boolean log_console(TitanLoggerApi.TitanLogEvent event, TTCN_Logger.Severity msg_severity) {
        String event_str = LegacyLogger.event_to_string(event, true);
        if (event_str == null) {
            TtcnError.TtcnWarning("No text for event");
            return false;
        }
        if (!TTCN_Communication.send_log(event.get_field_timestamp__().get_field_seconds().get_long(), event.get_field_timestamp__().get_field_microSeconds().get_int(), event.get_field_severity().get_int(), event_str)) {
            if (event_str.length() > 0) {
                if (msg_severity == TTCN_Logger.Severity.USER_UNQUALIFIED && event_str.startsWith(":") && event.get_field_sourceInfo__list().lengthof().get_int() > 0) {
                    int stackdepth = event.get_field_sourceInfo__list().lengthof().get_int();
                    TitanLoggerApi.LocationInfo loc = event.get_field_sourceInfo__list().get_at(stackdepth - 1);
                    System.err.print(MessageFormat.format("{0}:{1}", loc.get_field_filename().get_value(), loc.get_field_line().get_int()));
                }
                System.err.print(event_str);
            }
            System.err.println();
        }
        return true;
    }

    private boolean log_file_emerg(TitanLoggerApi.TitanLogEvent event) {
        String event_str = LegacyLogger.event_to_string(event, false);
        if (event_str == null) {
            TtcnError.TtcnWarning("No text for event");
            return true;
        }
        if (this.er_ == null) {
            String filename_emergency = this.get_file_name(0);
            filename_emergency = filename_emergency == null ? "emergency.log" : filename_emergency + "_emergency";
            this.er_ = new File(filename_emergency);
            if (this.er_ == null) {
                this.fatal_error("Opening of log file {0} for writing failed.", filename_emergency);
            }
        }
        boolean write_succes = true;
        try {
            BufferedWriter localWriter = new BufferedWriter(new FileWriter(this.er_), 32768);
            log_file_writer.set(localWriter);
            localWriter.write(event_str);
            localWriter.newLine();
            localWriter.flush();
            localWriter.close();
        }
        catch (IOException e) {
            write_succes = false;
        }
        return write_succes;
    }

    private boolean log_file(TitanLoggerApi.TitanLogEvent event, boolean log_buffered) {
        boolean print_success;
        if (this.is_disk_full_ && this.disk_full_action_.type == TTCN_Logger.disk_full_action_type_t.DISKFULL_RETRY) {
            int event_timestamp_seconds = event.get_field_timestamp__().get_field_seconds().get_int();
            int event_timestamp_microseconds = event.get_field_timestamp__().get_field_microSeconds().get_int();
            int diff_seconds = 0;
            int diff_microseconds = 0;
            if (event_timestamp_microseconds < this.disk_full_time_microseconds) {
                diff_seconds = event_timestamp_seconds - this.disk_full_time_seconds - 1;
                diff_microseconds = event_timestamp_microseconds + (1000000 - this.disk_full_time_microseconds);
            } else {
                diff_seconds = event_timestamp_seconds - this.disk_full_time_seconds;
                diff_microseconds = event_timestamp_microseconds - this.disk_full_time_microseconds;
            }
            if (diff_seconds < this.disk_full_action_.retry_interval) {
                return false;
            }
            this.is_disk_full_ = false;
            return false;
        }
        String event_str = LegacyLogger.event_to_string(event, false);
        if (event_str == null) {
            TtcnError.TtcnWarning("No text for event");
            return true;
        }
        int bytes_to_log = event_str.length() + 1;
        if (this.logfile_size_ != 0 && this.logfile_bytes_ != 0 && !log_buffered && (bytes_to_log + this.logfile_bytes_ + 1023) / 1024 > this.logfile_size_) {
            String filename_to_delete;
            File file_to_delete;
            this.close_file();
            ++this.logfile_index_;
            if (this.logfile_number_ > 1 && this.logfile_index_ > this.logfile_number_ && (file_to_delete = new File(filename_to_delete = this.get_file_name(this.logfile_index_ - this.logfile_number_))).exists()) {
                file_to_delete.delete();
            }
            this.open_file(false);
        }
        if (!log_buffered && (this.format_c_present_ || this.format_t_present_)) {
            switch (TTCN_Runtime.get_state()) {
                case HC_EXIT: 
                case MTC_EXIT: 
                case PTC_EXIT: {
                    break;
                }
                default: {
                    String new_filename = this.get_file_name(this.logfile_index_);
                    String current_filename = current_filename_.get();
                    if ((new_filename != null || current_filename == null) && (new_filename == null || new_filename.equals(current_filename))) break;
                    String switched = "Switching to log file " + new_filename;
                    TitanLoggerApi.TitanLogEvent switched_event = new TitanLoggerApi.TitanLogEvent();
                    switched_event.get_field_timestamp__().operator_assign(event.get_field_timestamp__());
                    switched_event.get_field_sourceInfo__list().operator_assign(event.get_field_sourceInfo__list());
                    switched_event.get_field_severity().operator_assign(TTCN_Logger.Severity.EXECUTOR_RUNTIME.ordinal());
                    switched_event.get_field_logEvent().get_field_choice().get_field_unhandledEvent().operator_assign(switched);
                    this.log_file(switched_event, true);
                    switched = null;
                    this.close_file();
                    this.open_file(false);
                    break;
                }
            }
        }
        if (log_fp_.get() == null) {
            this.open_file(true);
        }
        if (!(print_success = this.log_to_file(event_str))) {
            switch (this.disk_full_action_.type) {
                case DISKFULL_ERROR: {
                    this.fatal_error("Writing to log file failed.", new Object[0]);
                    break;
                }
                case DISKFULL_STOP: {
                    this.is_disk_full_ = true;
                    break;
                }
                case DISKFULL_RETRY: {
                    this.is_disk_full_ = true;
                    this.disk_full_time_seconds = event.get_field_timestamp__().get_field_seconds().get_int();
                    this.disk_full_time_microseconds = event.get_field_timestamp__().get_field_microSeconds().get_int();
                    break;
                }
                case DISKFULL_DELETE: {
                    if (this.logfile_number_ == 0) {
                        this.logfile_number_ = this.logfile_index_;
                    }
                    while (!print_success && this.logfile_number_ > 2) {
                        --this.logfile_number_;
                        if (this.logfile_index_ <= this.logfile_number_) continue;
                        String filename_to_delete = this.get_file_name(this.logfile_index_ - this.logfile_number_);
                        File file_to_delete = new File(filename_to_delete);
                        boolean remove_ret_val = false;
                        if (file_to_delete.exists()) {
                            remove_ret_val = file_to_delete.delete();
                        }
                        if (!remove_ret_val) break;
                        print_success = this.log_to_file(event_str);
                    }
                    if (!print_success) {
                        this.fatal_error("Writing to log file failed.", new Object[0]);
                        break;
                    }
                    this.logfile_bytes_ += bytes_to_log;
                    break;
                }
                default: {
                    this.fatal_error("LegacyLogger.log(): invalid DiskFullAction type.", new Object[0]);
                    break;
                }
            }
        } else {
            this.logfile_bytes_ += bytes_to_log;
        }
        return true;
    }

    private boolean log_to_file(String message_ptr) {
        boolean is_success = true;
        BufferedWriter localWriter = log_file_writer.get();
        try {
            localWriter.write(message_ptr);
        }
        catch (IOException e) {
            is_success = false;
        }
        if (is_success) {
            try {
                localWriter.newLine();
                localWriter.flush();
            }
            catch (IOException e) {
                is_success = false;
            }
        }
        return is_success;
    }

    private static void append_header(StringBuilder returnValue, long seconds, int microseconds, TTCN_Logger.Severity severity, StringBuilder sourceInfo) {
        TTCN_Logger.mputstr_timestamp(returnValue, TTCN_Logger.get_timestamp_format(), seconds, microseconds);
        returnValue.append(' ');
        if (TTCN_Logger.get_log_event_types() != TTCN_Logger.log_event_types_t.LOGEVENTTYPES_NO) {
            TTCN_Logger.mput_severity(returnValue, severity);
            if (TTCN_Logger.get_log_event_types() == TTCN_Logger.log_event_types_t.LOGEVENTTYPES_SUBCATEGORIES) {
                returnValue.append('_').append(TTCN_Logger.severity_subcategory_names[severity.ordinal()]);
            }
            returnValue.append(' ');
        }
        if (sourceInfo != null) {
            returnValue.append((CharSequence)sourceInfo).append(' ');
        }
    }

    private static String event_to_string(TitanLoggerApi.TitanLogEvent event, boolean without_header) {
        StringBuilder returnValue = new StringBuilder(100);
        if (!without_header) {
            StringBuilder sourceInfo = new StringBuilder();
            TitanLoggerApi.TitanLogEvent_sourceInfo__list sourceInfoList = event.get_field_sourceInfo__list();
            if (sourceInfoList.is_bound()) {
                TTCN_Logger.source_info_format_t source_info_format = TTCN_Logger.get_source_info_format();
                int stack_size = sourceInfoList.size_of().get_int();
                if (stack_size > 0) {
                    int i = 0;
                    switch (source_info_format) {
                        case SINFO_NONE: {
                            i = stack_size;
                            break;
                        }
                        case SINFO_SINGLE: {
                            i = stack_size - 1;
                            break;
                        }
                    }
                    boolean firstLocation = true;
                    while (i < stack_size) {
                        TitanLoggerApi.LocationInfo loc = sourceInfoList.get_at(i);
                        if (firstLocation) {
                            firstLocation = false;
                        } else {
                            sourceInfo.append("->");
                        }
                        sourceInfo.append((CharSequence)loc.get_field_filename().get_value()).append(':').append(loc.get_field_line().get_int());
                        switch (loc.get_field_ent__type().enum_value) {
                            case controlpart: {
                                sourceInfo.append(MessageFormat.format("(controlpart:{0})", loc.get_field_ent__name()));
                                break;
                            }
                            case testcase__: {
                                sourceInfo.append(MessageFormat.format("(testcase:{0})", loc.get_field_ent__name()));
                                break;
                            }
                            case altstep__: {
                                sourceInfo.append(MessageFormat.format("(altstep:{0})", loc.get_field_ent__name()));
                                break;
                            }
                            case function__: {
                                sourceInfo.append(MessageFormat.format("(function:{0})", loc.get_field_ent__name()));
                                break;
                            }
                            case external__function: {
                                sourceInfo.append(MessageFormat.format("(externalfunction:{0})", loc.get_field_ent__name()));
                                break;
                            }
                            case template__: {
                                sourceInfo.append(MessageFormat.format("(template:{0})", loc.get_field_ent__name()));
                                break;
                            }
                        }
                        ++i;
                    }
                } else if (source_info_format == TTCN_Logger.source_info_format_t.SINFO_SINGLE || source_info_format == TTCN_Logger.source_info_format_t.SINFO_STACK) {
                    sourceInfo.append('-');
                }
            }
            int severityIndex = event.get_field_severity().get_int();
            TTCN_Logger.Severity severity = TTCN_Logger.Severity.values()[severityIndex];
            TitanLoggerApi.TimestampType timestamp = event.get_field_timestamp__();
            LegacyLogger.append_header(returnValue, timestamp.get_field_seconds().get_long(), timestamp.get_field_microSeconds().get_int(), severity, sourceInfo);
        }
        TitanLoggerApi.LogEventType_choice choice = event.get_field_logEvent().get_field_choice();
        block12 : switch (choice.get_selection()) {
            case UNBOUND_VALUE: {
                return returnValue.toString();
            }
            case ALT_unhandledEvent: {
                returnValue.append((CharSequence)choice.get_field_unhandledEvent().get_value());
                break;
            }
            case ALT_timerEvent: {
                LegacyLogger.timer_event_str(returnValue, choice.get_field_timerEvent().get_field_choice());
                break;
            }
            case ALT_statistics: {
                LegacyLogger.statistics_str(returnValue, choice.get_field_statistics().get_field_choice());
                break;
            }
            case ALT_verdictOp: {
                LegacyLogger.verdictop_str(returnValue, choice.get_field_verdictOp().get_field_choice());
                break;
            }
            case ALT_testcaseOp: {
                LegacyLogger.testcaseop_str(returnValue, choice.get_field_testcaseOp().get_field_choice());
                break;
            }
            case ALT_actionEvent: {
                TitanLoggerApi.Strings_str__list slist = choice.get_field_actionEvent().get_field_str__list();
                int size = slist.size_of().get_int();
                for (int i = 0; i < size; ++i) {
                    returnValue.append((CharSequence)slist.get_at(i).get_value());
                }
                break;
            }
            case ALT_userLog: {
                TitanLoggerApi.Strings_str__list slist = choice.get_field_userLog().get_field_str__list();
                int size = slist.size_of().get_int();
                for (int i = 0; i < size; ++i) {
                    returnValue.append((CharSequence)slist.get_at(i).get_value());
                }
                break;
            }
            case ALT_debugLog: {
                returnValue.append((CharSequence)choice.get_field_debugLog().get_field_text().get_value());
                break;
            }
            case ALT_errorLog: {
                returnValue.append((CharSequence)choice.get_field_errorLog().get_field_text().get_value());
                break;
            }
            case ALT_warningLog: {
                returnValue.append((CharSequence)choice.get_field_warningLog().get_field_text().get_value());
                break;
            }
            case ALT_defaultEvent: {
                LegacyLogger.defaultop_event_str(returnValue, choice.get_field_defaultEvent().get_field_choice());
                break;
            }
            case ALT_executionSummary: {
                break;
            }
            case ALT_executorEvent: {
                LegacyLogger.executor_event_str(returnValue, choice.get_field_executorEvent().get_field_choice());
                break;
            }
            case ALT_matchingEvent: {
                LegacyLogger.matchingop_str(returnValue, choice.get_field_matchingEvent().get_field_choice());
                break;
            }
            case ALT_functionEvent: {
                switch (choice.get_field_functionEvent().get_field_choice().get_selection()) {
                    case ALT_random: {
                        TitanLoggerApi.FunctionEvent_choice_random ra = choice.get_field_functionEvent().get_field_choice().get_field_random();
                        switch (ra.get_field_operation().enum_value) {
                            case seed: {
                                returnValue.append(MessageFormat.format("Random number generator was initialized with seed {0}: {1}", ra.get_field_retval().get_value(), ra.get_field_intseed().get_int()));
                                break block12;
                            }
                            case read__out: {
                                returnValue.append(MessageFormat.format("Function rnd() returned {0}.", ra.get_field_retval().get_value()));
                                break block12;
                            }
                        }
                        break block12;
                    }
                }
                break;
            }
            case ALT_parallelEvent: {
                LegacyLogger.parallel_str(returnValue, choice.get_field_parallelEvent().get_field_choice());
                break;
            }
            case ALT_portEvent: {
                LegacyLogger.portevent_str(returnValue, choice.get_field_portEvent().get_field_choice());
            }
        }
        return returnValue.toString();
    }

    private static void timer_event_str(StringBuilder returnValue, TitanLoggerApi.TimerEvent_choice choice) {
        switch (choice.get_selection()) {
            case ALT_readTimer: {
                TitanLoggerApi.TimerType timer = choice.get_field_readTimer();
                returnValue.append(MessageFormat.format("Read timer {0}: {1} s", timer.get_field_name().get_value(), timer.get_field_value__().get_value()));
                break;
            }
            case ALT_startTimer: {
                TitanLoggerApi.TimerType timer = choice.get_field_startTimer();
                returnValue.append(MessageFormat.format("Start timer {0}: {1} s", timer.get_field_name().get_value(), timer.get_field_value__().get_value()));
                break;
            }
            case ALT_guardTimer: {
                TitanLoggerApi.TimerGuardType timer = choice.get_field_guardTimer();
                returnValue.append(MessageFormat.format("Test case guard timer was set to {0} s", timer.get_field_value__().get_value()));
                break;
            }
            case ALT_stopTimer: {
                TitanLoggerApi.TimerType timer = choice.get_field_stopTimer();
                returnValue.append(MessageFormat.format("Stop timer {0}: {1} s", timer.get_field_name().get_value(), timer.get_field_value__().get_value()));
                break;
            }
            case ALT_timeoutTimer: {
                TitanLoggerApi.TimerType timer = choice.get_field_timeoutTimer();
                returnValue.append(MessageFormat.format("Timeout {0}: {1} s", timer.get_field_name().get_value(), timer.get_field_value__().get_value()));
                break;
            }
            case ALT_timeoutAnyTimer: {
                returnValue.append("Operation `any timer.timeout' was successful.");
                break;
            }
            case ALT_unqualifiedTimer: {
                returnValue.append((CharSequence)choice.get_field_unqualifiedTimer().get_value());
                break;
            }
        }
    }

    private static void defaultop_event_str(StringBuilder returnValue, TitanLoggerApi.DefaultEvent_choice choice) {
        block0 : switch (choice.get_selection()) {
            case ALT_defaultopActivate: {
                TitanLoggerApi.DefaultOp dflt = choice.get_field_defaultopActivate();
                returnValue.append(MessageFormat.format("Altstep {0} was activated as default, id {1}", dflt.get_field_name().get_value(), dflt.get_field_id().get_int()));
                break;
            }
            case ALT_defaultopDeactivate: {
                TitanLoggerApi.DefaultOp dflt = choice.get_field_defaultopDeactivate();
                if (dflt.get_field_name().lengthof().is_greater_than(0)) {
                    returnValue.append(MessageFormat.format("Default with id {0} (altstep {1}) was deactivated.", dflt.get_field_id().get_int(), dflt.get_field_name().get_value()));
                    break;
                }
                returnValue.append("Deactivate operation on a null default reference was ignored.");
                break;
            }
            case ALT_defaultopExit: {
                TitanLoggerApi.DefaultOp dflt = choice.get_field_defaultopExit();
                returnValue.append(MessageFormat.format("Default with id {0} (altstep {1}) ", dflt.get_field_id().get_int(), dflt.get_field_name().get_value()));
                switch (dflt.get_field_end().enum_value) {
                    case UNBOUND_VALUE: 
                    case UNKNOWN_VALUE: {
                        break block0;
                    }
                    case finish: {
                        returnValue.append("finished. Skipping current alt statement or receiving operation.");
                        break block0;
                    }
                    case break__: {
                        returnValue.append("has reached a repeat statement.");
                        break block0;
                    }
                    case repeat__: {
                        returnValue.append("has reached a break statement. Skipping current alt statement or receiving operation.");
                    }
                }
            }
        }
    }

    private static void executor_event_str(StringBuilder returnValue, TitanLoggerApi.ExecutorEvent_choice eec) {
        switch (eec.get_selection()) {
            case UNBOUND_VALUE: {
                break;
            }
            case ALT_executorRuntime: {
                TitanLoggerApi.ExecutorRuntime rt = eec.get_field_executorRuntime();
                switch (rt.get_field_reason().enum_value) {
                    case UNBOUND_VALUE: 
                    case UNKNOWN_VALUE: {
                        break;
                    }
                    case connected__to__mc: {
                        returnValue.append("Connected to MC.");
                        break;
                    }
                    case disconnected__from__mc: {
                        returnValue.append("Disconnected from MC.");
                        break;
                    }
                    case initialization__of__modules__failed: {
                        returnValue.append("Initialization of modules failed.");
                        break;
                    }
                    case exit__requested__from__mc__hc: {
                        returnValue.append("Exit was requested from MC. Terminating HC.");
                        break;
                    }
                    case exit__requested__from__mc__mtc: {
                        returnValue.append("Exit was requested from MC. Terminating MTC.");
                        break;
                    }
                    case stop__was__requested__from__mc: {
                        returnValue.append("Stop was requested from MC.");
                        break;
                    }
                    case stop__was__requested__from__mc__ignored__on__idle__mtc: {
                        returnValue.append("Stop was requested from MC. Ignored on idle MTC.");
                        break;
                    }
                    case stop__was__requested__from__mc__ignored__on__idle__ptc: {
                        returnValue.append("Stop was requested from MC. Ignored on idle PTC.");
                        break;
                    }
                    case executing__testcase__in__module: {
                        returnValue.append(MessageFormat.format("Executing test case {0} in module {1}.", rt.get_field_testcase__name().get(), rt.get_field_module__name().get()));
                        break;
                    }
                    case performing__error__recovery: {
                        returnValue.append("Performing error recovery.");
                        break;
                    }
                    case executor__start__single__mode: {
                        returnValue.append(MessageFormat.format("TTCN-3 Test Executor started in single mode. Version: {0} .", "11.1.0"));
                        break;
                    }
                    case executor__finish__single__mode: {
                        returnValue.append("TTCN-3 Test Executor finished in single mode.");
                        break;
                    }
                    case exiting: {
                        returnValue.append("Exiting.");
                        break;
                    }
                    case fd__limits: {
                        returnValue.append(MessageFormat.format("Maximum number of open file descriptors: {0},   FD_SETSIZE = {1}", rt.get_field_pid().get().get_int(), rt.get_field_fd__setsize()));
                        break;
                    }
                    case host__controller__started: {
                        returnValue.append(MessageFormat.format("TTCN-3 Host Controller started on {0}. Version: {1}. ", rt.get_field_module__name().get().get_value(), "11.1.0"));
                        break;
                    }
                    case host__controller__finished: {
                        returnValue.append("TTCN-3 Host Controller finished.");
                        break;
                    }
                    case initializing__module: {
                        returnValue.append(MessageFormat.format("Initializing module {0}.", rt.get_field_module__name().get().get_value()));
                        break;
                    }
                    case initialization__of__module__finished: {
                        returnValue.append(MessageFormat.format("Initializing module {0} finished.", rt.get_field_module__name().get().get_value()));
                        break;
                    }
                    case mtc__created: {
                        returnValue.append(MessageFormat.format("MTC was created. Process id: {0}.", rt.get_field_pid().get().get_int()));
                        break;
                    }
                    case overload__check: {
                        returnValue.append("Trying to create a dummy child process to verify if the host is still overloaded.");
                        break;
                    }
                    case overload__check__fail: {
                        returnValue.append("Creation of the dummy child process failed.");
                        break;
                    }
                    case overloaded__no__more: {
                        break;
                    }
                    case resuming__execution: {
                        returnValue.append("Resuming execution.");
                        break;
                    }
                    case stopping__control__part__execution: {
                        returnValue.append("Resuming control part execution.");
                        break;
                    }
                    case stopping__current__testcase: {
                        returnValue.append("Stopping current testcase.");
                        break;
                    }
                    case stopping__test__component__execution: {
                        returnValue.append("Stopping test component execution.");
                        break;
                    }
                    case terminating__execution: {
                        returnValue.append("Terminating execution.");
                        break;
                    }
                    case user__paused__waiting__to__resume: {
                        returnValue.append("User has paused execution. Waiting for continue.");
                        break;
                    }
                    case waiting__for__ptcs__to__finish: {
                        returnValue.append("Waiting for PTCs to finish.");
                    }
                }
                break;
            }
            case ALT_executorConfigdata: {
                TitanLoggerApi.ExecutorConfigdata cfg = eec.get_field_executorConfigdata();
                switch (cfg.get_field_reason().enum_value) {
                    case UNBOUND_VALUE: 
                    case UNKNOWN_VALUE: {
                        break;
                    }
                    case received__from__mc: {
                        returnValue.append("Processing configuration data received from MC.");
                        break;
                    }
                    case processing__failed: {
                        returnValue.append("Processing of configuration data failed.");
                        break;
                    }
                    case processing__succeeded: {
                        returnValue.append("Configuration data was processed successfully.");
                        break;
                    }
                    case module__has__parameters: {
                        break;
                    }
                    case using__config__file: {
                        returnValue.append(MessageFormat.format("Using configuration file: `{0}''.", cfg.get_field_param__().get().get_value()));
                        break;
                    }
                    case overriding__testcase__list: {
                        returnValue.append(MessageFormat.format("Overriding testcase list: {0}.", cfg.get_field_param__().get().get_value()));
                    }
                }
                break;
            }
            case ALT_executorComponent: {
                TitanLoggerApi.ExecutorComponent cm = eec.get_field_executorComponent();
                switch (cm.get_field_reason().enum_value) {
                    case UNBOUND_VALUE: 
                    case UNKNOWN_VALUE: {
                        break;
                    }
                    case mtc__started: {
                        returnValue.append(MessageFormat.format("TTCN-3 Main Test Component started on {0}. Version: {1}.", TTCN_Runtime.get_host_name(), "11.1.0"));
                        break;
                    }
                    case mtc__finished: {
                        returnValue.append("TTCN-3 Main Test Component finished.");
                        break;
                    }
                    case ptc__started: {
                        break;
                    }
                    case ptc__finished: {
                        returnValue.append("TTCN-3 Parallel Test Component finished.");
                        break;
                    }
                    case component__init__fail: {
                        returnValue.append("Component type initialization failed. PTC terminates.");
                    }
                }
                break;
            }
            case ALT_executorMisc: {
                TitanLoggerApi.ExecutorUnqualified ex = eec.get_field_executorMisc();
                String name = ex.get_field_name().get_value().toString();
                String ip_addr_str = ex.get_field_addr().get_value().toString();
                switch (ex.get_field_reason().enum_value) {
                    case UNBOUND_VALUE: 
                    case UNKNOWN_VALUE: {
                        break;
                    }
                    case address__of__mc__was__set: {
                        if (name.equals(ip_addr_str)) {
                            returnValue.append(MessageFormat.format("The address of MC was set to {0}[{1}]:{2}.", name, ip_addr_str, ex.get_field_port__().get_int()));
                            break;
                        }
                        returnValue.append(MessageFormat.format("The address of MC was set to {0}:{1}.", ip_addr_str, ex.get_field_port__().get_int()));
                        break;
                    }
                    case address__of__control__connection: {
                        returnValue.append(MessageFormat.format("The local IP address of the control connection to MC is {0}.", ip_addr_str));
                        break;
                    }
                    case host__support__unix__domain__sockets: {
                        if (ex.get_field_port__().get_int() == 0) {
                            returnValue.append("This host supports UNIX domain sockets for local communication.");
                            break;
                        }
                        returnValue.append("This host does not support UNIX domain sockets for local communication.");
                        break;
                    }
                    case local__address__was__set: {
                        if (name.equals(ip_addr_str)) {
                            returnValue.append(MessageFormat.format("The local address was set to {0}[{1}].", name, ip_addr_str));
                            break;
                        }
                        returnValue.append(MessageFormat.format("The local address was set to {0}.", ip_addr_str));
                    }
                }
                break;
            }
            case ALT_logOptions: {
                returnValue.append((CharSequence)eec.get_field_logOptions().get_value());
                returnValue.append(LegacyLogger.plugin_specific_settings());
                break;
            }
            case ALT_extcommandStart: {
                returnValue.append(MessageFormat.format("Starting external command `{0}''.", eec.get_field_extcommandStart().get_value()));
                break;
            }
            case ALT_extcommandSuccess: {
                returnValue.append(MessageFormat.format("External command `{0}'' was executed successfully (exit status: 0).", eec.get_field_extcommandSuccess()));
            }
        }
    }

    private static void verdictop_str(StringBuilder returnValue, TitanLoggerApi.VerdictOp_choice choice) {
        block28: {
            block0 : switch (choice.get_selection()) {
                case UNBOUND_VALUE: {
                    break;
                }
                case ALT_setVerdict: {
                    TitanLoggerApi.SetVerdictType set = choice.get_field_setVerdict();
                    int newOrdinal = set.get_field_newVerdict().enum_value.ordinal();
                    String newVerdictName = TitanVerdictType.VerdictTypeEnum.values()[newOrdinal].getName();
                    int oldOrdinal = set.get_field_oldVerdict().enum_value.ordinal();
                    String oldVerdictName = TitanVerdictType.VerdictTypeEnum.values()[oldOrdinal].getName();
                    int localOrdinal = set.get_field_localVerdict().enum_value.ordinal();
                    String localVerdictName = TitanVerdictType.VerdictTypeEnum.values()[localOrdinal].getName();
                    if (set.get_field_newVerdict().is_greater_than(set.get_field_oldVerdict())) {
                        if (!set.get_field_oldReason().is_present() || !set.get_field_newReason().is_present()) {
                            returnValue.append(MessageFormat.format("setverdict({0}): {1} -> {2}", newVerdictName, oldVerdictName, localVerdictName));
                            break;
                        }
                        returnValue.append(MessageFormat.format("setverdict({0}): {1} -> {2} reason: \"{3}\", new component reason: \"{4}\"", newVerdictName, oldVerdictName, localVerdictName, set.get_field_oldReason().get().get_value(), set.get_field_newReason().get().get_value()));
                        break;
                    }
                    if (!set.get_field_oldReason().is_present() || !set.get_field_newReason().is_present()) {
                        returnValue.append(MessageFormat.format("setverdict({0}): {1} -> {2}, component reason not changed", newVerdictName, oldVerdictName, localVerdictName));
                        break;
                    }
                    returnValue.append(MessageFormat.format("setverdict({0}): {1} -> {2} reason: \"{3}\", component reason not changed", newVerdictName, oldVerdictName, localVerdictName, set.get_field_oldReason().get().get_value()));
                    break;
                }
                case ALT_getVerdict: {
                    int tempOrdinal = choice.get_field_getVerdict().enum_value.ordinal();
                    String tempVerdictName = TitanVerdictType.VerdictTypeEnum.values()[tempOrdinal].getName();
                    returnValue.append(MessageFormat.format("getverdict: {0}", tempVerdictName));
                    break;
                }
                case ALT_finalVerdict: {
                    switch (choice.get_field_finalVerdict().get_field_choice().get_selection()) {
                        case UNBOUND_VALUE: {
                            break block0;
                        }
                        case ALT_info: {
                            TitanLoggerApi.FinalVerdictInfo info = choice.get_field_finalVerdict().get_field_choice().get_field_info();
                            if (info.get_field_is__ptc().get_value().booleanValue()) {
                                if (info.get_field_ptc__compref().is_present() && info.get_field_ptc__compref().get().get_int() != -3) {
                                    if (info.get_field_ptc__name().is_present() && info.get_field_ptc__name().get().lengthof().get_int() > 0) {
                                        returnValue.append(MessageFormat.format("Local verdict of PTC {0}({1}): ", info.get_field_ptc__name().get().get_value(), info.get_field_ptc__compref().get().get_int()));
                                    } else {
                                        returnValue.append(MessageFormat.format("Local verdict of PTC with component reference {0}: ", info.get_field_ptc__compref().get().get_int()));
                                    }
                                    int ptcOrdinal = info.get_field_ptc__verdict().enum_value.ordinal();
                                    String ptcVerdictName = TitanVerdictType.VerdictTypeEnum.values()[ptcOrdinal].getName();
                                    int localOrdinal = info.get_field_local__verdict().enum_value.ordinal();
                                    String localVerdictName = TitanVerdictType.VerdictTypeEnum.values()[localOrdinal].getName();
                                    int newOrdinal = info.get_field_new__verdict().enum_value.ordinal();
                                    String newVerdictName = TitanVerdictType.VerdictTypeEnum.values()[newOrdinal].getName();
                                    returnValue.append(MessageFormat.format("{0} ({1} -> {2})", ptcVerdictName, localVerdictName, newVerdictName));
                                    if (info.get_field_verdict__reason().is_present() && info.get_field_verdict__reason().get().lengthof().get_int() > 0) {
                                        returnValue.append(MessageFormat.format(" reason: \"{0}\"", info.get_field_verdict__reason().get().get_value()));
                                        break block0;
                                    }
                                } else {
                                    int localOrdinal = info.get_field_local__verdict().enum_value.ordinal();
                                    String localVerdictName = TitanVerdictType.VerdictTypeEnum.values()[localOrdinal].getName();
                                    returnValue.append(MessageFormat.format("Final verdict of PTC: {0}", localVerdictName));
                                    if (info.get_field_verdict__reason().is_present() && info.get_field_verdict__reason().get().lengthof().get_int() > 0) {
                                        returnValue.append(MessageFormat.format(" reason: \"{0}\"", info.get_field_verdict__reason().get().get_value()));
                                        break block0;
                                    }
                                }
                            } else {
                                int localOrdinal = info.get_field_local__verdict().enum_value.ordinal();
                                String localVerdictName = TitanVerdictType.VerdictTypeEnum.values()[localOrdinal].getName();
                                returnValue.append(MessageFormat.format("Local verdict of MTC: {0}", localVerdictName));
                                if (info.get_field_verdict__reason().is_present() && info.get_field_verdict__reason().get().lengthof().get_int() > 0) {
                                    returnValue.append(MessageFormat.format(" reason: \"{0}\"", info.get_field_verdict__reason().get().get_value()));
                                    break block0;
                                }
                            }
                            break block28;
                        }
                        case ALT_notification: {
                            switch (choice.get_field_finalVerdict().get_field_choice().get_field_notification().enum_value) {
                                case UNBOUND_VALUE: 
                                case UNKNOWN_VALUE: {
                                    break block0;
                                }
                                case no__ptcs__were__created: {
                                    returnValue.append("No PTCs were created.");
                                    break block0;
                                }
                                case setting__final__verdict__of__the__test__case: {
                                    returnValue.append("Setting final verdict of the test case.");
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static void statistics_str(StringBuilder returnValue, TitanLoggerApi.StatisticsType_choice choice) {
        switch (choice.get_selection()) {
            case ALT_verdictStatistics: {
                TitanLoggerApi.StatisticsType_choice_verdictStatistics statistics = choice.get_field_verdictStatistics();
                int none_count = statistics.get_field_none__().get_int();
                int pass_count = statistics.get_field_pass__().get_int();
                int inconc_count = statistics.get_field_inconc__().get_int();
                int fail_count = statistics.get_field_fail__().get_int();
                int error_count = statistics.get_field_error__().get_int();
                if (none_count > 0 || pass_count > 0 || inconc_count > 0 || fail_count > 0 || error_count > 0) {
                    returnValue.append(MessageFormat.format("Verdict Statistics: {0} none ({1} %), {2} pass ({3} %), {4} inconc ({5} %), {6} fail ({7} %), {8} error ({9} %)", none_count, statistics.get_field_nonePercent().get_value(), pass_count, statistics.get_field_passPercent().get_value(), inconc_count, statistics.get_field_inconcPercent().get_value(), fail_count, statistics.get_field_failPercent().get_value(), error_count, statistics.get_field_errorPercent().get_value()));
                    break;
                }
                returnValue.append("Verdict statistics: 0 none, 0 pass, 0 inconc, 0 fail, 0 error.");
                break;
            }
            case ALT_controlpartStart: {
                returnValue.append(MessageFormat.format("Execution of control part in module {0} started.", choice.get_field_controlpartStart().get_value()));
                break;
            }
            case ALT_controlpartFinish: {
                returnValue.append(MessageFormat.format("Execution of control part in module {0} finished.", choice.get_field_controlpartFinish().get_value()));
                break;
            }
            case ALT_controlpartErrors: {
                returnValue.append(MessageFormat.format("Number of errors outside test cases: {0}", choice.get_field_controlpartErrors().get_int()));
                break;
            }
        }
    }

    private static void parallel_str(StringBuilder returnValue, TitanLoggerApi.ParallelEvent_choice choice) {
        block0 : switch (choice.get_selection()) {
            case UNBOUND_VALUE: {
                break;
            }
            case ALT_parallelPTC: {
                TitanLoggerApi.ParallelPTC ptc = choice.get_field_parallelPTC();
                switch (ptc.get_field_reason().enum_value) {
                    case UNBOUND_VALUE: 
                    case UNKNOWN_VALUE: {
                        break block0;
                    }
                    case init__component__start: {
                        returnValue.append(MessageFormat.format("Initializing variables, timers and ports of component type {0}.{1}", ptc.get_field_module__().get_value(), ptc.get_field_name().get_value()));
                        if (ptc.get_field_tc__loc().lengthof().get_int() > 0) {
                            returnValue.append(MessageFormat.format(" inside testcase {0}", ptc.get_field_tc__loc().get_value()));
                        }
                        returnValue.append('.');
                        break block0;
                    }
                    case init__component__finish: {
                        returnValue.append(MessageFormat.format("Component type {0}.{1} was initialized.", ptc.get_field_module__().get_value(), ptc.get_field_name().get_value()));
                        break block0;
                    }
                    case terminating__component: {
                        returnValue.append(MessageFormat.format("Terminating component type {0}.{1}.", ptc.get_field_module__().get_value(), ptc.get_field_name().get_value()));
                        break block0;
                    }
                    case component__shut__down: {
                        returnValue.append(MessageFormat.format("Component type {0}.{1} was shut down", ptc.get_field_module__().get_value(), ptc.get_field_name().get_value()));
                        if (ptc.get_field_tc__loc().lengthof().get_int() > 0) {
                            returnValue.append(MessageFormat.format(" inside testcase {0}", ptc.get_field_tc__loc().get_value()));
                        }
                        returnValue.append('.');
                        break block0;
                    }
                    case error__idle__ptc: {
                        returnValue.append("Error occurred on idle PTC. The component terminates.");
                        break block0;
                    }
                    case ptc__created: {
                        returnValue.append(MessageFormat.format("PTC was created. Component reference: {0}, alive: {1}, type: {2}.{3}", ptc.get_field_compref().get_int(), ptc.get_field_alive__pid().get_int() > 0 ? "yes" : "no", ptc.get_field_module__().get_value(), ptc.get_field_name().get_value()));
                        if (ptc.get_field_compname().lengthof().get_int() > 0) {
                            returnValue.append(MessageFormat.format(", component name: {0}", ptc.get_field_compname().get_value()));
                        }
                        if (ptc.get_field_tc__loc().lengthof().get_int() != 0) {
                            returnValue.append(MessageFormat.format(", location: {0}", ptc.get_field_tc__loc().get_value()));
                        }
                        returnValue.append('.');
                        break block0;
                    }
                    case ptc__created__pid: {
                        returnValue.append(MessageFormat.format("PTC was created. Component reference: {0}, component type: {1}.{2}", ptc.get_field_compref().get_int(), ptc.get_field_module__().get_value(), ptc.get_field_name().get_value()));
                        if (ptc.get_field_compname().lengthof().get_int() > 0) {
                            returnValue.append(MessageFormat.format(", component name: {0}", ptc.get_field_compname().get_value()));
                        }
                        if (ptc.get_field_tc__loc().lengthof().get_int() != 0) {
                            returnValue.append(MessageFormat.format(", testcase name: {0}", ptc.get_field_tc__loc().get_value()));
                        }
                        returnValue.append(MessageFormat.format(", process id: {0}.", ptc.get_field_alive__pid().get_int()));
                        break block0;
                    }
                    case function__started: {
                        returnValue.append("Function was started.");
                        break block0;
                    }
                    case function__stopped: {
                        returnValue.append(MessageFormat.format("Function {0} was stopped. PTC terminates.", ptc.get_field_name().get_value()));
                        break block0;
                    }
                    case function__finished: {
                        returnValue.append(MessageFormat.format("Function {0} finished. PTC {1}.", ptc.get_field_name().get_value(), ptc.get_field_alive__pid().get_int() == 0 ? "terminates" : "remains alive and is waiting for next start"));
                        break block0;
                    }
                    case function__error: {
                        returnValue.append(MessageFormat.format("Function {0} finished with an error. PTC terminates.", ptc.get_field_name().get_value()));
                        break block0;
                    }
                    case ptc__done: {
                        returnValue.append(MessageFormat.format("PTC with component reference {0} is done.", ptc.get_field_compref().get_int()));
                        break block0;
                    }
                    case ptc__killed: {
                        returnValue.append(MessageFormat.format("PTC with component reference {0} is killed.", ptc.get_field_compref().get_int()));
                        break block0;
                    }
                    case stopping__mtc: {
                        returnValue.append("Stopping MTC. The current test case will be terminated.");
                        break block0;
                    }
                    case ptc__stopped: {
                        returnValue.append(MessageFormat.format("PTC with component reference {0} was stopped.", ptc.get_field_compref().get_int()));
                        break block0;
                    }
                    case all__comps__stopped: {
                        returnValue.append("All components were stopped.");
                        break block0;
                    }
                    case ptc__was__killed: {
                        returnValue.append(MessageFormat.format("PTC with component reference {0} was killed.", ptc.get_field_compref().get_int()));
                        break block0;
                    }
                    case all__comps__killed: {
                        returnValue.append("All components were killed.");
                        break block0;
                    }
                    case kill__request__frm__mc: {
                        returnValue.append("Kill was requested from MC. Terminating idle PTC.");
                        break block0;
                    }
                    case mtc__finished: {
                        returnValue.append("MTC finished.");
                        break block0;
                    }
                    case ptc__finished: {
                        returnValue.append(MessageFormat.format("TC {0}({1}) finished.", ptc.get_field_compname().get_value(), ptc.get_field_compref().get_int()));
                        break block0;
                    }
                }
                break;
            }
            case ALT_parallelPTC__exit: {
                TitanLoggerApi.PTC__exit px = choice.get_field_parallelPTC__exit();
                int compref = px.get_field_compref().get_int();
                if (compref == 1) {
                    returnValue.append("MTC finished.");
                    break;
                }
                String comp_name = TitanComponent.get_component_string(compref);
                if (comp_name == null) {
                    returnValue.append(MessageFormat.format("PTC with component reference {0} finished.", compref));
                } else {
                    returnValue.append(MessageFormat.format("PTC {0}({1}) finished.", comp_name, compref));
                }
                returnValue.append(MessageFormat.format(" Process statistics: { process id: {0}, ", px.get_field_pid().get_int()));
                break;
            }
            case ALT_parallelPort: {
                TitanLoggerApi.ParPort pp = choice.get_field_parallelPort();
                String direction = "on";
                String preposition = "and";
                switch (pp.get_field_operation().enum_value) {
                    case UNBOUND_VALUE: 
                    case UNKNOWN_VALUE: {
                        break;
                    }
                    case connect__: {
                        returnValue.append("Connect");
                        break;
                    }
                    case disconnect__: {
                        returnValue.append("Disconnect");
                        break;
                    }
                    case map__: {
                        returnValue.append("Map");
                        direction = "of";
                        preposition = "to";
                        break;
                    }
                    case unmap__: {
                        returnValue.append("Unmap");
                        direction = "of";
                        preposition = "from";
                    }
                }
                String src = TitanComponent.get_component_string(pp.get_field_srcCompref().get_int());
                String dst = TitanComponent.get_component_string(pp.get_field_dstCompref().get_int());
                returnValue.append(MessageFormat.format(" operation {0} {1}:{2} {3} {4}:{5} finished.", direction, src, pp.get_field_srcPort().get_value(), preposition, dst, pp.get_field_dstPort().get_value()));
                break;
            }
        }
    }

    private static void testcaseop_str(StringBuilder returnValue, TitanLoggerApi.TestcaseEvent_choice choice) {
        switch (choice.get_selection()) {
            case ALT_testcaseStarted: {
                returnValue.append(MessageFormat.format("Test case {0} started.", choice.get_field_testcaseStarted().get_field_testcase__name().get_value()));
                break;
            }
            case ALT_testcaseFinished: {
                int ordinal = choice.get_field_testcaseFinished().get_field_verdict().enum_value.ordinal();
                String verdictName = TitanVerdictType.VerdictTypeEnum.values()[ordinal].getName();
                returnValue.append(MessageFormat.format("Test case {0} finished. Verdict: {1}", choice.get_field_testcaseFinished().get_field_name().get_field_testcase__name().get_value(), verdictName));
                break;
            }
        }
    }

    private static void matchingop_str(StringBuilder returnValue, TitanLoggerApi.MatchingEvent_choice choice) {
        block0 : switch (choice.get_selection()) {
            case ALT_matchingDone: {
                TitanLoggerApi.MatchingDoneType md = choice.get_field_matchingDone();
                switch (md.get_field_reason().enum_value) {
                    case UNBOUND_VALUE: 
                    case UNKNOWN_VALUE: {
                        break;
                    }
                    case done__failed__no__return: {
                        returnValue.append(MessageFormat.format("Done operation with type {0} on PTC {1}  failed: The started function did not return a value.", md.get_field_type__().get_value(), md.get_field_ptc().get_int()));
                        break;
                    }
                    case done__failed__wrong__return__type: {
                        returnValue.append(MessageFormat.format("Done operation with type {0} on PTC {1}  failed: The started function returned a value of type {2}.", md.get_field_type__().get_value(), md.get_field_ptc().get_int(), md.get_field_return__type().get_value()));
                        break;
                    }
                    case any__component__done__successful: {
                        returnValue.append("Operation 'any component.done' was successful.");
                        break;
                    }
                    case any__component__done__failed: {
                        returnValue.append("Operation 'any component.done' failed because no PTCs were created in the testcase.");
                        break;
                    }
                    case all__component__done__successful: {
                        returnValue.append("Operation 'all component.done' was successful.");
                        break;
                    }
                    case any__component__killed__successful: {
                        returnValue.append("Operation 'any component.killed' was successful.");
                        break;
                    }
                    case any__component__killed__failed: {
                        returnValue.append("Operation 'any component.killed' failed because no PTCs were created in the testcase.");
                        break;
                    }
                    case all__component__killed__successful: {
                        returnValue.append("Operation 'all component.killed' was successful.");
                    }
                }
                break;
            }
            case ALT_matchingTimeout: {
                TitanLoggerApi.MatchingTimeout mt = choice.get_field_matchingTimeout();
                if (mt.get_field_timer__name().is_present()) {
                    returnValue.append(MessageFormat.format("Timeout operation on timer {0} failed: The timer is not started.", mt.get_field_timer__name().get().get_value()));
                    break;
                }
                returnValue.append("Operation `any timer.timeout' failed: The test component does not have active timers.");
                break;
            }
            case ALT_matchingFailure: {
                TitanLoggerApi.MatchingFailureType mf = choice.get_field_matchingFailure();
                boolean is_call = false;
                switch (mf.get_field_reason().enum_value) {
                    case message__does__not__match__template: {
                        returnValue.append(MessageFormat.format("Matching on port {0} {1}: First message in the queue does not match the template: ", mf.get_field_port__name().get_value(), mf.get_field_info().get_value()));
                        break block0;
                    }
                    case exception__does__not__match__template: {
                        returnValue.append(MessageFormat.format("Matching on port {0} failed: The first exception in the queue does not match the template: {1}", mf.get_field_port__name().get_value(), mf.get_field_info().get_value()));
                        break block0;
                    }
                    case parameters__of__call__do__not__match__template: {
                        is_call = true;
                    }
                    case parameters__of__reply__do__not__match__template: {
                        returnValue.append(MessageFormat.format("Matching on port {0} failed: The parameters of the first {1} in the queue do not match the template: {2}", mf.get_field_port__name().get_value(), is_call ? "call" : "reply", mf.get_field_info().get_value()));
                        break block0;
                    }
                    case sender__does__not__match__from__clause: {
                        returnValue.append(MessageFormat.format("Matching on port {0} failed: Sender of the first entity in the queue does not match the from clause: {1}", mf.get_field_port__name().get_value(), mf.get_field_info().get_value()));
                        break block0;
                    }
                    case sender__is__not__system: {
                        returnValue.append(MessageFormat.format("Matching on port {0} failed: Sender of the first entity in the queue is not the system.", mf.get_field_port__name().get_value()));
                        break block0;
                    }
                    case not__an__exception__for__signature: {
                        returnValue.append(MessageFormat.format("Matching on port {0} failed: The first entity in the queue is not an exception for signature {1}.", mf.get_field_port__name().get_value(), mf.get_field_info().get_value()));
                        break block0;
                    }
                }
                break;
            }
            case ALT_matchingSuccess: {
                TitanLoggerApi.MatchingSuccessType ms = choice.get_field_matchingSuccess();
                returnValue.append(MessageFormat.format("Matching on port {0} succeeded: {1}", ms.get_field_port__name().get_value(), ms.get_field_info().get_value()));
                break;
            }
            case ALT_matchingProblem: {
                TitanLoggerApi.MatchingProblemType mp = choice.get_field_matchingProblem();
                returnValue.append("Operation `");
                if (mp.get_field_any__port().get_value().booleanValue()) {
                    returnValue.append("any port.");
                }
                if (mp.get_field_check__().get_value().booleanValue()) {
                    returnValue.append("check(");
                }
                switch (mp.get_field_operation().enum_value) {
                    case receive__: {
                        returnValue.append("receive");
                        break;
                    }
                    case trigger__: {
                        returnValue.append("trigger");
                        break;
                    }
                    case getcall__: {
                        returnValue.append("getcall");
                        break;
                    }
                    case getreply__: {
                        returnValue.append("getreply");
                        break;
                    }
                    case catch__: {
                        returnValue.append("catch");
                        break;
                    }
                    case check__: {
                        returnValue.append("check");
                        break;
                    }
                }
                if (mp.get_field_check__().get_value().booleanValue()) {
                    returnValue.append(')');
                }
                returnValue.append("' ");
                if (mp.get_field_port__name().is_bound()) {
                    returnValue.append(MessageFormat.format("on port {0} ", mp.get_field_port__name().get_value()));
                }
                returnValue.append("failed: ");
                switch (mp.get_field_reason().enum_value) {
                    case component__has__no__ports: {
                        returnValue.append("The test component does not have ports.");
                        break block0;
                    }
                    case no__incoming__signatures: {
                        returnValue.append("The port type does not have any incoming signatures.");
                        break block0;
                    }
                    case no__incoming__types: {
                        returnValue.append("The port type does not have any incoming message types.");
                        break block0;
                    }
                    case no__outgoing__blocking__signatures: {
                        returnValue.append("The port type does not have any outgoing blocking signatures.");
                        break block0;
                    }
                    case no__outgoing__blocking__signatures__that__support__exceptions: {
                        returnValue.append("The port type does not have any outgoing blocking signatures that support exceptions.");
                        break block0;
                    }
                    case port__not__started__and__queue__empty: {
                        returnValue.append("Port is not started and the queue is empty.");
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public static String plugin_specific_settings() {
        String[] disk_full_action_type_names = new String[]{"Error", "Stop", "Retry", "Delete"};
        String disk_full_action_str = null;
        disk_full_action_str = LegacyLogger.myself.disk_full_action_.type == TTCN_Logger.disk_full_action_type_t.DISKFULL_RETRY ? MessageFormat.format("Retry({0})", LegacyLogger.myself.disk_full_action_.retry_interval) : disk_full_action_type_names[LegacyLogger.myself.disk_full_action_.type.ordinal()];
        return MessageFormat.format("LogFileSize:={0}; LogFileNumber:={1}; DiskFullAction:={2}", LegacyLogger.myself.logfile_size_, LegacyLogger.myself.logfile_number_, disk_full_action_str);
    }

    private static void portevent_str(StringBuilder returnValue, TitanLoggerApi.PortEvent_choice choice) {
        block0 : switch (choice.get_selection()) {
            case ALT_portQueue: {
                TitanLoggerApi.Port__Queue portQueue = choice.get_field_portQueue();
                switch (portQueue.get_field_operation().enum_value) {
                    case enqueue__msg: {
                        String comp_str = TitanComponent.get_component_string(portQueue.get_field_compref().get_int());
                        returnValue.append(MessageFormat.format("Message enqueued on {0} from {1}{2}{3} id {4}", portQueue.get_field_port__name().get_value(), comp_str, portQueue.get_field_address__().get_value(), portQueue.get_field_param__().get_value(), portQueue.get_field_msgid().get_int()));
                        break block0;
                    }
                    case enqueue__call: {
                        String comp_str = TitanComponent.get_component_string(portQueue.get_field_compref().get_int());
                        returnValue.append(MessageFormat.format("Call enqueued on {0} from {1}{2}{3} id {4}", portQueue.get_field_port__name().get_value(), comp_str, portQueue.get_field_address__().get_value(), portQueue.get_field_param__().get_value(), portQueue.get_field_msgid().get_int()));
                        break block0;
                    }
                    case enqueue__reply: {
                        String comp_str = TitanComponent.get_component_string(portQueue.get_field_compref().get_int());
                        returnValue.append(MessageFormat.format("Reply enqueued on {0} from {1}{2}{3} id {4}", portQueue.get_field_port__name().get_value(), comp_str, portQueue.get_field_address__().get_value(), portQueue.get_field_param__().get_value(), portQueue.get_field_msgid().get_int()));
                        break block0;
                    }
                    case enqueue__exception: {
                        String comp_str = TitanComponent.get_component_string(portQueue.get_field_compref().get_int());
                        returnValue.append(MessageFormat.format("Exception enqueued on {0} from {1}{2}{3} id {4}", portQueue.get_field_port__name().get_value(), comp_str, portQueue.get_field_address__().get_value(), portQueue.get_field_param__().get_value(), portQueue.get_field_msgid().get_int()));
                        break block0;
                    }
                    case extract__msg: {
                        returnValue.append(MessageFormat.format("Message with id {0} was extracted from the queue of {1}.", portQueue.get_field_msgid().get_int(), portQueue.get_field_port__name().get_value()));
                        break block0;
                    }
                    case extract__op: {
                        returnValue.append(MessageFormat.format("Operation with id {0} was extracted from the queue of {1}.", portQueue.get_field_msgid().get_int(), portQueue.get_field_port__name().get_value()));
                        break block0;
                    }
                }
                break;
            }
            case ALT_portState: {
                TitanLoggerApi.Port__State ps = choice.get_field_portState();
                String what = "";
                switch (ps.get_field_operation().enum_value) {
                    case started: {
                        what = "started";
                        break;
                    }
                    case stopped: {
                        what = "stopped";
                        break;
                    }
                    case halted: {
                        what = "halted";
                        break;
                    }
                    default: {
                        return;
                    }
                }
                returnValue.append(MessageFormat.format("Port {0} was {1}.", ps.get_field_port__name().get_value(), what));
                break;
            }
            case ALT_procPortSend: {
                TitanLoggerApi.Proc__port__out ps = choice.get_field_procPortSend();
                String dest = ps.get_field_compref().get_int() == 2 ? ps.get_field_sys__name().get_value().toString() : TitanComponent.get_component_string(ps.get_field_compref().get_int());
                switch (ps.get_field_operation().enum_value) {
                    case call__op: {
                        returnValue.append("Called");
                        break;
                    }
                    case reply__op: {
                        returnValue.append("Replied");
                        break;
                    }
                    case exception__op: {
                        returnValue.append("Raised");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                returnValue.append(MessageFormat.format(" on {0} to {1} {2}", ps.get_field_port__name().get_value(), dest, ps.get_field_parameter().get_value()));
                break;
            }
            case ALT_procPortRecv: {
                TitanLoggerApi.Proc__port__in ps = choice.get_field_procPortRecv();
                String op2 = "";
                switch (ps.get_field_operation().enum_value) {
                    case call__op: {
                        returnValue.append(ps.get_field_check__().get_value() != false ? "Check-getcall" : "Getcall");
                        op2 = "call";
                        break;
                    }
                    case reply__op: {
                        returnValue.append(ps.get_field_check__().get_value() != false ? "Check-getreply" : "Getreply");
                        op2 = "reply";
                        break;
                    }
                    case exception__op: {
                        returnValue.append(ps.get_field_check__().get_value() != false ? "Check-catch" : "Catch");
                        op2 = "exception";
                        break;
                    }
                    default: {
                        return;
                    }
                }
                String source = TitanComponent.get_component_string(ps.get_field_compref().get_int());
                returnValue.append(MessageFormat.format(" operation on port {0} succeeded, {1} from {2}: {3} id {4}", ps.get_field_port__name().get_value(), op2, source, ps.get_field_parameter().get_value(), ps.get_field_msgid().get_int()));
                break;
            }
            case ALT_msgPortSend: {
                TitanLoggerApi.Msg__port__send ms = choice.get_field_msgPortSend();
                String dest = TitanComponent.get_component_string(ms.get_field_compref().get_int());
                returnValue.append(MessageFormat.format("Sent on {0} to {1}{2}", ms.get_field_port__name().get_value(), dest, ms.get_field_parameter().get_value()));
                break;
            }
            case ALT_msgPortRecv: {
                TitanLoggerApi.Msg__port__recv ms = choice.get_field_msgPortRecv();
                switch (ms.get_field_operation().enum_value) {
                    case receive__op: {
                        returnValue.append("Receive");
                        break;
                    }
                    case check__receive__op: {
                        returnValue.append("Check-receive");
                        break;
                    }
                    case trigger__op: {
                        returnValue.append("Trigger");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                returnValue.append(MessageFormat.format(" operation on port {0} succeeded, message from ", ms.get_field_port__name().get_value()));
                if (ms.get_field_compref().get_int() == 2) {
                    returnValue.append(MessageFormat.format("system({0})", ms.get_field_sys__name().get_value()));
                } else {
                    String dest = TitanComponent.get_component_string(ms.get_field_compref().get_int());
                    returnValue.append(dest);
                }
                returnValue.append(MessageFormat.format("{0} id {1}", ms.get_field_parameter().get_value(), ms.get_field_msgid().get_int()));
                break;
            }
            case ALT_dualMapped: {
                TitanLoggerApi.Dualface__mapped dual = choice.get_field_dualMapped();
                returnValue.append(MessageFormat.format("{0} message was mapped to {1} : {2}", dual.get_field_incoming().get_value() != false ? "Incoming" : "Outgoing", dual.get_field_target__type().get_value(), dual.get_field_value__().get_value()));
                if (!dual.get_field_incoming().get_value().booleanValue()) break;
                returnValue.append(MessageFormat.format(" id {0}", dual.get_field_msgid().get_int()));
                break;
            }
            case ALT_dualDiscard: {
                TitanLoggerApi.Dualface__discard dual = choice.get_field_dualDiscard();
                returnValue.append(MessageFormat.format("{0} message of type {1} ", dual.get_field_incoming().get_value() != false ? "Incoming" : "Outgoing", dual.get_field_target__type().get_value()));
                if (dual.get_field_unhandled().get_value().booleanValue()) {
                    returnValue.append(MessageFormat.format("could not be handled by the type mapping rules on port {0}.  The message was discarded.", dual.get_field_port__name().get_value()));
                    break;
                }
                returnValue.append(MessageFormat.format(" was discarded on port {0}", dual.get_field_port__name().get_value()));
                break;
            }
            case ALT_setState: {
                TitanLoggerApi.Setstate setstate = choice.get_field_setState();
                returnValue.append(MessageFormat.format("The state of the {0} port was changed by a setstate operation to {1}.", setstate.get_field_port__name().get_value(), setstate.get_field_state().get_value()));
                if (setstate.get_field_info().lengthof().get_int() == 0) break;
                returnValue.append(MessageFormat.format(" Information: {0}", setstate.get_field_info().get_value()));
                break;
            }
            case ALT_portMisc: {
                TitanLoggerApi.Port__Misc portMisc = choice.get_field_portMisc();
                String comp_str = TitanComponent.get_component_string(portMisc.get_field_remote__component().get_int());
                switch (portMisc.get_field_reason().enum_value) {
                    case removing__unterminated__connection: {
                        returnValue.append(MessageFormat.format("Removing unterminated connection between port {0} and {1}:{2}.", portMisc.get_field_port__name().get_value(), comp_str, portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                    case removing__unterminated__mapping: {
                        returnValue.append(MessageFormat.format("Removing unterminated mapping between port {0} and system:{1}.", portMisc.get_field_port__name().get_value(), portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                    case port__was__cleared: {
                        returnValue.append(MessageFormat.format("Port {0} was cleared.", portMisc.get_field_port__name().get_value()));
                        break block0;
                    }
                    case local__connection__established: {
                        returnValue.append(MessageFormat.format("Port {0} has established the connection with local port {1}.", portMisc.get_field_port__name().get_value(), portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                    case local__connection__terminated: {
                        returnValue.append(MessageFormat.format("Port {0} has terminated the connection with local port {1}.", portMisc.get_field_port__name().get_value(), portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                    case port__is__waiting__for__connection__tcp: {
                        returnValue.append(MessageFormat.format("Port {0} is waiting for connection from {1}:{2} on TCP port {3}:{4}.", portMisc.get_field_port__name().get_value(), comp_str, portMisc.get_field_remote__port().get_value(), portMisc.get_field_ip__address().get_value(), portMisc.get_field_tcp__port().get_int()));
                        break block0;
                    }
                    case port__is__waiting__for__connection__unix: {
                        returnValue.append(MessageFormat.format("Port {0} is waiting for connection from {1}:{2} on UNIX pathname {3}.", portMisc.get_field_port__name().get_value(), comp_str, portMisc.get_field_remote__port().get_value(), portMisc.get_field_ip__address().get_value()));
                        break block0;
                    }
                    case connection__established: {
                        returnValue.append(MessageFormat.format("Port {0} has established the connection with {1}:{2} using transport type {3}.", portMisc.get_field_port__name().get_value(), comp_str, portMisc.get_field_remote__port().get_value(), portMisc.get_field_ip__address().get_value()));
                        break block0;
                    }
                    case destroying__unestablished__connection: {
                        returnValue.append(MessageFormat.format("Destroying unestablished connection of port {0} to {1}:{2} because the other endpoint has terminated.", portMisc.get_field_port__name().get_value(), comp_str, portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                    case terminating__connection: {
                        returnValue.append(MessageFormat.format("Terminating the connection of port {0} to {1}:{2}. No more messages can be sent through this connection.", portMisc.get_field_port__name().get_value(), comp_str, portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                    case sending__termination__request__failed: {
                        returnValue.append(MessageFormat.format("Sending the connection termination request on port {0} to remote endpoint {1}:}{2} failed.", portMisc.get_field_port__name().get_value(), comp_str, portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                    case termination__request__received: {
                        returnValue.append(MessageFormat.format("Connection termination request was received on port {0} from {1}:{2}. No more data can be sent or received through this connection.", portMisc.get_field_port__name().get_value(), comp_str, portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                    case acknowledging__termination__request__failed: {
                        returnValue.append(MessageFormat.format("Sending the acknowledgment for connection termination request on port {0} to remote endpoint {1}:{2} failed.", portMisc.get_field_port__name().get_value(), comp_str, portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                    case sending__would__block: {
                        returnValue.append(MessageFormat.format("Sending data on the connection of port {0} to {1}:{2} would block execution. The size of the outgoing buffer was increased from {3} to {4} bytes.", portMisc.get_field_port__name().get_value(), comp_str, portMisc.get_field_remote__port().get_value(), portMisc.get_field_tcp__port().get_int(), portMisc.get_field_new__size().get_int()));
                        break block0;
                    }
                    case connection__accepted: {
                        returnValue.append(MessageFormat.format("Port {0} has accepted the connection from {1}:{2}.", portMisc.get_field_port__name().get_value(), comp_str, portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                    case connection__reset__by__peer: {
                        returnValue.append(MessageFormat.format("Connection of port {0} to {1}:{2} was reset by the peer.", portMisc.get_field_port__name().get_value(), comp_str, portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                    case connection__closed__by__peer: {
                        returnValue.append(MessageFormat.format("Connection of port {0} to {1}:{2} was closed unexpectedly by the peer.", portMisc.get_field_port__name().get_value(), comp_str, portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                    case port__disconnected: {
                        returnValue.append(MessageFormat.format("Port {0} was disconnected from {1}:{2}.", portMisc.get_field_port__name().get_value(), comp_str, portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                    case port__was__mapped__to__system: {
                        returnValue.append(MessageFormat.format("Port {0} was mapped to system:{1}.", portMisc.get_field_port__name().get_value(), portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                    case port__was__unmapped__from__system: {
                        returnValue.append(MessageFormat.format("Port {0} was unmapped from system:{1}.", portMisc.get_field_port__name().get_value(), portMisc.get_field_remote__port().get_value()));
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private static enum whoami {
        SINGLE,
        HC,
        MTC,
        PTC;

    }
}

