/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.runtime.core.Event_Handler;
import org.eclipse.titan.runtime.core.Module_List;
import org.eclipse.titan.runtime.core.NetworkHandler;
import org.eclipse.titan.runtime.core.TC_End;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TTCN_Runtime;
import org.eclipse.titan.runtime.core.TTCN_Snapshot;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanComponent;
import org.eclipse.titan.runtime.core.TitanLoggerApi;
import org.eclipse.titan.runtime.core.TitanPort;
import org.eclipse.titan.runtime.core.TitanVerdictType;
import org.eclipse.titan.runtime.core.TtcnError;
import org.eclipse.titan.runtime.core.cfgparser.CfgAnalyzer;

public final class TTCN_Communication {
    private static final int MSG_ERROR = 0;
    private static final int MSG_LOG = 1;
    private static final int MSG_VERSION = 2;
    private static final int MSG_MTC_CREATED = 3;
    private static final int MSG_PTC_CREATED = 4;
    private static final int MSG_CREATE_MTC = 2;
    private static final int MSG_CREATE_PTC = 3;
    private static final int MSG_KILL_PROCESS = 4;
    private static final int MSG_EXIT_HC = 5;
    private static final int MSG_CREATE_NAK = 4;
    private static final int MSG_HC_READY = 5;
    private static final int MSG_CREATE_ACK = 1;
    private static final int MSG_START_ACK = 2;
    private static final int MSG_STOP = 3;
    private static final int MSG_STOP_ACK = 4;
    private static final int MSG_KILL_ACK = 5;
    private static final int MSG_RUNNING = 6;
    private static final int MSG_ALIVE = 7;
    private static final int MSG_DONE_ACK = 8;
    private static final int MSG_KILLED_ACK = 9;
    private static final int MSG_CANCEL_DONE = 10;
    private static final int MSG_COMPONENT_STATUS = 11;
    private static final int MSG_CONNECT_LISTEN = 12;
    private static final int MSG_CONNECT = 13;
    private static final int MSG_CONNECT_ACK = 14;
    private static final int MSG_DISCONNECT = 15;
    private static final int MSG_DISCONNECT_ACK = 16;
    private static final int MSG_MAP = 17;
    private static final int MSG_MAP_ACK = 18;
    private static final int MSG_UNMAP = 19;
    private static final int MSG_UNMAP_ACK = 20;
    private static final int MSG_EXECUTE_CONTROL = 21;
    private static final int MSG_EXECUTE_TESTCASE = 22;
    private static final int MSG_PTC_VERDICT = 23;
    private static final int MSG_CONTINUE = 24;
    private static final int MSG_EXIT_MTC = 25;
    private static final int MSG_START = 21;
    private static final int MSG_KILL = 22;
    private static final int MSG_CREATE_REQ = 2;
    private static final int MSG_START_REQ = 3;
    private static final int MSG_STOP_REQ = 4;
    private static final int MSG_KILL_REQ = 5;
    private static final int MSG_IS_RUNNING = 6;
    private static final int MSG_IS_ALIVE = 7;
    private static final int MSG_DONE_REQ = 8;
    private static final int MSG_KILLED_REQ = 9;
    private static final int MSG_CANCEL_DONE_ACK = 10;
    private static final int MSG_CONNECT_REQ = 11;
    private static final int MSG_CONNECT_LISTEN_ACK = 12;
    private static final int MSG_CONNECTED = 13;
    private static final int MSG_CONNECT_ERROR = 14;
    private static final int MSG_DISCONNECT_REQ = 15;
    private static final int MSG_DISCONNECTED = 16;
    private static final int MSG_MAP_REQ = 17;
    private static final int MSG_MAPPED = 18;
    private static final int MSG_UNMAP_REQ = 19;
    private static final int MSG_UNMAPPED = 20;
    private static final int MSG_DEBUG_HALT_REQ = 101;
    private static final int MSG_DEBUG_CONTINUE_REQ = 102;
    private static final int MSG_DEBUG_BATCH = 103;
    private static final int MSG_TESTCASE_STARTED = 21;
    private static final int MSG_TESTCASE_FINISHED = 22;
    private static final int MSG_MTC_READY = 23;
    private static final int MSG_STOPPED = 21;
    private static final int MSG_STOPPED_KILLED = 22;
    private static final int MSG_KILLED = 23;
    private static final int MSG_DEBUG_COMMAND = 100;
    private static final int MSG_DEBUG_RETURN_VALUE = 100;
    private static final int MSG_CONFIGURE = 200;
    private static final int MSG_CONFIGURE_ACK = 200;
    private static final int MSG_CONFIGURE_NAK = 201;
    private static boolean mc_addr_set = false;
    private static ThreadLocal<Boolean> is_connected = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static String MC_host;
    private static int MC_port;
    private static NetworkHandler.HCNetworkHandler hcnh;
    private static boolean local_addr_set;
    private static ThreadLocal<SocketChannel> mc_socketchannel;
    private static ThreadLocal<MC_Connection> mc_connection;
    private static ThreadLocal<Double> call_interval;
    private static ThreadLocal<Text_Buf> incoming_buf;

    public static NetworkHandler.NetworkFamily get_network_family() {
        return hcnh.get_family();
    }

    public static boolean has_local_address() {
        return local_addr_set;
    }

    public static void set_local_address(String host_name) {
        if (local_addr_set) {
            TtcnError.TtcnWarning("The local address has already been set.");
        }
        if (is_connected.get().booleanValue()) {
            throw new TtcnError("Trying to change the local address, but there is an existing control connection to MC.");
        }
        if (host_name == null) {
            throw new TtcnError("TTCN_Communication.set_local_address: internal error: invalid host name.");
        }
        if (!hcnh.set_local_addr(host_name, 0)) {
            throw new TtcnError(MessageFormat.format("Could not get the IP address for the local address ({0}): Host name lookup failure.", host_name));
        }
        TTCN_Logger.log_executor_misc(TitanLoggerApi.ExecutorUnqualified_reason.enum_type.local__address__was__set, hcnh.get_local_host_str(), hcnh.get_local_addr_str(), 0);
        local_addr_set = true;
    }

    public static InetAddress get_local_address() {
        if (!local_addr_set) {
            throw new TtcnError("TTCN_Communication.get_local_address: internal error: the local address has not been set.");
        }
        return hcnh.get_local_addr().getAddress();
    }

    public static void set_mc_address(String MC_host, int MC_port) {
        if (mc_addr_set) {
            TtcnError.TtcnWarning("The address of MC has already been set.");
        }
        if (is_connected.get().booleanValue()) {
            throw new TtcnError("Trying to change the address of MC, but there is an existing connection.");
        }
        if (MC_host == null) {
            throw new TtcnError("TTCN_Communication.set_mc_address: internal error: invalid host name.");
        }
        if (MC_port < 0) {
            throw new TtcnError(MessageFormat.format("TTCN_Communication.set_mc_address: internal error: invalid TCP port. {0,number,#}", MC_port));
        }
        hcnh.set_family(new InetSocketAddress(MC_host, MC_port));
        if (!hcnh.set_mc_addr(MC_host, MC_port)) {
            throw new TtcnError(MessageFormat.format("Could not get the IP address of MC ({0}): Host name lookup failure.", MC_host));
        }
        if (hcnh.is_local(hcnh.get_mc_addr())) {
            TtcnError.TtcnWarning("The address of MC was set to a local IP address. This may cause incorrect behavior if a HC from a remote host also connects to MC.");
        }
        TTCN_Logger.log_executor_misc(TitanLoggerApi.ExecutorUnqualified_reason.enum_type.address__of__mc__was__set, hcnh.get_mc_host_str(), hcnh.get_mc_addr_str(), hcnh.get_mc_port());
        TTCN_Communication.MC_host = MC_host;
        TTCN_Communication.MC_port = MC_port;
        mc_addr_set = true;
    }

    public static boolean is_mc_connected() {
        return is_connected.get();
    }

    public static void connect_mc() {
        if (is_connected.get().booleanValue()) {
            throw new TtcnError("Trying to re-connect to MC, but there is an existing connection.");
        }
        if (!mc_addr_set) {
            throw new TtcnError("Trying to connect to MC, but the address of MC has not yet been set.");
        }
        SocketChannel newChannel = hcnh.connect_to_mc();
        mc_socketchannel.set(newChannel);
        if (newChannel == null) {
            throw new TtcnError(MessageFormat.format("Connecting to MC failed. MC address: {0}:{1,number,#} \r\n", hcnh.get_mc_addr_str(), hcnh.get_mc_port()));
        }
        MC_Connection newMCConnection = new MC_Connection(newChannel, incoming_buf.get());
        mc_connection.set(newMCConnection);
        try {
            newChannel.configureBlocking(false);
            TTCN_Snapshot.channelMap.get().put(newChannel, newMCConnection);
            newChannel.register(TTCN_Snapshot.selector.get(), 1);
        }
        catch (IOException e) {
            throw new TtcnError(e);
        }
        TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.connected__to__mc);
        is_connected.set(true);
    }

    public static void disconnect_mc() {
        if (is_connected.get().booleanValue()) {
            TTCN_Communication.close_mc_connection();
            TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.disconnected__from__mc);
        }
    }

    public static void close_mc_connection() {
        if (is_connected.get().booleanValue()) {
            call_interval.set(0.0);
            is_connected.set(false);
            incoming_buf.get().reset();
            try {
                mc_socketchannel.get().close();
            }
            catch (IOException e) {
                throw new TtcnError(e);
            }
            TTCN_Snapshot.channelMap.get().remove(mc_socketchannel);
            TTCN_Snapshot.set_timer(mc_connection.get(), 0.0, true, true, true);
        }
    }

    public static boolean set_tcp_nodelay(NetworkChannel fd, Boolean enable_nodelay) {
        try {
            fd.setOption(StandardSocketOptions.TCP_NODELAY, enable_nodelay);
            return true;
        }
        catch (IOException e) {
            TTCN_Logger.begin_event(TTCN_Logger.Severity.ERROR_UNQUALIFIED);
            TTCN_Logger.log_event(e.toString(), new Object[0]);
            TTCN_Logger.end_event();
            return false;
        }
    }

    public static boolean set_non_blocking_mode(AbstractSelectableChannel fd, boolean enable_nonblock) {
        try {
            fd.configureBlocking(!enable_nonblock);
            return true;
        }
        catch (IOException e) {
            TTCN_Logger.begin_event(TTCN_Logger.Severity.ERROR_UNQUALIFIED);
            TTCN_Logger.log_event(e.toString(), new Object[0]);
            TTCN_Logger.end_event();
            return false;
        }
    }

    public static void enable_periodic_call() {
        call_interval.set(1.0);
        TTCN_Snapshot.set_timer(mc_connection.get(), call_interval.get(), true, false, true);
    }

    public static void increase_call_interval() {
        if (call_interval.get() == null || call_interval.get() <= 0.0) {
            throw new TtcnError("INternal error: TTCN_Communication.increase_call_interval was called when call interval is not set.");
        }
        call_interval.set(call_interval.get() * 2.0);
        TTCN_Snapshot.set_timer(mc_connection.get(), call_interval.get(), true, false, true);
    }

    public static void disable_periodic_call() {
        TTCN_Snapshot.set_timer(mc_connection.get(), 0.0, true, true, true);
        call_interval.set(0.0);
    }

    public static void process_all_messages_hc() {
        if (!TTCN_Runtime.is_hc()) {
            throw new TtcnError("Internal error: TTCN_Communication.process_all_messages_hc() was called in invalid state.");
        }
        TTCN_Runtime.wait_terminated_processes();
        boolean wait_flag = false;
        boolean check_overload = TTCN_Runtime.is_overloaded();
        Text_Buf local_incoming_buf = incoming_buf.get();
        block9: while (local_incoming_buf.is_message()) {
            wait_flag = true;
            int msg_len = local_incoming_buf.pull_int().get_int();
            int msg_end = local_incoming_buf.get_pos() + msg_len;
            int msg_type = local_incoming_buf.pull_int().get_int();
            switch (msg_type) {
                case 0: {
                    TTCN_Communication.process_error();
                    continue block9;
                }
                case 200: {
                    TTCN_Communication.process_configure(msg_end, false);
                    continue block9;
                }
                case 2: {
                    TTCN_Communication.process_create_mtc();
                    TTCN_Runtime.wait_terminated_processes();
                    wait_flag = false;
                    check_overload = false;
                    continue block9;
                }
                case 3: {
                    TTCN_Communication.process_create_ptc();
                    TTCN_Runtime.wait_terminated_processes();
                    wait_flag = false;
                    check_overload = false;
                    continue block9;
                }
                case 4: {
                    TTCN_Communication.process_kill_process();
                    TTCN_Runtime.wait_terminated_processes();
                    wait_flag = false;
                    continue block9;
                }
                case 5: {
                    TTCN_Communication.process_exit_hc();
                    continue block9;
                }
                case 100: {
                    TTCN_Communication.process_debug_command();
                    continue block9;
                }
            }
            TTCN_Communication.process_unsupported_message(msg_type, msg_end);
        }
        if (wait_flag) {
            TTCN_Runtime.wait_terminated_processes();
        }
        if (!check_overload || TTCN_Runtime.is_overloaded()) {
            // empty if block
        }
    }

    public static void process_all_messages_tc() {
        if (!TTCN_Runtime.is_tc()) {
            throw new TtcnError("Internal error: TTCN_Communication.process_all_messages_tc() was called in invalid state.");
        }
        Text_Buf local_incoming_buf = incoming_buf.get();
        block36: while (local_incoming_buf.is_message()) {
            int msg_len = local_incoming_buf.pull_int().get_int();
            int msg_end = local_incoming_buf.get_pos() + msg_len;
            int msg_type = local_incoming_buf.pull_int().get_int();
            switch (msg_type) {
                case 0: {
                    TTCN_Communication.process_error();
                    continue block36;
                }
                case 1: {
                    TTCN_Communication.process_create_ack();
                    continue block36;
                }
                case 2: {
                    TTCN_Communication.process_start_ack();
                    continue block36;
                }
                case 3: {
                    TTCN_Communication.process_stop();
                    continue block36;
                }
                case 4: {
                    TTCN_Communication.process_stop_ack();
                    continue block36;
                }
                case 5: {
                    TTCN_Communication.process_kill_ack();
                    continue block36;
                }
                case 6: {
                    TTCN_Communication.process_running();
                    continue block36;
                }
                case 7: {
                    TTCN_Communication.process_alive();
                    continue block36;
                }
                case 8: {
                    TTCN_Communication.process_done_ack(msg_end);
                    continue block36;
                }
                case 9: {
                    TTCN_Communication.process_killed_ack();
                    continue block36;
                }
                case 10: {
                    if (TTCN_Runtime.is_mtc()) {
                        TTCN_Communication.process_cancel_done_mtc();
                        continue block36;
                    }
                    TTCN_Communication.process_cancel_done_ptc();
                    continue block36;
                }
                case 11: {
                    if (TTCN_Runtime.is_mtc()) {
                        TTCN_Communication.process_component_status_mtc(msg_end);
                        continue block36;
                    }
                    TTCN_Communication.process_component_status_ptc(msg_end);
                    continue block36;
                }
                case 12: {
                    TTCN_Communication.process_connect_listen();
                    continue block36;
                }
                case 13: {
                    TTCN_Communication.process_connect();
                    continue block36;
                }
                case 14: {
                    TTCN_Communication.process_connect_ack();
                    continue block36;
                }
                case 15: {
                    TTCN_Communication.process_disconnect();
                    continue block36;
                }
                case 16: {
                    TTCN_Communication.process_disconnect_ack();
                    continue block36;
                }
                case 17: {
                    TTCN_Communication.process_map();
                    continue block36;
                }
                case 18: {
                    TTCN_Communication.process_map_ack();
                    continue block36;
                }
                case 19: {
                    TTCN_Communication.process_unmap();
                    continue block36;
                }
                case 20: {
                    TTCN_Communication.process_unmap_ack();
                    continue block36;
                }
                case 100: {
                    throw new TtcnError("MSG_DEBUG_COMMAND received, but not yet supported!");
                }
            }
            if (TTCN_Runtime.is_mtc()) {
                switch (msg_type) {
                    case 21: {
                        TTCN_Communication.process_execute_control();
                        continue block36;
                    }
                    case 22: {
                        TTCN_Communication.process_execute_testcase();
                        continue block36;
                    }
                    case 23: {
                        TTCN_Communication.process_ptc_verdict();
                        continue block36;
                    }
                    case 24: {
                        throw new TtcnError("MSG_CONTINUE received, but not yet supported!");
                    }
                    case 25: {
                        TTCN_Communication.process_exit_mtc();
                        continue block36;
                    }
                    case 200: {
                        throw new TtcnError("MSG_CONFIGURE received, but not yet supported!");
                    }
                }
                TTCN_Communication.process_unsupported_message(msg_type, msg_end);
                continue;
            }
            switch (msg_type) {
                case 21: {
                    TTCN_Communication.process_start();
                    continue block36;
                }
                case 22: {
                    TTCN_Communication.process_kill();
                    continue block36;
                }
            }
            TTCN_Communication.process_unsupported_message(msg_type, msg_end);
        }
    }

    public static void send_version() {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(2);
        text_buf.push_int(11);
        text_buf.push_int(1);
        text_buf.push_int(0);
        text_buf.push_int(0);
        Module_List.push_version(text_buf);
        text_buf.push_string(TTCN_Runtime.get_host_name());
        text_buf.push_string(System.getProperty("os.arch"));
        text_buf.push_string(System.getProperty("os.name"));
        text_buf.push_string(System.getProperty("os.version"));
        text_buf.push_string("");
        text_buf.push_int(2);
        text_buf.push_int(transport_type_enum.TRANSPORT_LOCAL.ordinal());
        text_buf.push_int(transport_type_enum.TRANSPORT_INET_STREAM.ordinal());
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_configure_ack() {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(200);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_configure_nak() {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(201);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_hc_ready() {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(5);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_create_req(String componentTypeModule, String componentTypeName, String componentName, String componentLocation, boolean is_alive, double testcase_start_time) {
        long seconds = (long)testcase_start_time;
        int microseconds = (int)((testcase_start_time - (double)seconds) * 1000.0);
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(2);
        text_buf.push_string(componentTypeModule);
        text_buf.push_string(componentTypeName);
        text_buf.push_string(componentName);
        text_buf.push_string(componentLocation);
        text_buf.push_int(is_alive ? 1 : 0);
        int upper_int = (int)(seconds / -1L);
        int lower_int = (int)(seconds % -1L);
        text_buf.push_int(upper_int);
        text_buf.push_int(lower_int);
        text_buf.push_int(microseconds);
        TTCN_Communication.send_message(text_buf);
    }

    public static void prepare_start_req(Text_Buf text_buf, int component_reference, String module_name, String function_name) {
        text_buf.push_int(3);
        text_buf.push_int(component_reference);
        text_buf.push_string(module_name);
        text_buf.push_string(function_name);
    }

    public static void send_stop_req(int componentReference) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(4);
        text_buf.push_int(componentReference);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_kill_req(int componentReference) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(5);
        text_buf.push_int(componentReference);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_is_running(int componentReference) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(6);
        text_buf.push_int(componentReference);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_is_alive(int componentReference) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(7);
        text_buf.push_int(componentReference);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_done_req(int componentReference) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(8);
        text_buf.push_int(componentReference);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_killed_req(int componentReference) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(9);
        text_buf.push_int(componentReference);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_cancel_done_ack(int componentReference) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(10);
        text_buf.push_int(componentReference);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_connect_req(int sourceComponent, String sourcePort, int destinationComponent, String destinationPort) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(11);
        text_buf.push_int(sourceComponent);
        text_buf.push_string(sourcePort);
        text_buf.push_int(destinationComponent);
        text_buf.push_string(destinationPort);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_connect_listen_ack_inet_stream(String local_port, int local_port_number, int remote_component, String remote_port, InetAddress local_address) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(12);
        text_buf.push_string(local_port);
        text_buf.push_int(remote_component);
        text_buf.push_string(remote_port);
        text_buf.push_int(transport_type_enum.TRANSPORT_INET_STREAM.ordinal());
        if (local_address instanceof Inet4Address) {
            byte[] temp = local_address.getAddress();
            text_buf.push_raw(2, new byte[]{2, 0});
            text_buf.push_raw(2, new byte[]{(byte)(local_port_number / 256), (byte)(local_port_number % 256)});
            text_buf.push_raw(temp.length, temp);
            text_buf.push_raw(8, new byte[8]);
        } else if (local_address instanceof Inet6Address) {
            Inet6Address localipv6_address = TTCN_Communication.getIPv6Address(local_address);
            byte[] temp = localipv6_address.getAddress();
            text_buf.push_raw(2, new byte[]{2, 3});
            text_buf.push_raw(2, new byte[]{(byte)(local_port_number / 256), (byte)(local_port_number % 256)});
            text_buf.push_raw(temp.length, temp);
            text_buf.push_int(localipv6_address.getScopeId());
        }
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_connected(String local_port, int remote_component, String remote_port) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(13);
        text_buf.push_string(local_port);
        text_buf.push_int(remote_component);
        text_buf.push_string(remote_port);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_connect_error(String local_port, int remote_component, String remote_port, String message) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(14);
        text_buf.push_string(local_port);
        text_buf.push_int(remote_component);
        text_buf.push_string(remote_port);
        text_buf.push_string(message);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_disconnect_req(int sourceComponent, String sourcePort, int destinationComponent, String destinationPort) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(15);
        text_buf.push_int(sourceComponent);
        text_buf.push_string(sourcePort);
        text_buf.push_int(destinationComponent);
        text_buf.push_string(destinationPort);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_disconnected(String localPort, int remoteComponent, String remotePort) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(16);
        text_buf.push_string(localPort);
        text_buf.push_int(remoteComponent);
        text_buf.push_string(remotePort);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_map_req(int sourceComponent, String sourcePort, String systemPort, TitanPort.Map_Params params, boolean translation) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(17);
        text_buf.push_int(sourceComponent);
        text_buf.push_int(translation ? 1 : 0);
        text_buf.push_string(sourcePort);
        text_buf.push_string(systemPort);
        int nof_params = params.get_nof_params();
        text_buf.push_int(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            text_buf.push_string(params.get_param(i).get_value().toString());
        }
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_mapped(String localPort, String systemPort, TitanPort.Map_Params params, boolean translation) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(18);
        text_buf.push_int(translation ? 1 : 0);
        text_buf.push_string(localPort);
        text_buf.push_string(systemPort);
        int nof_params = params.get_nof_params();
        text_buf.push_int(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            text_buf.push_string(params.get_param(i).get_value().toString());
        }
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_unmap_req(int sourceComponent, String sourcePort, String systemPort, TitanPort.Map_Params params, boolean translation) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(19);
        text_buf.push_int(sourceComponent);
        text_buf.push_int(translation ? 1 : 0);
        text_buf.push_string(sourcePort);
        text_buf.push_string(systemPort);
        int nof_params = params.get_nof_params();
        text_buf.push_int(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            text_buf.push_string(params.get_param(i).get_value().toString());
        }
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_unmapped(String localPort, String systemPort, TitanPort.Map_Params params, boolean translation) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(20);
        text_buf.push_int(translation ? 1 : 0);
        text_buf.push_string(localPort);
        text_buf.push_string(systemPort);
        int nof_params = params.get_nof_params();
        text_buf.push_int(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            text_buf.push_string(params.get_param(i).get_value().toString());
        }
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_mtc_created() {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(3);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_testcase_started(String testcaseModule, String testcaseName, String mtc_comptype_module, String mtc_comptype_name, String system_comptype_module, String system_comptype_name) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(21);
        text_buf.push_string(testcaseModule);
        text_buf.push_string(testcaseName);
        text_buf.push_string(mtc_comptype_module);
        text_buf.push_string(mtc_comptype_name);
        text_buf.push_string(system_comptype_module);
        text_buf.push_string(system_comptype_name);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_testcase_finished(TitanVerdictType.VerdictTypeEnum finalVerdict, String reason) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(22);
        text_buf.push_int(finalVerdict.ordinal());
        text_buf.push_string(reason);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_mtc_ready() {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(23);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_ptc_created(int component_reference) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(4);
        text_buf.push_int(component_reference);
        TTCN_Communication.send_message(text_buf);
    }

    public static void prepare_stopped(Text_Buf text_buf, TitanVerdictType.VerdictTypeEnum final_verdict, String return_type, String reason) {
        text_buf.push_int(21);
        text_buf.push_int(final_verdict.getValue());
        text_buf.push_string(reason);
        text_buf.push_string(return_type);
    }

    public static void send_stopped(TitanVerdictType.VerdictTypeEnum final_verdict, String reason) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(21);
        text_buf.push_int(final_verdict.ordinal());
        text_buf.push_string(reason);
        text_buf.push_string(null);
        TTCN_Communication.send_message(text_buf);
    }

    public static void prepare_stopped_killed(Text_Buf text_buf, TitanVerdictType.VerdictTypeEnum final_verdict, String return_type, String reason) {
        text_buf.push_int(22);
        text_buf.push_int(final_verdict.getValue());
        text_buf.push_string(reason);
        text_buf.push_string(return_type);
    }

    public static void send_stopped_killed(TitanVerdictType.VerdictTypeEnum final_verdict, String reason) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(22);
        text_buf.push_int(final_verdict.getValue());
        text_buf.push_string(reason);
        text_buf.push_string(null);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_killed(TitanVerdictType.VerdictTypeEnum final_verdict, String reason) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(23);
        text_buf.push_int(final_verdict.getValue());
        text_buf.push_string(reason);
        text_buf.push_string(null);
        TTCN_Communication.send_message(text_buf);
    }

    public static boolean send_log(long seconds, int microseconds, int event_severity, String message_text) {
        if (is_connected.get().booleanValue()) {
            Text_Buf text_buf = new Text_Buf();
            text_buf.push_int(1);
            int upper_int = (int)(seconds / -1L);
            int lower_int = (int)(seconds % -1L);
            text_buf.push_int(upper_int);
            text_buf.push_int(lower_int);
            text_buf.push_int(microseconds);
            text_buf.push_int(event_severity);
            byte[] messageBytes = message_text.getBytes();
            text_buf.push_int(messageBytes.length);
            text_buf.push_raw(messageBytes);
            TTCN_Communication.send_message(text_buf);
            return TTCN_Runtime.get_state() != TTCN_Runtime.executorStateEnum.HC_IDLE;
        }
        switch (TTCN_Runtime.get_state()) {
            case HC_EXIT: 
            case MTC_INITIAL: 
            case MTC_EXIT: 
            case PTC_INITIAL: 
            case PTC_EXIT: {
                return true;
            }
        }
        return false;
    }

    public static void send_error(String message) {
        Text_Buf text_buf = new Text_Buf();
        text_buf.push_int(0);
        text_buf.push_string(message);
        TTCN_Communication.send_message(text_buf);
    }

    public static void send_message(Text_Buf text_buf) {
        if (!is_connected.get().booleanValue()) {
            throw new TtcnError("Trying to send a message to MC, but the control connection is down.");
        }
        text_buf.calculate_length();
        byte[] msg_ptr = text_buf.get_data();
        int msg_len = text_buf.get_len();
        int msg_begin = text_buf.get_begin();
        ByteBuffer buffer = ByteBuffer.wrap(msg_ptr, msg_begin, msg_len);
        SocketChannel localChannel = mc_socketchannel.get();
        try {
            while (buffer.hasRemaining()) {
                localChannel.write(buffer);
            }
        }
        catch (IOException e) {
            TTCN_Communication.close_mc_connection();
            StringWriter error = new StringWriter();
            e.printStackTrace(new PrintWriter(error));
            TTCN_Logger.begin_event(TTCN_Logger.Severity.ERROR_UNQUALIFIED);
            TTCN_Logger.log_event_str("Dynamic test case error: ");
            TTCN_Logger.log_event_str(error.toString());
            TTCN_Logger.end_event();
            throw new TtcnError("Sending data on the control connection to MC failed.");
        }
    }

    private static void process_configure(int msg_end, boolean to_mtc) {
        String config_str;
        switch (TTCN_Runtime.get_state()) {
            case HC_IDLE: 
            case HC_ACTIVE: 
            case HC_OVERLOADED: {
                if (!to_mtc) break;
            }
            case MTC_IDLE: {
                if (to_mtc) break;
            }
            default: {
                incoming_buf.get().cut_message();
                TTCN_Communication.send_error("Message CONFIGURE arrived in invalid state.");
                return;
            }
        }
        TTCN_Runtime.set_state(to_mtc ? TTCN_Runtime.executorStateEnum.MTC_CONFIGURING : TTCN_Runtime.executorStateEnum.HC_CONFIGURING);
        TTCN_Logger.log_configdata(TitanLoggerApi.ExecutorConfigdata_reason.enum_type.received__from__mc, null);
        Text_Buf local_incoming_buf = incoming_buf.get();
        int config_str_len = local_incoming_buf.pull_int().get_int();
        int config_str_begin = local_incoming_buf.get_pos();
        if (config_str_begin + config_str_len != msg_end) {
            local_incoming_buf.cut_message();
            TTCN_Communication.send_error("Malformed message CONFIGURE was received.");
            return;
        }
        if (config_str_len == 0) {
            config_str = "";
        } else {
            byte[] config_bytes = new byte[config_str_len];
            byte[] incoming_data = local_incoming_buf.get_data();
            System.arraycopy(incoming_data, local_incoming_buf.get_begin() + config_str_begin, config_bytes, 0, config_str_len);
            config_str = new String(config_bytes);
        }
        CfgAnalyzer cfgAnalyzer = new CfgAnalyzer();
        boolean success = !cfgAnalyzer.parse(config_str);
        TTCN_Logger.open_file();
        if (success) {
            try {
                Module_List.log_param();
                Module_List.post_init_modules();
            }
            catch (TtcnError error) {
                TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.initialization__of__modules__failed);
                success = false;
            }
        } else {
            TTCN_Logger.log_configdata(TitanLoggerApi.ExecutorConfigdata_reason.enum_type.processing__failed, null);
        }
        if (success) {
            TTCN_Communication.send_configure_ack();
            TTCN_Runtime.set_state(to_mtc ? TTCN_Runtime.executorStateEnum.MTC_IDLE : TTCN_Runtime.executorStateEnum.HC_ACTIVE);
            TTCN_Logger.log_configdata(TitanLoggerApi.ExecutorConfigdata_reason.enum_type.processing__succeeded, null);
        } else {
            TTCN_Communication.send_configure_nak();
            TTCN_Runtime.set_state(to_mtc ? TTCN_Runtime.executorStateEnum.MTC_IDLE : TTCN_Runtime.executorStateEnum.HC_IDLE);
        }
        local_incoming_buf.cut_message();
    }

    private static void process_create_mtc() {
        incoming_buf.get().cut_message();
        TTCN_Runtime.process_create_mtc();
    }

    private static void process_create_ptc() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        int component_reference = local_incoming_buf.pull_int().get_int();
        if (component_reference < 3) {
            local_incoming_buf.cut_message();
            TTCN_Communication.send_error(MessageFormat.format("Message CREATE_PTC refers to invalid component reference {0}.", component_reference));
            return;
        }
        String component_module_name = local_incoming_buf.pull_string();
        String component_definition_name = local_incoming_buf.pull_string();
        String system_module_name = local_incoming_buf.pull_string();
        String system_definition_name = local_incoming_buf.pull_string();
        if (component_module_name == null || component_definition_name == null || system_module_name == null || system_definition_name == null) {
            TTCN_Communication.send_error(MessageFormat.format("Message CREATE_PTC with component reference {0} contains an invalid component type or system type.", component_reference));
        }
        String component_name = local_incoming_buf.pull_string();
        boolean is_alive = local_incoming_buf.pull_int().get_int() != 0;
        String testcase_module_name = local_incoming_buf.pull_string();
        String testcase_definition_name = local_incoming_buf.pull_string();
        int upper_int = local_incoming_buf.pull_int().get_int();
        int lower_int = local_incoming_buf.pull_int().get_int();
        long seconds = upper_int * -1 + lower_int;
        int microSeconds = local_incoming_buf.pull_int().get_int();
        local_incoming_buf.cut_message();
        double start_time = (double)seconds + (double)microSeconds / 1000000.0;
        TTCN_Runtime.process_create_ptc(component_reference, component_module_name, component_definition_name, system_module_name, system_definition_name, component_name, is_alive, testcase_module_name, testcase_definition_name, start_time);
    }

    private static void process_kill_process() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        int component_reference = local_incoming_buf.pull_int().get_int();
        local_incoming_buf.cut_message();
        TTCN_Runtime.process_kill_process(component_reference);
    }

    private static void process_exit_hc() {
        incoming_buf.get().cut_message();
        TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.exit__requested__from__mc__hc);
        TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.HC_EXIT);
    }

    private static void process_create_ack() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        int component_reference = local_incoming_buf.pull_int().get_int();
        local_incoming_buf.cut_message();
        TTCN_Runtime.process_create_ack(component_reference);
    }

    private static void process_start_ack() {
        incoming_buf.get().cut_message();
        switch (TTCN_Runtime.get_state()) {
            case MTC_START: {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_TESTCASE);
                break;
            }
            case MTC_TERMINATING_TESTCASE: {
                break;
            }
            case PTC_START: {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.PTC_FUNCTION);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Message START_ACK arrived in invalid state.");
            }
        }
    }

    private static void process_stop() {
        incoming_buf.get().cut_message();
        switch (TTCN_Runtime.get_state()) {
            case MTC_IDLE: {
                TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.stop__was__requested__from__mc__ignored__on__idle__mtc);
                break;
            }
            case MTC_PAUSED: {
                TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.stop__was__requested__from__mc);
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_TERMINATING_EXECUTION);
                break;
            }
            case PTC_IDLE: 
            case PTC_STOPPED: {
                TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.stop__was__requested__from__mc__ignored__on__idle__ptc);
                break;
            }
            case PTC_EXIT: {
                break;
            }
            default: {
                TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.stop__was__requested__from__mc);
                TTCN_Runtime.stop_execution();
            }
        }
    }

    private static void process_stop_ack() {
        incoming_buf.get().cut_message();
        switch (TTCN_Runtime.get_state()) {
            case MTC_STOP: {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_TESTCASE);
                break;
            }
            case MTC_TERMINATING_TESTCASE: {
                break;
            }
            case PTC_STOP: {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.PTC_FUNCTION);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Message STOP_ACK arrived in invalid state.");
            }
        }
    }

    private static void process_kill_ack() {
        incoming_buf.get().cut_message();
        switch (TTCN_Runtime.get_state()) {
            case MTC_KILL: {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_TESTCASE);
                break;
            }
            case MTC_TERMINATING_TESTCASE: {
                break;
            }
            case PTC_KILL: {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.PTC_FUNCTION);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Message KILL_ACK arrived in invalid state.");
            }
        }
    }

    private static void process_running() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        boolean answer2 = local_incoming_buf.pull_int().get_int() != 0;
        local_incoming_buf.cut_message();
        TTCN_Runtime.process_running(answer2);
    }

    private static void process_alive() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        boolean answer2 = local_incoming_buf.pull_int().get_int() != 0;
        local_incoming_buf.cut_message();
        TTCN_Runtime.process_alive(answer2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void process_done_ack(int msg_end) {
        Text_Buf local_incoming_buf = incoming_buf.get();
        boolean answer2 = local_incoming_buf.pull_int().get_int() != 0;
        int verdict_int = local_incoming_buf.pull_int().get_int();
        TitanVerdictType.VerdictTypeEnum ptc_verdict = TitanVerdictType.VerdictTypeEnum.values()[verdict_int];
        String return_type = local_incoming_buf.pull_string();
        int return_value_begin = local_incoming_buf.get_pos();
        try {
            TTCN_Runtime.process_done_ack(answer2, ptc_verdict, return_type, local_incoming_buf.get_data(), msg_end - return_value_begin, local_incoming_buf.get_begin(), return_value_begin);
        }
        finally {
            local_incoming_buf.cut_message();
        }
    }

    private static void process_killed_ack() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        boolean answer2 = local_incoming_buf.pull_int().get_int() != 0;
        local_incoming_buf.cut_message();
        TTCN_Runtime.process_killed_ack(answer2);
    }

    private static void process_cancel_done_mtc() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        int component_reference = local_incoming_buf.pull_int().get_int();
        boolean cancel_any = local_incoming_buf.pull_int().get_int() != 0;
        local_incoming_buf.cut_message();
        TTCN_Runtime.cancel_component_done(component_reference);
        if (cancel_any) {
            TTCN_Runtime.cancel_component_done(-1);
        }
        TTCN_Communication.send_cancel_done_ack(component_reference);
    }

    private static void process_cancel_done_ptc() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        int component_reference = local_incoming_buf.pull_int().get_int();
        local_incoming_buf.cut_message();
        TTCN_Runtime.cancel_component_done(component_reference);
        TTCN_Communication.send_cancel_done_ack(component_reference);
    }

    private static void process_component_status_mtc(int msg_end) {
        boolean is_all_killed;
        Text_Buf local_incoming_buf = incoming_buf.get();
        int component_reference = local_incoming_buf.pull_int().get_int();
        boolean is_done = local_incoming_buf.pull_int().get_int() != 0;
        boolean is_killed = local_incoming_buf.pull_int().get_int() != 0;
        boolean is_any_done = local_incoming_buf.pull_int().get_int() != 0;
        boolean is_all_done = local_incoming_buf.pull_int().get_int() != 0;
        boolean is_any_killed = local_incoming_buf.pull_int().get_int() != 0;
        boolean bl = is_all_killed = local_incoming_buf.pull_int().get_int() != 0;
        if (is_done) {
            int verdict_int = local_incoming_buf.pull_int().get_int();
            TitanVerdictType.VerdictTypeEnum ptc_verdict = TitanVerdictType.VerdictTypeEnum.values()[verdict_int];
            String return_type = local_incoming_buf.pull_string();
            int return_value_begin = local_incoming_buf.get_pos();
            try {
                TTCN_Runtime.set_component_done(component_reference, ptc_verdict, return_type, local_incoming_buf.get_data(), msg_end - return_value_begin, local_incoming_buf.get_begin(), return_value_begin);
            }
            catch (TtcnError error) {
                local_incoming_buf.cut_message();
                throw error;
            }
        }
        if (is_killed) {
            TTCN_Runtime.set_component_killed(component_reference);
        }
        if (is_any_done) {
            TTCN_Runtime.set_component_done(-1, TitanVerdictType.VerdictTypeEnum.NONE, null, null, 0, 0, 0);
        }
        if (is_all_done) {
            TTCN_Runtime.set_component_done(-2, TitanVerdictType.VerdictTypeEnum.NONE, null, null, 0, 0, 0);
        }
        if (is_any_killed) {
            TTCN_Runtime.set_component_killed(-1);
        }
        if (is_all_killed) {
            TTCN_Runtime.set_component_killed(-2);
        }
        local_incoming_buf.cut_message();
        if (!(is_done || is_killed || component_reference == 0 && (is_any_done || is_all_done || is_any_killed || is_all_killed))) {
            throw new TtcnError("Internal error: Malformed COMPONENT_STATUS message was received.");
        }
    }

    private static void process_component_status_ptc(int msg_end) {
        boolean is_killed;
        Text_Buf local_incoming_buf = incoming_buf.get();
        int component_reference = local_incoming_buf.pull_int().get_int();
        boolean is_done = local_incoming_buf.pull_int().get_int() != 0;
        boolean bl = is_killed = local_incoming_buf.pull_int().get_int() != 0;
        if (is_done) {
            int verdict_int = local_incoming_buf.pull_int().get_int();
            TitanVerdictType.VerdictTypeEnum ptc_verdict = TitanVerdictType.VerdictTypeEnum.values()[verdict_int];
            String return_type = local_incoming_buf.pull_string();
            int return_value_begin = local_incoming_buf.get_pos();
            try {
                TTCN_Runtime.set_component_done(component_reference, ptc_verdict, return_type, local_incoming_buf.get_data(), msg_end - return_value_begin, local_incoming_buf.get_begin(), return_value_begin);
            }
            catch (TtcnError error) {
                local_incoming_buf.cut_message();
                throw error;
            }
        }
        if (is_killed) {
            TTCN_Runtime.set_component_killed(component_reference);
        }
        local_incoming_buf.cut_message();
        if (!is_done && !is_killed) {
            throw new TtcnError("Internal error: Malformed COMPONENT_STATUS message was received.");
        }
    }

    private static void process_connect_listen() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        String local_port = local_incoming_buf.pull_string();
        int remote_component = local_incoming_buf.pull_int().get_int();
        String remote_component_name = local_incoming_buf.pull_string();
        String remote_port = local_incoming_buf.pull_string();
        int temp_transport_type = local_incoming_buf.pull_int().get_int();
        local_incoming_buf.cut_message();
        if (remote_component != 1 && TitanComponent.self.get().get_component() != remote_component) {
            TitanComponent.register_component_name(remote_component, remote_component_name);
        }
        transport_type_enum transport_type = transport_type_enum.values()[temp_transport_type];
        TitanPort.process_connect_listen(local_port, remote_component, remote_port, transport_type);
        local_incoming_buf.cut_message();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void process_connect() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        String local_port = local_incoming_buf.pull_string();
        int remote_component = local_incoming_buf.pull_int().get_int();
        String remote_component_name = local_incoming_buf.pull_string();
        String remote_port = local_incoming_buf.pull_string();
        int temp_transport_type = local_incoming_buf.pull_int().get_int();
        try {
            if (remote_component != 1 && TitanComponent.self.get().get_component() != remote_component) {
                TitanComponent.register_component_name(remote_component, remote_component_name);
            }
            transport_type_enum transport_type = transport_type_enum.values()[temp_transport_type];
            TitanPort.process_connect(local_port, remote_component, remote_port, transport_type, incoming_buf.get());
        }
        finally {
            local_incoming_buf.cut_message();
        }
    }

    private static void process_connect_ack() {
        incoming_buf.get().cut_message();
        switch (TTCN_Runtime.get_state()) {
            case MTC_CONNECT: {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_TESTCASE);
                break;
            }
            case MTC_TERMINATING_TESTCASE: {
                break;
            }
            case PTC_CONNECT: {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.PTC_FUNCTION);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Message CONNECT_ACK arrived in invalid state.");
            }
        }
    }

    private static void process_disconnect() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        String local_port = local_incoming_buf.pull_string();
        int remote_component = local_incoming_buf.pull_int().get_int();
        String remote_port = local_incoming_buf.pull_string();
        local_incoming_buf.cut_message();
        TitanPort.process_disconnect(local_port, remote_component, remote_port);
    }

    private static void process_disconnect_ack() {
        incoming_buf.get().cut_message();
        switch (TTCN_Runtime.get_state()) {
            case MTC_DISCONNECT: {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_TESTCASE);
                break;
            }
            case MTC_TERMINATING_TESTCASE: {
                break;
            }
            case PTC_DISCONNECT: {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.PTC_FUNCTION);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Message DISCONNECT_ACK arrived in invalid state.");
            }
        }
    }

    private static void process_map() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        boolean translation = local_incoming_buf.pull_int().get_int() != 0;
        String local_port = local_incoming_buf.pull_string();
        String system_port = local_incoming_buf.pull_string();
        int nof_params = local_incoming_buf.pull_int().get_int();
        TitanPort.Map_Params params = new TitanPort.Map_Params(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            String par = local_incoming_buf.pull_string();
            params.set_param(i, new TitanCharString(par));
        }
        local_incoming_buf.cut_message();
        TitanPort.map_port(local_port, system_port, params, false);
        if (translation) {
            TitanPort.map_port(local_port, system_port, params, true);
        }
        if (!TTCN_Runtime.is_single()) {
            if (translation) {
                TTCN_Communication.send_mapped(system_port, local_port, params, translation);
            } else {
                TTCN_Communication.send_mapped(local_port, system_port, params, translation);
            }
        }
    }

    private static void process_map_ack() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        int nof_params = local_incoming_buf.pull_int().get_int();
        TitanPort.Map_Params local_map_params = TitanPort.map_params_cache.get();
        local_map_params.reset(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            String par = local_incoming_buf.pull_string();
            local_map_params.set_param(i, new TitanCharString(par));
        }
        local_incoming_buf.cut_message();
        switch (TTCN_Runtime.get_state()) {
            case MTC_MAP: {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_TESTCASE);
                break;
            }
            case MTC_TERMINATING_TESTCASE: {
                break;
            }
            case PTC_MAP: {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.PTC_FUNCTION);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Message MAP_ACK arrived in invalid state.");
            }
        }
    }

    private static void process_unmap() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        boolean translation = local_incoming_buf.pull_int().get_int() != 0;
        String local_port = local_incoming_buf.pull_string();
        String system_port = local_incoming_buf.pull_string();
        int nof_params = local_incoming_buf.pull_int().get_int();
        TitanPort.Map_Params params = new TitanPort.Map_Params(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            String par = local_incoming_buf.pull_string();
            params.set_param(i, new TitanCharString(par));
        }
        local_incoming_buf.cut_message();
        TitanPort.unmap_port(local_port, system_port, params, false);
        if (translation) {
            TitanPort.unmap_port(local_port, system_port, params, true);
        }
        if (!TTCN_Runtime.is_single()) {
            if (translation) {
                TTCN_Communication.send_unmapped(system_port, local_port, params, translation);
            } else {
                TTCN_Communication.send_unmapped(local_port, system_port, params, translation);
            }
        }
    }

    private static void process_unmap_ack() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        int nof_params = local_incoming_buf.pull_int().get_int();
        TitanPort.Map_Params local_map_params = TitanPort.map_params_cache.get();
        local_map_params.reset(nof_params);
        for (int i = 0; i < nof_params; ++i) {
            String par = local_incoming_buf.pull_string();
            local_map_params.set_param(i, new TitanCharString(par));
        }
        local_incoming_buf.cut_message();
        switch (TTCN_Runtime.get_state()) {
            case MTC_UNMAP: {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_TESTCASE);
                break;
            }
            case MTC_TERMINATING_TESTCASE: {
                break;
            }
            case PTC_UNMAP: {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.PTC_FUNCTION);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Message UNMAP_ACK arrived in invalid state.");
            }
        }
    }

    private static void process_execute_control() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        String module_name = local_incoming_buf.pull_string();
        local_incoming_buf.cut_message();
        if (TTCN_Runtime.get_state() != TTCN_Runtime.executorStateEnum.MTC_IDLE) {
            throw new TtcnError("Internal error: Message EXECUTE_CONTROL arrived in invalid state.");
        }
        TTCN_Logger.log(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, MessageFormat.format("Executing control part of module {0}.", module_name), new Object[0]);
        TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_CONTROLPART);
        try {
            Module_List.execute_control(module_name);
        }
        catch (TC_End tC_End) {
        }
        catch (TtcnError ttcnError) {
            // empty catch block
        }
        if (is_connected.get().booleanValue()) {
            TTCN_Communication.send_mtc_ready();
            TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_IDLE);
        } else {
            TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_EXIT);
        }
    }

    private static void process_execute_testcase() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        String module_name = local_incoming_buf.pull_string();
        String testcase_name = local_incoming_buf.pull_string();
        local_incoming_buf.cut_message();
        if (TTCN_Runtime.get_state() != TTCN_Runtime.executorStateEnum.MTC_IDLE) {
            throw new TtcnError("Internal error: Message EXECUTE_TESTCASE arrived in invalid state.");
        }
        TTCN_Logger.log_testcase_exec(testcase_name, module_name);
        TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_CONTROLPART);
        try {
            if (testcase_name != null && testcase_name.length() > 0) {
                Module_List.execute_testcase(module_name, testcase_name);
            } else {
                Module_List.execute_all_testcases(module_name);
            }
        }
        catch (TC_End tC_End) {
        }
        catch (TtcnError ttcnError) {
            // empty catch block
        }
        if (is_connected.get().booleanValue()) {
            TTCN_Communication.send_mtc_ready();
            TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_IDLE);
        } else {
            TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_EXIT);
        }
    }

    private static void process_ptc_verdict() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        TTCN_Runtime.process_ptc_verdict(local_incoming_buf);
        local_incoming_buf.cut_message();
    }

    private static void process_exit_mtc() {
        incoming_buf.get().cut_message();
        TTCN_Runtime.log_verdict_statistics();
        TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.exit__requested__from__mc__mtc);
        TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.MTC_EXIT);
    }

    private static void process_start() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        String module_name = local_incoming_buf.pull_string();
        String definition_name = local_incoming_buf.pull_string();
        if (module_name == null || definition_name == null) {
            local_incoming_buf.cut_message();
            throw new TtcnError("Internal error: Message START contains an invalid function name.");
        }
        TTCN_Runtime.start_function(module_name, definition_name, local_incoming_buf);
    }

    private static void process_kill() {
        incoming_buf.get().cut_message();
        TTCN_Runtime.process_kill();
    }

    private static void process_error() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        String error_string = local_incoming_buf.pull_string();
        local_incoming_buf.cut_message();
        throw new TtcnError("Error message was received from MC : " + error_string);
    }

    private static void process_unsupported_message(int msg_type, int msg_end) {
        Text_Buf local_incoming_buf = incoming_buf.get();
        TTCN_Logger.begin_event(TTCN_Logger.Severity.WARNING_UNQUALIFIED);
        TTCN_Logger.log_event_str(MessageFormat.format("Unsupported message was received from MC: type (decimal): {0}, data (hexadecimal): ", msg_type));
        byte[] data = local_incoming_buf.get_data();
        int begin = local_incoming_buf.get_begin();
        for (int i = local_incoming_buf.get_pos(); i < msg_end; ++i) {
            TTCN_Logger.log_octet(data[begin + i]);
        }
        TTCN_Logger.end_event();
        local_incoming_buf.cut_message();
    }

    private static void process_debug_command() {
        Text_Buf local_incoming_buf = incoming_buf.get();
        int command = local_incoming_buf.pull_int().get_int();
        int argument_count = local_incoming_buf.pull_int().get_int();
        if (argument_count > 0) {
            for (int i = 0; i < argument_count; ++i) {
                local_incoming_buf.pull_string();
            }
        }
        local_incoming_buf.cut_message();
    }

    private static Inet6Address getIPv6Address(InetAddress address) {
        return (Inet6Address)address;
    }

    static {
        hcnh = new NetworkHandler.HCNetworkHandler();
        local_addr_set = false;
        mc_socketchannel = new ThreadLocal<SocketChannel>(){

            @Override
            protected SocketChannel initialValue() {
                return null;
            }
        };
        mc_connection = new ThreadLocal<MC_Connection>(){

            @Override
            protected MC_Connection initialValue() {
                return null;
            }
        };
        call_interval = new ThreadLocal<Double>(){

            @Override
            protected Double initialValue() {
                return 0.0;
            }
        };
        incoming_buf = new ThreadLocal<Text_Buf>(){

            @Override
            protected Text_Buf initialValue() {
                return new Text_Buf();
            }
        };
    }

    static class MC_Connection
    extends Event_Handler.Channel_And_Timeout_Event_Handler {
        final SocketChannel mc_channel;
        final Text_Buf incoming_buffer;

        MC_Connection(SocketChannel channel, Text_Buf buffer) {
            this.mc_channel = channel;
            this.incoming_buffer = buffer;
        }

        @Override
        public void Handle_Event(SelectableChannel channel, boolean is_readable, boolean is_writeable) {
            if (!channel.equals(this.mc_channel)) {
                throw new TtcnError("MC_Connection: unexpected selectable channel.");
            }
            if (is_readable) {
                AtomicInteger buf_ptr = new AtomicInteger();
                AtomicInteger buf_len = new AtomicInteger();
                this.incoming_buffer.get_end(buf_ptr, buf_len);
                ByteBuffer tempbuffer = ByteBuffer.allocate(1024);
                int recv_len = 0;
                try {
                    recv_len = this.mc_channel.read(tempbuffer);
                }
                catch (IOException e) {
                    throw new TtcnError(e);
                }
                if (recv_len > 0) {
                    ((Text_Buf)incoming_buf.get()).push_raw(recv_len, tempbuffer.array());
                    if (!TTCN_Runtime.is_idle()) {
                        TTCN_Communication.process_all_messages_tc();
                    }
                } else {
                    TTCN_Communication.close_mc_connection();
                    if (recv_len == 0) {
                        throw new TtcnError("Control connection was closed unexpectedly by MC.");
                    }
                    throw new TtcnError("Receiving data on the control connection from MC failed.");
                }
            }
        }

        @Override
        public void Handle_Timeout(double time_since_last_call) {
            if (TTCN_Runtime.get_state() == TTCN_Runtime.executorStateEnum.HC_OVERLOADED) {
                TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.HC_OVERLOADED_TIMEOUT);
            } else {
                TtcnError.TtcnWarning("Unexpected timeout occurred on the control connection to MC.");
                TTCN_Communication.disable_periodic_call();
            }
        }
    }

    public static enum transport_type_enum {
        TRANSPORT_LOCAL,
        TRANSPORT_INET_STREAM,
        TRANSPORT_UNIX_STREAM,
        TRANSPORT_NUM;

    }
}

